/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;
import yesman.epicfight.api.utils.math.Vec2f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.gui.EntityIndicator;
import yesman.epicfight.client.gui.ModIngameGui;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;

@OnlyIn(value=Dist.CLIENT)
public class BattleModeGui
extends ModIngameGui {
    private static final Map<Integer, Vec3f> POSITION_MAP = Maps.newHashMap();
    private int sliding = 29;
    private boolean slidingToggle = false;
    private List<SkillContainer> skillIcons = Lists.newLinkedList();
    public Font font;
    private static final Vec2f[] CLOCK_POS;

    public BattleModeGui(Minecraft minecraft) {
        this.font = minecraft.f_91062_;
    }

    public void renderGui(LocalPlayerPatch playerpatch, float partialTicks) {
        if (!((LocalPlayer)playerpatch.getOriginal()).m_6084_() || ((LocalPlayer)playerpatch.getOriginal()).m_20202_() != null) {
            return;
        }
        if (this.sliding > 28) {
            return;
        }
        if (this.sliding > 0) {
            this.sliding = this.slidingToggle ? (this.sliding -= 2) : (this.sliding += 2);
        }
        Window sr = Minecraft.m_91087_().m_91268_();
        int width = sr.m_85445_();
        int height = sr.m_85446_();
        boolean depthTestEnabled = GL11.glGetBoolean((int)2929);
        boolean blendEnabled = GL11.glGetBoolean((int)3042);
        if (depthTestEnabled) {
            RenderSystem.m_69465_();
        }
        if (!blendEnabled) {
            RenderSystem.m_69478_();
        }
        PoseStack matStack = new PoseStack();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)EntityIndicator.BATTLE_ICON);
        float maxStamina = playerpatch.getMaxStamina();
        float stamina = playerpatch.getStamina();
        float prevStamina = playerpatch.getPrevStamina();
        if (maxStamina > 0.0f && stamina < maxStamina) {
            float ratio = (prevStamina + (stamina - prevStamina) * partialTicks) / maxStamina;
            matStack.m_85836_();
            matStack.m_85837_(0.0, (double)((float)this.sliding * 0.5f), 0.0);
            matStack.m_85841_(0.5f, 0.5f, 1.0f);
            RenderSystem.m_157429_((float)1.0f, (float)ratio, (float)0.25f, (float)1.0f);
            ModIngameGui.m_93133_((PoseStack)matStack, (int)((int)((float)(width - 120) * 2.0f)), (int)((int)((float)(height - 10) * 2.0f)), (float)2.0f, (float)38.0f, (int)237, (int)9, (int)255, (int)255);
            ModIngameGui.m_93133_((PoseStack)matStack, (int)((int)((float)(width - 120) * 2.0f)), (int)((int)((float)(height - 10) * 2.0f)), (float)2.0f, (float)47.0f, (int)((int)(237.0f * ratio)), (int)9, (int)255, (int)255);
            matStack.m_85849_();
        }
        for (int i = 0; i < SkillCategory.ENUM_MANAGER.universalValues().size(); ++i) {
            SkillContainer container = playerpatch.getSkill(i);
            if (container == null || container.isEmpty()) continue;
            SkillCategory slot = container.getSkill().getCategory();
            if (slot == SkillCategories.WEAPON_SPECIAL_ATTACK) {
                this.drawSpecialAttack(playerpatch, container, matStack, partialTicks);
                continue;
            }
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Skill skill = container.getSkill();
            if (skill != null && skill.shouldDraw(container)) {
                if (!this.skillIcons.contains(container)) {
                    this.skillIcons.removeIf(showingContainer -> showingContainer.getSkill().getCategory() == skill.getCategory());
                    this.skillIcons.add(container);
                }
                Vec3f pos = POSITION_MAP.get(this.skillIcons.indexOf(container));
                RenderSystem.m_69478_();
                skill.drawOnGui(this, container, matStack, pos.x, pos.y, pos.z, width, height);
                continue;
            }
            if (!this.skillIcons.contains(container)) continue;
            this.skillIcons.removeIf(shownContainer -> container == shownContainer);
        }
        if (depthTestEnabled) {
            RenderSystem.m_69482_();
        }
        if (!blendEnabled) {
            RenderSystem.m_69461_();
        }
    }

    private void drawSpecialAttack(LocalPlayerPatch playerpatch, SkillContainer container, PoseStack matStack, float partialTicks) {
        int stringWidth;
        int j;
        Window sr = Minecraft.m_91087_().m_91268_();
        int width = sr.m_85445_();
        int height = sr.m_85446_();
        Vec3f pos = POSITION_MAP.get(-1);
        int x = (int)pos.x;
        int y = (int)pos.y;
        float scale = 1.0f / pos.z;
        matStack.m_85836_();
        matStack.m_85841_(pos.z, pos.z, 1.0f);
        matStack.m_85837_(0.0, (double)((float)this.sliding * scale), 0.0);
        boolean creative = ((LocalPlayer)playerpatch.getOriginal()).m_7500_();
        boolean fullstack = creative || container.isFull();
        float cooldownRatio = fullstack ? 1.0f : container.getResource(partialTicks);
        boolean isCompatibleWeapon = !container.isDisabled();
        int vertexNum = 0;
        float iconSize = 32.0f;
        float iconSizeDiv = iconSize * 0.5f;
        float top = y;
        float bottom = (float)y - iconSize;
        float left = x;
        float right = (float)x - iconSize;
        float middle = (float)x - iconSizeDiv;
        float lastVertexX = 0.0f;
        float lastVertexY = 0.0f;
        float lastTexX = 0.0f;
        float lastTexY = 0.0f;
        if (cooldownRatio < 0.125f) {
            vertexNum = 6;
            lastTexX = cooldownRatio / 0.25f;
            lastTexY = 0.0f;
            lastVertexX = middle - iconSize * lastTexX;
            lastVertexY = top;
            lastTexX += 0.5f;
        } else if (cooldownRatio < 0.375f) {
            vertexNum = 5;
            lastTexX = 1.0f;
            lastTexY = (cooldownRatio - 0.125f) / 0.25f;
            lastVertexX = right;
            lastVertexY = top - iconSize * lastTexY;
        } else if (cooldownRatio < 0.625f) {
            vertexNum = 4;
            lastTexX = (cooldownRatio - 0.375f) / 0.25f;
            lastTexY = 1.0f;
            lastVertexX = right + iconSize * lastTexX;
            lastVertexY = bottom;
            lastTexX = 1.0f - lastTexX;
        } else if (cooldownRatio < 0.875f) {
            vertexNum = 3;
            lastTexX = 0.0f;
            lastTexY = (cooldownRatio - 0.625f) / 0.25f;
            lastVertexX = left;
            lastVertexY = bottom + iconSize * lastTexY;
            lastTexY = 1.0f - lastTexY;
        } else {
            vertexNum = 2;
            lastTexX = (cooldownRatio - 0.875f) / 0.25f;
            lastTexY = 0.0f;
            lastVertexX = left - iconSize * lastTexX;
            lastVertexY = top;
        }
        RenderSystem.m_69478_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)container.getSkill().getSkillTexture());
        RenderSystem.m_157429_((float)lastVertexX, (float)lastVertexY, (float)lastTexX, (float)lastTexY);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        if (isCompatibleWeapon) {
            if (container.getStack() > 0) {
                RenderSystem.m_157429_((float)0.0f, (float)0.64f, (float)0.72f, (float)0.8f);
            } else {
                RenderSystem.m_157429_((float)0.0f, (float)0.5f, (float)0.5f, (float)0.6f);
            }
        } else {
            RenderSystem.m_157429_((float)0.5f, (float)0.5f, (float)0.5f, (float)0.6f);
        }
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85817_);
        for (j = 0; j < vertexNum; ++j) {
            bufferbuilder.m_85982_(matStack.m_85850_().m_85861_(), ((float)width - (left - iconSize * BattleModeGui.CLOCK_POS[j].x)) * scale, ((float)height - (top - iconSize * BattleModeGui.CLOCK_POS[j].y)) * scale, 0.0f).m_7421_(BattleModeGui.CLOCK_POS[j].x, BattleModeGui.CLOCK_POS[j].y).m_5752_();
        }
        bufferbuilder.m_85982_(matStack.m_85850_().m_85861_(), ((float)width - lastVertexX) * scale, ((float)height - lastVertexY) * scale, 0.0f).m_7421_(lastTexX, lastTexY).m_5752_();
        tessellator.m_85914_();
        if (isCompatibleWeapon) {
            RenderSystem.m_157429_((float)0.08f, (float)0.79f, (float)0.95f, (float)1.0f);
        } else {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        RenderSystem.m_69464_();
        bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85817_);
        for (j = 0; j < 2; ++j) {
            bufferbuilder.m_85982_(matStack.m_85850_().m_85861_(), ((float)width - (left - iconSize * BattleModeGui.CLOCK_POS[j].x)) * scale, ((float)height - (top - iconSize * BattleModeGui.CLOCK_POS[j].y)) * scale, 0.0f).m_7421_(BattleModeGui.CLOCK_POS[j].x, BattleModeGui.CLOCK_POS[j].y).m_5752_();
        }
        for (j = CLOCK_POS.length - 1; j >= vertexNum; --j) {
            bufferbuilder.m_85982_(matStack.m_85850_().m_85861_(), ((float)width - (left - iconSize * BattleModeGui.CLOCK_POS[j].x)) * scale, ((float)height - (top - iconSize * BattleModeGui.CLOCK_POS[j].y)) * scale, 0.0f).m_7421_(BattleModeGui.CLOCK_POS[j].x, BattleModeGui.CLOCK_POS[j].y).m_5752_();
        }
        bufferbuilder.m_85982_(matStack.m_85850_().m_85861_(), ((float)width - lastVertexX) * scale, ((float)height - lastVertexY) * scale, 0.0f).m_7421_(lastTexX, lastTexY).m_5752_();
        tessellator.m_85914_();
        matStack.m_85841_(scale, scale, 1.0f);
        if (!fullstack) {
            String s = String.valueOf((int)(cooldownRatio * 100.0f));
            stringWidth = (this.font.m_92895_(s) - 6) / 3;
            this.font.m_92750_(matStack, s, (float)width - (float)x + 13.0f - (float)stringWidth, (float)height - (float)y + 13.0f, 0xFFFFFF);
        } else if (container.getRemainDuration() > 0 && container.getSkill().getActivateType() != Skill.ActivateType.TOGGLE) {
            String s = String.valueOf(container.getRemainDuration());
            stringWidth = (this.font.m_92895_(s) - 6) / 3;
            this.font.m_92750_(matStack, s, (float)width - (float)x + 13.0f - (float)stringWidth, (float)height - (float)y + 13.0f, 0xFFFFFF);
        }
        if (container.getSkill().getMaxStack() > 1) {
            String s = String.valueOf(container.getStack());
            stringWidth = (this.font.m_92895_(s) - 6) / 3;
            this.font.m_92750_(matStack, s, (float)width - (float)x + 25.0f - (float)stringWidth, (float)height - (float)y + 22.0f, 0xFFFFFF);
        }
        matStack.m_85849_();
    }

    public void slideUp() {
        this.sliding = 28;
        this.slidingToggle = true;
    }

    public void slideDown() {
        this.sliding = 1;
        this.slidingToggle = false;
    }

    public int getSlidingProgression() {
        return this.sliding;
    }

    static {
        POSITION_MAP.put(-1, new Vec3f(42.0f, 48.0f, 0.117f));
        POSITION_MAP.put(0, new Vec3f(70.0f, 36.0f, 0.078f));
        POSITION_MAP.put(1, new Vec3f(94.0f, 36.0f, 0.078f));
        POSITION_MAP.put(2, new Vec3f(116.0f, 36.0f, 0.078f));
        CLOCK_POS = new Vec2f[]{new Vec2f(0.5f, 0.5f), new Vec2f(0.5f, 0.0f), new Vec2f(0.0f, 0.0f), new Vec2f(0.0f, 1.0f), new Vec2f(1.0f, 1.0f), new Vec2f(1.0f, 0.0f)};
    }
}

