/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import java.util.OptionalDouble;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EpicFightRenderTypes
extends RenderType {
    private static final Function<ResourceLocation, RenderType> ANIMATED_MODEL = Util.m_143827_(textureLocation -> {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(f_173066_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(textureLocation, false, false)).m_110685_(f_110139_).m_110661_(f_110110_).m_110671_(f_110152_).m_110677_(f_110154_).m_110691_(true);
        return EpicFightRenderTypes.m_173215_((String)"epicfight:animated_model", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)state);
    });
    private static final Function<ResourceLocation, RenderType> ANIMATED_ITEM_ENTITY_TRANSLUCENT_CULL = Util.m_143827_(textureLocation -> {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(f_173064_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(textureLocation, false, false)).m_110685_(f_110139_).m_110675_(f_110129_).m_110671_(f_110152_).m_110677_(f_110154_).m_110687_(f_110114_).m_110691_(true);
        return EpicFightRenderTypes.m_173215_((String)"epicfight:animated_item_entity_translucent_cull", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)state);
    });
    private static final Function<ResourceLocation, RenderType> ANIMATED_ARMOR_CUTOUT_NO_CULL = Util.m_143827_(p_173206_ -> {
        RenderType.CompositeState rendertype$compositestate = RenderType.CompositeState.m_110628_().m_173292_(f_173111_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(p_173206_, false, false)).m_110685_(f_110134_).m_110661_(f_110110_).m_110671_(f_110152_).m_110677_(f_110154_).m_110669_(f_110119_).m_110691_(true);
        return EpicFightRenderTypes.m_173215_((String)"epicfight:armor_cutout_no_cull", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)rendertype$compositestate);
    });
    private static final Function<ResourceLocation, RenderType> ANIMATED_ARMOR_TRANSPARENT_CUTOUT_NO_CULL = Util.m_143827_(p_173206_ -> {
        RenderType.CompositeState rendertype$compositestate = RenderType.CompositeState.m_110628_().m_173292_(f_173111_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(p_173206_, false, false)).m_110685_(f_110139_).m_110661_(f_110110_).m_110671_(f_110152_).m_110677_(f_110154_).m_110669_(f_110119_).m_110691_(true);
        return EpicFightRenderTypes.m_173215_((String)"epicfight:armor_cutout_no_cull", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)rendertype$compositestate);
    });
    private static final RenderType ANIMATED_ARMOR_GLINT = EpicFightRenderTypes.m_173215_((String)"epicfight:animated_armor_glint", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173078_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ItemRenderer.f_115092_, true, false)).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_).m_110685_(f_110137_).m_110683_(f_110151_).m_110669_(f_110119_).m_110691_(false));
    private static final Function<ResourceLocation, RenderType> ENTITY_INDICATOR = Util.m_143827_(textureLocation -> {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(f_173102_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(textureLocation, false, false)).m_110685_(f_110134_).m_110671_(f_110153_).m_110677_(f_110155_).m_110691_(true);
        return EpicFightRenderTypes.m_173215_((String)"epicfight:entity_indicator", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)state);
    });
    private static final Function<ResourceLocation, RenderType> ENTITY_DECAL_TRIANGLES = Util.m_143827_(p_173194_ -> {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(f_173069_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(p_173194_, false, false)).m_110663_(f_110112_).m_110661_(f_110110_).m_110671_(f_110152_).m_110677_(f_110154_).m_110691_(false);
        return EpicFightRenderTypes.m_173215_((String)"epicfight:entity_decal_triangles", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)state);
    });
    private static final Function<ResourceLocation, RenderType> DRAGON_EXPLOSION_ALPHA_TRIANGLES = Util.m_143827_(textureLocation -> {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(f_173072_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(textureLocation, false, false)).m_110661_(f_110110_).m_110691_(true);
        return EpicFightRenderTypes.m_173215_((String)"epicfight:dragon_explosion_triangles", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)state);
    });
    private static final RenderType DEBUG_COLLIDER = EpicFightRenderTypes.m_173215_((String)"epicfight:debug_collider", (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.LINE_STRIP, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173104_).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.empty())).m_110669_(f_110119_).m_110685_(f_110139_).m_110675_(f_110129_).m_110687_(f_110114_).m_110661_(f_110110_).m_110691_(false));
    private static final RenderType DEBUG_QUADS = EpicFightRenderTypes.m_173215_((String)"epicfight:debug_quad", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173104_).m_110669_(f_110119_).m_110685_(f_110134_).m_110687_(f_110114_).m_110661_(f_110110_).m_110691_(false));
    private static final Function<ResourceLocation, RenderType> ENTITY_TRANSLUCENT_TRIANGLES = texture -> EpicFightRenderTypes.m_173215_((String)"epicfight:entity_transparent", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173066_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_110685_(f_110139_).m_110661_(f_110110_).m_110671_(f_110152_).m_110677_(f_110154_).m_110687_(f_110114_).m_110691_(false));

    private EpicFightRenderTypes(String p_173178_, VertexFormat p_173179_, VertexFormat.Mode p_173180_, int p_173181_, boolean p_173182_, boolean p_173183_, Runnable p_173184_, Runnable p_173185_) {
        super(p_173178_, p_173179_, p_173180_, p_173181_, p_173182_, p_173183_, p_173184_, p_173185_);
    }

    public static RenderType animatedModel(ResourceLocation locationIn) {
        return ANIMATED_MODEL.apply(locationIn);
    }

    public static RenderType itemEntityTranslucentCull(ResourceLocation locationIn) {
        return ANIMATED_ITEM_ENTITY_TRANSLUCENT_CULL.apply(locationIn);
    }

    public static RenderType animatedArmor(ResourceLocation locationIn, boolean transparent) {
        return transparent ? ANIMATED_ARMOR_TRANSPARENT_CUTOUT_NO_CULL.apply(locationIn) : ANIMATED_ARMOR_CUTOUT_NO_CULL.apply(locationIn);
    }

    public static RenderType enchantedAnimatedArmor() {
        return ANIMATED_ARMOR_GLINT;
    }

    public static RenderType entityIndicator(ResourceLocation locationIn) {
        return ENTITY_INDICATOR.apply(locationIn);
    }

    public static RenderType dragonExplosionAlphaTriangles(ResourceLocation locationIn) {
        return DRAGON_EXPLOSION_ALPHA_TRIANGLES.apply(locationIn);
    }

    public static RenderType entityDecalTriangles(ResourceLocation locationIn) {
        return ENTITY_DECAL_TRIANGLES.apply(locationIn);
    }

    public static RenderType debugQuads() {
        return DEBUG_QUADS;
    }

    public static RenderType debugCollider() {
        return DEBUG_COLLIDER;
    }

    public static RenderType energySwirlTrianlges(ResourceLocation texture, float u, float v) {
        return EpicFightRenderTypes.m_173215_((String)"epicfight:energy_swirl_triangles", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173074_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_110683_((RenderStateShard.TexturingStateShard)new RenderStateShard.OffsetTexturingStateShard(u, v)).m_110685_(f_110135_).m_110661_(f_110110_).m_110671_(f_110152_).m_110677_(f_110154_).m_110691_(false));
    }

    public static RenderType entityTranslucentTriangles(ResourceLocation texture) {
        return ENTITY_TRANSLUCENT_TRIANGLES.apply(texture);
    }

    public static VertexConsumer getArmorVertexBuilder(MultiBufferSource buffer, RenderType renderType, boolean withGlint) {
        return withGlint ? VertexMultiConsumer.m_86168_((VertexConsumer)buffer.m_6299_(EpicFightRenderTypes.enchantedAnimatedArmor()), (VertexConsumer)buffer.m_6299_(renderType)) : buffer.m_6299_(renderType);
    }
}

