/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.patched.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.model.ClientModel;
import yesman.epicfight.api.client.model.ClientModels;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.renderer.patched.entity.PatchedEntityRenderer;
import yesman.epicfight.client.renderer.patched.layer.PatchedLayer;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public abstract class PatchedLivingEntityRenderer<E extends LivingEntity, T extends LivingEntityPatch<E>, M extends EntityModel<E>>
extends PatchedEntityRenderer<E, T, LivingEntityRenderer<E, M>> {
    private Map<Class<?>, PatchedLayer<E, T, M, ? extends RenderLayer<E, M>>> patchedLayers = Maps.newHashMap();

    @Override
    public void render(E entityIn, T entitypatch, LivingEntityRenderer<E, M> renderer, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks) {
        super.render(entityIn, entitypatch, renderer, buffer, poseStack, packedLight, partialTicks);
        Minecraft mc = Minecraft.m_91087_();
        boolean isVisible = this.isVisible(entityIn, entitypatch);
        boolean isVisibleToPlayer = !isVisible && !entityIn.m_20177_((Player)mc.f_91074_);
        boolean isGlowing = mc.m_91314_(entityIn);
        RenderType renderType = this.getRenderType(entityIn, entitypatch, renderer, isVisible, isVisibleToPlayer, isGlowing);
        ClientModel model = ((LivingEntityPatch)entitypatch).getEntityModel(ClientModels.LOGICAL_CLIENT);
        Armature armature = model.getArmature();
        poseStack.m_85836_();
        this.mulPoseStack(poseStack, armature, entityIn, entitypatch, partialTicks);
        OpenMatrix4f[] poseMatrices = this.getPoseMatrices(entitypatch, armature, partialTicks);
        if (renderType != null) {
            VertexConsumer builder = buffer.m_6299_(renderType);
            model.drawAnimatedModel(poseStack, builder, packedLight, 1.0f, 1.0f, 1.0f, isVisibleToPlayer ? 0.15f : 1.0f, this.getOverlayCoord(entityIn, entitypatch, partialTicks), poseMatrices);
        }
        if (!entityIn.m_5833_()) {
            this.renderLayer(renderer, entitypatch, entityIn, poseMatrices, buffer, poseStack, packedLight, partialTicks);
        }
        if (renderType != null && Minecraft.m_91087_().m_91290_().m_114377_()) {
            for (Layer.Priority priority : Layer.Priority.values()) {
                AnimationPlayer animPlayer = ((LivingEntityPatch)entitypatch).getClientAnimator().getCompositeLayer((Layer.Priority)priority).animationPlayer;
                float playTime = animPlayer.getPrevElapsedTime() + (animPlayer.getElapsedTime() - animPlayer.getPrevElapsedTime()) * partialTicks;
                animPlayer.getAnimation().renderDebugging(poseStack, buffer, (LivingEntityPatch<?>)entitypatch, playTime, partialTicks);
            }
        }
        poseStack.m_85849_();
    }

    protected void renderLayer(LivingEntityRenderer<E, M> renderer, T entitypatch, E entityIn, OpenMatrix4f[] poses, MultiBufferSource buffer, PoseStack poseStack, int packedLightIn, float partialTicks) {
        ArrayList layers = Lists.newArrayList();
        renderer.f_115291_.forEach(layers::add);
        Iterator iter = layers.iterator();
        float f = MathUtils.lerpBetween(((LivingEntity)entityIn).f_20884_, ((LivingEntity)entityIn).f_20883_, partialTicks);
        float f1 = MathUtils.lerpBetween(((LivingEntity)entityIn).f_20886_, ((LivingEntity)entityIn).f_20885_, partialTicks);
        float f2 = f1 - f;
        float f7 = entityIn.m_5686_(partialTicks);
        while (iter.hasNext()) {
            RenderLayer layer2 = (RenderLayer)iter.next();
            Class<?> rendererClass = layer2.getClass();
            if (rendererClass.isAnonymousClass()) {
                rendererClass = rendererClass.getSuperclass();
            }
            this.patchedLayers.computeIfPresent(rendererClass, (key, val) -> {
                val.renderLayer(0, entitypatch, entityIn, layer2, poseStack, buffer, packedLightIn, poses, f2, f7, partialTicks);
                iter.remove();
                return val;
            });
        }
        OpenMatrix4f modelMatrix = new OpenMatrix4f();
        modelMatrix.mulFront(((LivingEntityPatch)entitypatch).getEntityModel(ClientModels.LOGICAL_CLIENT).getArmature().searchJointById(this.getRootJointIndex()).getAnimatedTransform());
        OpenMatrix4f transpose = OpenMatrix4f.transpose(modelMatrix, null);
        poseStack.m_85836_();
        MathUtils.translateStack(poseStack, modelMatrix);
        MathUtils.rotateStack(poseStack, transpose);
        poseStack.m_85837_(0.0, this.getLayerCorrection(), 0.0);
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        layers.forEach(layer -> layer.m_6494_(poseStack, buffer, packedLightIn, (Entity)entityIn, entityIn.f_20925_, entityIn.f_20924_, partialTicks, (float)entityIn.f_19797_, f2, f7));
        poseStack.m_85849_();
    }

    public RenderType getRenderType(E entityIn, T entitypatch, LivingEntityRenderer<E, M> renderer, boolean isVisible, boolean isVisibleToPlayer, boolean isGlowing) {
        ResourceLocation resourcelocation = this.getEntityTexture(entitypatch, renderer);
        if (isVisibleToPlayer) {
            return EpicFightRenderTypes.itemEntityTranslucentCull(resourcelocation);
        }
        if (isVisible) {
            return EpicFightRenderTypes.animatedModel(resourcelocation);
        }
        return isGlowing ? RenderType.m_110491_((ResourceLocation)resourcelocation) : null;
    }

    protected int getOverlayCoord(E entity, T entitypatch, float partialTicks) {
        return OverlayTexture.m_118093_((int)0, (int)OverlayTexture.m_118096_((((LivingEntity)entity).f_20916_ > 5 ? 1 : 0) != 0));
    }

    @Override
    public void mulPoseStack(PoseStack poseStack, Armature armature, E entityIn, T entitypatch, float partialTicks) {
        super.mulPoseStack(poseStack, armature, entityIn, entitypatch, partialTicks);
        if (entityIn.m_6144_()) {
            poseStack.m_85837_(0.0, 0.15, 0.0);
        }
    }

    public void addPatchedLayer(Class<?> originalLayerClass, PatchedLayer<E, T, M, ? extends RenderLayer<E, M>> patchedLayer) {
        this.patchedLayers.put(originalLayerClass, patchedLayer);
    }

    protected boolean isVisible(E entityIn, T entitypatch) {
        return !entityIn.m_20145_();
    }

    protected int getRootJointIndex() {
        return 0;
    }

    protected double getLayerCorrection() {
        return 1.15;
    }
}

