/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.patched.item;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.client.model.ClientModels;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.renderer.patched.item.RenderItemBase;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public class RenderShield
extends RenderItemBase {
    public RenderShield() {
        super(new OpenMatrix4f().rotateDeg(-80.0f, Vec3f.X_AXIS).translate(0.0f, 0.2f, 0.0f), new OpenMatrix4f().translate(0.0f, 1.5f, -0.15f).rotateDeg(180.0f, Vec3f.Y_AXIS).rotateDeg(90.0f, Vec3f.X_AXIS));
    }

    @Override
    public void renderItemInHand(ItemStack stack, LivingEntityPatch<?> entitypatch, InteractionHand hand, MultiBufferSource buffer, PoseStack poseStack, int packedLight) {
        OpenMatrix4f modelMatrix = this.getCorrectionMatrix(stack, entitypatch, hand);
        String holdingHand = hand == InteractionHand.MAIN_HAND ? "Tool_R" : "Tool_L";
        OpenMatrix4f jointTransform = entitypatch.getEntityModel(ClientModels.LOGICAL_CLIENT).getArmature().searchJointByName(holdingHand).getAnimatedTransform();
        modelMatrix.mulFront(jointTransform);
        poseStack.m_85836_();
        this.mulPoseStack(poseStack, modelMatrix);
        ItemTransforms.TransformType transformType = hand == InteractionHand.MAIN_HAND ? ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND : ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND;
        Minecraft.m_91087_().m_91291_().m_174269_(stack, transformType, packedLight, OverlayTexture.f_118083_, poseStack, buffer, 0);
        poseStack.m_85849_();
        GlStateManager.m_84513_();
    }
}

