/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.config;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.client.gui.widget.ColorSlider;
import yesman.epicfight.config.ClientConfig;
import yesman.epicfight.config.ConfigManager;
import yesman.epicfight.config.Option;

public class ConfigurationIngame {
    public static final float A_TICK = 0.05f;
    public static final float GENERAL_ANIMATION_CONVERT_TIME = 0.15f;
    public final Option.IntegerOption longPressCount;
    public final Option<Boolean> filterAnimation;
    public final Option<Boolean> showHealthIndicator;
    public final Option<Boolean> showTargetIndicator;
    public final Option.DoubleOption aimHelperColor;
    public final Option<Boolean> enableAimHelperPointer;
    public final Option<Boolean> cameraAutoSwitch;
    public final Option<Boolean> autoPreparation;
    public final Option<Boolean> offBloodEffects;
    public final List<Item> battleAutoSwitchItems;
    public final List<Item> miningAutoSwitchItems;
    public int aimHelperRealColor;

    public ConfigurationIngame() {
        ClientConfig config = ConfigManager.INGAME_CONFIG;
        this.longPressCount = new Option.IntegerOption((Integer)config.longPressCountConfig.get(), 1, 10);
        this.filterAnimation = new Option<Boolean>((Boolean)config.filterAnimation.get());
        this.showHealthIndicator = new Option<Boolean>((Boolean)config.showHealthIndicator.get());
        this.showTargetIndicator = new Option<Boolean>((Boolean)config.showTargetIndicator.get());
        this.aimHelperColor = new Option.DoubleOption((Double)config.aimHelperColor.get(), 0.0, 1.0);
        this.enableAimHelperPointer = new Option<Boolean>((Boolean)config.enableAimHelper.get());
        this.aimHelperRealColor = ColorSlider.toColorInteger((Double)config.aimHelperColor.get());
        this.cameraAutoSwitch = new Option<Boolean>((Boolean)config.cameraAutoSwitch.get());
        this.autoPreparation = new Option<Boolean>((Boolean)config.autoPreparation.get());
        this.offBloodEffects = new Option<Boolean>((Boolean)config.offBloodEffects.get());
        this.battleAutoSwitchItems = Lists.newArrayList(((List)config.battleAutoSwitchItems.get()).stream().map(itemName -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName))).iterator());
        this.miningAutoSwitchItems = Lists.newArrayList(((List)config.miningAutoSwitchItems.get()).stream().map(itemName -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName))).iterator());
    }

    public void resetSettings() {
        this.longPressCount.setDefaultValue();
        this.filterAnimation.setDefaultValue();
        this.showHealthIndicator.setDefaultValue();
        this.showTargetIndicator.setDefaultValue();
        this.aimHelperColor.setDefaultValue();
        this.enableAimHelperPointer.setDefaultValue();
        this.cameraAutoSwitch.setDefaultValue();
        this.autoPreparation.setDefaultValue();
        this.offBloodEffects.setDefaultValue();
        this.aimHelperRealColor = ColorSlider.toColorInteger((Double)this.aimHelperColor.getValue());
    }

    public void save() {
        ClientConfig config = ConfigManager.INGAME_CONFIG;
        config.longPressCountConfig.set((Object)((Integer)this.longPressCount.getValue()));
        config.filterAnimation.set((Object)this.filterAnimation.getValue());
        config.showHealthIndicator.set((Object)this.showHealthIndicator.getValue());
        config.showTargetIndicator.set((Object)this.showTargetIndicator.getValue());
        config.aimHelperColor.set((Object)((Double)this.aimHelperColor.getValue()));
        config.enableAimHelper.set((Object)this.enableAimHelperPointer.getValue());
        config.cameraAutoSwitch.set((Object)this.cameraAutoSwitch.getValue());
        config.autoPreparation.set((Object)this.autoPreparation.getValue());
        config.offBloodEffects.set((Object)this.offBloodEffects.getValue());
        this.aimHelperRealColor = ColorSlider.toColorInteger((Double)this.aimHelperColor.getValue());
        config.battleAutoSwitchItems.set((Object)Lists.newArrayList(this.battleAutoSwitchItems.stream().map(item -> item.getRegistryName().toString()).iterator()));
        config.miningAutoSwitchItems.set((Object)Lists.newArrayList(this.miningAutoSwitchItems.stream().map(item -> item.getRegistryName().toString()).iterator()));
    }
}

