/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.events;

import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.ExtendedDamageSource;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPPlayAnimation;
import yesman.epicfight.network.server.SPPotion;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.HumanoidMobPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.EndermanPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.projectile.ProjectilePatch;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.eventlistener.HurtEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.ProjectileHitEvent;
import yesman.epicfight.world.gamerule.EpicFightGamerules;

@Mod.EventBusSubscriber(modid="epicfight")
public class EntityEvents {
    @SubscribeEvent
    public static void spawnEvent(EntityJoinWorldEvent event) {
        EntityPatch entitypatch = (EntityPatch)event.getEntity().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
        if (entitypatch != null && !entitypatch.isInitialized()) {
            entitypatch.onJoinWorld(event.getEntity(), event);
        }
        if (event.getEntity() instanceof Projectile) {
            Projectile projectileentity = (Projectile)event.getEntity();
            ProjectilePatch projectilePatch = (ProjectilePatch)event.getEntity().getCapability(EpicFightCapabilities.CAPABILITY_PROJECTILE, null).orElse(null);
            if (projectilePatch != null) {
                projectilePatch.onJoinWorld(projectileentity, event);
            }
        }
    }

    @SubscribeEvent
    public static void updateEvent(LivingEvent.LivingUpdateEvent event) {
        LivingEntityPatch entitypatch = (LivingEntityPatch)event.getEntityLiving().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
        if (entitypatch != null && entitypatch.getOriginal() != null) {
            entitypatch.tick(event);
        }
    }

    @SubscribeEvent
    public static void knockBackEvent(LivingKnockBackEvent event) {
        EntityPatch cap = (EntityPatch)event.getEntityLiving().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null);
        if (cap != null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void hurtEvent(LivingHurtEvent event) {
        ExtendedDamageSource extendedDamageSource = null;
        Entity trueSource = event.getSource().m_7639_();
        if (trueSource != null) {
            ProjectilePatch projectileCap;
            if (event.getSource() instanceof ExtendedDamageSource) {
                extendedDamageSource = (ExtendedDamageSource)event.getSource();
            } else if (event.getSource() instanceof IndirectEntityDamageSource && event.getSource().m_7640_() != null && (projectileCap = (ProjectilePatch)event.getSource().m_7640_().getCapability(EpicFightCapabilities.CAPABILITY_PROJECTILE, null).orElse(null)) != null) {
                extendedDamageSource = projectileCap.getEpicFightDamageSource(event.getSource());
            }
            if (extendedDamageSource != null) {
                LivingEntityPatch hitentitypatch;
                int k;
                int i;
                int j;
                float f;
                float f1;
                float f2;
                float ignoreDamage;
                LivingEntity hitEntity = event.getEntityLiving();
                float totalDamage = event.getAmount();
                if (hitEntity instanceof ServerPlayer) {
                    ServerPlayerPatch playerpatch = (ServerPlayerPatch)hitEntity.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null);
                    HurtEvent.Post hurtEvent = new HurtEvent.Post(playerpatch, extendedDamageSource, totalDamage);
                    playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.HURT_EVENT_POST, hurtEvent);
                    totalDamage = hurtEvent.getAmount();
                }
                float calculatedDamage = ignoreDamage = totalDamage * extendedDamageSource.getArmorNegation() * 0.01f;
                if (hitEntity.m_21023_(MobEffects.f_19606_) && (f2 = (f1 = calculatedDamage) - (calculatedDamage = Math.max((f = calculatedDamage * (float)(j = 25 - (i = (hitEntity.m_21124_(MobEffects.f_19606_).m_19564_() + 1) * 5))) / 25.0f, 0.0f))) > 0.0f && f2 < 3.4028235E37f) {
                    if (hitEntity instanceof ServerPlayer) {
                        ((ServerPlayer)hitEntity).m_36222_(Stats.f_12934_, Math.round(f2 * 10.0f));
                    } else if (event.getSource().m_7639_() instanceof ServerPlayer) {
                        ((ServerPlayer)event.getSource().m_7639_()).m_36222_(Stats.f_12930_, Math.round(f2 * 10.0f));
                    }
                }
                if (calculatedDamage > 0.0f && (k = EnchantmentHelper.m_44856_((Iterable)hitEntity.m_6168_(), (DamageSource)event.getSource())) > 0) {
                    calculatedDamage = CombatRules.m_19269_((float)calculatedDamage, (float)k);
                }
                float absorpAmount = hitEntity.m_6103_() - calculatedDamage;
                hitEntity.m_7911_(Math.max(absorpAmount, 0.0f));
                float realHealthDamage = Math.max(-absorpAmount, 0.0f);
                if (realHealthDamage > 0.0f && realHealthDamage < 3.4028235E37f && event.getSource().m_7639_() instanceof ServerPlayer) {
                    ((ServerPlayer)event.getSource().m_7639_()).m_36222_(Stats.f_12929_, Math.round(realHealthDamage * 10.0f));
                }
                if (absorpAmount < 0.0f) {
                    hitEntity.m_21153_(hitEntity.m_21223_() + absorpAmount);
                    LivingEntityPatch attacker = (LivingEntityPatch)trueSource.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
                    if (attacker != null) {
                        attacker.gatherDamageDealt(extendedDamageSource, calculatedDamage);
                    }
                }
                event.setAmount(totalDamage - ignoreDamage);
                if (event.getAmount() + ignoreDamage > 0.0f && (hitentitypatch = (LivingEntityPatch)hitEntity.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null)) != null) {
                    StaticAnimation hitAnimation = null;
                    float extendStunTime = 0.0f;
                    float knockBackAmount = 0.0f;
                    float weightReduction = 40.0f / hitentitypatch.getWeight();
                    float stunShield = hitentitypatch.getStunShield();
                    if (stunShield > 0.0f) {
                        hitentitypatch.setStunShield(stunShield - extendedDamageSource.getImpact());
                    }
                    switch (extendedDamageSource.getStunType()) {
                        case SHORT: {
                            if (hitEntity.m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get()) || hitentitypatch.getStunShield() != 0.0f) break;
                            float totalStunTime = (0.25f + extendedDamageSource.getImpact() * 0.1f) * weightReduction;
                            if (!((totalStunTime *= 1.0f - hitentitypatch.getStunTimeTimeReduction()) >= 0.1f)) break;
                            extendStunTime = totalStunTime - 0.1f;
                            boolean flag = totalStunTime >= 0.83f;
                            ExtendedDamageSource.StunType stunType = flag ? ExtendedDamageSource.StunType.LONG : ExtendedDamageSource.StunType.SHORT;
                            extendStunTime = flag ? 0.0f : extendStunTime;
                            hitAnimation = hitentitypatch.getHitAnimation(stunType);
                            knockBackAmount = Math.min(flag ? extendedDamageSource.getImpact() * 0.05f : totalStunTime, 2.0f);
                            break;
                        }
                        case LONG: {
                            hitAnimation = hitEntity.m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get()) ? null : hitentitypatch.getHitAnimation(ExtendedDamageSource.StunType.LONG);
                            knockBackAmount = Math.min(extendedDamageSource.getImpact() * 0.25f * weightReduction, 5.0f);
                            break;
                        }
                        case HOLD: {
                            hitAnimation = hitentitypatch.getHitAnimation(ExtendedDamageSource.StunType.SHORT);
                            extendStunTime = extendedDamageSource.getImpact() * 0.1f;
                            break;
                        }
                        case KNOCKDOWN: {
                            hitAnimation = hitEntity.m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get()) ? null : hitentitypatch.getHitAnimation(ExtendedDamageSource.StunType.KNOCKDOWN);
                            knockBackAmount = Math.min(extendedDamageSource.getImpact() * 0.05f, 5.0f);
                            break;
                        }
                        case FALL: {
                            break;
                        }
                    }
                    Vec3 sourcePosition = ((DamageSource)extendedDamageSource).m_7270_();
                    if (sourcePosition != null) {
                        if (hitAnimation != null) {
                            if (!(hitEntity instanceof Player)) {
                                hitEntity.m_7618_(EntityAnchorArgument.Anchor.FEET, sourcePosition);
                            }
                            hitentitypatch.setStunReductionOnHit();
                            hitentitypatch.playAnimationSynchronized(hitAnimation, extendStunTime);
                        }
                        if (knockBackAmount != 0.0f) {
                            hitentitypatch.knockBackEntity(((DamageSource)extendedDamageSource).m_7270_(), knockBackAmount);
                        }
                    }
                }
            }
        }
        if (event.getEntityLiving().m_6117_() && event.getEntityLiving().m_21211_().m_41720_() == Items.f_42740_ && event.getEntityLiving() instanceof Player) {
            event.getEntityLiving().f_19853_.m_5594_((Player)event.getEntityLiving(), event.getEntityLiving().m_142538_(), SoundEvents.f_12346_, event.getEntityLiving().m_5720_(), 1.0f, 0.8f + event.getEntityLiving().m_21187_().nextFloat() * 0.4f);
        }
    }

    @SubscribeEvent
    public static void damageEvent(LivingDamageEvent event) {
        LivingEntityPatch attacker;
        Entity trueSource = event.getSource().m_7639_();
        if (event.getSource() instanceof ExtendedDamageSource && trueSource != null && (attacker = (LivingEntityPatch)trueSource.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null)) != null) {
            attacker.gatherDamageDealt((ExtendedDamageSource)event.getSource(), event.getAmount());
        }
    }

    @SubscribeEvent
    public static void attackEvent(LivingAttackEvent event) {
        if (event.getEntity().f_19853_.m_5776_()) {
            return;
        }
        LivingEntityPatch entitypatch = (LivingEntityPatch)event.getEntity().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null);
        Object damageSource = null;
        if (entitypatch != null && event.getEntityLiving().m_21223_() > 0.0f) {
            ProjectilePatch projectilepatch;
            if (event.getSource() instanceof IndirectEntityDamageSource && event.getSource().m_7640_() != null && (projectilepatch = (ProjectilePatch)event.getSource().m_7640_().getCapability(EpicFightCapabilities.CAPABILITY_PROJECTILE).orElse(null)) != null) {
                damageSource = projectilepatch.getEpicFightDamageSource(event.getSource());
            }
            if (damageSource == null) {
                damageSource = event.getSource();
            }
            AttackResult result = entitypatch.tryHurt((DamageSource)damageSource, event.getAmount());
            if (!result.resultType.dealtDamage()) {
                event.setCanceled(true);
            } else if (event.getAmount() != result.damage) {
                event.setCanceled(true);
                DamageSource damagesource = new DamageSource(event.getSource().m_19385_());
                damagesource.m_19381_();
                event.getEntity().m_6469_(damagesource, result.damage);
            }
        }
    }

    @SubscribeEvent
    public static void dropEvent(LivingDropsEvent event) {
        LivingEntityPatch entitypatch = (LivingEntityPatch)event.getEntityLiving().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null);
        if (entitypatch != null && entitypatch.onDrop(event)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void projectileImpactEvent(ProjectileImpactEvent event) {
        EntityHitResult rayresult;
        ProjectilePatch projectilepatch = (ProjectilePatch)event.getProjectile().getCapability(EpicFightCapabilities.CAPABILITY_PROJECTILE, null).orElse(null);
        if (!event.getProjectile().f_19853_.m_5776_() && projectilepatch != null && projectilepatch.onProjectileImpact(event)) {
            event.setCanceled(true);
            return;
        }
        if (event.getRayTraceResult() instanceof EntityHitResult && (rayresult = (EntityHitResult)event.getRayTraceResult()).m_82443_() != null) {
            ServerPlayerPatch playerpatch;
            boolean canceled;
            if (rayresult.m_82443_() instanceof ServerPlayer && (canceled = (playerpatch = (ServerPlayerPatch)rayresult.m_82443_().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null)).getEventListener().triggerEvents(PlayerEventListener.EventType.PROJECTILE_HIT_EVENT, new ProjectileHitEvent(playerpatch, event)))) {
                event.setCanceled(true);
            }
            if (event.getProjectile().m_37282_() != null) {
                if (rayresult.m_82443_().equals((Object)event.getProjectile().m_37282_().m_20202_())) {
                    event.setCanceled(true);
                }
                if (rayresult.m_82443_() instanceof PartEntity) {
                    Entity parent = ((PartEntity)rayresult.m_82443_()).getParent();
                    if (event.getProjectile().m_37282_().m_7306_(parent)) {
                        event.setCanceled(true);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void equipChangeEvent(LivingEquipmentChangeEvent event) {
        if (event.getFrom().m_41720_() == event.getTo().m_41720_()) {
            return;
        }
        LivingEntityPatch entitypatch = (LivingEntityPatch)event.getEntity().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
        CapabilityItem fromCap = EpicFightCapabilities.getItemStackCapability(event.getFrom());
        CapabilityItem toCap = EpicFightCapabilities.getItemStackCapability(event.getTo());
        if (event.getSlot() != EquipmentSlot.OFFHAND) {
            if (fromCap != null) {
                event.getEntityLiving().m_21204_().m_22161_(fromCap.getAttributeModifiers(event.getSlot(), entitypatch));
            }
            if (toCap != null) {
                event.getEntityLiving().m_21204_().m_22178_(toCap.getAttributeModifiers(event.getSlot(), entitypatch));
            }
        }
        if (entitypatch != null && entitypatch.getOriginal() != null) {
            if (event.getSlot().m_20743_() == EquipmentSlot.Type.HAND) {
                InteractionHand hand = event.getSlot() == EquipmentSlot.MAINHAND ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
                entitypatch.updateHeldItem(fromCap, toCap, event.getFrom(), event.getTo(), hand);
            } else if (event.getSlot().m_20743_() == EquipmentSlot.Type.ARMOR) {
                entitypatch.updateArmor(fromCap, toCap, event.getSlot());
            }
        }
    }

    @SubscribeEvent
    public static void sizingEvent(EntityEvent.Size event) {
        if (event.getEntity() instanceof EnderDragon) {
            event.setNewSize(EntityDimensions.m_20395_((float)5.0f, (float)3.0f));
        }
    }

    @SubscribeEvent
    public static void effectAddEvent(PotionEvent.PotionAddedEvent event) {
        if (!event.getEntity().f_19853_.m_5776_()) {
            EpicFightNetworkManager.sendToAll(new SPPotion(event.getPotionEffect().m_19544_(), SPPotion.Action.ACTIVATE, event.getEntity().m_142049_()));
        }
    }

    @SubscribeEvent
    public static void effectRemoveEvent(PotionEvent.PotionRemoveEvent event) {
        if (!event.getEntity().f_19853_.m_5776_() && event.getPotionEffect() != null) {
            EpicFightNetworkManager.sendToAll(new SPPotion(event.getPotionEffect().m_19544_(), SPPotion.Action.REMOVE, event.getEntity().m_142049_()));
        }
    }

    @SubscribeEvent
    public static void effectExpiryEvent(PotionEvent.PotionExpiryEvent event) {
        if (!event.getEntity().f_19853_.m_5776_()) {
            EpicFightNetworkManager.sendToAll(new SPPotion(event.getPotionEffect().m_19544_(), SPPotion.Action.REMOVE, event.getEntity().m_142049_()));
        }
    }

    @SubscribeEvent
    public static void mountEvent(EntityMountEvent event) {
        EntityPatch mountEntity = (EntityPatch)event.getEntityMounting().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
        if (!event.getWorldObj().m_5776_() && mountEntity instanceof HumanoidMobPatch && mountEntity.getOriginal() != null && event.getEntityBeingMounted() instanceof Mob) {
            ((HumanoidMobPatch)mountEntity).onMount(event.isMounting(), event.getEntityBeingMounted());
        }
    }

    @SubscribeEvent
    public static void tpEvent(EntityTeleportEvent.EnderEntity event) {
        EnderMan enderman;
        EndermanPatch endermanpatch;
        LivingEntity entity = event.getEntityLiving();
        if (event.getEntityLiving() instanceof EnderMan && (endermanpatch = (EndermanPatch)(enderman = (EnderMan)entity).getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null)) != null) {
            if (endermanpatch.getEntityState().inaction()) {
                for (Entity collideEntity : enderman.f_19853_.m_45976_(Entity.class, enderman.m_142469_().m_82377_(0.2, 0.2, 0.2))) {
                    if (!(collideEntity instanceof Projectile)) continue;
                    return;
                }
                event.setCanceled(true);
            } else if (endermanpatch.isRaging()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void jumpEvent(LivingEvent.LivingJumpEvent event) {
        LivingEntityPatch entitypatch = (LivingEntityPatch)event.getEntity().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
        if (entitypatch != null && entitypatch.isLogicalClient() && !entitypatch.getEntityState().inaction() && !event.getEntity().m_20069_()) {
            StaticAnimation jumpAnimation = entitypatch.getClientAnimator().getJumpAnimation();
            ((Animator)entitypatch.getAnimator()).playAnimation(jumpAnimation, 0.0f);
            EpicFightNetworkManager.sendToServer(new CPPlayAnimation(jumpAnimation.getNamespaceId(), jumpAnimation.getId(), 0.0f, true, false));
        }
    }

    @SubscribeEvent
    public static void deathEvent(LivingDeathEvent event) {
        LivingEntityPatch entitypatch = (LivingEntityPatch)event.getEntityLiving().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
        if (entitypatch != null) {
            entitypatch.onDeath();
        }
    }

    @SubscribeEvent
    public static void fallEvent(LivingFallEvent event) {
        StaticAnimation fallAnimation;
        float distance;
        LivingEntityPatch entitypatch;
        if (event.getEntity().f_19853_.m_46469_().m_46207_(EpicFightGamerules.HAS_FALL_ANIMATION) && !event.getEntity().f_19853_.m_5776_() && event.getDamageMultiplier() > 0.0f && (entitypatch = (LivingEntityPatch)event.getEntity().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null)) != null && !entitypatch.getEntityState().inaction() && (distance = event.getDistance()) > 5.0f && (fallAnimation = entitypatch.getHitAnimation(ExtendedDamageSource.StunType.FALL)) != null) {
            entitypatch.playAnimationSynchronized(fallAnimation, 0.0f);
        }
    }
}

