/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.events;

import net.minecraft.client.player.LocalPlayer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.UseAnim;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPChangeGamerule;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.ItemUseEndEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.RightClickItemEvent;
import yesman.epicfight.world.gamerule.EpicFightGamerules;

@Mod.EventBusSubscriber(modid="epicfight")
public class PlayerEvents {
    @SubscribeEvent
    public static void startTrackingEvent(PlayerEvent.StartTracking event) {
        Entity trackingTarget = event.getTarget();
        LivingEntityPatch entitypatch = (LivingEntityPatch)trackingTarget.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null);
        if (entitypatch != null) {
            entitypatch.onStartTracking((ServerPlayer)event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void rightClickItemServerEvent(PlayerInteractEvent.RightClickItem event) {
        ServerPlayerPatch playerpatch;
        if (!(event.getSide() != LogicalSide.SERVER || (playerpatch = (ServerPlayerPatch)event.getPlayer().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null)) == null || ((ServerPlayer)playerpatch.getOriginal()).m_21206_().m_41780_() != UseAnim.NONE && playerpatch.getHoldingItemCapability(InteractionHand.MAIN_HAND).getStyle(playerpatch).canUseOffhand())) {
            boolean canceled = playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, new RightClickItemEvent<ServerPlayerPatch>(playerpatch));
            if (playerpatch.getEntityState().movementLocked()) {
                canceled = true;
            }
            event.setCanceled(canceled);
        }
    }

    @SubscribeEvent
    public static void itemUseStartEvent(LivingEntityUseItemEvent.Start event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            PlayerPatch playerpatch = (PlayerPatch)event.getEntity().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null);
            InteractionHand hand = player.m_21120_(InteractionHand.MAIN_HAND).equals(event.getItem()) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
            CapabilityItem itemCap = playerpatch.getHoldingItemCapability(hand);
            if (!playerpatch.getEntityState().canUseSkill()) {
                event.setCanceled(true);
            } else if (event.getItem() == player.m_21206_() && !playerpatch.getHoldingItemCapability(InteractionHand.MAIN_HAND).getStyle(playerpatch).canUseOffhand()) {
                event.setCanceled(true);
            }
            if (itemCap.getUseAnimation(playerpatch) == UseAnim.BLOCK) {
                event.setDuration(Integer.MAX_VALUE);
            }
        }
    }

    @SubscribeEvent
    public static void cloneEvent(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        ServerPlayerPatch oldCap = (ServerPlayerPatch)event.getOriginal().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null);
        if (oldCap != null) {
            ServerPlayerPatch newCap = (ServerPlayerPatch)event.getPlayer().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null);
            if (!event.isWasDeath() || event.getOriginal().f_19853_.m_46469_().m_46207_(EpicFightGamerules.KEEP_SKILLS)) {
                newCap.copySkillsFrom(oldCap);
            }
            newCap.toMode(oldCap.getPlayerMode(), false);
        }
        event.getOriginal().invalidateCaps();
    }

    @SubscribeEvent
    public static void changeDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getPlayer();
        ServerPlayerPatch playerpatch = (ServerPlayerPatch)player.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
        playerpatch.modifyLivingMotionByCurrentItem();
        EpicFightNetworkManager.sendToPlayer(new SPChangeGamerule(SPChangeGamerule.SynchronizedGameRules.WEIGHT_PENALTY, player.f_19853_.m_46469_().m_46215_(EpicFightGamerules.WEIGHT_PENALTY)), (ServerPlayer)player);
        EpicFightNetworkManager.sendToPlayer(new SPChangeGamerule(SPChangeGamerule.SynchronizedGameRules.DIABLE_ENTITY_UI, player.f_19853_.m_46469_().m_46207_(EpicFightGamerules.DISABLE_ENTITY_UI)), (ServerPlayer)player);
    }

    @SubscribeEvent
    public static void itemUseStopEvent(LivingEntityUseItemEvent.Stop event) {
        ServerPlayer player;
        ServerPlayerPatch playerpatch;
        if (event.getEntity().f_19853_.m_5776_()) {
            if (event.getEntity() instanceof LocalPlayer) {
                ClientEngine.instance.renderEngine.zoomOut(0);
            }
        } else if (event.getEntity() instanceof ServerPlayer && (playerpatch = (ServerPlayerPatch)(player = (ServerPlayer)event.getEntity()).getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null)) != null) {
            boolean canceled = playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.SERVER_ITEM_STOP_EVENT, new ItemUseEndEvent(playerpatch));
            event.setCanceled(canceled);
        }
    }

    @SubscribeEvent
    public static void itemUseTickEvent(LivingEntityUseItemEvent.Tick event) {
        PlayerPatch playerpatch;
        if (event.getEntity() instanceof Player && event.getItem().m_41720_() instanceof BowItem && (playerpatch = (PlayerPatch)event.getEntity().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null)).getEntityState().inaction()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void attackEntityEvent(AttackEntityEvent event) {
        boolean isLivingTarget;
        boolean bl = isLivingTarget = event.getTarget() instanceof LivingEntity ? ((LivingEntity)event.getTarget()).m_5789_() : false;
        if (!event.getEntity().f_19853_.m_46469_().m_46207_(EpicFightGamerules.DO_VANILLA_ATTACK) && isLivingTarget) {
            event.setCanceled(true);
        }
    }
}

