/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.gameasset;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.forgeevent.SkillRegistryEvent;
import yesman.epicfight.api.utils.ExtendedDamageSource;
import yesman.epicfight.api.utils.math.ExtraDamageType;
import yesman.epicfight.api.utils.math.ValueCorrector;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.skill.ActiveGuardSkill;
import yesman.epicfight.skill.AirAttack;
import yesman.epicfight.skill.BasicAttack;
import yesman.epicfight.skill.BerserkerSkill;
import yesman.epicfight.skill.BladeRushSkill;
import yesman.epicfight.skill.DodgeSkill;
import yesman.epicfight.skill.EnergizingGuardSkill;
import yesman.epicfight.skill.EviscerateSkill;
import yesman.epicfight.skill.FatalDrawSkill;
import yesman.epicfight.skill.GuardSkill;
import yesman.epicfight.skill.KatanaPassive;
import yesman.epicfight.skill.KnockdownWakeupSkill;
import yesman.epicfight.skill.LethalSlicingSkill;
import yesman.epicfight.skill.LiechtenauerSkill;
import yesman.epicfight.skill.PassiveSkill;
import yesman.epicfight.skill.SimpleSpecialAttackSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SpecialAttackSkill;
import yesman.epicfight.skill.StaminaPillagerSkill;
import yesman.epicfight.skill.StepSkill;
import yesman.epicfight.skill.SwordmasterSkill;
import yesman.epicfight.skill.TechnicianSkill;

public class Skills {
    private static final Map<ResourceLocation, Skill> SKILLS = Maps.newHashMap();
    private static final Map<ResourceLocation, Skill> LEARNABLE_SKILLS = Maps.newHashMap();
    private static final Random RANDOM = new Random();
    private static int LAST_PICK = 0;
    public static Skill BASIC_ATTACK;
    public static Skill AIR_ATTACK;
    public static Skill KNOCKDOWN_WAKEUP;
    public static Skill ROLL;
    public static Skill STEP;
    public static Skill GUARD;
    public static Skill ACTIVE_GUARD;
    public static Skill ENERGIZING_GUARD;
    public static Skill BERSERKER;
    public static Skill STAMINA_PILLAGER;
    public static Skill SWORD_MASTER;
    public static Skill TECHNICIAN;
    public static Skill GUILLOTINE_AXE;
    public static Skill SWEEPING_EDGE;
    public static Skill DANCING_EDGE;
    public static Skill SLAUGHTER_STANCE;
    public static Skill HEARTPIERCER;
    public static Skill GIANT_WHIRLWIND;
    public static Skill FATAL_DRAW;
    public static Skill KATANA_PASSIVE;
    public static Skill LETHAL_SLICING;
    public static Skill RELENTLESS_COMBO;
    public static Skill LIECHTENAUER;
    public static Skill EVISCERATE;
    public static Skill BLADE_RUSH;
    public static Skill CHARGING_JUMP;
    public static Skill GROUND_SLAM;

    public static Skill getSkill(String name) {
        ResourceLocation rl = name.indexOf(58) >= 0 ? new ResourceLocation(name) : new ResourceLocation("epicfight", name);
        if (SKILLS.containsKey(rl)) {
            return SKILLS.get(rl);
        }
        return null;
    }

    public static Collection<ResourceLocation> getLearnableSkillNames() {
        return LEARNABLE_SKILLS.keySet();
    }

    public static Collection<Skill> getLearnableSkills() {
        return LEARNABLE_SKILLS.values();
    }

    public static String getRandomLearnableSkillName() {
        ArrayList<Skill> values = new ArrayList<Skill>(LEARNABLE_SKILLS.values());
        LAST_PICK = (LAST_PICK + RANDOM.nextInt(values.size() - 1) + 1) % values.size();
        return ((Skill)values.get(LAST_PICK)).toString();
    }

    public static void registerSkills() {
        BASIC_ATTACK = Skills.registerSkill(new BasicAttack(BasicAttack.createBuilder()));
        AIR_ATTACK = Skills.registerSkill(new AirAttack(AirAttack.createBuilder()));
        ROLL = Skills.registerSkill(new DodgeSkill(DodgeSkill.createBuilder(new ResourceLocation("epicfight", "roll")).setConsumption(4.0f).setAnimations(Animations.BIPED_ROLL_FORWARD, Animations.BIPED_ROLL_BACKWARD)));
        STEP = Skills.registerSkill(new StepSkill(DodgeSkill.createBuilder(new ResourceLocation("epicfight", "step")).setConsumption(3.0f).setAnimations(Animations.BIPED_STEP_FORWARD, Animations.BIPED_STEP_BACKWARD, Animations.BIPED_STEP_LEFT, Animations.BIPED_STEP_RIGHT)));
        KNOCKDOWN_WAKEUP = Skills.registerSkill(new KnockdownWakeupSkill(DodgeSkill.createBuilder(new ResourceLocation("epicfight", "knockdown_wakeup")).setConsumption(6.0f).setAnimations(Animations.BIPED_KNOCKDOWN_WAKEUP_LEFT, Animations.BIPED_KNOCKDOWN_WAKEUP_RIGHT).setCategory(SkillCategories.KNOCKDOWN_WAKEUP)));
        GUARD = Skills.registerSkill(new GuardSkill(GuardSkill.createBuilder(new ResourceLocation("epicfight", "guard")).setRequiredXp(5)));
        ACTIVE_GUARD = Skills.registerSkill(new ActiveGuardSkill(ActiveGuardSkill.createBuilder(new ResourceLocation("epicfight", "active_guard")).setRequiredXp(8)));
        ENERGIZING_GUARD = Skills.registerSkill(new EnergizingGuardSkill(EnergizingGuardSkill.createBuilder(new ResourceLocation("epicfight", "energizing_guard")).setRequiredXp(8)));
        BERSERKER = Skills.registerSkill(new BerserkerSkill(PassiveSkill.createBuilder(new ResourceLocation("epicfight", "berserker"))));
        STAMINA_PILLAGER = Skills.registerSkill(new StaminaPillagerSkill(PassiveSkill.createBuilder(new ResourceLocation("epicfight", "stamina_pillager"))));
        SWORD_MASTER = Skills.registerSkill(new SwordmasterSkill(PassiveSkill.createBuilder(new ResourceLocation("epicfight", "swordmaster"))));
        TECHNICIAN = Skills.registerSkill(new TechnicianSkill(PassiveSkill.createBuilder(new ResourceLocation("epicfight", "technician"))));
        SWEEPING_EDGE = Skills.registerSkill(new SimpleSpecialAttackSkill(SimpleSpecialAttackSkill.createBuilder(new ResourceLocation("epicfight", "sweeping_edge")).setConsumption(30.0f).setAnimations(Animations.SWEEPING_EDGE)).newPropertyLine().addProperty(AnimationProperty.AttackPhaseProperty.MAX_STRIKES, ValueCorrector.adder(1.0f)).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE, ValueCorrector.multiplier(2.0f)).addProperty(AnimationProperty.AttackPhaseProperty.ARMOR_NEGATION, ValueCorrector.adder(20.0f)).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT, ValueCorrector.multiplier(1.6f)).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, ExtendedDamageSource.StunType.LONG).registerPropertiesToAnimation());
        DANCING_EDGE = Skills.registerSkill(new SimpleSpecialAttackSkill(SimpleSpecialAttackSkill.createBuilder(new ResourceLocation("epicfight", "dancing_edge")).setConsumption(30.0f).setAnimations(Animations.DANCING_EDGE)).newPropertyLine().addProperty(AnimationProperty.AttackPhaseProperty.MAX_STRIKES, ValueCorrector.adder(1.0f)).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT, ValueCorrector.multiplier(1.2f)).registerPropertiesToAnimation());
        GUILLOTINE_AXE = Skills.registerSkill(new SimpleSpecialAttackSkill(SimpleSpecialAttackSkill.createBuilder(new ResourceLocation("epicfight", "guillotine_axe")).setConsumption(20.0f).setAnimations(Animations.GUILLOTINE_AXE)).newPropertyLine().addProperty(AnimationProperty.AttackPhaseProperty.MAX_STRIKES, ValueCorrector.setter(1.0f)).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE, ValueCorrector.multiplier(2.5f)).addProperty(AnimationProperty.AttackPhaseProperty.ARMOR_NEGATION, ValueCorrector.adder(20.0f)).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT, ValueCorrector.multiplier(2.0f)).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, ExtendedDamageSource.StunType.LONG).registerPropertiesToAnimation());
        SLAUGHTER_STANCE = Skills.registerSkill(new SimpleSpecialAttackSkill(SimpleSpecialAttackSkill.createBuilder(new ResourceLocation("epicfight", "slaughter_stance")).setConsumption(40.0f).setAnimations(Animations.SPEAR_SLASH)).newPropertyLine().addProperty(AnimationProperty.AttackPhaseProperty.MAX_STRIKES, ValueCorrector.adder(4.0f)).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE, ValueCorrector.multiplier(1.25f)).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT, ValueCorrector.multiplier(1.2f)).registerPropertiesToAnimation());
        HEARTPIERCER = Skills.registerSkill(new SimpleSpecialAttackSkill(SimpleSpecialAttackSkill.createBuilder(new ResourceLocation("epicfight", "heartpiercer")).setConsumption(40.0f).setAnimations(Animations.SPEAR_THRUST)).newPropertyLine().addProperty(AnimationProperty.AttackPhaseProperty.ARMOR_NEGATION, ValueCorrector.adder(10.0f)).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, ExtendedDamageSource.StunType.HOLD).registerPropertiesToAnimation());
        GIANT_WHIRLWIND = Skills.registerSkill(new SimpleSpecialAttackSkill(SimpleSpecialAttackSkill.createBuilder(new ResourceLocation("epicfight", "giant_whirlwind")).setConsumption(60.0f).setAnimations(Animations.GIANT_WHIRLWIND)).newPropertyLine().addProperty(AnimationProperty.AttackPhaseProperty.IMPACT, ValueCorrector.multiplier(1.4f)).registerPropertiesToAnimation());
        FATAL_DRAW = Skills.registerSkill(new FatalDrawSkill(SpecialAttackSkill.createBuilder(new ResourceLocation("epicfight", "fatal_draw")).setConsumption(30.0f)).newPropertyLine().addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE, ValueCorrector.multiplier(2.0f)).addProperty(AnimationProperty.AttackPhaseProperty.ARMOR_NEGATION, ValueCorrector.adder(50.0f)).addProperty(AnimationProperty.AttackPhaseProperty.MAX_STRIKES, ValueCorrector.adder(6.0f)).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, ExtendedDamageSource.StunType.HOLD).registerPropertiesToAnimation());
        KATANA_PASSIVE = Skills.registerSkill(new KatanaPassive(Skill.createBuilder(new ResourceLocation("epicfight", "katana_passive")).setCategory(SkillCategories.WEAPON_PASSIVE).setConsumption(5.0f).setActivateType(Skill.ActivateType.ONE_SHOT).setResource(Skill.Resource.COOLDOWN)));
        LETHAL_SLICING = Skills.registerSkill(new LethalSlicingSkill(SpecialAttackSkill.createBuilder(new ResourceLocation("epicfight", "lethal_slicing")).setConsumption(35.0f)).newPropertyLine().addProperty(AnimationProperty.AttackPhaseProperty.MAX_STRIKES, ValueCorrector.setter(2.0f)).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT, ValueCorrector.setter(0.5f)).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE, ValueCorrector.setter(1.0f)).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, ExtendedDamageSource.StunType.LONG).addProperty(AnimationProperty.AttackPhaseProperty.HIT_SOUND, EpicFightSounds.BLUNT_HIT).addProperty(AnimationProperty.AttackPhaseProperty.PARTICLE, EpicFightParticles.HIT_BLUNT).newPropertyLine().addProperty(AnimationProperty.AttackPhaseProperty.ARMOR_NEGATION, ValueCorrector.adder(50.0f)).addProperty(AnimationProperty.AttackPhaseProperty.MAX_STRIKES, ValueCorrector.adder(2.0f)).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE, ValueCorrector.multiplier(1.7f)).addProperty(AnimationProperty.AttackPhaseProperty.SWING_SOUND, EpicFightSounds.WHOOSH_SHARP).registerPropertiesToAnimation());
        RELENTLESS_COMBO = Skills.registerSkill(new SimpleSpecialAttackSkill(SimpleSpecialAttackSkill.createBuilder(new ResourceLocation("epicfight", "relentless_combo")).setConsumption(20.0f).setAnimations(Animations.RELENTLESS_COMBO)).newPropertyLine().addProperty(AnimationProperty.AttackPhaseProperty.MAX_STRIKES, ValueCorrector.setter(1.0f)).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, ExtendedDamageSource.StunType.HOLD).addProperty(AnimationProperty.AttackPhaseProperty.PARTICLE, EpicFightParticles.HIT_BLUNT).registerPropertiesToAnimation());
        LIECHTENAUER = Skills.registerSkill(new LiechtenauerSkill(SpecialAttackSkill.createBuilder(new ResourceLocation("epicfight", "liechtenauer")).setConsumption(40.0f).setMaxDuration(4).setActivateType(Skill.ActivateType.DURATION_INFINITE)));
        EVISCERATE = Skills.registerSkill(new EviscerateSkill(SpecialAttackSkill.createBuilder(new ResourceLocation("epicfight", "eviscerate")).setConsumption(25.0f)).newPropertyLine().addProperty(AnimationProperty.AttackPhaseProperty.MAX_STRIKES, ValueCorrector.setter(1.0f)).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT, ValueCorrector.setter(2.0f)).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, ExtendedDamageSource.StunType.HOLD).newPropertyLine().addProperty(AnimationProperty.AttackPhaseProperty.MAX_STRIKES, ValueCorrector.setter(1.0f)).addProperty(AnimationProperty.AttackPhaseProperty.EXTRA_DAMAGE, ExtraDamageType.get(ExtraDamageType.PERCENT_OF_TARGET_LOST_HEALTH, 0.5f)).addProperty(AnimationProperty.AttackPhaseProperty.ARMOR_NEGATION, ValueCorrector.adder(50.0f)).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, ExtendedDamageSource.StunType.LONG).registerPropertiesToAnimation());
        BLADE_RUSH = Skills.registerSkill(new BladeRushSkill(SpecialAttackSkill.createBuilder(new ResourceLocation("epicfight", "blade_rush")).setConsumption(25.0f).setMaxDuration(1).setMaxStack(4).setActivateType(Skill.ActivateType.TOGGLE)).newPropertyLine().addProperty(AnimationProperty.AttackPhaseProperty.MAX_STRIKES, ValueCorrector.setter(1.0f)).newPropertyLine().addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE, ValueCorrector.multiplier(2.5f)).addProperty(AnimationProperty.AttackPhaseProperty.ARMOR_NEGATION, ValueCorrector.adder(20.0f)).addProperty(AnimationProperty.AttackPhaseProperty.MAX_STRIKES, ValueCorrector.setter(1.0f)).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, ExtendedDamageSource.StunType.HOLD).addProperty(AnimationProperty.AttackPhaseProperty.HIT_SOUND, EpicFightSounds.BLADE_RUSH_FINISHER).addProperty(AnimationProperty.AttackPhaseProperty.PARTICLE, EpicFightParticles.BLADE_RUSH_SKILL).registerPropertiesToAnimation());
        SkillRegistryEvent skillRegistryEvent = new SkillRegistryEvent(SKILLS, LEARNABLE_SKILLS);
        ModLoader.get().postEvent((Event)skillRegistryEvent);
    }

    private static Skill registerSkill(Skill skill) {
        Skills.registerIfAbsent(SKILLS, skill);
        if (skill.getCategory().learnable()) {
            Skills.registerIfAbsent(LEARNABLE_SKILLS, skill);
        }
        return skill;
    }

    private static void registerIfAbsent(Map<ResourceLocation, Skill> map, Skill skill) {
        if (map.containsKey(skill.getRegistryName())) {
            EpicFightMod.LOGGER.info("Duplicated skill name : " + skill.getRegistryName() + ". Registration was skipped.");
        } else {
            map.put(skill.getRegistryName(), skill);
        }
    }

    static {
        SKILLS.put(new ResourceLocation("epicfight", "empty"), null);
    }
}

