/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.mixin;

import com.google.common.primitives.Floats;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntConsumer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.List;
import net.minecraft.util.Mth;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BufferBuilder.class})
public abstract class MixinBufferBuilder {
    @Shadow
    private ByteBuffer f_85648_;
    @Shadow
    @Final
    private List<BufferBuilder.DrawState> f_166764_;
    @Shadow
    private int f_85651_;
    @Shadow
    private int f_85652_;
    @Shadow
    private int f_85654_;
    @Shadow
    private VertexFormatElement f_85655_;
    @Shadow
    private int f_85656_;
    @Shadow
    private VertexFormat f_85658_;
    @Shadow
    private VertexFormat.Mode f_85657_;
    @Shadow
    private boolean f_85661_;
    @Shadow
    private Vector3f[] f_166766_;
    @Shadow
    private float f_166767_;
    @Shadow
    private float f_166768_;
    @Shadow
    private float f_166769_;
    @Shadow
    private boolean f_166762_;

    @Inject(at={@At(value="HEAD")}, method={"setQuadSortOrigin(FFF)V"})
    public void epicfight_setQuadSortOrigin(float x, float y, float z, CallbackInfo callbackInfo) {
        if (this.f_85657_ == VertexFormat.Mode.TRIANGLES && (this.f_166767_ != x || this.f_166768_ != y || this.f_166769_ != z)) {
            this.f_166767_ = x;
            this.f_166768_ = y;
            this.f_166769_ = z;
            if (this.f_166766_ == null) {
                this.f_166766_ = this.makeTrianglesSortingPoints();
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"end()V"}, cancellable=true)
    public void epicfight_end(CallbackInfo callbackInfo) {
        boolean flag;
        if (!this.f_85661_) {
            throw new IllegalStateException("Not building!");
        }
        int i = this.f_85657_.m_166958_(this.f_85654_);
        VertexFormat.IndexType vertexformat$indextype = VertexFormat.IndexType.m_166933_((int)i);
        if (this.f_166766_ != null) {
            int j = Mth.m_144941_((int)(i * vertexformat$indextype.f_166924_), (int)4);
            this.m_85722_(j);
            if (this.f_85657_ == VertexFormat.Mode.QUADS) {
                this.m_166786_(vertexformat$indextype);
            } else if (this.f_85657_ == VertexFormat.Mode.TRIANGLES) {
                this.putSortedTriangleIndices(vertexformat$indextype);
            }
            flag = false;
            this.f_85652_ += j;
            this.f_85651_ += this.f_85654_ * this.f_85658_.m_86020_() + j;
        } else {
            flag = true;
            this.f_85651_ += this.f_85654_ * this.f_85658_.m_86020_();
        }
        this.f_85661_ = false;
        this.f_166764_.add(new BufferBuilder.DrawState(this.f_85658_, this.f_85654_, i, this.f_85657_, vertexformat$indextype, this.f_166762_, flag));
        this.f_85654_ = 0;
        this.f_85655_ = null;
        this.f_85656_ = 0;
        this.f_166766_ = null;
        this.f_166767_ = Float.NaN;
        this.f_166768_ = Float.NaN;
        this.f_166769_ = Float.NaN;
        this.f_166762_ = false;
        callbackInfo.cancel();
    }

    private void putSortedTriangleIndices(VertexFormat.IndexType indexType) {
        float[] afloat = new float[this.f_166766_.length];
        int[] aint = new int[this.f_166766_.length];
        int i = 0;
        while (i < this.f_166766_.length) {
            float f = this.f_166766_[i].m_122239_() - this.f_166767_;
            float f1 = this.f_166766_[i].m_122260_() - this.f_166768_;
            float f2 = this.f_166766_[i].m_122269_() - this.f_166769_;
            afloat[i] = f * f + f1 * f1 + f2 * f2;
            aint[i] = i++;
        }
        IntArrays.mergeSort((int[])aint, (p_166784_, p_166785_) -> Floats.compare((float)afloat[p_166785_], (float)afloat[p_166784_]));
        IntConsumer intconsumer = this.m_166777_(indexType);
        this.f_85648_.position(this.f_85652_);
        for (int j : aint) {
            intconsumer.accept(j * this.f_85657_.f_166948_ + 0);
            intconsumer.accept(j * this.f_85657_.f_166948_ + 1);
            intconsumer.accept(j * this.f_85657_.f_166948_ + 2);
        }
    }

    @Shadow
    public abstract void m_85722_(int var1);

    @Shadow
    public abstract void m_166786_(VertexFormat.IndexType var1);

    @Shadow
    public abstract IntConsumer m_166777_(VertexFormat.IndexType var1);

    public Vector3f[] makeTrianglesSortingPoints() {
        FloatBuffer floatbuffer = this.f_85648_.asFloatBuffer();
        int i = this.f_85651_ / 4;
        int j = this.f_85658_.m_86017_();
        int k = j * this.f_85657_.f_166948_;
        int l = this.f_85654_ / this.f_85657_.f_166948_;
        Vector3f[] avector3f = new Vector3f[l];
        for (int i1 = 0; i1 < l; ++i1) {
            float x1 = floatbuffer.get(i + i1 * k + 0);
            float y1 = floatbuffer.get(i + i1 * k + 1);
            float z1 = floatbuffer.get(i + i1 * k + 2);
            float x2 = floatbuffer.get(i + i1 * k + j + 0);
            float y2 = floatbuffer.get(i + i1 * k + j + 1);
            float z2 = floatbuffer.get(i + i1 * k + j + 2);
            float x3 = floatbuffer.get(i + i1 * k + j * 2 + 0);
            float y3 = floatbuffer.get(i + i1 * k + j * 2 + 1);
            float z3 = floatbuffer.get(i + i1 * k + j * 2 + 2);
            avector3f[i1] = this.getOriginQuadCenter(x1, y1, z1, x2, y2, z2, x3, y3, z3);
        }
        return avector3f;
    }

    private Vector3f getOriginQuadCenter(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3) {
        float[] lineLength = new float[]{Mth.m_14116_((float)(Mth.m_14207_((float)(x2 - x1)) + Mth.m_14207_((float)(y2 - y1)) + Mth.m_14207_((float)(z2 - z1)))), Mth.m_14116_((float)(Mth.m_14207_((float)(x3 - x2)) + Mth.m_14207_((float)(y3 - y2)) + Mth.m_14207_((float)(z3 - z2)))), Mth.m_14116_((float)(Mth.m_14207_((float)(x1 - x3)) + Mth.m_14207_((float)(y1 - y3)) + Mth.m_14207_((float)(z1 - z3))))};
        int longest = 0;
        for (int i = 1; i < 3; ++i) {
            if (!(lineLength[i] > lineLength[longest])) continue;
            longest = i;
        }
        switch (longest) {
            case 0: {
                return new Vector3f((x1 + x2) * 0.5f, (y1 + y2) * 0.5f, (z1 + z2) * 0.5f);
            }
            case 1: {
                return new Vector3f((x2 + x3) * 0.5f, (y2 + y3) * 0.5f, (z2 + z3) * 0.5f);
            }
            case 2: {
                return new Vector3f((x3 + x1) * 0.5f, (y3 + y1) * 0.5f, (z3 + z1) * 0.5f);
            }
        }
        return null;
    }
}

