/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.network.client;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPChangePlayerMode;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class CPChangePlayerMode {
    private PlayerPatch.PlayerMode mode;

    public CPChangePlayerMode(PlayerPatch.PlayerMode mode) {
        this.mode = mode;
    }

    public static CPChangePlayerMode fromBytes(FriendlyByteBuf buf) {
        return new CPChangePlayerMode(PlayerPatch.PlayerMode.values()[buf.readInt()]);
    }

    public static void toBytes(CPChangePlayerMode msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.mode.ordinal());
    }

    public static void handle(CPChangePlayerMode msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerPatch playerpatch;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (playerpatch = (ServerPlayerPatch)player.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null)) != null) {
                playerpatch.toMode(msg.mode, false);
                EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(new SPChangePlayerMode(player.m_142049_(), playerpatch.getPlayerMode()), (Entity)player);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

