/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill;

import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class AirAttack
extends Skill {
    public static Skill.Builder<AirAttack> createBuilder() {
        return new Skill.Builder(new ResourceLocation("epicfight", "air_attack")).setCategory(SkillCategories.AIR_ATTACK).setConsumption(2.0f).setActivateType(Skill.ActivateType.ONE_SHOT).setResource(Skill.Resource.STAMINA);
    }

    public AirAttack(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    @Override
    public boolean isExecutableState(PlayerPatch<?> executer) {
        EntityState playerState = executer.getEntityState();
        Player player = (Player)executer.getOriginal();
        return !player.m_20159_() && !player.m_5833_() && !executer.isUnstable() && playerState.canBasicAttack();
    }

    @Override
    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        List<StaticAnimation> motions = executer.getHoldingItemCapability(InteractionHand.MAIN_HAND).getAutoAttckMotion(executer);
        StaticAnimation attackMotion = motions.get(motions.size() - 1);
        if (attackMotion != null) {
            super.executeOnServer(executer, args);
            executer.playAnimationSynchronized(attackMotion, 0.0f);
        }
    }
}

