/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill;

import java.util.List;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.BasicAttackEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class BasicAttack
extends Skill {
    private static final SkillDataManager.SkillDataKey<Integer> COMBO_COUNTER = SkillDataManager.SkillDataKey.createDataKey(SkillDataManager.ValueType.INTEGER);
    private static final UUID EVENT_UUID = UUID.fromString("a42e0198-fdbc-11eb-9a03-0242ac130003");

    public static Skill.Builder<BasicAttack> createBuilder() {
        return new Skill.Builder(new ResourceLocation("epicfight", "basic_attack")).setCategory(SkillCategories.BASIC_ATTACK).setConsumption(0.0f).setActivateType(Skill.ActivateType.ONE_SHOT).setResource(Skill.Resource.NONE);
    }

    public BasicAttack(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    @Override
    public void onInitiate(SkillContainer container) {
        container.getDataManager().registerData(COMBO_COUNTER);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {
            if (!event.getAnimation().isBasicAttackAnimation()) {
                container.getDataManager().setData(COMBO_COUNTER, 0);
            }
        });
    }

    @Override
    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
    }

    @Override
    public boolean isExecutableState(PlayerPatch<?> executer) {
        EntityState playerState = executer.getEntityState();
        Player player = (Player)executer.getOriginal();
        return !player.m_5833_() && !executer.isUnstable() && playerState.canBasicAttack();
    }

    @Override
    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        if (executer.getEventListener().triggerEvents(PlayerEventListener.EventType.BASIC_ATTACK_EVENT, new BasicAttackEvent(executer))) {
            return;
        }
        CapabilityItem cap = executer.getHoldingItemCapability(InteractionHand.MAIN_HAND);
        StaticAnimation attackMotion = null;
        ServerPlayer player = (ServerPlayer)executer.getOriginal();
        SkillDataManager dataManager = executer.getSkill(this.category).getDataManager();
        int comboCounter = dataManager.getDataValue(COMBO_COUNTER);
        if (player.m_20159_()) {
            Entity entity = player.m_20202_();
            if (entity instanceof PlayerRideableJumping && ((PlayerRideableJumping)entity).m_7132_() && cap.availableOnHorse() && cap.getMountAttackMotion() != null) {
                attackMotion = cap.getMountAttackMotion().get(comboCounter %= cap.getMountAttackMotion().size());
                ++comboCounter;
            }
        } else {
            List<StaticAnimation> combo = cap.getAutoAttckMotion(executer);
            int comboSize = combo.size();
            boolean dashAttack = player.m_20142_();
            comboCounter = dashAttack ? comboSize - 2 : (comboCounter %= comboSize - 2);
            attackMotion = combo.get(comboCounter);
            comboCounter = dashAttack ? 0 : comboCounter + 1;
        }
        dataManager.setData(COMBO_COUNTER, comboCounter);
        if (attackMotion != null) {
            executer.playAnimationSynchronized(attackMotion, 0.0f);
        }
        executer.updateEntityState();
    }

    @Override
    public void updateContainer(SkillContainer container) {
        if (container.getExecuter().getTickSinceLastAction() > 10 && container.getDataManager().getDataValue(COMBO_COUNTER) > 0) {
            container.getDataManager().setData(COMBO_COUNTER, 0);
        }
    }
}

