/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill;

import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.ExtendedDamageSource;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.gameasset.Skills;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SpecialAttackSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class LiechtenauerSkill
extends SpecialAttackSkill {
    private static final UUID EVENT_UUID = UUID.fromString("244c57c0-a837-11eb-bcbc-0242ac130002");
    private static final SkillDataManager.SkillDataKey<Integer> PARRY_MOTION_COUNTER = SkillDataManager.SkillDataKey.createDataKey(SkillDataManager.ValueType.INTEGER);

    public LiechtenauerSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    @Override
    public void onInitiate(SkillContainer container) {
        container.getDataManager().registerData(PARRY_MOTION_COUNTER);
        if (!container.getExecuter().isLogicalClient()) {
            this.setMaxDurationSynchronize((ServerPlayerPatch)container.getExecuter(), this.maxDuration + EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)container.getExecuter().getOriginal())));
        }
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_POST, EVENT_UUID, event -> {
            if (container.isActivated() && !event.getTarget().m_6084_()) {
                this.setDurationSynchronize((ServerPlayerPatch)event.getPlayerPatch(), container.duration + 1);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, event -> {
            if (event.getAmount() > 0.0f && container.duration > 0 && this.isExecutableState((PlayerPatch<?>)event.getPlayerPatch()) && this.canExecute((PlayerPatch<?>)event.getPlayerPatch()) && LiechtenauerSkill.isBlockableSource((DamageSource)event.getDamageSource())) {
                DamageSource damageSource = (DamageSource)event.getDamageSource();
                boolean isFront = false;
                Vec3 sourceLocation = damageSource.m_7270_();
                if (sourceLocation != null) {
                    Vec3 viewVector = ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20252_(1.0f);
                    Vec3 toSourceLocation = sourceLocation.m_82546_(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20182_()).m_82541_();
                    if (toSourceLocation.m_82526_(viewVector) > 0.0) {
                        isFront = true;
                    }
                }
                if (isFront) {
                    this.setDurationSynchronize((ServerPlayerPatch)event.getPlayerPatch(), container.duration - 1);
                    if (((ServerPlayerPatch)event.getPlayerPatch()).getSkill((SkillCategory)SkillCategories.GUARD).containingSkill == Skills.ACTIVE_GUARD) {
                        SkillDataManager dataManager = ((ServerPlayerPatch)event.getPlayerPatch()).getSkill(this.getCategory()).getDataManager();
                        int motionCounter = dataManager.getDataValue(PARRY_MOTION_COUNTER);
                        dataManager.setDataF(PARRY_MOTION_COUNTER, v -> v + 1);
                        ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized((motionCounter %= 2) == 0 ? Animations.LONGSWORD_GUARD_ACTIVE_HIT1 : Animations.LONGSWORD_GUARD_ACTIVE_HIT2, 0.0f);
                    } else {
                        ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized(Animations.LONGSWORD_GUARD_HIT, 0.0f);
                    }
                    ((ServerPlayerPatch)event.getPlayerPatch()).playSound(EpicFightSounds.CLASH, -0.05f, 0.1f);
                    Object playerentity = ((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
                    ((HitParticleType)((Object)((Object)EpicFightParticles.HIT_BLUNT.get()))).spawnParticleWithArgument((ServerLevel)((Entity)playerentity).f_19853_, HitParticleType.FRONT_OF_EYES, HitParticleType.ZERO, (Entity)playerentity, damageSource.m_7640_());
                    float knockback = 0.25f;
                    if (damageSource instanceof ExtendedDamageSource) {
                        knockback += Math.min(((ExtendedDamageSource)damageSource).getImpact() * 0.1f, 1.0f);
                    }
                    if (damageSource.m_7640_() instanceof LivingEntity) {
                        knockback += (float)EnchantmentHelper.m_44894_((LivingEntity)((LivingEntity)damageSource.m_7640_())) * 0.1f;
                    }
                    ((ServerPlayerPatch)event.getPlayerPatch()).knockBackEntity(damageSource.m_7640_().m_20182_(), knockback);
                    event.setCanceled(true);
                    event.setResult(AttackResult.ResultType.BLOCKED);
                }
            }
        }, 0);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID, event -> {
            if (((LocalPlayerPatch)event.getPlayerPatch()).getSkill(this.category).isActivated()) {
                LocalPlayer clientPlayer = (LocalPlayer)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal();
                clientPlayer.m_6858_(false);
                clientPlayer.f_108583_ = -1;
                Minecraft mc = Minecraft.m_91087_();
                ClientEngine.instance.controllEngine.setKeyBind(mc.f_91066_.f_92091_, false);
            }
        });
    }

    @Override
    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, 0);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_POST, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID);
    }

    @Override
    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        if (executer.getSkill(this.category).isActivated()) {
            super.cancelOnServer(executer, args);
            this.setConsumptionSynchronize(executer, this.consumption * ((float)executer.getSkill((SkillCategory)this.category).duration / (float)(this.maxDuration + EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)executer.getOriginal())) + 1)));
            this.setDurationSynchronize(executer, 0);
            this.setStackSynchronize(executer, executer.getSkill(this.category).getStack() - 1);
            executer.modifyLivingMotionByCurrentItem();
        } else {
            this.setDurationSynchronize(executer, this.maxDuration + EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)executer.getOriginal())));
            executer.getSkill(this.category).activate();
            executer.modifyLivingMotionByCurrentItem();
        }
    }

    @Override
    public void cancelOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        super.cancelOnServer(executer, args);
        this.setConsumptionSynchronize(executer, 0.0f);
        this.setStackSynchronize(executer, executer.getSkill(this.category).getStack() - 1);
        executer.modifyLivingMotionByCurrentItem();
    }

    @Override
    public boolean canExecute(PlayerPatch<?> executer) {
        if (executer.isLogicalClient()) {
            return super.canExecute(executer);
        }
        return executer.getHoldingItemCapability(InteractionHand.MAIN_HAND).getSpecialAttack(executer) == this && ((Player)executer.getOriginal()).m_20202_() == null;
    }

    @Override
    public SpecialAttackSkill registerPropertiesToAnimation() {
        return this;
    }

    private static boolean isBlockableSource(DamageSource damageSource) {
        return !damageSource.m_19378_() && !damageSource.m_19372_();
    }
}

