/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.utils.ExtendedDamageSource;
import yesman.epicfight.api.utils.math.ValueCorrector;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

public abstract class SpecialAttackSkill
extends Skill {
    protected List<Map<AnimationProperty.AttackPhaseProperty<?>, Object>> properties = Lists.newArrayList();

    public static Skill.Builder<? extends SpecialAttackSkill> createBuilder(ResourceLocation resourceLocation) {
        return new Skill.Builder(resourceLocation).setCategory(SkillCategories.WEAPON_SPECIAL_ATTACK).setResource(Skill.Resource.SPECIAL_GAUAGE);
    }

    public SpecialAttackSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    @Override
    public boolean canExecute(PlayerPatch<?> executer) {
        if (executer.isLogicalClient()) {
            return executer.getSkill(this.getCategory()).isReady() || ((Player)executer.getOriginal()).m_7500_();
        }
        return executer.getHoldingItemCapability(InteractionHand.MAIN_HAND).getSpecialAttack(executer) == this && ((Player)executer.getOriginal()).m_20202_() == null && (!executer.getSkill(this.category).isActivated() || this.activateType == Skill.ActivateType.TOGGLE);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerCap) {
        ArrayList list = Lists.newArrayList();
        String traslatableText = this.getTranslatableText();
        list.add(new TranslatableComponent(traslatableText).m_130940_(ChatFormatting.WHITE).m_7220_((Component)new TextComponent(String.format("[%.0f]", Float.valueOf(this.consumption))).m_130940_(ChatFormatting.AQUA)));
        list.add(new TranslatableComponent(traslatableText + ".tooltip").m_130940_(ChatFormatting.DARK_GRAY));
        return list;
    }

    protected void generateTooltipforPhase(List<Component> list, ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerpatch, Map<AnimationProperty.AttackPhaseProperty<?>, Object> propertyMap, String title) {
        Multimap attributes = itemStack.m_41638_(EquipmentSlot.MAINHAND);
        Multimap<Attribute, AttributeModifier> capAttributes = cap.getAttributeModifiers(EquipmentSlot.MAINHAND, playerpatch);
        double damage = ((Player)playerpatch.getOriginal()).m_21051_(Attributes.f_22281_).m_22115_() + (double)EnchantmentHelper.m_44833_((ItemStack)itemStack, (MobType)MobType.f_21640_);
        double armorNegation = ((Player)playerpatch.getOriginal()).m_21051_((Attribute)EpicFightAttributes.ARMOR_NEGATION.get()).m_22115_();
        double impact = ((Player)playerpatch.getOriginal()).m_21051_((Attribute)EpicFightAttributes.IMPACT.get()).m_22115_();
        double maxStrikes = ((Player)playerpatch.getOriginal()).m_21051_((Attribute)EpicFightAttributes.MAX_STRIKES.get()).m_22115_();
        ValueCorrector damageCorrector = ValueCorrector.empty();
        ValueCorrector armorNegationCorrector = ValueCorrector.empty();
        ValueCorrector impactCorrector = ValueCorrector.empty();
        ValueCorrector maxStrikesCorrector = ValueCorrector.empty();
        for (AttributeModifier modifier : attributes.get((Object)Attributes.f_22281_)) {
            damage += modifier.m_22218_();
        }
        for (AttributeModifier modifier : capAttributes.get((Object)((Attribute)EpicFightAttributes.ARMOR_NEGATION.get()))) {
            armorNegation += modifier.m_22218_();
        }
        for (AttributeModifier modifier : capAttributes.get((Object)((Attribute)EpicFightAttributes.IMPACT.get()))) {
            impact += modifier.m_22218_();
        }
        for (AttributeModifier modifier : capAttributes.get((Object)((Attribute)EpicFightAttributes.MAX_STRIKES.get()))) {
            maxStrikes += modifier.m_22218_();
        }
        this.getProperty(AnimationProperty.AttackPhaseProperty.DAMAGE, propertyMap).ifPresent(damageCorrector::merge);
        this.getProperty(AnimationProperty.AttackPhaseProperty.ARMOR_NEGATION, propertyMap).ifPresent(armorNegationCorrector::merge);
        this.getProperty(AnimationProperty.AttackPhaseProperty.IMPACT, propertyMap).ifPresent(impactCorrector::merge);
        this.getProperty(AnimationProperty.AttackPhaseProperty.MAX_STRIKES, propertyMap).ifPresent(maxStrikesCorrector::merge);
        impactCorrector.merge(ValueCorrector.multiplier(1.0f + (float)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44980_, (ItemStack)itemStack) * 0.12f));
        damage = damageCorrector.getTotalValue(playerpatch.getModifiedDamage(null, null, (float)damage));
        armorNegation = armorNegationCorrector.getTotalValue((float)armorNegation);
        impact = impactCorrector.getTotalValue((float)impact);
        maxStrikes = maxStrikesCorrector.getTotalValue((float)maxStrikes);
        list.add((Component)new TextComponent(title).m_130940_(ChatFormatting.UNDERLINE).m_130940_(ChatFormatting.GRAY));
        MutableComponent damageComponent = new TranslatableComponent("skill.epicfight.damage", new Object[]{new TextComponent(ItemStack.f_41584_.format(damage)).m_130940_(ChatFormatting.RED)}).m_130940_(ChatFormatting.DARK_GRAY);
        this.getProperty(AnimationProperty.AttackPhaseProperty.EXTRA_DAMAGE, propertyMap).ifPresent(extraDamage -> damageComponent.m_7220_((Component)new TranslatableComponent(extraDamage.toString(), new Object[]{new TextComponent(ItemStack.f_41584_.format(extraDamage.getArgument() * 100.0f) + "%").m_130940_(ChatFormatting.RED)})).m_130940_(ChatFormatting.DARK_GRAY));
        list.add((Component)damageComponent);
        if (armorNegation != 0.0) {
            list.add((Component)new TranslatableComponent(((Attribute)EpicFightAttributes.ARMOR_NEGATION.get()).m_22087_(), new Object[]{new TextComponent(ItemStack.f_41584_.format(armorNegation)).m_130940_(ChatFormatting.GOLD)}).m_130940_(ChatFormatting.DARK_GRAY));
        }
        if (impact != 0.0) {
            list.add((Component)new TranslatableComponent(((Attribute)EpicFightAttributes.IMPACT.get()).m_22087_(), new Object[]{new TextComponent(ItemStack.f_41584_.format(impact)).m_130940_(ChatFormatting.AQUA)}).m_130940_(ChatFormatting.DARK_GRAY));
        }
        list.add((Component)new TranslatableComponent(((Attribute)EpicFightAttributes.MAX_STRIKES.get()).m_22087_(), new Object[]{new TextComponent(ItemStack.f_41584_.format(maxStrikes)).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.DARK_GRAY));
        Optional<ExtendedDamageSource.StunType> stunOption = this.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, propertyMap);
        stunOption.ifPresent(stunType -> list.add((Component)new TextComponent(ChatFormatting.DARK_GRAY + "Apply " + stunType.toString())));
        if (!stunOption.isPresent()) {
            list.add((Component)new TextComponent(ChatFormatting.DARK_GRAY + "Apply " + ExtendedDamageSource.StunType.SHORT.toString()));
        }
    }

    protected <V> Optional<V> getProperty(AnimationProperty.AttackPhaseProperty<V> propertyType, Map<AnimationProperty.AttackPhaseProperty<?>, Object> map) {
        return Optional.ofNullable(map.get(propertyType));
    }

    public SpecialAttackSkill newPropertyLine() {
        this.properties.add(Maps.newHashMap());
        return this;
    }

    public <T> SpecialAttackSkill addProperty(AnimationProperty.AttackPhaseProperty<T> attribute, T object) {
        this.properties.get(this.properties.size() - 1).put(attribute, object);
        return this;
    }

    public abstract SpecialAttackSkill registerPropertiesToAnimation();
}

