/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill;

import java.util.UUID;
import yesman.epicfight.skill.PassiveSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class StaminaPillagerSkill
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("20807880-fd30-11eb-9a03-0242ac130003");

    public StaminaPillagerSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    @Override
    public void onInitiate(SkillContainer container) {
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_POST, EVENT_UUID, event -> {
            if (!event.getTarget().m_6084_()) {
                float stamina = ((ServerPlayerPatch)event.getPlayerPatch()).getStamina();
                float missingStamina = ((ServerPlayerPatch)event.getPlayerPatch()).getMaxStamina() - stamina;
                ((ServerPlayerPatch)event.getPlayerPatch()).setStamina(stamina + missingStamina * 0.3f);
            }
        });
    }

    @Override
    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_POST, EVENT_UUID);
    }
}

