/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch;

import com.mojang.datafixers.util.Pair;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.data.reloader.MobPatchReloadListener;
import yesman.epicfight.api.model.Model;
import yesman.epicfight.api.utils.ExtendedDamageSource;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.gameasset.Models;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.ai.goal.AnimatedAttackGoal;
import yesman.epicfight.world.entity.ai.goal.TargetChasingGoal;

public class CustomMobPatch<T extends PathfinderMob>
extends MobPatch<T> {
    private final MobPatchReloadListener.CustomMobPatchProvider provider;

    public CustomMobPatch(Faction faction, MobPatchReloadListener.CustomMobPatchProvider provider) {
        super(faction);
        this.provider = provider;
    }

    @Override
    protected void initAI() {
        super.initAI();
        ((PathfinderMob)this.original).f_21345_.m_25352_(0, new AnimatedAttackGoal<CustomMobPatch>(this, this.provider.getCombatBehaviorsBuilder().build(this)));
        ((PathfinderMob)this.original).f_21345_.m_25352_(1, (Goal)new TargetChasingGoal(this, (PathfinderMob)this.getOriginal(), this.provider.getChasingSpeed(), true));
    }

    @Override
    protected void initAttributes() {
        ((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.WEIGHT.get()).m_22100_(((PathfinderMob)this.original).m_21051_(Attributes.f_22276_).m_22115_() * 2.0);
        ((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.MAX_STRIKES.get()).m_22100_(this.provider.getAttributeValues().get(EpicFightAttributes.MAX_STRIKES.get()).doubleValue());
        ((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.ARMOR_NEGATION.get()).m_22100_(this.provider.getAttributeValues().get(EpicFightAttributes.ARMOR_NEGATION.get()).doubleValue());
        ((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.IMPACT.get()).m_22100_(this.provider.getAttributeValues().get(EpicFightAttributes.IMPACT.get()).doubleValue());
        if (this.provider.getAttributeValues().containsKey(Attributes.f_22281_)) {
            ((PathfinderMob)this.original).m_21051_(Attributes.f_22281_).m_22100_(this.provider.getAttributeValues().get(Attributes.f_22281_).doubleValue());
        }
    }

    @Override
    public void initAnimator(ClientAnimator clientAnimator) {
        for (Pair<LivingMotion, StaticAnimation> pair : this.provider.getDefaultAnimations()) {
            clientAnimator.addLivingAnimation((LivingMotion)pair.getFirst(), (StaticAnimation)pair.getSecond());
        }
        clientAnimator.setCurrentMotionsAsDefault();
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        super.commonAggressiveMobUpdateMotion(considerInaction);
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return modelDB.get(this.provider.getModelLocation());
    }

    @Override
    public StaticAnimation getHitAnimation(ExtendedDamageSource.StunType stunType) {
        return this.provider.getStunAnimations().get((Object)stunType);
    }

    @Override
    public OpenMatrix4f getModelMatrix(float partialTicks) {
        float scale = this.provider.getScale();
        return super.getModelMatrix(partialTicks).scale(scale, scale, scale);
    }
}

