/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPSetAttackTarget;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.ai.goal.AnimatedAttackGoal;
import yesman.epicfight.world.entity.ai.goal.TargetChasingGoal;

public abstract class MobPatch<T extends Mob>
extends LivingEntityPatch<T> {
    protected final Faction mobFaction;

    public MobPatch() {
        this.mobFaction = Faction.NEUTRAL;
    }

    public MobPatch(Faction faction) {
        this.mobFaction = faction;
    }

    @Override
    public void onJoinWorld(T entityIn, EntityJoinWorldEvent event) {
        super.onJoinWorld(entityIn, event);
        if (!((Mob)entityIn).f_19853_.m_5776_() && !((Mob)this.original).m_21525_()) {
            this.initAI();
        }
    }

    protected void initAI() {
        HashSet toRemove = Sets.newHashSet();
        this.selectGoalToRemove(toRemove);
        toRemove.forEach(arg_0 -> ((GoalSelector)((Mob)this.original).f_21345_).m_25363_(arg_0));
    }

    protected void selectGoalToRemove(Set<Goal> toRemove) {
        for (WrappedGoal wrappedGoal : ((Mob)this.original).f_21345_.m_148105_()) {
            Goal goal = wrappedGoal.m_26015_();
            if (!(goal instanceof MeleeAttackGoal) && !(goal instanceof AnimatedAttackGoal) && !(goal instanceof RangedAttackGoal) && !(goal instanceof TargetChasingGoal)) continue;
            toRemove.add(goal);
        }
    }

    protected final void commonMobUpdateMotion(boolean considerInaction) {
        this.currentLivingMotion = ((Mob)this.original).m_21223_() <= 0.0f ? LivingMotions.DEATH : (this.state.inaction() && considerInaction ? LivingMotions.IDLE : (((Mob)this.original).m_20202_() != null ? LivingMotions.MOUNT : (((Mob)this.original).m_20184_().f_82480_ < (double)-0.55f ? LivingMotions.FALL : (((Mob)this.original).f_20924_ > 0.01f ? LivingMotions.WALK : LivingMotions.IDLE))));
        this.currentCompositeMotion = this.currentLivingMotion;
    }

    protected final void commonAggressiveMobUpdateMotion(boolean considerInaction) {
        this.currentLivingMotion = ((Mob)this.original).m_21223_() <= 0.0f ? LivingMotions.DEATH : (this.state.inaction() && considerInaction ? LivingMotions.IDLE : (((Mob)this.original).m_20202_() != null ? LivingMotions.MOUNT : (((Mob)this.original).m_20184_().f_82480_ < (double)-0.55f ? LivingMotions.FALL : (((Mob)this.original).f_20924_ > 0.01f ? (((Mob)this.original).m_5912_() ? LivingMotions.CHASE : LivingMotions.WALK) : LivingMotions.IDLE))));
        this.currentCompositeMotion = this.currentLivingMotion;
    }

    protected final void commonAggressiveRangedMobUpdateMotion(boolean considerInaction) {
        this.commonAggressiveMobUpdateMotion(considerInaction);
        UseAnim useAction = ((Mob)this.original).m_21120_(((Mob)this.original).m_7655_()).m_41780_();
        if (((Mob)this.original).m_6117_()) {
            this.currentCompositeMotion = useAction == UseAnim.CROSSBOW ? LivingMotions.RELOAD : LivingMotions.AIM;
        } else if (this.getClientAnimator().getCompositeLayer((Layer.Priority)Layer.Priority.MIDDLE).animationPlayer.getAnimation().isReboundAnimation()) {
            this.currentCompositeMotion = LivingMotions.NONE;
        }
        if (CrossbowItem.m_40932_((ItemStack)((Mob)this.original).m_21205_())) {
            this.currentCompositeMotion = LivingMotions.AIM;
        } else if (this.getClientAnimator().isAiming() && this.currentCompositeMotion != LivingMotions.AIM) {
            this.playReboundAnimation();
        }
    }

    @Override
    public void updateArmor(CapabilityItem fromCap, CapabilityItem toCap, EquipmentSlot slotType) {
        if (((Mob)this.original).m_21204_().m_22171_((Attribute)EpicFightAttributes.STUN_ARMOR.get())) {
            if (fromCap != null) {
                ((Mob)this.original).m_21204_().m_22161_(fromCap.getAttributeModifiers(slotType, this));
            }
            if (toCap != null) {
                ((Mob)this.original).m_21204_().m_22178_(toCap.getAttributeModifiers(slotType, this));
            }
        }
    }

    @Override
    public boolean isTeammate(Entity entityIn) {
        EntityPatch cap = (EntityPatch)entityIn.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null);
        if (cap != null && cap instanceof MobPatch && ((MobPatch)cap).mobFaction.equals((Object)this.mobFaction)) {
            Optional<LivingEntity> opt = Optional.ofNullable(this.getTarget());
            return opt.map(attackTarget -> !attackTarget.m_7306_(entityIn)).orElse(true);
        }
        return super.isTeammate(entityIn);
    }

    @Override
    public LivingEntity getTarget() {
        return ((Mob)this.original).m_5448_();
    }

    public void setAttakTargetSync(LivingEntity entityIn) {
        if (!((Mob)this.original).f_19853_.m_5776_()) {
            ((Mob)this.original).m_6710_(entityIn);
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(new SPSetAttackTarget(((Mob)this.original).m_142049_(), entityIn != null ? entityIn.m_142049_() : -1), this.original);
        }
    }

    @Override
    public float getAttackDirectionPitch() {
        LivingEntity attackTarget = this.getTarget();
        if (attackTarget != null) {
            float partialTicks = EpicFightMod.isPhysicalClient() ? Minecraft.m_91087_().m_91296_() : 1.0f;
            Vec3 target = attackTarget.m_20299_(partialTicks);
            Vec3 vector3d = ((Mob)this.original).m_20299_(partialTicks);
            double d0 = target.f_82479_ - vector3d.f_82479_;
            double d1 = target.f_82480_ - vector3d.f_82480_;
            double d2 = target.f_82481_ - vector3d.f_82481_;
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            return Mth.m_14036_((float)Mth.m_14177_((float)((float)(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875))), (float)-30.0f, (float)30.0f);
        }
        return super.getAttackDirectionPitch();
    }
}

