/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.mob;

import io.netty.buffer.ByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RunIf;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.model.Model;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.Models;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPSpawnData;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.HumanoidMobPatch;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.ai.brain.BrainRecomposer;
import yesman.epicfight.world.entity.ai.brain.task.AnimatedCombatBehavior;
import yesman.epicfight.world.entity.ai.brain.task.BackUpIfTooCloseStopInaction;
import yesman.epicfight.world.entity.ai.brain.task.MoveToTargetSinkStopInaction;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;

public class PiglinPatch
extends HumanoidMobPatch<Piglin> {
    public PiglinPatch() {
        super(Faction.PIGLINS);
    }

    @Override
    protected void initAttributes() {
        super.initAttributes();
        ((Piglin)this.original).m_21051_((Attribute)EpicFightAttributes.IMPACT.get()).m_22100_(1.0);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initAnimator(ClientAnimator clientAnimator) {
        clientAnimator.addLivingAnimation(LivingMotions.IDLE, Animations.PIGLIN_IDLE);
        clientAnimator.addLivingAnimation(LivingMotions.FALL, Animations.BIPED_FALL);
        clientAnimator.addLivingAnimation(LivingMotions.MOUNT, Animations.BIPED_MOUNT);
        clientAnimator.addLivingAnimation(LivingMotions.CELEBRATE, EpicFightMod.getInstance().animationManager.findAnimationById("epicfight".hashCode(), Animations.PIGLIN_CELEBRATE1.getId() + ((Piglin)this.original).m_21187_().nextInt(3)));
        clientAnimator.addLivingAnimation(LivingMotions.ADMIRE, Animations.PIGLIN_ADMIRE);
        clientAnimator.addLivingAnimation(LivingMotions.WALK, Animations.PIGLIN_WALK);
        clientAnimator.addLivingAnimation(LivingMotions.CHASE, Animations.PIGLIN_WALK);
        clientAnimator.addLivingAnimation(LivingMotions.DEATH, Animations.PIGLIN_DEATH);
        clientAnimator.addLivingAnimation(LivingMotions.RELOAD, Animations.BIPED_CROSSBOW_RELOAD);
        clientAnimator.addLivingAnimation(LivingMotions.AIM, Animations.BIPED_CROSSBOW_AIM);
        clientAnimator.addLivingAnimation(LivingMotions.SHOT, Animations.BIPED_CROSSBOW_SHOT);
        clientAnimator.setCurrentMotionsAsDefault();
    }

    @Override
    public void onStartTracking(ServerPlayer trackingPlayer) {
        if (((Piglin)this.original).m_6162_()) {
            SPSpawnData packet = new SPSpawnData(((Piglin)this.original).m_142049_());
            EpicFightNetworkManager.sendToPlayer(packet, trackingPlayer);
        }
        super.onStartTracking(trackingPlayer);
    }

    @Override
    public void processSpawnData(ByteBuf buf) {
        ClientAnimator animator = this.getClientAnimator();
        animator.addLivingAnimation(LivingMotions.WALK, Animations.BIPED_RUN);
        animator.setCurrentMotionsAsDefault();
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        if (((Piglin)this.getOriginal()).m_21206_().m_204117_(ItemTags.f_13151_)) {
            this.currentLivingMotion = LivingMotions.ADMIRE;
        } else if (((Piglin)this.original).m_34771_()) {
            this.currentLivingMotion = LivingMotions.CELEBRATE;
        } else {
            super.commonAggressiveRangedMobUpdateMotion(considerInaction);
        }
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)modelDB.piglin;
    }

    @Override
    public void setAIAsInfantry(boolean holdingRanedWeapon) {
        CombatBehaviors.Builder<HumanoidMobPatch<?>> builder = this.getHoldingItemWeaponMotionBuilder();
        if (builder != null) {
            BrainRecomposer.replaceBehavior(((Piglin)this.original).m_6274_(), Activity.f_37988_, 13, MeleeAttack.class, new AnimatedCombatBehavior<PiglinPatch>(this, builder.build(this)));
        }
        BrainRecomposer.replaceBehavior(((Piglin)this.original).m_6274_(), Activity.f_37988_, 11, RunIf.class, new RunIf(entity -> entity.m_21093_(is -> is.m_41720_() instanceof CrossbowItem), new BackUpIfTooCloseStopInaction(5, 0.75f)));
        BrainRecomposer.replaceBehavior(((Piglin)this.original).m_6274_(), Activity.f_37978_, 1, MoveToTargetSink.class, new MoveToTargetSinkStopInaction());
        BrainRecomposer.removeBehavior(((Piglin)this.original).m_6274_(), Activity.f_37989_, 15, RunOne.class);
    }

    @Override
    public void setAIAsMounted(Entity ridingEntity) {
    }
}

