/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.mob;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.monster.Vex;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.model.Model;
import yesman.epicfight.api.utils.ExtendedDamageSource;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.Models;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.entity.eventlistener.HurtEvent;

public class VexPatch
extends MobPatch<Vex> {
    public VexPatch() {
        super(Faction.ILLAGER);
    }

    @Override
    protected void initAI() {
        super.initAI();
        ((Vex)this.original).f_21345_.m_25352_(0, (Goal)new ChargeAttackGoal());
        ((Vex)this.original).f_21345_.m_25352_(1, (Goal)new StopStandGoal());
    }

    @Override
    protected void selectGoalToRemove(Set<Goal> toRemove) {
        super.selectGoalToRemove(toRemove);
        Iterator iterator = ((Vex)this.original).f_21345_.m_148105_().iterator();
        int index = 0;
        while (iterator.hasNext()) {
            WrappedGoal goal = (WrappedGoal)iterator.next();
            Goal inner = goal.m_26015_();
            if (index == 1) {
                toRemove.add(inner);
                break;
            }
            ++index;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initAnimator(ClientAnimator clientAnimator) {
        clientAnimator.addLivingAnimation(LivingMotions.IDLE, Animations.VEX_IDLE);
        clientAnimator.addLivingAnimation(LivingMotions.DEATH, Animations.VEX_DEATH);
        clientAnimator.addLivingAnimation(LivingMotions.IDLE, Animations.VEX_FLIPPING);
        clientAnimator.setCurrentMotionsAsDefault();
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        if (((Vex)this.original).m_21223_() <= 0.0f) {
            this.currentLivingMotion = LivingMotions.DEATH;
        } else if (this.state.inaction() && considerInaction) {
            this.currentLivingMotion = LivingMotions.IDLE;
        } else {
            this.currentLivingMotion = LivingMotions.IDLE;
            this.currentCompositeMotion = LivingMotions.IDLE;
        }
    }

    @Override
    public void onAttackBlocked(HurtEvent.Pre hurtEvent, LivingEntityPatch<?> opponent) {
        ((Vex)this.original).m_146884_(((LivingEntity)opponent.getOriginal()).m_146892_().m_82549_(((LivingEntity)opponent.getOriginal()).m_20154_()));
        this.playAnimationSynchronized(Animations.VEX_NEUTRALIZED, 0.0f);
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)modelDB.vex;
    }

    @Override
    public StaticAnimation getHitAnimation(ExtendedDamageSource.StunType stunType) {
        return Animations.VEX_HIT;
    }

    @Override
    public OpenMatrix4f getModelMatrix(float partialTicks) {
        return super.getModelMatrix(partialTicks).scale(0.4f, 0.4f, 0.4f);
    }

    class ChargeAttackGoal
    extends Goal {
        private int chargingCounter;

        public ChargeAttackGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (((Vex)VexPatch.this.original).m_5448_() != null && !VexPatch.this.getEntityState().inaction() && ((Vex)VexPatch.this.original).m_21187_().nextInt(10) == 0) {
                double distance = ((Vex)VexPatch.this.original).m_20280_((Entity)((Vex)VexPatch.this.original).m_5448_());
                return distance < 50.0;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.chargingCounter > 0;
        }

        public void m_8056_() {
            ((Vex)VexPatch.this.original).m_21566_().m_6849_(((Vex)VexPatch.this.original).m_20185_(), ((Vex)VexPatch.this.original).m_20186_(), ((Vex)VexPatch.this.original).m_20189_(), 0.25);
            VexPatch.this.playAnimationSynchronized(Animations.VEX_CHARGE, 0.0f);
            ((Vex)VexPatch.this.original).m_5496_(SoundEvents.f_12500_, 1.0f, 1.0f);
            ((Vex)VexPatch.this.original).m_34042_(true);
            this.chargingCounter = 20;
        }

        public void m_8041_() {
            ((Vex)VexPatch.this.original).m_34042_(false);
        }

        public void m_8037_() {
            --this.chargingCounter;
        }
    }

    class StopStandGoal
    extends Goal {
        public StopStandGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return VexPatch.this.getEntityState().inaction();
        }

        public void m_8056_() {
            ((Vex)VexPatch.this.original).m_21566_().m_6849_(((Vex)VexPatch.this.original).m_20185_(), ((Vex)VexPatch.this.original).m_20186_(), ((Vex)VexPatch.this.original).m_20189_(), 0.25);
        }
    }
}

