/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.mob;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Set;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.MobCombatBehaviors;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.mob.AbstractIllagerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

public class VindicatorPatch<T extends PathfinderMob>
extends AbstractIllagerPatch<T> {
    public VindicatorPatch() {
        super(Faction.ILLAGER);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initAnimator(ClientAnimator clientAnimator) {
        super.initAnimator(clientAnimator);
        clientAnimator.addLivingAnimation(LivingMotions.ANGRY, Animations.VINDICATOR_IDLE_AGGRESSIVE);
        clientAnimator.addLivingAnimation(LivingMotions.CHASE, Animations.VINDICATOR_CHASE);
        clientAnimator.setCurrentMotionsAsDefault();
    }

    @Override
    protected void initAttributes() {
        super.initAttributes();
        ((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.IMPACT.get()).m_22100_(1.0);
    }

    @Override
    protected void setWeaponMotions() {
        super.setWeaponMotions();
        this.weaponLivingMotions.put(CapabilityItem.WeaponCategories.GREATSWORD, ImmutableMap.of((Object)CapabilityItem.Styles.TWO_HAND, Set.of(Pair.of((Object)LivingMotions.WALK, (Object)Animations.ILLAGER_WALK), Pair.of((Object)LivingMotions.CHASE, (Object)Animations.BIPED_WALK_TWOHAND))));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.AXE, ImmutableMap.of((Object)CapabilityItem.Styles.COMMON, MobCombatBehaviors.VINDICATOR_ONEHAND));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.SWORD, ImmutableMap.of((Object)CapabilityItem.Styles.COMMON, MobCombatBehaviors.VINDICATOR_ONEHAND));
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        if (((PathfinderMob)this.original).m_21223_() <= 0.0f) {
            this.currentLivingMotion = LivingMotions.DEATH;
        } else if (this.state.inaction() && considerInaction) {
            this.currentLivingMotion = LivingMotions.IDLE;
        } else {
            boolean isAngry = ((PathfinderMob)this.original).m_5912_();
            this.currentLivingMotion = ((PathfinderMob)this.original).f_20924_ > 0.01f ? (isAngry ? LivingMotions.CHASE : LivingMotions.WALK) : (isAngry ? LivingMotions.ANGRY : LivingMotions.IDLE);
        }
    }

    @Override
    public void setAIAsMounted(Entity ridingEntity) {
    }
}

