/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.player;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.ExtendedDamageSource;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPAddSkill;
import yesman.epicfight.network.server.SPChangeLivingMotion;
import yesman.epicfight.network.server.SPChangePlayerMode;
import yesman.epicfight.network.server.SPChangePlayerYaw;
import yesman.epicfight.network.server.SPChangeSkill;
import yesman.epicfight.network.server.SPPlayAnimation;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.skill.CapabilitySkill;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.eventlistener.HurtEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class ServerPlayerPatch
extends PlayerPatch<ServerPlayer> {
    private LivingEntity attackTarget;
    private boolean updatedMotionCurrentTick;

    @Override
    public void onJoinWorld(ServerPlayer entityIn, EntityJoinWorldEvent event) {
        super.onJoinWorld(entityIn, event);
        CapabilitySkill skillCapability = this.getSkillCapability();
        for (SkillContainer skill2 : skillCapability.skillContainers) {
            if (skill2.getSkill() == null || !skill2.getSkill().getCategory().shouldSynchronized()) continue;
            EpicFightNetworkManager.sendToPlayer(new SPChangeSkill(skill2.getSkill().getCategory().universalOrdinal(), skill2.getSkill().toString(), SPChangeSkill.State.ENABLE), (ServerPlayer)this.original);
        }
        ArrayList learnedSkill = Lists.newArrayList();
        for (SkillCategory category : SkillCategory.ENUM_MANAGER.universalValues()) {
            if (!skillCapability.hasCategory(category)) continue;
            learnedSkill.addAll(Lists.newArrayList(skillCapability.getLearnedSkills(category).stream().map(skill -> skill.toString()).iterator()));
        }
        EpicFightNetworkManager.sendToPlayer(new SPAddSkill(learnedSkill.toArray(new String[0])), (ServerPlayer)this.original);
        EpicFightNetworkManager.sendToPlayer(new SPChangePlayerMode(((ServerPlayer)this.getOriginal()).m_142049_(), this.playerMode), (ServerPlayer)this.original);
    }

    @Override
    public void onStartTracking(ServerPlayer trackingPlayer) {
        SPChangeLivingMotion msg = new SPChangeLivingMotion(((ServerPlayer)this.getOriginal()).m_142049_());
        msg.putEntries(((Animator)this.getAnimator()).getLivingAnimationEntrySet());
        EpicFightNetworkManager.sendToPlayer(msg, trackingPlayer);
        EpicFightNetworkManager.sendToPlayer(new SPChangePlayerMode(((ServerPlayer)this.getOriginal()).m_142049_(), this.playerMode), trackingPlayer);
    }

    @Override
    public void gatherDamageDealt(ExtendedDamageSource source, float amount) {
        float value;
        SkillContainer container;
        if (source.isBasicAttack() && !(container = this.getSkill(SkillCategories.WEAPON_SPECIAL_ATTACK)).isFull() && container.hasSkill(this.getHoldingItemCapability(InteractionHand.MAIN_HAND).getSpecialAttack(this)) && (value = container.getResource() + amount) > 0.0f) {
            this.getSkill(SkillCategories.WEAPON_SPECIAL_ATTACK).getSkill().setConsumptionSynchronize(this, value);
        }
    }

    @Override
    public void tick(LivingEvent.LivingUpdateEvent event) {
        super.tick(event);
        this.updatedMotionCurrentTick = false;
    }

    @Override
    public void updateMotion(boolean considerInaction) {
    }

    @Override
    public void updateHeldItem(CapabilityItem fromCap, CapabilityItem toCap, ItemStack from, ItemStack to, InteractionHand hand) {
        CapabilityItem mainHandCap = hand == InteractionHand.MAIN_HAND ? toCap : this.getHoldingItemCapability(InteractionHand.MAIN_HAND);
        mainHandCap.changeWeaponSpecialSkill(this);
        if (hand == InteractionHand.OFF_HAND) {
            if (!from.m_41619_()) {
                from.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ATTACK_DAMAGE.get())).m_22130_(arg_0));
                from.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22283_).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ATTACK_SPEED.get())).m_22130_(arg_0));
            }
            if (!fromCap.isEmpty()) {
                fromCap.getAttributeModifiers(EquipmentSlot.MAINHAND, this).get((Object)((Attribute)EpicFightAttributes.ARMOR_NEGATION.get())).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ARMOR_NEGATION.get())).m_22130_(arg_0));
                fromCap.getAttributeModifiers(EquipmentSlot.MAINHAND, this).get((Object)((Attribute)EpicFightAttributes.IMPACT.get())).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_IMPACT.get())).m_22130_(arg_0));
                fromCap.getAttributeModifiers(EquipmentSlot.MAINHAND, this).get((Object)((Attribute)EpicFightAttributes.MAX_STRIKES.get())).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_MAX_STRIKES.get())).m_22130_(arg_0));
                fromCap.getAttributeModifiers(EquipmentSlot.MAINHAND, this).get((Object)Attributes.f_22281_).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ATTACK_DAMAGE.get())).m_22130_(arg_0));
                fromCap.getAttributeModifiers(EquipmentSlot.MAINHAND, this).get((Object)Attributes.f_22283_).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ATTACK_SPEED.get())).m_22130_(arg_0));
            }
            if (!to.m_41619_()) {
                to.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ATTACK_DAMAGE.get())).m_22118_(arg_0));
                to.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22283_).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ATTACK_SPEED.get())).m_22118_(arg_0));
            }
            if (!toCap.isEmpty()) {
                toCap.getAttributeModifiers(EquipmentSlot.MAINHAND, this).get((Object)((Attribute)EpicFightAttributes.ARMOR_NEGATION.get())).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ARMOR_NEGATION.get())).m_22118_(arg_0));
                toCap.getAttributeModifiers(EquipmentSlot.MAINHAND, this).get((Object)((Attribute)EpicFightAttributes.IMPACT.get())).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_IMPACT.get())).m_22118_(arg_0));
                toCap.getAttributeModifiers(EquipmentSlot.MAINHAND, this).get((Object)((Attribute)EpicFightAttributes.MAX_STRIKES.get())).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_MAX_STRIKES.get())).m_22118_(arg_0));
                toCap.getAttributeModifiers(EquipmentSlot.MAINHAND, this).get((Object)Attributes.f_22281_).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ATTACK_DAMAGE.get())).m_22118_(arg_0));
                toCap.getAttributeModifiers(EquipmentSlot.MAINHAND, this).get((Object)Attributes.f_22283_).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ATTACK_SPEED.get())).m_22118_(arg_0));
            }
        }
        this.modifyLivingMotionByCurrentItem();
    }

    public void modifyLivingMotionByCurrentItem() {
        if (this.updatedMotionCurrentTick) {
            return;
        }
        ((Animator)this.getAnimator()).resetMotions();
        CapabilityItem mainhandCap = this.getHoldingItemCapability(InteractionHand.MAIN_HAND);
        CapabilityItem offhandCap = this.getAdvancedHoldingItemCapability(InteractionHand.OFF_HAND);
        HashMap motionModifier = Maps.newHashMap();
        offhandCap.getLivingMotionModifier(this, InteractionHand.OFF_HAND).forEach(motionModifier::put);
        mainhandCap.getLivingMotionModifier(this, InteractionHand.MAIN_HAND).forEach(motionModifier::put);
        for (Map.Entry entry : motionModifier.entrySet()) {
            ((Animator)this.getAnimator()).addLivingAnimation((LivingMotion)entry.getKey(), (StaticAnimation)entry.getValue());
        }
        SPChangeLivingMotion msg = new SPChangeLivingMotion(((ServerPlayer)this.original).m_142049_());
        msg.putEntries(((Animator)this.getAnimator()).getLivingAnimationEntrySet());
        EpicFightNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(msg, (ServerPlayer)this.original);
        this.updatedMotionCurrentTick = true;
    }

    @Override
    public void playAnimationSynchronized(StaticAnimation animation, float convertTimeModifier, LivingEntityPatch.AnimationPacketProvider packetProvider) {
        super.playAnimationSynchronized(animation, convertTimeModifier, packetProvider);
        EpicFightNetworkManager.sendToPlayer(packetProvider.get(animation, convertTimeModifier, this), (ServerPlayer)this.original);
    }

    @Override
    public void reserveAnimation(StaticAnimation animation) {
        super.reserveAnimation(animation);
        EpicFightNetworkManager.sendToPlayer(new SPPlayAnimation(animation, ((ServerPlayer)this.original).m_142049_(), 0.0f), (ServerPlayer)this.original);
    }

    @Override
    public void changeYaw(float amount) {
        super.changeYaw(amount);
        EpicFightNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(new SPChangePlayerYaw(((ServerPlayer)this.original).m_142049_(), this.yaw), (ServerPlayer)this.original);
    }

    @Override
    public AttackResult tryHurt(DamageSource damageSource, float amount) {
        HurtEvent.Pre hurtEvent = new HurtEvent.Pre(this, damageSource, amount);
        if (this.getEventListener().triggerEvents(PlayerEventListener.EventType.HURT_EVENT_PRE, hurtEvent)) {
            return new AttackResult(hurtEvent.getResult(), hurtEvent.getAmount());
        }
        return super.tryHurt(damageSource, amount);
    }

    @Override
    public void toMiningMode(boolean synchronize) {
        super.toMiningMode(synchronize);
        if (synchronize) {
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(new SPChangePlayerMode(((ServerPlayer)this.original).m_142049_(), PlayerPatch.PlayerMode.MINING), (ServerPlayer)this.original);
        }
    }

    @Override
    public void toBattleMode(boolean synchronize) {
        super.toBattleMode(synchronize);
        if (synchronize) {
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(new SPChangePlayerMode(((ServerPlayer)this.original).m_142049_(), PlayerPatch.PlayerMode.BATTLE), (ServerPlayer)this.original);
        }
    }

    @Override
    public boolean isTeammate(Entity entityIn) {
        if (entityIn instanceof Player && !((ServerPlayer)this.getOriginal()).f_8924_.m_129799_()) {
            return true;
        }
        return super.isTeammate(entityIn);
    }

    public void setAttackTarget(LivingEntity entity) {
        this.attackTarget = entity;
    }

    @Override
    public LivingEntity getTarget() {
        return this.attackTarget;
    }
}

