/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.provider;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.projectile.ArrowPatch;
import yesman.epicfight.world.capabilities.projectile.DragonFireballPatch;
import yesman.epicfight.world.capabilities.projectile.ProjectilePatch;
import yesman.epicfight.world.capabilities.projectile.WitherSkullPatch;

public class ProviderProjectile
implements ICapabilityProvider,
NonNullSupplier<ProjectilePatch<?>> {
    private static final Map<EntityType<?>, Supplier<ProjectilePatch<?>>> CAPABILITY_BY_TYPE = new HashMap();
    private static final Map<Class<? extends Projectile>, Supplier<ProjectilePatch<?>>> CAPABILITY_BY_CLASS = new HashMap();
    private ProjectilePatch<?> capability;
    private LazyOptional<ProjectilePatch<?>> optional = LazyOptional.of((NonNullSupplier)this);

    public static void registerPatches() {
        CAPABILITY_BY_TYPE.computeIfAbsent(EntityType.f_20548_, type -> ArrowPatch::new);
        CAPABILITY_BY_TYPE.computeIfAbsent(EntityType.f_20498_, type -> WitherSkullPatch::new);
        CAPABILITY_BY_TYPE.computeIfAbsent(EntityType.f_20561_, type -> DragonFireballPatch::new);
        CAPABILITY_BY_CLASS.put(AbstractArrow.class, ArrowPatch::new);
    }

    public ProviderProjectile(Projectile projectile) {
        if (CAPABILITY_BY_TYPE.containsKey(projectile.m_6095_())) {
            this.capability = CAPABILITY_BY_TYPE.get(projectile.m_6095_()).get();
        } else {
            Supplier<ProjectilePatch<?>> capSupplier = this.makeCustomCapability(projectile);
            CAPABILITY_BY_TYPE.put(projectile.m_6095_(), capSupplier);
            this.capability = capSupplier.get();
        }
    }

    private Supplier<ProjectilePatch<?>> makeCustomCapability(Projectile projectileEntity) {
        Supplier<ProjectilePatch<?>> cap = () -> null;
        for (Class<?> clazz = projectileEntity.getClass(); clazz != null && cap.get() == null; clazz = clazz.getSuperclass()) {
            cap = CAPABILITY_BY_CLASS.getOrDefault(clazz, () -> null);
        }
        return cap;
    }

    public boolean hasCapability() {
        return this.capability != null;
    }

    public ProjectilePatch<?> get() {
        return this.capability;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return cap == EpicFightCapabilities.CAPABILITY_PROJECTILE ? this.optional.cast() : LazyOptional.empty();
    }
}

