/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.entity.ai.attribute;

import java.util.UUID;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import yesman.epicfight.world.entity.EpicFightEntities;
import yesman.epicfight.world.entity.WitherGhostClone;

public class EpicFightAttributes {
    public static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (String)"epicfight");
    public static final RegistryObject<Attribute> MAX_STAMINA = ATTRIBUTES.register("staminar", () -> new RangedAttribute("attribute.name.epicfight.staminar", 0.0, 0.0, 1024.0).m_22084_(true));
    public static final RegistryObject<Attribute> STUN_ARMOR = ATTRIBUTES.register("stun_armor", () -> new RangedAttribute("attribute.name.epicfight.stun_armor", 0.0, 0.0, 1024.0).m_22084_(true));
    public static final RegistryObject<Attribute> WEIGHT = ATTRIBUTES.register("weight", () -> new RangedAttribute("attribute.name.epicfight.weight", 0.0, 0.0, 1024.0).m_22084_(true));
    public static final RegistryObject<Attribute> MAX_STRIKES = ATTRIBUTES.register("max_strikes", () -> new RangedAttribute("attribute.name.epicfight.max_strikes", 1.0, 1.0, 1024.0).m_22084_(true));
    public static final RegistryObject<Attribute> ARMOR_NEGATION = ATTRIBUTES.register("armor_negation", () -> new RangedAttribute("attribute.name.epicfight.armor_negation", 0.0, 0.0, 100.0).m_22084_(true));
    public static final RegistryObject<Attribute> IMPACT = ATTRIBUTES.register("impact", () -> new RangedAttribute("attribute.name.epicfight.impact", 0.0, 0.0, 1024.0).m_22084_(true));
    public static final RegistryObject<Attribute> OFFHAND_ATTACK_DAMAGE = ATTRIBUTES.register("offhand_attack_damage", () -> new RangedAttribute("offhand attack damage", 1.0, 0.0, 2048.0));
    public static final RegistryObject<Attribute> OFFHAND_ATTACK_SPEED = ATTRIBUTES.register("offhand_attack_speed", () -> new RangedAttribute("offhand attack speed", 4.0, 0.0, 1024.0).m_22084_(true));
    public static final RegistryObject<Attribute> OFFHAND_MAX_STRIKES = ATTRIBUTES.register("offhand_max_strikes", () -> new RangedAttribute("attribute.name.epicfight.offhand_max_strikes", 1.0, 1.0, 1024.0).m_22084_(true));
    public static final RegistryObject<Attribute> OFFHAND_ARMOR_NEGATION = ATTRIBUTES.register("offhand_armor_negation", () -> new RangedAttribute("attribute.name.epicfight.offhand_armor_negation", 0.0, 0.0, 100.0).m_22084_(true));
    public static final RegistryObject<Attribute> OFFHAND_IMPACT = ATTRIBUTES.register("offhand_impact", () -> new RangedAttribute("attribute.name.epicfight.offhand_impact", 0.0, 0.0, 1024.0).m_22084_(true));
    public static final UUID ARMOR_NEGATION_MODIFIER = UUID.fromString("b0a7436e-5734-11eb-ae93-0242ac130002");
    public static final UUID MAX_STRIKE_MODIFIER = UUID.fromString("b0a745b2-5734-11eb-ae93-0242ac130002");
    public static final UUID IMPACT_MODIFIER = UUID.fromString("b0a746ac-5734-11eb-ae93-0242ac130002");
    public static final UUID ATTACK_DAMAGE_MODIFIER = UUID.fromString("1c224694-19f3-11ec-9621-0242ac130002");
    public static final UUID ATTACK_SPEED_MODIFIER = UUID.fromString("1c2249f0-19f3-11ec-9621-0242ac130002");

    public static void registerNewMobs(EntityAttributeCreationEvent event) {
        event.put((EntityType)EpicFightEntities.WITHER_SKELETON_MINION.get(), AbstractSkeleton.m_32166_().m_22265_());
        event.put((EntityType)EpicFightEntities.WITHER_GHOST_CLONE.get(), WitherGhostClone.createAttributes().m_22265_());
    }

    public static void modifyExistingMobs(EntityAttributeModificationEvent event) {
        EpicFightAttributes.commonCreature((EntityType<? extends LivingEntity>)EntityType.f_20554_, event);
        EpicFightAttributes.commonCreature((EntityType<? extends LivingEntity>)EntityType.f_20568_, event);
        EpicFightAttributes.commonCreature((EntityType<? extends LivingEntity>)EntityType.f_20460_, event);
        EpicFightAttributes.humanoid((EntityType<? extends LivingEntity>)EntityType.f_20513_, event);
        EpicFightAttributes.commonCreature((EntityType<? extends LivingEntity>)EntityType.f_20518_, event);
        EpicFightAttributes.commonCreature((EntityType<? extends LivingEntity>)EntityType.f_20479_, event);
        EpicFightAttributes.commonCreature((EntityType<? extends LivingEntity>)EntityType.f_20491_, event);
        EpicFightAttributes.humanoid((EntityType<? extends LivingEntity>)EntityType.f_20493_, event);
        EpicFightAttributes.humanoid((EntityType<? extends LivingEntity>)EntityType.f_20495_, event);
        EpicFightAttributes.commonCreature((EntityType<? extends LivingEntity>)EntityType.f_20456_, event);
        EpicFightAttributes.commonCreature((EntityType<? extends LivingEntity>)EntityType.f_20500_, event);
        EpicFightAttributes.commonCreature((EntityType<? extends LivingEntity>)EntityType.f_20565_, event);
        EpicFightAttributes.commonCreature((EntityType<? extends LivingEntity>)EntityType.f_20558_, event);
        EpicFightAttributes.humanoid((EntityType<? extends LivingEntity>)EntityType.f_20562_, event);
        EpicFightAttributes.commonCreature((EntityType<? extends LivingEntity>)EntityType.f_20566_, event);
        EpicFightAttributes.humanoid((EntityType<? extends LivingEntity>)EntityType.f_20458_, event);
        EpicFightAttributes.humanoid((EntityType<? extends LivingEntity>)EntityType.f_20511_, event);
        EpicFightAttributes.humanoid((EntityType<? extends LivingEntity>)EntityType.f_20512_, event);
        EpicFightAttributes.humanoid((EntityType<? extends LivingEntity>)EntityType.f_20524_, event);
        EpicFightAttributes.humanoid((EntityType<? extends LivingEntity>)EntityType.f_20481_, event);
        EpicFightAttributes.humanoid((EntityType<? extends LivingEntity>)EntityType.f_20497_, event);
        EpicFightAttributes.humanoid((EntityType<? extends LivingEntity>)EntityType.f_20501_, event);
        EpicFightAttributes.humanoid((EntityType<? extends LivingEntity>)EntityType.f_20530_, event);
        EpicFightAttributes.humanoid((EntityType<? extends LivingEntity>)EntityType.f_20531_, event);
        EpicFightAttributes.commonCreature((EntityType<? extends LivingEntity>)((EntityType)EpicFightEntities.WITHER_SKELETON_MINION.get()), event);
        EpicFightAttributes.player((EntityType<? extends LivingEntity>)EntityType.f_20532_, event);
        EpicFightAttributes.dragon((EntityType<? extends EnderDragon>)EntityType.f_20565_, event);
        EpicFightAttributes.commonCreature((EntityType<? extends LivingEntity>)EntityType.f_20496_, event);
    }

    private static void commonCreature(EntityType<? extends LivingEntity> entityType, EntityAttributeModificationEvent event) {
        event.add(entityType, (Attribute)WEIGHT.get());
        event.add(entityType, (Attribute)ARMOR_NEGATION.get());
        event.add(entityType, (Attribute)IMPACT.get());
        event.add(entityType, (Attribute)MAX_STRIKES.get());
        event.add(entityType, (Attribute)STUN_ARMOR.get());
    }

    private static void humanoid(EntityType<? extends LivingEntity> entityType, EntityAttributeModificationEvent event) {
        EpicFightAttributes.commonCreature(entityType, event);
        event.add(entityType, (Attribute)OFFHAND_ATTACK_DAMAGE.get());
        event.add(entityType, (Attribute)OFFHAND_ATTACK_SPEED.get());
        event.add(entityType, (Attribute)OFFHAND_MAX_STRIKES.get());
        event.add(entityType, (Attribute)OFFHAND_ARMOR_NEGATION.get());
        event.add(entityType, (Attribute)OFFHAND_IMPACT.get());
    }

    private static void player(EntityType<? extends LivingEntity> entityType, EntityAttributeModificationEvent event) {
        EpicFightAttributes.humanoid(entityType, event);
        event.add(entityType, (Attribute)MAX_STAMINA.get());
    }

    private static void dragon(EntityType<? extends EnderDragon> entityType, EntityAttributeModificationEvent event) {
        EpicFightAttributes.commonCreature(entityType, event);
        event.add(entityType, Attributes.f_22281_);
    }

    public static AttributeModifier getArmorNegationModifier(double value) {
        return new AttributeModifier(ARMOR_NEGATION_MODIFIER, "epicfight:weapon_modifier", value, AttributeModifier.Operation.ADDITION);
    }

    public static AttributeModifier getMaxStrikesModifier(int value) {
        return new AttributeModifier(MAX_STRIKE_MODIFIER, "epicfight:weapon_modifier", (double)value, AttributeModifier.Operation.ADDITION);
    }

    public static AttributeModifier getImpactModifier(double value) {
        return new AttributeModifier(IMPACT_MODIFIER, "epicfight:weapon_modifier", value, AttributeModifier.Operation.ADDITION);
    }

    public static AttributeModifier getDamageBonusModifier(double value) {
        return new AttributeModifier(ATTACK_DAMAGE_MODIFIER, "epicfight:weapon_modifier", value, AttributeModifier.Operation.ADDITION);
    }

    public static AttributeModifier getSpeedBonusModifier(double value) {
        return new AttributeModifier(ATTACK_SPEED_MODIFIER, "epicfight:weapon_modifier", value, AttributeModifier.Operation.ADDITION);
    }
}

