/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.entity.ai.goal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.network.server.SPPlayAnimation;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;

public class CombatBehaviors<T extends MobPatch<?>> {
    private final List<BehaviorSeries<T>> behaviorSeriesList = Lists.newArrayList();
    private final T mobpatch;
    private int currentBehaviorPointer;

    protected CombatBehaviors(Builder<T> builder, T mobpatch) {
        builder.behaviorSeriesList.stream().map(behaviorSeriesBuilder -> behaviorSeriesBuilder.build()).forEach(this.behaviorSeriesList::add);
        this.mobpatch = mobpatch;
        this.currentBehaviorPointer = -1;
    }

    private int getRandomCombatBehaviorSeries() {
        ArrayList candidates = Lists.newArrayList();
        ArrayList rescaledWeight = Lists.newArrayList();
        float weightSum = 0.0f;
        for (int i = 0; i < this.behaviorSeriesList.size(); ++i) {
            BehaviorSeries<T> move;
            boolean result;
            if (this.currentBehaviorPointer == i || !(result = (move = this.behaviorSeriesList.get(i)).test(this.mobpatch))) continue;
            weightSum += move.weight;
            candidates.add(i);
        }
        Iterator i = candidates.iterator();
        while (i.hasNext()) {
            int i2 = (Integer)i.next();
            rescaledWeight.add(Float.valueOf(this.behaviorSeriesList.get((int)i2).weight / weightSum));
        }
        float random = ((Mob)((EntityPatch)this.mobpatch).getOriginal()).m_21187_().nextFloat();
        float delta = 0.0f;
        for (int i3 = 0; i3 < candidates.size(); ++i3) {
            int index = (Integer)candidates.get(i3);
            if (!(random < (delta += ((Float)rescaledWeight.get(i3)).floatValue()))) continue;
            this.behaviorSeriesList.get(index).resetCooldown(this, true);
            return index;
        }
        return -1;
    }

    public void execute(int seriesPointer) {
        this.currentBehaviorPointer = seriesPointer;
        BehaviorSeries<T> behaviorSeries = this.behaviorSeriesList.get(seriesPointer);
        Behavior<T> behavior = behaviorSeries.behaviors.get(behaviorSeries.nextBehaviorPointer);
        behaviorSeries.upCounter();
        behavior.execute(this.mobpatch);
    }

    public void resetCooldown(int seriesPointer, boolean resetSharingCooldown) {
        this.behaviorSeriesList.get(seriesPointer).resetCooldown(this, resetSharingCooldown);
    }

    public Behavior<T> selectRandomBehaviorSeries() {
        int seriesPointer = this.getRandomCombatBehaviorSeries();
        if (seriesPointer >= 0) {
            this.currentBehaviorPointer = seriesPointer;
            BehaviorSeries<T> behaviorSeries = this.behaviorSeriesList.get(seriesPointer);
            Behavior behavior = behaviorSeries.behaviors.get(behaviorSeries.nextBehaviorPointer);
            behaviorSeries.upCounter();
            if (behaviorSeries.loopFinished && !behaviorSeries.looping) {
                behaviorSeries.loopFinished = false;
                this.currentBehaviorPointer = -1;
            }
            return behavior;
        }
        return null;
    }

    public Behavior<T> tryProceed() {
        int seriesPointer;
        BehaviorSeries<T> currentBehaviorSeries = this.behaviorSeriesList.get(this.currentBehaviorPointer);
        if (currentBehaviorSeries.canBeInterrupted && (seriesPointer = this.getRandomCombatBehaviorSeries()) >= 0 && this.currentBehaviorPointer != seriesPointer) {
            this.currentBehaviorPointer = seriesPointer;
            BehaviorSeries<T> newCombatBehaviorSeries = this.behaviorSeriesList.get(seriesPointer);
            return newCombatBehaviorSeries.behaviors.get(newCombatBehaviorSeries.nextBehaviorPointer);
        }
        if (currentBehaviorSeries.loopFinished && !currentBehaviorSeries.looping) {
            currentBehaviorSeries.loopFinished = false;
            this.currentBehaviorPointer = -1;
            return null;
        }
        Behavior<T> nextBehavior = currentBehaviorSeries.behaviors.get(currentBehaviorSeries.nextBehaviorPointer);
        if (nextBehavior.checkPredicates(this.mobpatch)) {
            currentBehaviorSeries.upCounter();
            return nextBehavior;
        }
        this.currentBehaviorPointer = -1;
        if (!currentBehaviorSeries.looping) {
            currentBehaviorSeries.nextBehaviorPointer = 0;
        }
        return null;
    }

    public boolean hasActivatedMove() {
        return this.currentBehaviorPointer >= 0;
    }

    public void tick() {
        for (BehaviorSeries<T> behaviorSeries : this.behaviorSeriesList) {
            behaviorSeries.tick();
        }
    }

    public static <T extends MobPatch<?>> Builder<T> builder() {
        return new Builder();
    }

    public static class Builder<T extends MobPatch<?>> {
        private List<BehaviorSeries.Builder<T>> behaviorSeriesList = Lists.newArrayList();

        public Builder<T> newBehaviorSeries(BehaviorSeries.Builder<T> builder) {
            this.behaviorSeriesList.add(builder);
            return this;
        }

        public CombatBehaviors<T> build(T mobpatch) {
            return new CombatBehaviors<T>(this, mobpatch);
        }
    }

    public static class BehaviorSeries<T extends MobPatch<?>> {
        private final List<Behavior<T>> behaviors = Lists.newArrayList();
        private final boolean looping;
        private final boolean canBeInterrupted;
        private final float weight;
        private final int maxCooldown;
        private List<Integer> cooldownSharingPointer;
        private int cooldown;
        private int nextBehaviorPointer;
        private boolean loopFinished;

        private BehaviorSeries(Builder<T> builder) {
            builder.behaviors.stream().map(motionBuilder -> motionBuilder.build()).forEach(this.behaviors::add);
            this.looping = builder.looping;
            this.canBeInterrupted = builder.canBeInterrupted;
            this.weight = builder.weight;
            this.cooldownSharingPointer = builder.cooldownSharingPointers;
            this.maxCooldown = builder.cooldown;
        }

        public boolean test(T mobpatch) {
            if (this.cooldown > 0) {
                return false;
            }
            return this.behaviors.get(this.nextBehaviorPointer).checkPredicates(mobpatch);
        }

        public void upCounter() {
            ++this.nextBehaviorPointer;
            this.loopFinished = false;
            int behaviorsNum = this.behaviors.size();
            if (this.nextBehaviorPointer >= behaviorsNum) {
                this.nextBehaviorPointer %= behaviorsNum;
                this.loopFinished = true;
            }
        }

        public void tick() {
            --this.cooldown;
        }

        public void resetCooldown(CombatBehaviors<T> mobBehavior, boolean resetSharingCooldown) {
            this.cooldown = this.maxCooldown;
            if (resetSharingCooldown) {
                for (int i : this.cooldownSharingPointer) {
                    BehaviorSeries behaviorSeries = mobBehavior.behaviorSeriesList.get(i);
                    behaviorSeries.cooldown = behaviorSeries.maxCooldown;
                }
            }
        }

        public static <T extends MobPatch<?>> Builder<T> builder() {
            return new Builder();
        }

        public static class Builder<T extends MobPatch<?>> {
            private List<Behavior.Builder<T>> behaviors = Lists.newArrayList();
            private boolean looping = false;
            private boolean canBeInterrupted = true;
            private float weight;
            private int cooldown;
            private List<Integer> cooldownSharingPointers = Lists.newArrayList();

            public Builder<T> weight(float weight) {
                this.weight = weight;
                return this;
            }

            public Builder<T> cooldown(int cooldown) {
                this.cooldown = cooldown;
                return this;
            }

            public Builder<T> simultaneousCooldown(int ... cooldownSharingPointers) {
                for (int pointer : cooldownSharingPointers) {
                    this.cooldownSharingPointers.add(pointer);
                }
                return this;
            }

            public Builder<T> nextBehavior(Behavior.Builder<T> motion) {
                this.behaviors.add(motion);
                return this;
            }

            public Builder<T> looping(boolean looping) {
                this.looping = looping;
                return this;
            }

            public Builder<T> canBeInterrupted(boolean canBeInterrupted) {
                this.canBeInterrupted = canBeInterrupted;
                return this;
            }

            public BehaviorSeries<T> build() {
                return new BehaviorSeries(this);
            }
        }
    }

    public static class Behavior<T extends MobPatch<?>> {
        private Consumer<T> behavior;
        private final List<BehaviorPredicate<T>> predicates;

        private Behavior(Builder<T> builder) {
            this.behavior = builder.behavior;
            this.predicates = builder.predicate;
        }

        private boolean checkPredicates(T mobpatch) {
            for (BehaviorPredicate<T> predicate : this.predicates) {
                if (predicate.test(mobpatch)) continue;
                return false;
            }
            return true;
        }

        public void execute(T mobpatch) {
            this.behavior.accept(mobpatch);
            ((LivingEntityPatch)mobpatch).updateEntityState();
        }

        public static <T extends MobPatch<?>> Builder<T> builder() {
            return new Builder();
        }

        public static class Builder<T extends MobPatch<?>> {
            private Consumer<T> behavior;
            private List<BehaviorPredicate<T>> predicate = Lists.newArrayList();
            private LivingEntityPatch.AnimationPacketProvider packetProvider = SPPlayAnimation::new;

            public Builder<T> behavior(Consumer<T> behavior) {
                this.behavior = behavior;
                return this;
            }

            public Builder<T> emptyBehavior() {
                this.behavior = mobpatch -> {};
                return this;
            }

            public Builder<T> animationBehavior(StaticAnimation motion) {
                this.behavior = mobpatch -> mobpatch.playAnimationSynchronized(motion, 0.0f, this.packetProvider);
                return this;
            }

            public Builder<T> withinEyeHeight() {
                this.predicate(new TargetWithinEyeHeight());
                return this;
            }

            public Builder<T> randomChance(float chance) {
                this.predicate(new RandomChance(chance));
                return this;
            }

            public Builder<T> withinDistance(double minDistance, double maxDistance) {
                this.predicate(new TargetWithinDistance(minDistance * minDistance, maxDistance * maxDistance));
                return this;
            }

            public Builder<T> withinAngle(double minDegree, double maxDegree) {
                this.predicate(new TargetWithinAngle(minDegree, maxDegree));
                return this;
            }

            public Builder<T> withinAngleHorizontal(double minDegree, double maxDegree) {
                this.predicate(new TargetWithinAngle.Horizontal(minDegree, maxDegree));
                return this;
            }

            public Builder<T> health(float health, Health.Comparator comparator) {
                this.predicate(new Health(health, comparator));
                return this;
            }

            public Builder<T> custom(Function<T, Boolean> customPredicate) {
                this.predicate(new CustomPredicate<T>(customPredicate));
                return this;
            }

            public Builder<T> predicate(BehaviorPredicate<T> predicate) {
                this.predicate.add(predicate);
                return this;
            }

            public Builder<T> packetProvider(LivingEntityPatch.AnimationPacketProvider packetProvider) {
                this.packetProvider = packetProvider;
                return this;
            }

            public Behavior<T> build() {
                return new Behavior(this);
            }
        }
    }

    public static class Health<T extends MobPatch<?>>
    extends BehaviorPredicate<T> {
        private final float value;
        private final Comparator comparator;

        public Health(float value, Comparator comparator) {
            this.value = value;
            this.comparator = comparator;
        }

        @Override
        public boolean test(T mobpatch) {
            switch (this.comparator) {
                case LESS_ABSOLUTE: {
                    return this.value > ((Mob)((EntityPatch)mobpatch).getOriginal()).m_21223_();
                }
                case GREATER_ABSOLUTE: {
                    return this.value < ((Mob)((EntityPatch)mobpatch).getOriginal()).m_21223_();
                }
                case LESS_RATIO: {
                    return this.value > ((Mob)((EntityPatch)mobpatch).getOriginal()).m_21223_() / ((Mob)((EntityPatch)mobpatch).getOriginal()).m_21233_();
                }
                case GREATER_RATIO: {
                    return this.value < ((Mob)((EntityPatch)mobpatch).getOriginal()).m_21223_() / ((Mob)((EntityPatch)mobpatch).getOriginal()).m_21233_();
                }
            }
            return true;
        }

        public static enum Comparator {
            GREATER_ABSOLUTE,
            LESS_ABSOLUTE,
            GREATER_RATIO,
            LESS_RATIO;

        }
    }

    public static class TargetWithinAngle<T extends MobPatch<?>>
    extends BehaviorPredicate<T> {
        protected final double minDegree;
        protected final double maxDegree;

        public TargetWithinAngle(double minDegree, double maxDegree) {
            this.minDegree = minDegree;
            this.maxDegree = maxDegree;
        }

        @Override
        public boolean test(T mobpatch) {
            LivingEntity target = ((MobPatch)mobpatch).getTarget();
            double degree = ((EntityPatch)mobpatch).getAngleTo((Entity)target);
            return this.minDegree < degree && degree < this.maxDegree;
        }

        public static class Horizontal<T extends MobPatch<?>>
        extends TargetWithinAngle<T> {
            public Horizontal(double minDegree, double maxDegree) {
                super(minDegree, maxDegree);
            }

            @Override
            public boolean test(T mobpatch) {
                LivingEntity target = ((MobPatch)mobpatch).getTarget();
                double degree = ((EntityPatch)mobpatch).getAngleToHorizontal((Entity)target);
                return this.minDegree < degree && degree < this.maxDegree;
            }
        }
    }

    public static class TargetWithinDistance<T extends MobPatch<?>>
    extends BehaviorPredicate<T> {
        private final double minDistance;
        private final double maxDistance;

        public TargetWithinDistance(double minDistance, double maxDistance) {
            this.minDistance = minDistance;
            this.maxDistance = maxDistance;
        }

        @Override
        public boolean test(T mobpatch) {
            double distanceSqr = ((Mob)((EntityPatch)mobpatch).getOriginal()).m_20280_((Entity)((MobPatch)mobpatch).getTarget());
            return this.minDistance < distanceSqr && distanceSqr < this.maxDistance;
        }
    }

    public static class TargetWithinEyeHeight<T extends MobPatch<?>>
    extends BehaviorPredicate<T> {
        @Override
        public boolean test(T mobpatch) {
            double veticalDistance = Math.abs(((Mob)((EntityPatch)mobpatch).getOriginal()).m_20186_() - ((MobPatch)mobpatch).getTarget().m_20186_());
            return veticalDistance < (double)((Mob)((EntityPatch)mobpatch).getOriginal()).m_20192_();
        }
    }

    public static class RandomChance<T extends MobPatch<?>>
    extends BehaviorPredicate<T> {
        private final float chance;

        public RandomChance(float chance) {
            this.chance = chance;
        }

        @Override
        public boolean test(T mobpatch) {
            return ((Mob)((EntityPatch)mobpatch).getOriginal()).m_21187_().nextFloat() < this.chance;
        }
    }

    public static class CustomPredicate<T extends MobPatch<?>>
    extends BehaviorPredicate<T> {
        Function<T, Boolean> test;

        public CustomPredicate(Function<T, Boolean> test) {
            this.test = test;
        }

        @Override
        public boolean test(T mobpatch) {
            return this.test.apply(mobpatch);
        }
    }

    public static abstract class BehaviorPredicate<T extends MobPatch<?>> {
        public abstract boolean test(T var1);
    }
}

