/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client;

import java.lang.ref.WeakReference;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class BulletTrail {
    private int entityId;
    private Vec3 position;
    private Vec3 motion;
    private float yaw;
    private float pitch;
    private boolean dead;
    private ItemStack item;
    private int trailColor;
    private double trailLengthMultiplier;
    private int age;
    private int maxAge;
    private double gravity;
    private int shooterId;
    private WeakReference<Entity> shooter;
    private float shooterYaw;
    private float shooterPitch;
    private float size;

    public int getMaxAge() {
        return this.maxAge;
    }

    public BulletTrail(int entityId, Vec3 position, Vec3 motion, float shooterYaw, float shooterPitch, ItemStack item, int trailColor, double trailMultiplier, int maxAge, double gravity, int shooterId, float size) {
        this.entityId = entityId;
        this.position = position;
        this.motion = motion;
        this.item = item;
        this.trailColor = trailColor;
        this.trailLengthMultiplier = trailMultiplier;
        this.maxAge = maxAge;
        this.gravity = gravity;
        this.shooterId = shooterId;
        this.updateYawPitch();
        this.shooterYaw = shooterYaw;
        this.shooterPitch = shooterPitch;
        this.size = size;
    }

    private void updateYawPitch() {
        float horizontalLength = Mth.m_14116_((float)((float)(this.motion.f_82479_ * this.motion.f_82479_ + this.motion.f_82481_ * this.motion.f_82481_)));
        this.yaw = (float)Math.toDegrees(Mth.m_14136_((double)this.motion.f_82479_, (double)this.motion.f_82481_));
        this.pitch = (float)Math.toDegrees(Mth.m_14136_((double)this.motion.f_82480_, (double)horizontalLength));
    }

    public void tick() {
        Entity entity;
        double distance;
        ++this.age;
        this.position = this.position.m_82549_(this.motion);
        if (this.gravity != 0.0) {
            this.motion = this.motion.m_82520_(0.0, this.gravity, 0.0);
            this.updateYawPitch();
        }
        double d = distance = (entity = Minecraft.m_91087_().m_91288_()) != null ? Math.sqrt(entity.m_20238_(this.position)) : Double.MAX_VALUE;
        if (this.age >= this.maxAge || distance > 1024.0) {
            this.dead = true;
        }
    }

    public int getEntityId() {
        return this.entityId;
    }

    public Vec3 getPosition() {
        return this.position;
    }

    public Vec3 getMotion() {
        return this.motion;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public boolean isDead() {
        return this.dead;
    }

    public int getAge() {
        return this.age;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public int getTrailColor() {
        return this.trailColor;
    }

    public double getTrailLengthMultiplier() {
        return this.trailLengthMultiplier;
    }

    public int getShooterId() {
        return this.shooterId;
    }

    public float getShooterYaw() {
        return this.shooterYaw;
    }

    public float getShooterPitch() {
        return this.shooterPitch;
    }

    public float getSize() {
        return this.size;
    }

    @Nullable
    public Entity getShooter() {
        Entity entity;
        ClientLevel world;
        if (this.shooter == null && (world = Minecraft.m_91087_().f_91073_) != null && (entity = world.m_6815_(this.shooterId)) != null) {
            this.shooter = new WeakReference<Entity>(entity);
        }
        if (this.shooter != null) {
            Entity entity2 = (Entity)this.shooter.get();
            if (entity2 != null && !entity2.m_6084_()) {
                return null;
            }
            return entity2;
        }
        return null;
    }

    public boolean isTrailVisible() {
        Entity entity = Minecraft.m_91087_().m_91288_();
        return entity != null;
    }

    public int hashCode() {
        return this.entityId;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BulletTrail) {
            return ((BulletTrail)obj).entityId == this.entityId;
        }
        return false;
    }
}

