/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.handler;

import com.mrcrayfish.framework.common.data.SyncedEntityData;
import com.tac.guns.Config;
import com.tac.guns.client.Keys;
import com.tac.guns.client.handler.CrosshairHandler;
import com.tac.guns.client.render.animation.module.GunAnimationController;
import com.tac.guns.client.render.crosshair.Crosshair;
import com.tac.guns.common.AimingManager;
import com.tac.guns.common.Gun;
import com.tac.guns.duck.MouseSensitivityModifier;
import com.tac.guns.init.ModBlocks;
import com.tac.guns.init.ModSyncedDataKeys;
import com.tac.guns.item.GunItem;
import com.tac.guns.item.attachment.impl.Scope;
import com.tac.guns.item.transition.TimelessGunItem;
import com.tac.guns.network.PacketHandler;
import com.tac.guns.network.message.MessageAim;
import com.tac.guns.util.math.MathUtil;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.FOVModifierEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class AimingHandler {
    private static AimingHandler instance;
    private final AimingManager.AimTracker localTracker = new AimingManager.AimTracker();
    private double normalisedAdsProgress;
    private double oldProgress;
    private double newProgress;
    private boolean aiming = false;
    private boolean toggledAim = false;
    public boolean isRenderingHand = false;
    private int currentScopeZoomIndex = 0;
    private boolean isPressed = false;

    public static AimingHandler get() {
        if (instance == null) {
            instance = new AimingHandler();
        }
        return instance;
    }

    public int getCurrentScopeZoomIndex() {
        return this.currentScopeZoomIndex;
    }

    public void resetCurrentScopeZoomIndex() {
        this.currentScopeZoomIndex = 0;
    }

    private AimingHandler() {
        Keys.SIGHT_SWITCH.addPressCallback(() -> {
            if (!Keys.noConflict(Keys.SIGHT_SWITCH)) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null && (mc.f_91074_.m_21205_().m_41720_() instanceof GunItem || Gun.getScope(mc.f_91074_.m_21205_()) != null)) {
                ++this.currentScopeZoomIndex;
            }
        });
    }

    @SubscribeEvent
    public void onLocalPlayerLoggedOut(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        AimingManager.get().getAimingMap().clear();
    }

    @SubscribeEvent
    public void onClickInput(InputEvent.ClickInputEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        assert (player != null);
        ItemStack heldItem = player.m_21205_();
        boolean isGunInHand = heldItem.m_41720_() instanceof TimelessGunItem;
        if (!isGunInHand) {
            return;
        }
        if (!event.isUseItem()) {
            return;
        }
        boolean hasMouseOverBlock = mc.f_91077_ instanceof BlockHitResult;
        if (!hasMouseOverBlock) {
            return;
        }
        assert (mc.f_91073_ != null);
        BlockHitResult result = (BlockHitResult)mc.f_91077_;
        BlockState state = mc.f_91073_.m_8055_(result.m_82425_());
        Block block = state.m_60734_();
        Config.RightClickUse config = Config.CLIENT.rightClickUse;
        if (block instanceof EntityBlock ? (Boolean)config.allowChests.get() != false : (block == Blocks.f_50091_ || block == ModBlocks.WORKBENCH.get() ? (Boolean)config.allowCraftingTable.get() != false : (state.m_204336_(BlockTags.f_13103_) ? (Boolean)config.allowDoors.get() != false : (state.m_204336_(BlockTags.f_13036_) ? (Boolean)config.allowTrapDoors.get() != false : (state.m_204336_(Tags.Blocks.CHESTS) ? (Boolean)config.allowChests.get() != false : (state.m_204336_(Tags.Blocks.FENCE_GATES) ? (Boolean)config.allowFenceGates.get() != false : (state.m_204336_(BlockTags.f_13093_) ? (Boolean)config.allowButton.get() != false : (block == Blocks.f_50164_ ? (Boolean)config.allowLever.get() != false : (Boolean)config.allowRestUse.get() != false)))))))) {
            return;
        }
        event.setCanceled(true);
        event.setSwingHand(false);
    }

    public float getAimProgress(Player player, float partialTicks) {
        if (player.m_7578_()) {
            return (float)this.localTracker.getNormalProgress(partialTicks);
        }
        AimingManager.AimTracker tracker = AimingManager.get().getAimTracker(player);
        if (tracker != null) {
            return (float)tracker.getNormalProgress(partialTicks);
        }
        return 0.0f;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        this.tickLerpProgress();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (this.aiming) {
            player.m_6858_(false);
        }
        if (!((Boolean)Config.CLIENT.controls.holdToAim.get()).booleanValue() && !Keys.AIM_TOGGLE.m_90857_()) {
            this.isPressed = false;
        }
        if (this.isAiming()) {
            if (!this.aiming) {
                ModSyncedDataKeys.AIMING.setValue((Entity)player, (Object)true);
                PacketHandler.getPlayChannel().sendToServer((Object)new MessageAim(true));
                this.aiming = true;
                ItemStack stack = player.m_150109_().m_36056_();
                GunAnimationController controller = GunAnimationController.fromItem(stack.m_41720_());
                if (controller.isAnimationRunning(GunAnimationController.AnimationLabel.INSPECT)) {
                    controller.stopAnimation();
                }
            }
            this.localTracker.handleAiming(player.m_21120_(InteractionHand.MAIN_HAND), true);
        } else {
            if (this.aiming) {
                ModSyncedDataKeys.AIMING.setValue((Entity)player, (Object)false);
                PacketHandler.getPlayChannel().sendToServer((Object)new MessageAim(false));
                this.aiming = false;
            }
            this.localTracker.handleAiming(player.m_21120_(InteractionHand.MAIN_HAND), false);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onFovUpdate(FOVModifierEvent event) {
        ItemStack heldItem;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && !mc.f_91074_.m_21205_().m_41619_() && mc.f_91066_.m_92176_() == CameraType.FIRST_PERSON && (heldItem = mc.f_91074_.m_21205_()).m_41720_() instanceof TimelessGunItem) {
            Gun modifiedGun;
            TimelessGunItem gunItem = (TimelessGunItem)heldItem.m_41720_();
            if (AimingHandler.get().normalisedAdsProgress != 0.0 && !((Boolean)SyncedEntityData.instance().get((Entity)mc.f_91074_, ModSyncedDataKeys.RELOADING)).booleanValue() && (modifiedGun = gunItem.getModifiedGun(heldItem)).getModules().getZoom() != null) {
                float newFov = modifiedGun.getModules().getZoom().getFovModifier();
                Scope scope = Gun.getScope(heldItem);
                if (scope != null) {
                    if ((Boolean)Config.COMMON.gameplay.realisticLowPowerFovHandling.get() == false || scope.getAdditionalZoom().getZoomMultiple() > 1.0f && (Boolean)Config.COMMON.gameplay.realisticLowPowerFovHandling.get() != false || gunItem.isIntegratedOptic().booleanValue()) {
                        newFov = (float)MathUtil.magnificationToFovMultiplier(scope.getAdditionalZoom().getZoomMultiple(), Minecraft.m_91087_().f_91066_.f_92068_);
                        if (newFov >= 1.0f) {
                            newFov = modifiedGun.getModules().getZoom().getFovModifier();
                        }
                        event.setNewfov(newFov + (1.0f - newFov) * (1.0f - (float)this.normalisedAdsProgress));
                    }
                } else if (!((Boolean)Config.COMMON.gameplay.realisticIronSightFovHandling.get()).booleanValue() || gunItem.isIntegratedOptic().booleanValue()) {
                    event.setNewfov(newFov + (1.0f - newFov) * (1.0f - (float)this.normalisedAdsProgress));
                }
            }
        }
    }

    @SubscribeEvent
    public void captureFovAndModifyMouseSensitivity(EntityViewRenderEvent.FieldOfView event) {
        if (!this.isRenderingHand) {
            Minecraft mc = Minecraft.m_91087_();
            double modifier = MathUtil.fovToMagnification(event.getFOV(), mc.f_91066_.f_92068_);
            ((MouseSensitivityModifier)mc.f_91067_).setSensitivity(mc.f_91066_.f_92053_ / modifier);
        }
    }

    private void tickLerpProgress() {
        this.oldProgress = this.newProgress;
        this.newProgress += (this.normalisedAdsProgress - this.newProgress) * 0.5;
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onRenderOverlay(RenderGameOverlayEvent.PreLayer event) {
        this.normalisedAdsProgress = this.localTracker.getNormalProgress(event.getPartialTicks());
        Crosshair crosshair = CrosshairHandler.get().getCurrentCrosshair();
        if (this.normalisedAdsProgress > 0.0 && (crosshair == null || crosshair.isDefault()) && event.getOverlay() == ForgeIngameGui.CROSSHAIR_ELEMENT) {
            event.setCanceled(true);
        }
    }

    public boolean isAiming() {
        boolean zooming;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return false;
        }
        if (mc.f_91074_.m_5833_()) {
            return false;
        }
        if (mc.f_91080_ != null) {
            return false;
        }
        ItemStack heldItem = mc.f_91074_.m_21205_();
        if (!(heldItem.m_41720_() instanceof GunItem)) {
            return false;
        }
        Gun gun = ((GunItem)heldItem.m_41720_()).getModifiedGun(heldItem);
        if (gun.getModules().getZoom() == null) {
            return false;
        }
        ItemCooldowns tracker = Minecraft.m_91087_().f_91074_.m_36335_();
        float cooldown = tracker.m_41521_(heldItem.m_41720_(), Minecraft.m_91087_().m_91296_());
        if (gun.getGeneral().isBoltAction() && (double)cooldown < 0.8 && cooldown > 0.0f && Gun.getScope(heldItem) != null) {
            return false;
        }
        if (((Boolean)SyncedEntityData.instance().get((Entity)mc.f_91074_, ModSyncedDataKeys.RELOADING)).booleanValue()) {
            return false;
        }
        if (((Boolean)Config.CLIENT.controls.holdToAim.get()).booleanValue()) {
            zooming = Keys.AIM_HOLD.m_90857_();
        } else {
            if (Keys.AIM_TOGGLE.m_90857_() && !this.isPressed) {
                this.isPressed = true;
                this.forceToggleAim();
            }
            zooming = this.toggledAim;
        }
        return zooming;
    }

    public boolean isToggledAim() {
        return this.toggledAim;
    }

    public void forceToggleAim() {
        this.toggledAim = !this.toggledAim;
    }

    public double getNormalisedAdsProgress() {
        return this.normalisedAdsProgress;
    }

    public double getLerpAdsProgress(float partialTicks) {
        return Mth.m_14139_((double)partialTicks, (double)this.oldProgress, (double)this.newProgress);
    }
}

