/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.handler;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mrcrayfish.framework.common.data.SyncedEntityData;
import com.tac.guns.Config;
import com.tac.guns.GunMod;
import com.tac.guns.client.GunRenderType;
import com.tac.guns.client.event.PlayerModelEvent;
import com.tac.guns.client.event.RenderItemEvent;
import com.tac.guns.client.handler.AimingHandler;
import com.tac.guns.client.handler.RecoilHandler;
import com.tac.guns.client.handler.ReloadHandler;
import com.tac.guns.client.handler.ScopeJitterHandler;
import com.tac.guns.client.handler.command.GunEditor;
import com.tac.guns.client.render.IHeldAnimation;
import com.tac.guns.client.render.animation.module.GunAnimationController;
import com.tac.guns.client.render.animation.module.PistalAnimationController;
import com.tac.guns.client.render.model.IOverrideModel;
import com.tac.guns.client.render.model.OverrideModelManager;
import com.tac.guns.client.util.RenderUtil;
import com.tac.guns.common.Gun;
import com.tac.guns.common.network.ServerPlayHandler;
import com.tac.guns.common.tooling.CommandsHandler;
import com.tac.guns.event.GunFireEvent;
import com.tac.guns.event.GunReloadEvent;
import com.tac.guns.init.ModSyncedDataKeys;
import com.tac.guns.item.GrenadeItem;
import com.tac.guns.item.GunItem;
import com.tac.guns.item.OldScopeItem;
import com.tac.guns.item.PistolScopeItem;
import com.tac.guns.item.ScopeItem;
import com.tac.guns.item.attachment.IAttachment;
import com.tac.guns.item.attachment.IBarrel;
import com.tac.guns.item.attachment.impl.Barrel;
import com.tac.guns.item.attachment.impl.Scope;
import com.tac.guns.item.transition.ITimelessAnimated;
import com.tac.guns.item.transition.TimelessGunItem;
import com.tac.guns.network.PacketHandler;
import com.tac.guns.network.message.MessagePlayerShake;
import com.tac.guns.util.GunModifierHelper;
import com.tac.guns.util.IDLNBTUtil;
import com.tac.guns.util.OptifineHelper;
import com.tac.guns.util.math.MathUtil;
import com.tac.guns.util.math.OneDimensionalPerlinNoise;
import com.tac.guns.util.math.SecondOrderDynamics;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LightLayer;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.network.NetworkDirection;

public class GunRenderingHandler {
    private static GunRenderingHandler instance;
    private final SecondOrderDynamics recoilDynamics = new SecondOrderDynamics(0.5f, 0.6f, 2.65f, 0.0f);
    private final SecondOrderDynamics swayYawDynamics = new SecondOrderDynamics(0.4f, 0.5f, 3.25f, 0.0f);
    private final SecondOrderDynamics swayPitchDynamics = new SecondOrderDynamics(0.3f, 0.4f, 3.5f, 0.0f);
    private final SecondOrderDynamics aimingDynamics = new SecondOrderDynamics(0.45f, 0.8f, 1.2f, 0.0f);
    private final SecondOrderDynamics sprintDynamics = new SecondOrderDynamics(0.22f, 0.7f, 0.6f, 0.0f);
    private final SecondOrderDynamics bobbingDynamics = new SecondOrderDynamics(0.22f, 0.7f, 0.6f, 1.0f);
    private final SecondOrderDynamics speedUpDynamics = new SecondOrderDynamics(0.22f, 0.7f, 0.6f, 0.0f);
    private final SecondOrderDynamics delaySwayDynamics = new SecondOrderDynamics(0.75f, 0.9f, 1.4f, 0.0f);
    private final SecondOrderDynamics sprintDynamicsZ = new SecondOrderDynamics(0.22f, 0.8f, 0.5f, 0.0f);
    private final SecondOrderDynamics jumpingDynamics = new SecondOrderDynamics(0.28f, 1.0f, 0.65f, 0.0f);
    private final SecondOrderDynamics sprintDynamicsHSS = new SecondOrderDynamics(0.3f, 0.6f, 0.6f, 0.0f);
    private final SecondOrderDynamics sprintDynamicsZHSS = new SecondOrderDynamics(0.27f, 0.75f, 0.5f, 0.0f);
    public final SecondOrderDynamics sprintDynamicsHSSLeftHand = new SecondOrderDynamics(0.38f, 1.0f, 0.0f, 0.0f);
    public static final ResourceLocation MUZZLE_FLASH_TEXTURE;
    public static final ResourceLocation MUZZLE_SMOKE_TEXTURE;
    private final Random random = new Random();
    private final Set<Integer> entityIdForMuzzleFlash = new HashSet<Integer>();
    private final Set<Integer> entityIdForDrawnMuzzleFlash = new HashSet<Integer>();
    private Queue<ShellInAir> shells = new ArrayDeque<ShellInAir>();
    private final Map<Integer, Float> entityIdToRandomValue = new HashMap<Integer, Float>();
    public int sprintTransition;
    private int prevSprintTransition;
    private int sprintCooldown;
    private int restingTimer;
    private final int restingTimerUpper = 5;
    private float offhandTranslate;
    private float prevOffhandTranslate;
    public float muzzleExtraOnEnch = 0.0f;
    private Field equippedProgressMainHandField;
    private Field prevEquippedProgressMainHandField;
    private float startingDistance = 0.0f;
    private float speedUpDistanceFrom = 0.0f;
    public float speedUpDistance = 0.6f;
    public float speedUpProgress = 0.0f;
    private float additionalSwayProgress = 0.0f;
    private long fireTime = System.currentTimeMillis();
    public float immersiveWeaponRoll;
    public float walkingDistance1;
    public float walkingDistance = 0.0f;
    public float walkingCrouch;
    public float walkingCameraYaw;
    public float zoomProgressInv;
    public double xOffset = 0.0;
    public double yOffset = 0.0;
    public double zOffset = 0.0;
    public double opticMovement;
    public double slideKeep;
    public float translateX = 0.0f;
    public float translateY = 0.0f;
    public float translateZ = 0.0f;
    private double fix = 0.0;
    private static float maxRotationDegree;
    private static float delayedSwayMultiplier;
    private static Vector3f YDIR;
    public float sOT = 0.0f;
    public float wSpeed = 0.0f;
    public float kickReduction = 0.0f;
    public float recoilReduction = 0.0f;
    public double kick = 0.0;
    public float recoilLift = 0.0f;
    public float newSwayYawAmount = 0.0f;
    public float weaponsHorizontalAngle = 0.0f;
    public float newSwayPitch = 0.0f;
    public float newSwayYaw = 0.0f;
    public float newSwayYawPitch = 0.0f;
    public float newSwayYawYaw = 0.0f;
    private int backwardTicker = 0;
    private float velocity = 0.0f;
    private float acceleration = 0.0f;
    private float stepLength = 0.0f;
    private long prevTime = new Date().getTime();
    private final OneDimensionalPerlinNoise noiseX = new OneDimensionalPerlinNoise(-0.0025f, 0.0025f, 1900L);
    private final OneDimensionalPerlinNoise noiseY = new OneDimensionalPerlinNoise(-0.003f, 0.003f, 1900L);
    private final OneDimensionalPerlinNoise aimed_noiseX;
    private final OneDimensionalPerlinNoise aimed_noiseY;
    private final OneDimensionalPerlinNoise additionNoiseY;
    private final OneDimensionalPerlinNoise noiseRotationY;
    private final OneDimensionalPerlinNoise aimed_noiseRotationY;
    public float aimingHandLayerFov;
    public float originHandLayerFov;
    public float currentHandLayerFov;
    public double displayX;
    public double displayY;
    public double displayZ;
    public double sizeZ;
    public double adjustedTrailZ;

    public static GunRenderingHandler get() {
        if (instance == null) {
            instance = new GunRenderingHandler();
        }
        return instance;
    }

    private GunRenderingHandler() {
        this.noiseY.setReverse(true);
        this.aimed_noiseX = new OneDimensionalPerlinNoise(-7.5E-5f, 7.5E-5f, 1750L);
        this.aimed_noiseY = new OneDimensionalPerlinNoise(-0.00165f, 0.00165f, 1750L);
        this.noiseY.setReverse(true);
        this.additionNoiseY = new OneDimensionalPerlinNoise(-9.5E-4f, 9.5E-4f, 1900L);
        this.noiseRotationY = new OneDimensionalPerlinNoise(-0.675f, 0.675f, 1900L);
        this.aimed_noiseRotationY = new OneDimensionalPerlinNoise(-0.675f, 0.675f, 1900L);
        this.aimingHandLayerFov = 6.41236f;
        this.originHandLayerFov = 70.0f;
        this.currentHandLayerFov = 70.0f;
        this.displayX = 0.0;
        this.displayY = 0.0;
        this.displayZ = 0.0;
        this.sizeZ = 0.0;
        this.adjustedTrailZ = 0.0;
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        this.updateSprinting();
        this.updateMuzzleFlash();
        this.updateShellCasing();
        this.updateOffhandTranslate();
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        if (Minecraft.m_91087_().f_91074_.f_108618_.f_108569_) {
            if (this.backwardTicker < 8) {
                ++this.backwardTicker;
            }
        } else if (this.backwardTicker > 0) {
            --this.backwardTicker;
        }
        if (CommandsHandler.get().getCatCurrentIndex() == 1 && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.flash) {
            if (!(Minecraft.m_91087_().f_91074_.m_21205_().m_41720_() instanceof TimelessGunItem)) {
                return;
            }
            TimelessGunItem gun = (TimelessGunItem)Minecraft.m_91087_().f_91074_.m_21205_().m_41720_();
            Gun modifiedGun = gun.getModifiedGun(Minecraft.m_91087_().f_91074_.m_21205_());
            if (modifiedGun.getDisplay().getFlash() != null || GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.flash) {
                this.showMuzzleFlashForPlayer(Minecraft.m_91087_().f_91074_.m_142049_());
            }
        }
    }

    @SubscribeEvent
    public void onGunFired(GunFireEvent event) {
        if (event.isClient()) {
            this.fireTime = System.currentTimeMillis();
        }
    }

    @SubscribeEvent
    public void onCameraSetup(EntityViewRenderEvent.CameraSetup event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        if (!(mc.f_91074_.m_21205_().m_41720_() instanceof GunItem) || mc.f_91074_.m_21205_().m_41783_() == null) {
            return;
        }
        if ((((Boolean)Config.COMMON.gameplay.forceCameraShakeOnFire.get()).booleanValue() || ((Boolean)Config.CLIENT.display.cameraShakeOnFire.get()).booleanValue()) && IDLNBTUtil.getInt(mc.f_91074_.m_21205_(), "CurrentFireMode") != 0) {
            float cameraShakeDuration = 0.06f;
            long alphaTime = System.currentTimeMillis() - this.fireTime;
            float progress = (float)alphaTime < cameraShakeDuration * 1000.0f ? 1.0f - (float)alphaTime / (cameraShakeDuration * 1000.0f) : 0.0f;
            float alpha = progress * (float)(Math.random() - 0.5 < 0.0 ? -1 : 1) * 0.9f;
            event.setPitch(event.getPitch() - Math.abs(alpha));
            event.setRoll(event.getRoll() + alpha * 0.5f);
        }
    }

    @SubscribeEvent
    public void onFovModifying(EntityViewRenderEvent.FieldOfView event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || !mc.f_91074_.m_6084_() || mc.f_91074_.m_5833_()) {
            return;
        }
        if (!(mc.f_91074_.m_21205_().m_41720_() instanceof GunItem) || mc.f_91074_.m_21205_().m_41783_() == null) {
            return;
        }
        if ((((Boolean)Config.COMMON.gameplay.forceCameraShakeOnFire.get()).booleanValue() || ((Boolean)Config.CLIENT.display.cameraShakeOnFire.get()).booleanValue()) && mc.f_91074_.m_21205_().m_41783_().m_128451_("CurrentFireMode") != 0) {
            float cameraShakeDuration = 0.06f * (AimingHandler.get().isAiming() ? 1.5f : 1.0f);
            long alphaTime = System.currentTimeMillis() - this.fireTime;
            float progress = (float)alphaTime < cameraShakeDuration * 1000.0f ? 1.0f - (float)alphaTime / (cameraShakeDuration * 1000.0f) : 0.0f;
            event.setFOV(event.getFOV() + (double)(progress * 0.5f));
        }
    }

    private void updateSprinting() {
        this.prevSprintTransition = this.sprintTransition;
        Minecraft mc = Minecraft.m_91087_();
        if (!(mc.f_91074_ == null || !mc.f_91074_.m_20142_() || mc.f_91074_.m_6047_() || ((Boolean)SyncedEntityData.instance().get((Entity)mc.f_91074_, ModSyncedDataKeys.SHOOTING)).booleanValue() || ((Boolean)SyncedEntityData.instance().get((Entity)mc.f_91074_, ModSyncedDataKeys.RELOADING)).booleanValue() || AimingHandler.get().isAiming() || this.sprintCooldown != 0)) {
            ItemStack heldItem;
            if (Minecraft.m_91087_().f_91074_ != null && (heldItem = Minecraft.m_91087_().f_91074_.m_21205_()).m_41720_() instanceof GunItem) {
                GunItem modifiedGun = (GunItem)heldItem.m_41720_();
                GunAnimationController controller = GunAnimationController.fromItem(modifiedGun);
                if (this.sprintTransition < 5 && (controller == null || modifiedGun.getGun().getGeneral().getGripType().getHeldAnimation().canApplySprintingAnimation() && !controller.isAnimationRunning())) {
                    ++this.sprintTransition;
                }
                if (controller != null && controller.isAnimationRunning() && this.sprintTransition > 0) {
                    --this.sprintTransition;
                }
            }
        } else if (this.sprintTransition > 0) {
            this.sprintTransition = 0;
        }
        if (this.sprintCooldown > 0) {
            --this.sprintCooldown;
        }
        if (this.sprintTransition == 0) {
            if (this.restingTimer < 5) {
                ++this.restingTimer;
            }
        } else {
            this.restingTimer = 0;
        }
    }

    private void updateMuzzleFlash() {
        this.entityIdForMuzzleFlash.removeAll(this.entityIdForDrawnMuzzleFlash);
        this.entityIdToRandomValue.keySet().removeAll(this.entityIdForDrawnMuzzleFlash);
        this.entityIdForDrawnMuzzleFlash.clear();
        this.entityIdForDrawnMuzzleFlash.addAll(this.entityIdForMuzzleFlash);
    }

    private void updateShellCasing() {
        while (this.shells.peek() != null && this.shells.peek().livingTick <= 0) {
            this.shells.poll();
        }
        for (ShellInAir shell : this.shells) {
            --shell.livingTick;
            shell.velocity.m_122253_(new Vector3f(-0.02f * shell.velocity.m_122239_(), -0.25f, -0.02f * shell.velocity.m_122260_()));
            shell.preDisplacement.setX(shell.displacement.m_122239_());
            shell.preDisplacement.setY(shell.displacement.m_122260_());
            shell.preDisplacement.setZ(shell.displacement.m_122269_());
            shell.preRotation.setX(shell.rotation.m_122239_());
            shell.preRotation.setY(shell.rotation.m_122260_());
            shell.preRotation.setZ(shell.rotation.m_122269_());
            shell.displacement.m_122253_(shell.velocity);
            shell.rotation.m_122253_(shell.angularVelocity);
        }
    }

    private void updateOffhandTranslate() {
        this.prevOffhandTranslate = this.offhandTranslate;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        boolean down = false;
        ItemStack heldItem = mc.f_91074_.m_21205_();
        if (heldItem.m_41720_() instanceof GunItem) {
            Gun modifiedGun = ((GunItem)heldItem.m_41720_()).getModifiedGun(heldItem);
            down = !modifiedGun.getGeneral().getGripType().getHeldAnimation().canRenderOffhandItem();
        }
        float direction = down ? -0.3f : 0.3f;
        this.offhandTranslate = Mth.m_14036_((float)(this.offhandTranslate + direction), (float)0.0f, (float)1.0f);
    }

    @SubscribeEvent
    public void onGunFire(GunFireEvent.Post event) {
        Gun.ShellCasing shellCasing;
        if (!event.isClient()) {
            return;
        }
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        Item item = event.getStack().m_41720_();
        if (item instanceof ITimelessAnimated) {
            ITimelessAnimated animated = (ITimelessAnimated)item;
            animated.playAnimation("fire", event.getStack(), true);
        }
        this.sprintTransition = 0;
        this.speedUpDistanceFrom = Minecraft.m_91087_().f_91074_.f_19787_;
        this.sprintCooldown = 8;
        ItemStack heldItem = event.getStack();
        GunItem gunItem = (GunItem)heldItem.m_41720_();
        Gun modifiedGun = gunItem.getModifiedGun(heldItem);
        if (modifiedGun.getDisplay().getFlash() != null) {
            this.showMuzzleFlashForPlayer(Minecraft.m_91087_().f_91074_.m_142049_());
        }
        if ((shellCasing = modifiedGun.getDisplay().getShellCasing()) != null) {
            float card = 1.0f - this.random.nextFloat() * 2.0f;
            float vard = 1.2f - this.random.nextFloat() * 0.4f;
            this.shells.add(new ShellInAir(new Vector3f((float)shellCasing.getXOffset(), (float)shellCasing.getYOffset(), (float)shellCasing.getZOffset()), new Vector3f(shellCasing.getVelocityX() + shellCasing.getRVelocityX() * card, shellCasing.getVelocityY() + shellCasing.getRVelocityY() * card, shellCasing.getVelocityZ() + shellCasing.getRVelocityZ() * card), new Vector3f(vard * shellCasing.getAVelocityX(), vard * shellCasing.getAVelocityY(), vard * shellCasing.getAVelocityZ()), modifiedGun.getDisplay().getShellCasing().getTickLife()));
        }
    }

    @SubscribeEvent
    public void onGunFirePre(GunFireEvent.Pre event) {
        if (this.sprintTransition == 0) {
            if (this.restingTimer < 5) {
                event.setCanceled(true);
            }
        } else {
            event.setCanceled(true);
        }
    }

    public void showMuzzleFlashForPlayer(int entityId) {
        this.entityIdForMuzzleFlash.add(entityId);
        this.entityIdToRandomValue.put(entityId, Float.valueOf(this.random.nextFloat()));
    }

    @SubscribeEvent
    public void onAnimatedGunReload(GunReloadEvent.Pre event) {
        Item item = event.getStack().m_41720_();
        if (item instanceof ITimelessAnimated) {
            ITimelessAnimated animated = (ITimelessAnimated)item;
            animated.playAnimation("reload", event.getStack(), false);
        }
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderHandEvent event) {
        int blockLight;
        GunAnimationController controller = GunAnimationController.fromItem(event.getItemStack().m_41720_());
        boolean isAnimated = controller != null;
        PoseStack matrixStack = event.getPoseStack();
        boolean right = Minecraft.m_91087_().f_91066_.f_92127_ == HumanoidArm.RIGHT ? event.getHand() == InteractionHand.MAIN_HAND : event.getHand() == InteractionHand.OFF_HAND;
        ItemStack heldItem = event.getItemStack();
        if (!(heldItem.m_41720_() instanceof GunItem)) {
            return;
        }
        event.setCanceled(true);
        ItemStack overrideModel = ItemStack.f_41583_;
        if (heldItem.m_41783_() != null && heldItem.m_41783_().m_128425_("Model", 10)) {
            overrideModel = ItemStack.m_41712_((CompoundTag)heldItem.m_41783_().m_128469_("Model"));
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        GunItem gunItem = (GunItem)heldItem.m_41720_();
        if (mc.f_91066_.f_92080_ && mc.m_91288_() instanceof Player) {
            float crouch;
            Player playerentity = (Player)mc.m_91288_();
            float deltaDistanceWalked = playerentity.f_19787_ - playerentity.f_19867_;
            float distanceWalked = -(playerentity.f_19787_ + deltaDistanceWalked * event.getPartialTicks());
            float cameraYaw = Mth.m_14179_((float)event.getPartialTicks(), (float)playerentity.f_36099_, (float)playerentity.f_36100_);
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(-(Math.abs(Mth.m_14089_((float)(distanceWalked * (float)Math.PI - 0.2f)) * cameraYaw) * 5.0f)));
            matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(-(Mth.m_14031_((float)(distanceWalked * (float)Math.PI)) * cameraYaw * 3.0f)));
            matrixStack.m_85837_((double)(-(Mth.m_14031_((float)(distanceWalked * (float)Math.PI)) * cameraYaw * 0.5f)), (double)(-(-Math.abs(Mth.m_14089_((float)(distanceWalked * (float)Math.PI)) * cameraYaw))), 0.0);
            boolean aimed = false;
            if (AimingHandler.get().isAiming()) {
                aimed = true;
            }
            double invertZoomProgress = aimed ? (Gun.getScope(heldItem) != null ? 0.0575 : 0.0725) : 0.468;
            float f = crouch = mc.f_91074_.m_6047_() ? 148.0f : 1.0f;
            if (playerentity.f_19787_ == playerentity.f_19867_ && !playerentity.m_6144_()) {
                this.startingDistance = playerentity.f_19787_;
            }
            if (!mc.f_91074_.f_108618_.m_108577_()) {
                this.speedUpDistanceFrom = playerentity.f_19787_;
                this.speedUpProgress -= (float)(new Date().getTime() - this.prevTime) / 150.0f;
                if (this.speedUpProgress < 0.0f) {
                    this.speedUpProgress = 0.0f;
                }
            } else {
                this.speedUpProgress = -distanceWalked - this.speedUpDistanceFrom < this.speedUpDistance ? (-distanceWalked - this.speedUpDistanceFrom) / this.speedUpDistance : 1.0f;
            }
            this.walkingDistance1 = distanceWalked += this.startingDistance;
            this.walkingCrouch = crouch;
            this.walkingCameraYaw = cameraYaw;
            this.zoomProgressInv = (float)invertZoomProgress;
            this.applyBobbingTransforms(matrixStack, false);
            this.applyJumpingTransforms(matrixStack, event.getPartialTicks());
            this.applyNoiseMovementTransform(matrixStack);
            matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(Mth.m_14031_((float)(distanceWalked * crouch * (float)Math.PI)) * cameraYaw * 3.0f * (float)invertZoomProgress));
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(Math.abs(Mth.m_14089_((float)(distanceWalked * crouch * (float)Math.PI - 0.2f)) * cameraYaw) * 5.0f * (float)invertZoomProgress));
            float rollingForceCrouch = mc.f_91074_.m_6047_() ? 4.0f : 1.0f;
            float rollingForceAim = AimingHandler.get().isAiming() ? 0.425f : 1.0f;
            float targetAngle = heldItem.m_41720_() instanceof GunItem ? mc.f_91074_.f_108618_.f_108566_ * (6.65f * rollingForceCrouch * rollingForceAim) : 0.0f;
            this.immersiveWeaponRoll = Mth.m_14121_((float)this.immersiveWeaponRoll, (float)targetAngle, (float)0.335f);
            matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(this.immersiveWeaponRoll));
        }
        if (event.getHand() == InteractionHand.OFF_HAND) {
            Gun modifiedGun;
            if (heldItem.m_41720_() instanceof GunItem) {
                event.setCanceled(true);
                return;
            }
            float offhand = 1.0f - Mth.m_14179_((float)event.getPartialTicks(), (float)this.prevOffhandTranslate, (float)this.offhandTranslate);
            matrixStack.m_85837_(0.0, (double)(offhand * -0.6f), 0.0);
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null && player.m_21205_().m_41720_() instanceof GunItem && !(modifiedGun = ((GunItem)player.m_21205_().m_41720_()).getModifiedGun(player.m_21205_())).getGeneral().getGripType().getHeldAnimation().canRenderOffhandItem()) {
                return;
            }
            matrixStack.m_85837_(0.0, -2.0 * AimingHandler.get().getNormalisedAdsProgress(), 0.0);
        }
        LocalPlayer entity = mc.f_91074_;
        BakedModel model = Minecraft.m_91087_().m_91291_().m_174264_(overrideModel.m_41619_() ? heldItem : overrideModel, entity.f_19853_, (LivingEntity)entity, entity == null ? 0 : entity.m_142049_());
        float scaleX = model.m_7442_().f_111790_.f_111757_.m_122239_();
        float scaleY = model.m_7442_().f_111790_.f_111757_.m_122260_();
        float scaleZ = model.m_7442_().f_111790_.f_111757_.m_122269_();
        this.translateX = model.m_7442_().f_111790_.f_111756_.m_122239_();
        this.translateY = model.m_7442_().f_111790_.f_111756_.m_122260_();
        this.translateZ = model.m_7442_().f_111790_.f_111756_.m_122269_();
        matrixStack.m_85836_();
        Gun modifiedGun = gunItem.getModifiedGun(heldItem);
        if (modifiedGun.canAimDownSight() && event.getHand() == InteractionHand.MAIN_HAND) {
            this.xOffset = 0.0;
            this.yOffset = 0.0;
            this.zOffset = 0.0;
            Scope scope = Gun.getScope(heldItem);
            boolean isScopeOffsetType = (Boolean)Config.CLIENT.display.gameplayEnchancedScopeOffset.get();
            boolean isScopeRenderType = (Boolean)Config.CLIENT.display.scopeDoubleRender.get();
            if (modifiedGun.canAttachType(IAttachment.Type.SCOPE) && scope != null) {
                double viewFinderOffset;
                double d = viewFinderOffset = isScopeOffsetType || OptifineHelper.isShadersEnabled() ? scope.getViewFinderOffsetSpecial() : scope.getViewFinderOffset();
                if (scope.getAdditionalZoom().getZoomMultiple() > 1.0f) {
                    viewFinderOffset = isScopeRenderType ? (isScopeOffsetType || OptifineHelper.isShadersEnabled() ? scope.getViewFinderOffsetSpecial() : scope.getViewFinderOffset()) : (isScopeOffsetType || OptifineHelper.isShadersEnabled() ? scope.getViewFinderOffsetSpecialDR() : scope.getViewFinderOffsetDR());
                }
                try {
                    scaledPos = modifiedGun.getModules().getAttachments().getScope();
                    this.xOffset = (double)(-this.translateX) + modifiedGun.getModules().getZoom().getXOffset() * 0.0625 + -scaledPos.getXOffset() * 0.0625 * (double)scaleX;
                    this.yOffset = (double)(-this.translateY) + (8.0 - scaledPos.getYOffset()) * 0.0625 * (double)scaleY - scope.getCenterOffset() * (double)scaleY * 0.0625 * scaledPos.getScale();
                    this.zOffset = (Boolean)Config.CLIENT.display.sight1xRealisticPosition.get() != false && scope.getAdditionalZoom().getZoomMultiple() == 1.0f ? (double)(-this.translateZ) + modifiedGun.getModules().getZoom().getZOffset() * 0.0625 * (double)scaleZ : (double)(-this.translateZ) - scaledPos.getZOffset() * 0.0625 * (double)scaleZ + 0.72 - viewFinderOffset * (double)scaleZ * scaledPos.getScale();
                }
                catch (NullPointerException e) {
                    GunMod.LOGGER.info("GunRenderingHandler NPE @509");
                }
                this.fix = Objects.equals(scope.getTagName(), "qmk152") ? -0.05 : (Objects.equals(scope.getTagName(), "elcan14x") ? -0.06 : (Objects.equals(scope.getTagName(), "acog4x") ? -0.03 : (Objects.equals(scope.getTagName(), "vlpvo6") ? -0.05 : (Objects.equals(scope.getTagName(), "gener8x") ? -0.06 : (Objects.equals(scope.getTagName(), "aimpoint2") || Objects.equals(scope.getTagName(), "eotechn") || Objects.equals(scope.getTagName(), "vortex1") || Objects.equals(scope.getTagName(), "eotechshort") ? -0.02 : 0.0)))));
            } else if (modifiedGun.canAttachType(IAttachment.Type.OLD_SCOPE) && scope != null) {
                double viewFinderOffset;
                double d = viewFinderOffset = isScopeOffsetType || isScopeRenderType ? scope.getViewFinderOffsetSpecial() : scope.getViewFinderOffset();
                if (OptifineHelper.isShadersEnabled()) {
                    viewFinderOffset *= 0.735;
                }
                scaledPos = modifiedGun.getModules().getAttachments().getOldScope();
                this.xOffset = (double)(-this.translateX) + modifiedGun.getModules().getZoom().getXOffset() * 0.0625 + -scaledPos.getXOffset() * 0.0625 * (double)scaleX;
                this.yOffset = (double)(-this.translateY) + (8.0 - scaledPos.getYOffset()) * 0.0625 * (double)scaleY - scope.getCenterOffset() * (double)scaleY * 0.0625 * scaledPos.getScale();
                this.zOffset = (double)(-this.translateZ) - scaledPos.getZOffset() * 0.0625 * (double)scaleZ + 0.72 - viewFinderOffset * (double)scaleZ * scaledPos.getScale();
                this.fix = -0.05;
            } else if (modifiedGun.canAttachType(IAttachment.Type.PISTOL_SCOPE) && scope != null) {
                double viewFinderOffset;
                double d = viewFinderOffset = isScopeOffsetType || isScopeRenderType ? scope.getViewFinderOffsetSpecial() : scope.getViewFinderOffset();
                if (OptifineHelper.isShadersEnabled()) {
                    viewFinderOffset *= 0.735;
                }
                scaledPos = modifiedGun.getModules().getAttachments().getPistolScope();
                this.xOffset = (double)(-this.translateX) + modifiedGun.getModules().getZoom().getXOffset() * 0.0625 + -scaledPos.getXOffset() * 0.0625 * (double)scaleX;
                this.yOffset = (double)(-this.translateY) + (8.0 - scaledPos.getYOffset()) * 0.0625 * (double)scaleY - scope.getCenterOffset() * (double)scaleY * 0.0625 * scaledPos.getScale();
                this.zOffset = (Boolean)Config.CLIENT.display.sight1xRealisticPosition.get() != false && scope.getAdditionalZoom().getZoomMultiple() == 1.0f ? (double)(-this.translateZ) + modifiedGun.getModules().getZoom().getZOffset() * 0.0625 * (double)scaleZ : (double)(-this.translateZ) - scaledPos.getZOffset() * 0.0625 * (double)scaleZ + 0.72 - viewFinderOffset * (double)scaleZ * scaledPos.getScale();
                this.fix = 0.0;
            } else if (modifiedGun.getModules().getZoom() != null) {
                this.xOffset = (double)(-this.translateX) + modifiedGun.getModules().getZoom().getXOffset() * 0.0625 * (double)scaleX;
                this.yOffset = (double)(-this.translateY) + (8.0 - modifiedGun.getModules().getZoom().getYOffset() - 0.2) * 0.0625 * (double)scaleY;
                this.zOffset = (double)(-this.translateZ) + modifiedGun.getModules().getZoom().getZOffset() * 0.0625 * (double)scaleZ;
                this.fix = 0.0;
            }
            float side = right ? 1.0f : -1.0f;
            double transition = (float)AimingHandler.get().getLerpAdsProgress(event.getPartialTicks());
            float result = this.aimingDynamics.update(0.05f, (float)transition);
            matrixStack.m_85837_(this.xOffset * (double)side * (double)result - 0.56 * (double)side * (double)result, this.yOffset * (double)result + 0.52 * (double)result + 0.033 - Math.abs(0.5 - (double)result) * 0.066 + this.fix, this.zOffset * (double)result);
            matrixStack.m_85845_(Vector3f.f_122227_.m_122240_((float)(5.0 * (1.0 - transition))));
            matrixStack.m_85837_(0.0, (0.015 - this.fix) * transition, 0.0);
            if (((Boolean)Config.COMMON.gameplay.realisticAimedBreathing.get()).booleanValue()) {
                double scopeJitterOffset = 0.8;
                scopeJitterOffset = scope == null ? (scopeJitterOffset *= modifiedGun.getModules().getZoom().getStabilityOffset()) : (scopeJitterOffset *= scope.getStabilityOffset());
                if (entity.m_6047_()) {
                    scopeJitterOffset *= 0.3;
                }
                if (entity.m_20142_() && !entity.m_6047_()) {
                    scopeJitterOffset *= 4.0;
                }
                if (entity.m_20184_().m_7096_() != 0.0 || entity.m_20184_().m_7098_() != 0.0 || entity.m_20184_().m_7094_() != 0.0) {
                    scopeJitterOffset *= 6.5;
                }
                double yOffsetRatio = ScopeJitterHandler.getInstance().getYOffsetRatio() * (0.009375000000000001 * scopeJitterOffset);
                double xOffsetRatio = ScopeJitterHandler.getInstance().getXOffsetRatio() * (0.0074375000000000005 * scopeJitterOffset);
                Objects.requireNonNull(Minecraft.m_91087_().f_91074_).m_146926_((float)((double)Objects.requireNonNull(Minecraft.m_91087_().f_91074_).m_146909_() + yOffsetRatio));
                Objects.requireNonNull(Minecraft.m_91087_().f_91074_).m_146926_((float)((double)Objects.requireNonNull(Minecraft.m_91087_().f_91074_).m_146908_() + xOffsetRatio));
            }
        }
        maxRotationDegree = ((Double)Config.CLIENT.display.weaponDelayedSwayMaximum.get()).floatValue();
        delayedSwayMultiplier = ((Double)Config.CLIENT.display.weaponDelayedSwayMultiplier.get()).floatValue();
        YDIR = (Boolean)Config.CLIENT.display.weaponDelayedSwayDirection.get() != false ? Vector3f.f_122224_ : Vector3f.f_122225_;
        this.applyDelayedSwayTransforms(matrixStack, entity, event.getPartialTicks());
        float equipProgress = this.getEquipProgress(event.getPartialTicks());
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(equipProgress * -50.0f));
        HumanoidArm hand = right ? HumanoidArm.RIGHT : HumanoidArm.LEFT;
        Objects.requireNonNull(entity);
        int n = blockLight = entity.m_6060_() ? 14 : entity.f_19853_.m_45517_(LightLayer.BLOCK, new BlockPos(entity.m_20299_(event.getPartialTicks())));
        if (blockLight > 14) {
            blockLight = 14;
        }
        int packedLight = LightTexture.m_109885_((int)blockLight, (int)entity.f_19853_.m_45517_(LightLayer.SKY, new BlockPos(entity.m_20299_(event.getPartialTicks()))));
        int offset = right ? 1 : -1;
        matrixStack.m_85837_(0.56 * (double)offset, -0.52, -0.72);
        this.applySprintingTransforms(heldItem, hand, matrixStack, event.getPartialTicks());
        this.applyRecoilTransforms(matrixStack, heldItem, modifiedGun);
        if (!isAnimated) {
            this.applyReloadTransforms(matrixStack, hand, event.getPartialTicks(), heldItem);
        }
        matrixStack.m_85836_();
        IHeldAnimation pose = modifiedGun.getGeneral().getGripType().getHeldAnimation();
        if (pose != null) {
            if (!isAnimated) {
                matrixStack.m_85837_(-0.56, 0.52, 0.72);
            }
            if (!isAnimated) {
                pose.renderFirstPersonArms(Minecraft.m_91087_().f_91074_, hand, heldItem, matrixStack, event.getMultiBufferSource(), event.getPackedLight(), event.getPartialTicks());
            }
        }
        matrixStack.m_85849_();
        ItemTransforms.TransformType transformType = right ? ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND : ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND;
        this.renderWeapon((LivingEntity)Minecraft.m_91087_().f_91074_, heldItem, transformType, event.getPoseStack(), event.getMultiBufferSource(), packedLight, event.getPartialTicks());
        matrixStack.m_85849_();
    }

    private void applyDelayedSwayTransforms(PoseStack stack, LocalPlayer player, float partialTicks) {
        this.applyDelayedSwayTransforms(stack, player, partialTicks, 1.0f);
    }

    private boolean checkIsLongRangeScope(ItemStack itemStack) {
        ItemStack attachmentStack;
        IAttachment.Type type;
        Gun gun = ((GunItem)itemStack.m_41720_()).getModifiedGun(itemStack);
        if (!gun.canAttachType(type = IAttachment.Type.SCOPE) || !(attachmentStack = Gun.getAttachment(type, itemStack)).m_41619_()) {
            // empty if block
        }
        return false;
    }

    public void applyDelayedSwayTransforms(PoseStack stack, LocalPlayer player, float partialTicks, float percentage) {
        if (((Boolean)Config.CLIENT.display.weaponDelayedSway.get()).booleanValue() && player != null) {
            float f4 = Mth.m_14179_((float)partialTicks, (float)player.f_108587_, (float)player.f_108585_);
            float degree = this.delaySwayDynamics.update(0.0f, (player.m_5675_(partialTicks) - f4) * delayedSwayMultiplier);
            if (Math.abs(degree) > maxRotationDegree) {
                degree = degree / Math.abs(degree) * maxRotationDegree;
            }
            degree = (float)((double)degree * (1.0 / Math.pow(MathUtil.fovToMagnification(this.currentHandLayerFov, this.originHandLayerFov), 2.0)));
            degree *= percentage;
            if (((Boolean)Config.CLIENT.display.weaponDelayedSwayYNOptical.get()).booleanValue() && Gun.getScope(player.m_21205_()) != null || YDIR.equals((Object)Vector3f.f_122224_)) {
                stack.m_85837_((double)this.translateX, (double)this.translateY, (double)this.translateZ);
                stack.m_85845_(YDIR.m_122240_(degree));
                stack.m_85845_(Vector3f.f_122227_.m_122240_(degree * 1.5f * (float)(1.0 - AimingHandler.get().getNormalisedAdsProgress())));
                stack.m_85837_((double)(-this.translateX), (double)(-this.translateY), (double)(-this.translateZ));
            } else {
                stack.m_85837_((double)(-this.translateX), (double)(-this.translateY), (double)(-this.translateZ));
                stack.m_85845_(YDIR.m_122240_(degree));
                stack.m_85845_(Vector3f.f_122227_.m_122240_(degree * 1.5f * (float)(1.0 - AimingHandler.get().getNormalisedAdsProgress())));
                stack.m_85837_((double)this.translateX, (double)this.translateY, (double)this.translateZ);
            }
        }
    }

    private void applySprintingTransforms(ItemStack gun, HumanoidArm hand, PoseStack matrixStack, float partialTicks) {
        TimelessGunItem modifiedGun = (TimelessGunItem)gun.m_41720_();
        GunAnimationController controller = GunAnimationController.fromItem(gun.m_41720_());
        float draw = controller == null || !controller.isAnimationRunning(GunAnimationController.AnimationLabel.DRAW) ? 1 : 0;
        float leftHanded = hand == HumanoidArm.LEFT ? -1.0f : 1.0f;
        this.sOT = ((float)this.prevSprintTransition + (float)(this.sprintTransition - this.prevSprintTransition) * partialTicks) / 5.0f;
        this.wSpeed = ServerPlayHandler.calceldGunWeightSpeed(modifiedGun.getGun(), gun);
        if (this.wSpeed > 0.094f) {
            float result = this.sprintDynamicsHSS.update(0.05f, this.sOT) * draw;
            float result2 = this.sprintDynamicsZHSS.update(0.05f, this.sOT) * draw;
            matrixStack.m_85837_(0.215 * (double)leftHanded * (double)result, (double)(0.07f * result), (double)(-30.0f * leftHanded * result / 170.0f));
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(60.0f * result2));
            matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(-25.0f * result2));
        } else {
            float result = this.sprintDynamics.update(0.05f, this.sOT) * draw;
            float result2 = this.sprintDynamicsZ.update(0.05f, this.sOT) * draw;
            matrixStack.m_85837_(-0.25 * (double)leftHanded * (double)result, -0.1 * (double)result - 0.1 + Math.abs(0.5 - (double)result) * 0.2, 0.0);
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(28.0f * leftHanded * result));
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(15.0f * result2));
            matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(20.0f * result2));
        }
    }

    private void applyReloadTransforms(PoseStack matrixStack, HumanoidArm hand, float partialTicks, ItemStack modifiedGun) {
        float reloadProgress = ReloadHandler.get().getReloadProgress(partialTicks, modifiedGun);
        if (reloadProgress > 0.0f) {
            float leftHanded = hand == HumanoidArm.LEFT ? -1.0f : 1.0f;
            matrixStack.m_85837_(-0.25 * (double)leftHanded, -0.1, 0.0);
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(45.0f * leftHanded));
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(-25.0f));
        }
    }

    private void applyRecoilTransforms(PoseStack matrixStack, ItemStack item, Gun gun) {
        Minecraft mc = Minecraft.m_91087_();
        double kickReduce = 1.0;
        double recoilNormal = RecoilHandler.get().getGunRecoilNormal();
        if (Gun.hasAttachmentEquipped(item, gun, IAttachment.Type.SCOPE) || Gun.hasAttachmentEquipped(item, gun, IAttachment.Type.PISTOL_SCOPE) || Gun.hasAttachmentEquipped(item, gun, IAttachment.Type.OLD_SCOPE)) {
            recoilNormal -= recoilNormal * (0.25 * AimingHandler.get().getNormalisedAdsProgress());
            kickReduce = gun.getModules().getZoom().getFovModifier();
            if (kickReduce > 1.0) {
                kickReduce = 1.0;
            }
            if (kickReduce < 0.0) {
                kickReduce = 0.0;
            }
        }
        this.kickReduction = 1.0f - GunModifierHelper.getKickReduction(item);
        this.recoilReduction = 1.0f - GunModifierHelper.getRecoilModifier(item);
        this.kick = (double)gun.getGeneral().getRecoilKick() * 0.0625 * recoilNormal * RecoilHandler.get().getAdsRecoilReduction(gun);
        this.recoilLift = (float)((double)((float)(RecoilHandler.get().getGunRecoilAngle() * recoilNormal) * (float)RecoilHandler.get().getAdsRecoilReduction(gun)) * kickReduce);
        this.newSwayYawAmount = (float)(2.0 + 1.0 * (1.0 - AimingHandler.get().getNormalisedAdsProgress()));
        this.newSwayYawPitch = (float)((double)(RecoilHandler.get().lastRandPitch * this.newSwayYawAmount - this.newSwayYawAmount / 2.0f) * recoilNormal) / 2.0f;
        this.newSwayYawYaw = (float)((double)(RecoilHandler.get().lastRandYaw * this.newSwayYawAmount - this.newSwayYawAmount / 2.0f) * recoilNormal) / 2.0f;
        float kickTiming = 0.11f;
        if (IDLNBTUtil.getInt(item, "CurrentFireMode") == 1) {
            this.newSwayYawAmount = (float)((double)this.newSwayYawAmount * 0.5);
            this.recoilLift = (float)((double)this.recoilLift * 0.925);
            kickTiming += 0.06f;
        }
        if (mc.f_91074_ != null && mc.f_91074_.m_6047_()) {
            this.recoilLift = (float)((double)this.recoilLift * 0.875);
        }
        this.weaponsHorizontalAngle = (float)(RecoilHandler.get().getGunHorizontalRecoilAngle() * recoilNormal) * (float)RecoilHandler.get().getAdsRecoilReduction(gun) * 1.25f;
        float newKick = this.recoilDynamics.update(kickTiming, (float)this.kick * this.kickReduction);
        double magnification = MathUtil.fovToMagnification(this.currentHandLayerFov, this.originHandLayerFov);
        newKick = (float)((double)newKick * (1.0 / Math.pow(magnification, 0.3)));
        matrixStack.m_85837_(0.0, 0.0, (double)newKick);
        matrixStack.m_85837_(0.0, 0.05 * (double)newKick, 0.35 * (double)newKick);
        this.newSwayYaw = this.swayYawDynamics.update(0.12f, this.newSwayYawYaw * this.recoilReduction * this.weaponsHorizontalAngle);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(this.newSwayPitch * 0.2875f));
        this.newSwayPitch = this.swayPitchDynamics.update(0.21f, this.newSwayYawPitch * this.recoilReduction * this.recoilLift);
        matrixStack.m_85845_(Vector3f.f_122226_.m_122240_(this.newSwayPitch * 0.215f));
        if (gun.getGeneral().getWeaponRecoilOffset() != 0.0f) {
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(this.recoilLift * this.recoilReduction));
        }
        matrixStack.m_85837_(0.0, -0.05 * (double)newKick, -0.35 * (double)newKick);
    }

    public void applyBobbingTransforms(PoseStack matrixStack, boolean convert) {
        matrixStack.m_85837_(0.0, 0.0, 0.25);
        float amplifier = this.bobbingDynamics.update(0.05f, (float)((double)((float)this.sprintTransition / 2.0f + 1.0f) * (1.0 - AimingHandler.get().getNormalisedAdsProgress() * 0.75)));
        float speedUp = this.speedUpDynamics.update(0.05f, this.speedUpProgress * (1.0f - this.sOT) * (float)(1.0 - AimingHandler.get().getNormalisedAdsProgress()));
        float delta = -Mth.m_14031_((float)(this.walkingDistance1 * (float)Math.PI)) * this.walkingCameraYaw * 0.5f * (convert ? -0.5f : 1.0f) * amplifier * (float)(8 - this.backwardTicker) / 8.0f;
        float delta2 = -Mth.m_14031_((float)(this.walkingDistance1 * (float)Math.PI * 2.0f)) * this.walkingCameraYaw * 0.5f * (convert ? -0.35f : 1.0f) * amplifier * (float)(12 - this.backwardTicker) / 12.0f;
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(35.0f * delta * (float)(1.0 - AimingHandler.get().getNormalisedAdsProgress())));
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(-3.0f * speedUp));
        matrixStack.m_85837_(0.0, 0.0, -0.25 + 0.07 * (double)speedUp);
        matrixStack.m_85837_(0.45 * (double)delta, 0.25 * (double)delta2, 0.0);
        if (this.wSpeed > 0.094f) {
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(delta * 5.0f * (float)this.sprintTransition));
        } else {
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(delta * 5.0f));
        }
    }

    public void applyBobbingTransforms(PoseStack matrixStack, boolean convert, float effectMultiplier) {
        if (effectMultiplier == 0.0f) {
            effectMultiplier = 1.0f;
        }
        matrixStack.m_85837_(0.0, 0.0, 0.25);
        float amplifier = this.bobbingDynamics.update(0.05f, (float)((double)((float)this.sprintTransition / 2.0f + 1.0f) * (1.0 - AimingHandler.get().getNormalisedAdsProgress() * 0.75) * (double)(RecoilHandler.get().getRecoilProgress() == 0.0 ? 1 : 0)));
        float speedUp = this.speedUpDynamics.update(0.05f, this.speedUpProgress * (1.0f - this.sOT) * (float)(1.0 - AimingHandler.get().getNormalisedAdsProgress()));
        float delta = -Mth.m_14031_((float)(this.walkingDistance1 * (float)Math.PI)) * this.walkingCameraYaw * 0.5f * (convert ? -0.5f : 1.0f) * amplifier * (float)(8 - this.backwardTicker) / 8.0f;
        float delta2 = -Mth.m_14031_((float)(this.walkingDistance1 * (float)Math.PI * 2.0f)) * this.walkingCameraYaw * 0.5f * (convert ? -0.35f : 1.0f) * amplifier * (float)(12 - this.backwardTicker) / 12.0f;
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(35.0f * effectMultiplier * delta * (float)(1.0 - AimingHandler.get().getNormalisedAdsProgress())));
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(-3.0f * effectMultiplier * speedUp));
        matrixStack.m_85837_(0.0, 0.0, -0.25 + 0.07 * (double)effectMultiplier * (double)speedUp);
        matrixStack.m_85837_(0.45 * (double)effectMultiplier * (double)delta, 0.25 * (double)effectMultiplier * (double)delta2, 0.0);
        if (this.wSpeed > 0.094f) {
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(delta * effectMultiplier * 5.0f * (float)this.sprintTransition));
        } else {
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(delta * effectMultiplier * 5.0f));
        }
    }

    public void applyJumpingTransforms(PoseStack matrixStack, float partialTicks) {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        double posY = Mth.m_14139_((double)partialTicks, (double)Minecraft.m_91087_().f_91074_.f_19791_, (double)Minecraft.m_91087_().f_91074_.m_20186_());
        float newVelocity = (float)(posY - Minecraft.m_91087_().f_91074_.f_19791_) / partialTicks;
        float newAcceleration = newVelocity - this.velocity;
        Date date = new Date();
        if (Math.abs(this.acceleration) < Math.abs(newAcceleration) && (double)Math.abs(newAcceleration) > 0.05) {
            this.acceleration = newAcceleration;
            this.stepLength = this.acceleration / 250.0f;
        }
        long partialTime = date.getTime() - this.prevTime;
        if (this.acceleration > 0.0f) {
            this.acceleration -= (float)partialTime * this.stepLength;
            if (this.acceleration < 0.0f) {
                this.acceleration = 0.0f;
            }
        }
        if (this.acceleration < 0.0f) {
            this.acceleration -= (float)partialTime * this.stepLength;
            if (this.acceleration > 0.0f) {
                this.acceleration = 0.0f;
            }
        }
        float maxMotion = 0.265f;
        float transition = -this.jumpingDynamics.update(0.05f, (Math.abs(this.acceleration) < maxMotion ? this.acceleration / maxMotion * 0.15f : Math.abs(this.acceleration) / this.acceleration * 0.15f) * ((float)this.sprintTransition / 3.0f + 1.0f) * (1.0f - 0.7f * (float)AimingHandler.get().getNormalisedAdsProgress()));
        if (transition > 0.0f) {
            transition *= 0.8f;
        }
        matrixStack.m_85837_(0.0, (double)transition, 0.0);
        this.velocity = newVelocity;
        this.prevTime = date.getTime();
    }

    public void applyJumpingTransforms(PoseStack matrixStack, float partialTicks, float reverser) {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        double posY = Mth.m_14139_((double)partialTicks, (double)Minecraft.m_91087_().f_91074_.f_19791_, (double)Minecraft.m_91087_().f_91074_.m_20186_());
        float newVelocity = (float)(posY - Minecraft.m_91087_().f_91074_.f_19791_) / partialTicks;
        float newAcceleration = newVelocity - this.velocity;
        Date date = new Date();
        if (Math.abs(this.acceleration) < Math.abs(newAcceleration) && (double)Math.abs(newAcceleration) > 0.05) {
            this.acceleration = newAcceleration;
            this.stepLength = this.acceleration / 250.0f;
        }
        long partialTime = date.getTime() - this.prevTime;
        if (this.acceleration > 0.0f) {
            this.acceleration -= (float)partialTime * this.stepLength;
            if (this.acceleration < 0.0f) {
                this.acceleration = 0.0f;
            }
        }
        if (this.acceleration < 0.0f) {
            this.acceleration -= (float)partialTime * this.stepLength;
            if (this.acceleration > 0.0f) {
                this.acceleration = 0.0f;
            }
        }
        float maxMotion = 0.265f;
        float transition = -this.jumpingDynamics.update(0.05f, (Math.abs(this.acceleration) < maxMotion ? this.acceleration / maxMotion * 0.15f : Math.abs(this.acceleration) / this.acceleration * 0.15f) * ((float)this.sprintTransition / 3.0f + 1.0f) * (1.0f - 0.7f * (float)AimingHandler.get().getNormalisedAdsProgress()));
        if (transition > 0.0f) {
            transition *= 0.8f;
        }
        if (reverser != 0.0f) {
            transition *= reverser;
        }
        matrixStack.m_85837_(0.0, (double)transition, 0.0);
        this.velocity = newVelocity;
        this.prevTime = date.getTime();
    }

    public void applyNoiseMovementTransform(PoseStack matrixStack) {
        if (AimingHandler.get().getNormalisedAdsProgress() == 1.0) {
            matrixStack.m_85837_((double)(this.aimed_noiseX.getValue() / 2.0f), (double)(this.aimed_noiseY.getValue() + this.additionNoiseY.getValue()), 0.0);
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(this.aimed_noiseRotationY.getValue() * 0.405f));
            matrixStack.m_85845_(Vector3f.f_122227_.m_122240_((float)((double)this.aimed_noiseRotationY.getValue() * 0.925)));
        } else {
            matrixStack.m_85837_((double)this.noiseX.getValue(), (double)(this.noiseY.getValue() + this.additionNoiseY.getValue()), 0.0);
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(this.noiseRotationY.getValue()));
        }
    }

    public void applyNoiseMovementTransform(PoseStack matrixStack, float reverser) {
        if (AimingHandler.get().getNormalisedAdsProgress() == 1.0) {
            matrixStack.m_85837_((double)(this.aimed_noiseX.getValue() * (reverser * 2.0f)), (double)((this.aimed_noiseY.getValue() + this.additionNoiseY.getValue()) * reverser), 0.0);
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(this.aimed_noiseRotationY.getValue() * reverser));
            matrixStack.m_85845_(Vector3f.f_122227_.m_122240_((float)((double)this.aimed_noiseRotationY.getValue() * 0.85 * (double)reverser)));
        } else {
            matrixStack.m_85837_((double)(this.noiseX.getValue() * -reverser), (double)((this.noiseY.getValue() + this.additionNoiseY.getValue()) * reverser), 0.0);
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(this.noiseRotationY.getValue() * reverser));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onKnockback(LivingKnockBackEvent event) {
        if (event.getEntityLiving() instanceof Player) {
            Player player = (Player)event.getEntityLiving();
            if (player.f_19853_.f_46443_) {
                return;
            }
            if (!(player.m_21205_().m_41720_() instanceof GunItem) && !((Boolean)Config.CLIENT.display.cameraShakeOptionGlobal.get()).booleanValue()) {
                return;
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (serverPlayer.f_8906_ == null) {
                    return;
                }
                if (serverPlayer.f_8906_.m_6198_() == null) {
                    return;
                }
                PacketHandler.getPlayChannel().sendTo((Object)new MessagePlayerShake((LivingEntity)player), serverPlayer.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
            }
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.RenderTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.START)) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (!mc.m_91302_()) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        if (Minecraft.m_91087_().f_91066_.m_92176_() != CameraType.FIRST_PERSON) {
            return;
        }
        ItemStack heldItem = player.m_21120_(InteractionHand.MAIN_HAND);
        if (heldItem.m_41619_()) {
            return;
        }
        if (player.m_6117_() && player.m_7655_() == InteractionHand.MAIN_HAND && heldItem.m_41720_() instanceof GrenadeItem) {
            float cookTime;
            if (!((GrenadeItem)heldItem.m_41720_()).canCook()) {
                return;
            }
            int duration = player.m_21252_();
            if (duration >= 10 && (cookTime = 1.0f - (float)(duration - 10) / (float)(player.m_21211_().m_41779_() - 10)) > 0.0f) {
                double scale = 3.0;
                Window window = mc.m_91268_();
                int i = (int)((double)(window.m_85446_() / 2 - 7 - 60) / scale);
                int j = (int)Math.ceil(((double)(window.m_85445_() / 2) - 8.0 * scale) / scale);
                RenderSystem.m_69478_();
                RenderSystem.m_69453_();
                RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
                PoseStack stack = RenderSystem.m_157191_();
                stack.m_85836_();
                stack.m_85841_((float)scale, (float)scale, (float)scale);
                RenderSystem.m_157182_();
                int progress = (int)Math.ceil(cookTime * 17.0f) - 1;
                PoseStack matrixStack = new PoseStack();
                Screen.m_93133_((PoseStack)matrixStack, (int)j, (int)i, (float)36.0f, (float)94.0f, (int)16, (int)4, (int)256, (int)256);
                Screen.m_93133_((PoseStack)matrixStack, (int)j, (int)i, (float)52.0f, (float)94.0f, (int)progress, (int)4, (int)256, (int)256);
                stack.m_85849_();
                RenderSystem.m_157182_();
                RenderSystem.m_69461_();
            }
            return;
        }
    }

    @SubscribeEvent
    public void onRenderHeldItem(RenderItemEvent.Held.Pre event) {
        InteractionHand hand = Minecraft.m_91087_().f_91066_.f_92127_ == HumanoidArm.RIGHT ? (event.getHandSide() == HumanoidArm.RIGHT ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND) : (event.getHandSide() == HumanoidArm.LEFT ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
        LivingEntity entity = event.getEntity();
        ItemStack heldItem = entity.m_21120_(hand);
        if (hand == InteractionHand.OFF_HAND) {
            Gun modifiedGun;
            if (heldItem.m_41720_() instanceof GunItem) {
                event.setCanceled(true);
                return;
            }
            if (entity.m_21205_().m_41720_() instanceof GunItem && !(modifiedGun = ((GunItem)entity.m_21205_().m_41720_()).getModifiedGun(entity.m_21205_())).getGeneral().getGripType().getHeldAnimation().canRenderOffhandItem()) {
                event.setCanceled(true);
                return;
            }
        }
        if (heldItem.m_41720_() instanceof GunItem) {
            CompoundTag compound;
            event.setCanceled(true);
            if (heldItem.m_41783_() != null && (compound = heldItem.m_41783_()).m_128425_("Scale", 5)) {
                float scale = compound.m_128457_("Scale");
                event.getPoseStack().m_85841_(scale, scale, scale);
            }
            Gun gun = ((GunItem)heldItem.m_41720_()).getModifiedGun(heldItem);
            if (entity instanceof Player) {
                gun.getGeneral().getGripType().getHeldAnimation().applyHeldItemTransforms((Player)entity, hand, AimingHandler.get().getAimProgress((Player)entity, event.getPartialTicks()), event.getPoseStack(), event.getBufferSource());
            }
            this.renderWeapon(entity, heldItem, event.getTransformType(), event.getPoseStack(), event.getBufferSource(), event.getLight(), event.getPartialTicks());
        }
    }

    @SubscribeEvent
    public void onSetupAngles(PlayerModelEvent.SetupAngles.Post event) {
        if (event.getAgeInTicks() == 0.0f) {
            event.getModelPlayer().f_102811_.f_104203_ = 0.0f;
            event.getModelPlayer().f_102811_.f_104204_ = 0.0f;
            event.getModelPlayer().f_102811_.f_104205_ = 0.0f;
            event.getModelPlayer().f_102812_.f_104203_ = 0.0f;
            event.getModelPlayer().f_102812_.f_104204_ = 0.0f;
            event.getModelPlayer().f_102812_.f_104205_ = 0.0f;
            return;
        }
        Player player = event.getPlayer();
        ItemStack heldItem = player.m_21205_();
        if (!heldItem.m_41619_() && heldItem.m_41720_() instanceof GunItem) {
            PlayerModel model = event.getModelPlayer();
            Gun gun = ((GunItem)heldItem.m_41720_()).getModifiedGun(heldItem);
            gun.getGeneral().getGripType().getHeldAnimation().applyPlayerModelRotation(player, model, InteractionHand.MAIN_HAND, AimingHandler.get().getAimProgress((Player)event.getEntity(), Minecraft.m_91087_().m_91296_()));
            GunRenderingHandler.copyModelAngles(model.f_102811_, model.f_103375_);
            GunRenderingHandler.copyModelAngles(model.f_102812_, model.f_103374_);
        }
    }

    private static void copyModelAngles(ModelPart source, ModelPart dest) {
        dest.f_104203_ = source.f_104203_;
        dest.f_104204_ = source.f_104204_;
        dest.f_104205_ = source.f_104205_;
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Pre event) {
        Player player = event.getPlayer();
        ItemStack heldItem = player.m_21205_();
        if (!heldItem.m_41619_() && heldItem.m_41720_() instanceof GunItem) {
            Gun gun = ((GunItem)heldItem.m_41720_()).getModifiedGun(heldItem);
            gun.getGeneral().getGripType().getHeldAnimation().applyPlayerPreRender(player, InteractionHand.MAIN_HAND, AimingHandler.get().getAimProgress((Player)event.getEntity(), event.getPartialTick()), event.getPoseStack(), event.getMultiBufferSource());
        }
    }

    @SubscribeEvent
    public void onModelRender(PlayerModelEvent.Render.Pre event) {
        Player player = event.getPlayer();
        ItemStack offHandStack = player.m_21206_();
        if (offHandStack.m_41720_() instanceof GunItem) {
            switch (player.m_5737_().m_20828_()) {
                case LEFT: {
                    event.getModelPlayer().f_102815_ = HumanoidModel.ArmPose.EMPTY;
                    break;
                }
                case RIGHT: {
                    event.getModelPlayer().f_102816_ = HumanoidModel.ArmPose.EMPTY;
                }
            }
        }
    }

    @SubscribeEvent
    public void onRenderPlayer(PlayerModelEvent.Render.Post event) {
        PoseStack matrixStack = event.getPoseStack();
        Player player = event.getPlayer();
        ItemStack heldItem = player.m_21206_();
        if (Minecraft.m_91087_().f_91066_.m_92176_().m_90612_()) {
            return;
        }
        if (!heldItem.m_41619_() && heldItem.m_41720_() instanceof GunItem) {
            matrixStack.m_85836_();
            Gun gun = ((GunItem)heldItem.m_41720_()).getModifiedGun(heldItem);
            if (gun.getGeneral().getGripType().getHeldAnimation().applyOffhandTransforms(player, event.getModelPlayer(), heldItem, matrixStack, event.getDeltaTicks())) {
                MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
                this.renderWeapon((LivingEntity)player, heldItem, ItemTransforms.TransformType.FIXED, matrixStack, (MultiBufferSource)buffer, event.getLight(), event.getDeltaTicks());
            }
            matrixStack.m_85849_();
        }
    }

    @SubscribeEvent
    public void onRenderEntityItem(RenderItemEvent.Entity.Pre event) {
        Minecraft mc = Minecraft.m_91087_();
        if (!event.getTransformType().equals((Object)ItemTransforms.TransformType.GUI)) {
            event.setCanceled(this.renderWeapon((LivingEntity)mc.f_91074_, event.getItem(), event.getTransformType(), event.getPoseStack(), event.getBufferSource(), event.getLight(), event.getPartialTicks()));
        }
    }

    @SubscribeEvent
    public void onRenderEntityItem(RenderItemEvent.Gui.Pre event) {
        if (!((Boolean)Config.CLIENT.quality.reducedQualityHotBar.get()).booleanValue()) {
            Minecraft mc = Minecraft.m_91087_();
            event.setCanceled(this.renderWeapon((LivingEntity)mc.f_91074_, event.getItem(), event.getTransformType(), event.getPoseStack(), event.getBufferSource(), event.getLight(), event.getPartialTicks()));
        }
    }

    @SubscribeEvent
    public void onRenderItemFrame(RenderItemEvent.ItemFrame.Pre event) {
        Minecraft mc = Minecraft.m_91087_();
        event.setCanceled(this.renderWeapon((LivingEntity)mc.f_91074_, event.getItem(), event.getTransformType(), event.getPoseStack(), event.getBufferSource(), event.getLight(), event.getPartialTicks()));
    }

    public boolean renderWeapon(LivingEntity entity, ItemStack stack, ItemTransforms.TransformType transformType, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int light, float partialTicks) {
        if (stack.m_41720_() instanceof GunItem) {
            Gun.ScaledPositioned positioned;
            ItemStack attachmentStack;
            Scope scope;
            IAttachment.Type type;
            Gun gun;
            matrixStack.m_85836_();
            ItemStack model = ItemStack.f_41583_;
            if (stack.m_41783_() != null && stack.m_41783_().m_128425_("Model", 10)) {
                model = ItemStack.m_41712_((CompoundTag)stack.m_41783_().m_128469_("Model"));
            }
            RenderUtil.applyTransformType(model.m_41619_() ? stack : model, matrixStack, transformType, entity);
            if (ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND.equals((Object)transformType) && (gun = ((GunItem)stack.m_41720_()).getModifiedGun(stack)).canAttachType(type = IAttachment.Type.SCOPE) && (scope = Gun.getScope(stack)) != null && !(attachmentStack = Gun.getAttachment(type, stack)).m_41619_() && (positioned = gun.getAttachmentPosition(type)) != null) {
                double transition = AimingHandler.get().getLerpAdsProgress(partialTicks);
                double displayX = positioned.getXOffset() * 0.0625;
                double displayY = positioned.getYOffset() * 0.0625;
                double displayZ = positioned.getZOffset() * 0.0625;
                this.currentHandLayerFov = Mth.m_14179_((float)((float)transition), (float)this.originHandLayerFov, (float)(scope.isNeedSqueeze() ? this.aimingHandLayerFov : 55.0f));
                float zScale = (float)Math.tan((double)(this.currentHandLayerFov / 180.0f) * Math.PI / 2.0) / (float)Math.tan((double)(this.originHandLayerFov / 180.0f) * Math.PI / 2.0);
                matrixStack.m_85837_(displayX, displayY, displayZ);
                matrixStack.m_85837_(0.0, -0.5, 0.0);
                matrixStack.m_85841_(1.0f, 1.0f, zScale);
                matrixStack.m_85837_(0.0, 0.5, 0.0);
                matrixStack.m_85837_(-displayX, -displayY, -displayZ);
                matrixStack.m_85837_(0.0, 0.0, (double)((float)transition * scope.getAdditionalZoom().getZoomZTransition()) * 0.0625 / (double)zScale);
            }
            this.renderGun(entity, transformType, model.m_41619_() ? stack : model, matrixStack, renderTypeBuffer, light, partialTicks);
            this.renderAttachments(entity, transformType, stack, matrixStack, renderTypeBuffer, light, partialTicks);
            this.renderMuzzleFlash(entity, matrixStack, renderTypeBuffer, stack, transformType);
            this.renderShellCasing(entity, matrixStack, stack, transformType, renderTypeBuffer, light, partialTicks);
            matrixStack.m_85849_();
            return true;
        }
        return false;
    }

    public boolean renderScope(LivingEntity entity, ItemStack stack, ItemTransforms.TransformType transformType, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int light, float partialTicks) {
        if (stack.m_41720_() instanceof ScopeItem || stack.m_41720_() instanceof PistolScopeItem || stack.m_41720_() instanceof OldScopeItem) {
            matrixStack.m_85836_();
            ItemStack model = ItemStack.f_41583_;
            RenderUtil.applyTransformType(model.m_41619_() ? stack : model, matrixStack, transformType, entity);
            this.renderGun(entity, transformType, model.m_41619_() ? stack : model, matrixStack, renderTypeBuffer, light, partialTicks);
            matrixStack.m_85849_();
            return true;
        }
        return false;
    }

    private void renderGun(LivingEntity entity, ItemTransforms.TransformType transformType, ItemStack stack, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int light, float partialTicks) {
        if (stack.m_41720_() instanceof ITimelessAnimated) {
            RenderUtil.renderModel(stack, matrixStack, renderTypeBuffer, light, OverlayTexture.f_118083_, entity);
        }
        if (OverrideModelManager.hasModel(stack)) {
            IOverrideModel model = OverrideModelManager.getModel(stack);
            if (model != null) {
                if (OverrideModelManager.hasModel(stack) && transformType.equals((Object)ItemTransforms.TransformType.GUI) && !((Boolean)Config.CLIENT.quality.reducedQualityHotBar.get()).booleanValue()) {
                    matrixStack.m_85836_();
                    matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(25.0f));
                    matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(-145.0f));
                    matrixStack.m_85841_(0.55f, 0.55f, 0.55f);
                }
                model.render(partialTicks, transformType, stack, ItemStack.f_41583_, entity, matrixStack, renderTypeBuffer, light, OverlayTexture.f_118083_);
            }
        } else {
            RenderUtil.renderModel(stack, matrixStack, renderTypeBuffer, light, OverlayTexture.f_118083_, entity);
        }
        if (OverrideModelManager.hasModel(stack) && transformType.equals((Object)ItemTransforms.TransformType.GUI) && !((Boolean)Config.CLIENT.quality.reducedQualityHotBar.get()).booleanValue()) {
            matrixStack.m_85849_();
        }
    }

    private void renderAttachments(LivingEntity entity, ItemTransforms.TransformType transformType, ItemStack stack, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int light, float partialTicks) {
        if (stack.m_41720_() instanceof GunItem) {
            Gun gun = ((GunItem)stack.m_41720_()).getModifiedGun(stack);
            CompoundTag gunTag = stack.m_41784_();
            CompoundTag attachments = gunTag.m_128469_("Attachments");
            for (String tagKey : attachments.m_128431_()) {
                Gun.ScaledPositioned positioned;
                ItemStack attachmentStack;
                IAttachment.Type type = IAttachment.Type.byTagKey(tagKey);
                if (!gun.canAttachType(type) || (attachmentStack = Gun.getAttachment(type, stack)).m_41619_() || (positioned = gun.getAttachmentPosition(type)) == null) continue;
                double displayX = positioned.getXOffset() * 0.0625;
                double displayY = positioned.getYOffset() * 0.0625;
                double displayZ = positioned.getZOffset() * 0.0625;
                matrixStack.m_85836_();
                GunAnimationController controller = GunAnimationController.fromItem(stack.m_41720_());
                if (controller != null) {
                    if (type != null) {
                        if (controller instanceof PistalAnimationController && gun.getModules().getAttachments().getPistolScope() != null && gun.getModules().getAttachments().getPistolScope().getDoOnSlideMovement()) {
                            PistalAnimationController pcontroller = (PistalAnimationController)controller;
                            controller.applyTransform(stack, pcontroller.getSlideNodeIndex(), transformType, entity, matrixStack);
                        } else {
                            controller.applyAttachmentsTransform(stack, transformType, entity, matrixStack);
                        }
                    } else {
                        controller.applyAttachmentsTransform(stack, transformType, entity, matrixStack);
                    }
                }
                matrixStack.m_85837_(displayX, displayY, displayZ);
                matrixStack.m_85837_(0.0, -0.5, 0.0);
                matrixStack.m_85841_((float)positioned.getScale(), (float)positioned.getScale(), (float)positioned.getScale());
                IOverrideModel model = OverrideModelManager.getModel(attachmentStack);
                if (model != null) {
                    model.render(partialTicks, transformType, attachmentStack, stack, entity, matrixStack, renderTypeBuffer, light, OverlayTexture.f_118083_);
                } else {
                    RenderUtil.renderModel(attachmentStack, stack, matrixStack, renderTypeBuffer, light, OverlayTexture.f_118083_);
                }
                matrixStack.m_85849_();
            }
        }
    }

    private void renderMuzzleFlash(LivingEntity entity, PoseStack matrixStack, MultiBufferSource buffer, ItemStack weapon, ItemTransforms.TransformType transformType) {
        Gun modifiedGun = ((GunItem)weapon.m_41720_()).getModifiedGun(weapon);
        if (modifiedGun.getDisplay().getFlash() == null) {
            return;
        }
        if ((transformType == ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || transformType == ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND || transformType == ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND || transformType == ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND) && this.entityIdForMuzzleFlash.contains(entity.m_142049_())) {
            float randomValue;
            this.drawMuzzleFlash(weapon, modifiedGun, randomValue, (randomValue = this.entityIdToRandomValue.get(entity.m_142049_()).floatValue()) >= 0.5f, matrixStack, buffer);
        }
    }

    private void drawMuzzleFlash(ItemStack weapon, Gun modifiedGun, float random, boolean flip, PoseStack matrixStack, MultiBufferSource buffer) {
        matrixStack.m_85836_();
        Gun.Display.Flash muzzleFlash = modifiedGun.getDisplay().getFlash();
        if (muzzleFlash == null) {
            return;
        }
        double displayX = ((Gun.Positioned)muzzleFlash).getXOffset() * 0.0625;
        double displayY = ((Gun.Positioned)muzzleFlash).getYOffset() * 0.0625;
        double displayZ = (((Gun.Positioned)muzzleFlash).getZOffset() + (double)this.muzzleExtraOnEnch) * 0.0625;
        if (GunRenderingHandler.get().muzzleExtraOnEnch != 0.0f) {
            this.muzzleExtraOnEnch = 0.0f;
        }
        matrixStack.m_85837_(displayX, displayY, displayZ);
        matrixStack.m_85837_(0.0, -0.5, 0.0);
        ItemStack barrelStack = Gun.getAttachment(IAttachment.Type.BARREL, weapon);
        if (!barrelStack.m_41619_() && barrelStack.m_41720_() instanceof IBarrel) {
            Barrel barrel = (Barrel)((IBarrel)barrelStack.m_41720_()).getProperties();
            Gun.ScaledPositioned positioned = modifiedGun.getModules().getAttachments().getBarrel();
            if (positioned != null) {
                matrixStack.m_85837_(0.0, 0.0, (double)(-barrel.getLength()) * 0.0625 * positioned.getScale());
            }
        }
        matrixStack.m_85841_(0.5f, 0.5f, 0.0f);
        double partialSize = modifiedGun.getDisplay().getFlash().getSize() / 5.0;
        float size = (float)(modifiedGun.getDisplay().getFlash().getSize() - partialSize + partialSize * (double)random);
        size = (float)GunModifierHelper.getMuzzleFlashSize(weapon, size);
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(360.0f * random));
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(flip ? 180.0f : 0.0f));
        matrixStack.m_85837_((double)(-size / 2.0f), (double)(-size / 2.0f), 0.0);
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        VertexConsumer builder = buffer.m_6299_(GunRenderType.getMuzzleFlash());
        builder.m_85982_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_85982_(matrix, size, 0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_85982_(matrix, size, size, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_85982_(matrix, 0.0f, size, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
        matrixStack.m_85849_();
    }

    private void renderShellCasing(LivingEntity entity, PoseStack matrixStack, ItemStack weapon, ItemTransforms.TransformType transformType, MultiBufferSource renderTypeBuffer, int light, float partialTicks) {
        Gun modifiedGun = ((GunItem)weapon.m_41720_()).getModifiedGun(weapon);
        if (modifiedGun.getDisplay().getShellCasing() == null) {
            return;
        }
        ResourceLocation modelResource = modifiedGun.getDisplay().getShellCasing().getCasingModel();
        if (modelResource == null) {
            return;
        }
        BakedModel caseModel = Minecraft.m_91087_().m_91304_().getModel(modelResource);
        if (caseModel == Minecraft.m_91087_().m_91304_().m_119409_()) {
            return;
        }
        if (transformType == ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || transformType == ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND) {
            for (ShellInAir shell : this.shells) {
                matrixStack.m_85836_();
                Vector3f pos = shell.origin.m_122281_();
                Vector3f dis1 = shell.preDisplacement.m_122281_();
                Vector3f dis2 = shell.displacement.m_122281_();
                dis1.m_122261_(1.0f - partialTicks);
                dis2.m_122261_(partialTicks);
                pos.m_122253_(dis1);
                pos.m_122253_(dis2);
                Vector3f rot = new Vector3f(0.0f, 0.0f, 0.0f);
                Vector3f rot1 = shell.preRotation.m_122281_();
                Vector3f rot2 = shell.rotation.m_122281_();
                rot1.m_122261_(1.0f - partialTicks);
                rot2.m_122261_(partialTicks);
                rot.m_122253_(rot1);
                rot.m_122253_(rot2);
                float displayXv = pos.m_122239_() * 0.0625f;
                float displayYv = pos.m_122260_() * 0.0625f;
                float displayZv = pos.m_122269_() * 0.0625f;
                float scale = (float)modifiedGun.getDisplay().getShellCasing().getScale();
                matrixStack.m_85837_((double)displayXv, (double)displayYv, (double)displayZv);
                matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(rot.m_122239_()));
                matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(rot.m_122260_()));
                matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(rot.m_122269_()));
                matrixStack.m_85841_(scale, scale, scale);
                RenderUtil.renderModel(caseModel, weapon, matrixStack, renderTypeBuffer, light, OverlayTexture.f_118083_);
                matrixStack.m_85849_();
            }
        }
    }

    private float getEquipProgress(float partialTicks) {
        if (this.equippedProgressMainHandField == null) {
            this.equippedProgressMainHandField = ObfuscationReflectionHelper.findField(ItemInHandRenderer.class, (String)"f_109302_");
            this.equippedProgressMainHandField.setAccessible(true);
        }
        if (this.prevEquippedProgressMainHandField == null) {
            this.prevEquippedProgressMainHandField = ObfuscationReflectionHelper.findField(ItemInHandRenderer.class, (String)"f_109303_");
            this.prevEquippedProgressMainHandField.setAccessible(true);
        }
        ItemInHandRenderer firstPersonRenderer = Minecraft.m_91087_().m_91292_();
        try {
            float equippedProgressMainHand = ((Float)this.equippedProgressMainHandField.get(firstPersonRenderer)).floatValue();
            float prevEquippedProgressMainHand = ((Float)this.prevEquippedProgressMainHandField.get(firstPersonRenderer)).floatValue();
            return 1.0f - Mth.m_14179_((float)partialTicks, (float)prevEquippedProgressMainHand, (float)equippedProgressMainHand);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    static {
        MUZZLE_FLASH_TEXTURE = new ResourceLocation("tac", "textures/effect/muzzle_flash.png");
        MUZZLE_SMOKE_TEXTURE = new ResourceLocation("tac", "textures/effect/muzzle_smoke.png");
    }

    public static class ShellInAir {
        public int livingTick;
        public Vector3f preDisplacement = new Vector3f(0.0f, 0.0f, 0.0f);
        public Vector3f displacement = new Vector3f(0.0f, 0.0f, 0.0f);
        public Vector3f preRotation = new Vector3f(0.0f, 0.0f, 0.0f);
        public Vector3f rotation = new Vector3f(0.0f, 0.0f, 0.0f);
        public Vector3f origin;
        public Vector3f velocity;
        public Vector3f angularVelocity;

        public ShellInAir(@Nonnull Vector3f origin, @Nonnull Vector3f velocity, @Nonnull Vector3f angularVelocity, int life) {
            this.origin = origin.m_122281_();
            this.velocity = velocity.m_122281_();
            this.angularVelocity = angularVelocity.m_122281_();
            this.livingTick = life;
        }
    }
}

