/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.handler;

import com.mrcrayfish.framework.common.data.SyncedEntityData;
import com.tac.guns.client.handler.AnimationHandler;
import com.tac.guns.client.render.animation.module.GunAnimationController;
import com.tac.guns.client.render.animation.module.PumpShotgunAnimationController;
import com.tac.guns.common.Gun;
import com.tac.guns.event.GunFireEvent;
import com.tac.guns.event.GunReloadEvent;
import com.tac.guns.init.ModSyncedDataKeys;
import com.tac.guns.item.GunItem;
import com.tac.guns.network.PacketHandler;
import com.tac.guns.network.message.MessageReload;
import com.tac.guns.network.message.MessageUpdateGunID;
import com.tac.guns.util.GunModifierHelper;
import com.tac.guns.util.WearableHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ReloadHandler {
    private static ReloadHandler instance;
    private int startReloadTick;
    private int reloadTimer;
    private int prevReloadTimer;
    private int reloadingSlot;
    private int startUpReloadTimer;
    private boolean empty;
    private boolean prevState = false;
    private ItemStack prevItemStack;
    public int rigAmmoCount = 0;

    public static ReloadHandler get() {
        if (instance == null) {
            instance = new ReloadHandler();
        }
        return instance;
    }

    private ReloadHandler() {
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        this.prevReloadTimer = this.reloadTimer;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            if (((Boolean)SyncedEntityData.instance().get((Entity)player, ModSyncedDataKeys.RELOADING)).booleanValue() && this.reloadingSlot != player.m_150109_().f_35977_) {
                this.setReloading(false);
            }
            this.updateReloadTimer((Player)player);
            PacketHandler.getPlayChannel().sendToServer((Object)new MessageUpdateGunID());
        }
    }

    private boolean isInGame() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91265_() != null) {
            return false;
        }
        if (mc.f_91080_ != null) {
            return false;
        }
        if (!mc.f_91067_.m_91600_()) {
            return false;
        }
        return mc.m_91302_();
    }

    public void setReloading(boolean reloading) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            if (reloading) {
                CompoundTag tag;
                ItemStack stack;
                this.prevItemStack = stack = player.m_21205_();
                if (stack.m_41720_() instanceof GunItem && (tag = stack.m_41783_()) != null && !tag.m_128425_("IgnoreAmmo", 1)) {
                    Gun gun = ((GunItem)stack.m_41720_()).getModifiedGun(stack);
                    if (tag.m_128451_("AmmoCount") >= GunModifierHelper.getAmmoCapacity(stack, gun)) {
                        return;
                    }
                    ItemStack rig = WearableHelper.PlayerWornRig((Player)player);
                    if (!player.m_7500_() && !rig.m_41619_() ? Gun.findAmmo((Player)player, gun.getProjectile().getItem()).length < 1 && this.rigAmmoCount < 1 : !player.m_7500_() && Gun.findAmmo((Player)player, gun.getProjectile().getItem()).length < 1) {
                        return;
                    }
                    if (MinecraftForge.EVENT_BUS.post((Event)new GunReloadEvent.Pre((Player)player, stack))) {
                        return;
                    }
                    SyncedEntityData.instance().set((Entity)player, ModSyncedDataKeys.RELOADING, (Object)true);
                    PacketHandler.getPlayChannel().sendToServer((Object)new MessageReload(true));
                    AnimationHandler.INSTANCE.onGunReload(true, stack);
                    this.reloadingSlot = player.m_150109_().f_35977_;
                    MinecraftForge.EVENT_BUS.post((Event)new GunReloadEvent.Post((Player)player, stack));
                }
            } else {
                if (this.prevItemStack != null) {
                    AnimationHandler.INSTANCE.onGunReload(false, this.prevItemStack);
                }
                SyncedEntityData.instance().set((Entity)player, ModSyncedDataKeys.RELOADING, (Object)false);
                PacketHandler.getPlayChannel().sendToServer((Object)new MessageReload(false));
                this.reloadingSlot = -1;
            }
        }
    }

    private void updateReloadTimer(Player player) {
        ItemStack stack = player.m_21205_();
        if (((Boolean)SyncedEntityData.instance().get((Entity)player, ModSyncedDataKeys.RELOADING)).booleanValue()) {
            CompoundTag tag;
            this.prevState = true;
            if (stack.m_41720_() instanceof GunItem && (tag = stack.m_41783_()) != null) {
                Gun gun = ((GunItem)stack.m_41720_()).getModifiedGun(stack);
                if (this.startUpReloadTimer == -1) {
                    this.startUpReloadTimer = gun.getReloads().getPreReloadPauseTicks();
                }
                if (gun.getReloads().isMagFed()) {
                    if (this.startUpReloadTimer == 0) {
                        if (this.startReloadTick == -1) {
                            this.startReloadTick = player.f_19797_ + 5;
                        }
                        if (tag.m_128451_("AmmoCount") <= 0) {
                            if (this.reloadTimer < gun.getReloads().getReloadMagTimer() + gun.getReloads().getAdditionalReloadEmptyMagTimer()) {
                                ++this.reloadTimer;
                            }
                        } else if (this.reloadTimer < gun.getReloads().getReloadMagTimer()) {
                            ++this.reloadTimer;
                        }
                    } else {
                        --this.startUpReloadTimer;
                    }
                } else if (this.startUpReloadTimer == 0) {
                    if (this.startReloadTick == -1) {
                        this.startReloadTick = player.f_19797_ + 5;
                    }
                    if (this.reloadTimer < gun.getReloads().getinterReloadPauseTicks() && !AnimationHandler.INSTANCE.isReloadingIntro(this.prevItemStack.m_41720_())) {
                        ++this.reloadTimer;
                    }
                    if (this.reloadTimer == gun.getReloads().getinterReloadPauseTicks()) {
                        AnimationHandler.INSTANCE.onReloadLoop(this.prevItemStack.m_41720_());
                        this.reloadTimer = 0;
                    }
                } else {
                    --this.startUpReloadTimer;
                }
            }
        } else {
            if (this.prevState) {
                this.prevState = false;
                AnimationHandler.INSTANCE.onReloadEnd(this.prevItemStack.m_41720_());
            }
            if (stack.m_41720_() instanceof GunItem) {
                Gun gun = ((GunItem)stack.m_41720_()).getModifiedGun(stack);
                if (gun.getReloads().isMagFed()) {
                    if (this.startReloadTick != -1) {
                        this.startReloadTick = -1;
                    }
                    if (this.reloadTimer > 0) {
                        this.reloadTimer = 0;
                    }
                } else {
                    if (this.startReloadTick != -1) {
                        this.startReloadTick = -1;
                    }
                    if (this.reloadTimer > 0) {
                        --this.reloadTimer;
                    }
                }
            } else {
                if (this.startReloadTick != -1) {
                    this.startReloadTick = -1;
                }
                if (this.reloadTimer > 0) {
                    this.reloadTimer = 0;
                }
            }
        }
    }

    public int getStartReloadTick() {
        return this.startReloadTick;
    }

    public int getReloadTimer() {
        return this.reloadTimer;
    }

    public int getStartUpReloadTimer() {
        return this.startUpReloadTimer;
    }

    public boolean isReloading() {
        return this.startReloadTick != -1;
    }

    public float getReloadProgress(float partialTicks, ItemStack stack) {
        boolean isEmpty = false;
        GunItem gunItem = (GunItem)stack.m_41720_();
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            boolean bl = isEmpty = tag.m_128451_("AmmoCount") <= 0;
        }
        return this.startUpReloadTimer == 0 ? (gunItem.getGun().getReloads().isMagFed() ? (isEmpty ? ((float)this.prevReloadTimer + (float)(this.reloadTimer - this.prevReloadTimer) * partialTicks + (float)this.startUpReloadTimer) / ((float)gunItem.getGun().getReloads().getReloadMagTimer() + (float)gunItem.getGun().getReloads().getAdditionalReloadEmptyMagTimer()) : ((float)this.prevReloadTimer + (float)(this.reloadTimer - this.prevReloadTimer) * partialTicks + (float)this.startUpReloadTimer) / (float)gunItem.getGun().getReloads().getReloadMagTimer()) : ((float)this.reloadTimer + (float)(this.reloadTimer - this.prevReloadTimer) * partialTicks) / (float)gunItem.getGun().getReloads().getinterReloadPauseTicks()) : 1.0f;
    }

    @SubscribeEvent
    public void onGunFire(GunFireEvent.Pre event) {
        CompoundTag tag;
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem)) {
            return;
        }
        Gun gun = ((GunItem)stack.m_41720_()).getModifiedGun(stack);
        if (GunAnimationController.fromItem(stack.m_41720_()) instanceof PumpShotgunAnimationController && this.isReloading()) {
            event.setCanceled(true);
        }
        if ((tag = stack.m_41784_()).m_128451_("AmmoCount") <= 0) {
            if (gun.getReloads().getReloadMagTimer() + gun.getReloads().getAdditionalReloadEmptyMagTimer() - this.reloadTimer > 5 && this.isReloading()) {
                event.setCanceled(true);
            }
        } else if (gun.getReloads().getReloadMagTimer() - this.reloadTimer > 5 && this.isReloading()) {
            event.setCanceled(true);
        }
    }
}

