/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.handler.command;

import com.google.gson.GsonBuilder;
import com.tac.guns.Config;
import com.tac.guns.GunMod;
import com.tac.guns.client.Keys;
import com.tac.guns.common.Gun;
import com.tac.guns.common.tooling.CommandsHandler;
import com.tac.guns.item.attachment.IAttachment;
import com.tac.guns.item.transition.TimelessGunItem;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.Level;

public class GunEditor {
    private static GunEditor instance;
    private String previousWeaponTag = "";
    private TaCWeaponDevModes prevMode;
    private TaCWeaponDevModes mode;
    private HashMap<String, Gun> map = new HashMap();
    private boolean resetMode;
    private double rateMod = 0.0;
    private double burstRateMod = 0.0;
    private float recoilAngleMod = 0.0f;
    private float recoilKickMod = 0.0f;
    private float horizontalRecoilAngleMod = 0.0f;
    private float cameraRecoilModifierMod = 0.0f;
    private float weaponRecoilDurationMod = 0.0f;
    private float cameraRecoilDurationMod = 0.0f;
    private float recoilDurationMod = 0.0f;
    private float recoilAdsReductionMod = 0.0f;
    private double projectileAmountMod = 0.0;
    private float spreadMod = 0.0f;
    private float weightKiloMod = 0.0f;
    private float damageMod = 0.0f;
    private float armorIgnoreMod = 0.0f;
    private float criticalMod = 0.0f;
    private float criticalDamageMod = 0.0f;
    private float headDamageMod = 0.0f;
    private float closeDamageMod = 0.0f;
    private float decayStartMod = 0.0f;
    private float minDecayMultiplierMod = 0.0f;
    private float decayEndMod = 0.0f;
    private float sizePrjMod = 0.0f;
    private double speedMod = 0.0;
    private double lifeMod = 0.0;
    double reloadMagTimerMod = 0.0;
    double additionalReloadEmptyMagTimerMod = 0.0;
    double reloadAmountMod = 0.0;
    double preReloadPauseTicksMod = 0.0;
    double interReloadPauseTicksMod = 0.0;
    private double xMod = 0.0;
    private double yMod = 0.0;
    private double zMod = 0.0;
    private boolean controlToggle = false;
    private boolean altToggle = false;
    private double sizeMod = 0.0;

    public static GunEditor get() {
        if (instance == null) {
            instance = new GunEditor();
        }
        return instance;
    }

    private GunEditor() {
    }

    public TaCWeaponDevModes getMode() {
        return this.mode;
    }

    public void setResetMode(boolean reset) {
        this.resetMode = reset;
    }

    public void setMode(TaCWeaponDevModes mode) {
        this.mode = mode;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (!((Boolean)Config.COMMON.development.enableTDev.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        CommandsHandler ch = CommandsHandler.get();
        if (ch == null || ch.getCatCurrentIndex() != 1) {
            return;
        }
        if (mc.f_91074_.m_21205_() == null || mc.f_91074_.m_21205_() == ItemStack.f_41583_ || !(mc.f_91074_.m_21205_().m_41720_() instanceof TimelessGunItem)) {
            return;
        }
        TimelessGunItem gunItem = (TimelessGunItem)mc.f_91074_.m_21205_().m_41720_();
        if (this.prevMode == null) {
            this.prevMode = this.mode;
        } else if (this.prevMode != this.mode && this.resetMode) {
            this.resetMode = false;
            this.resetData();
            this.ensureData(this.getMapItem(gunItem.m_5524_(), gunItem.getGun()), gunItem.getGun().copy());
            this.prevMode = this.mode;
        }
        if (this.previousWeaponTag == "") {
            this.previousWeaponTag = gunItem.m_5524_();
        } else if (this.previousWeaponTag != gunItem.m_5524_()) {
            this.previousWeaponTag = gunItem.m_5524_();
            this.resetData();
            this.ensureData(this.getMapItem(gunItem.m_5524_(), gunItem.getGun()), gunItem.getGun().copy());
        }
    }

    @SubscribeEvent
    public void onKeyPressed(InputEvent.KeyInputEvent event) {
        if (!((Boolean)Config.COMMON.development.enableTDev.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        if (mc.f_91074_.m_21205_() == null || mc.f_91074_.m_21205_() == ItemStack.f_41583_ || !(mc.f_91074_.m_21205_().m_41720_() instanceof TimelessGunItem)) {
            return;
        }
        CommandsHandler ch = CommandsHandler.get();
        if (ch == null || ch.getCatCurrentIndex() != 1) {
            return;
        }
        TimelessGunItem gunItem = (TimelessGunItem)mc.f_91074_.m_21205_().m_41720_();
        if (ch.catInGlobal(1) && this.mode != null) {
            switch (this.mode) {
                case general: {
                    this.handleGeneralMod(event, gunItem);
                    break;
                }
                case reloads: {
                    this.handleReloadsMod(event, gunItem);
                    break;
                }
                case projectile: {
                    this.handleProjectileMod(event, gunItem);
                    break;
                }
                case display: {
                    break;
                }
                case flash: {
                    this.handleFlashMod(event, gunItem);
                    break;
                }
                case zoom: {
                    this.handleZoomMod(event, gunItem);
                    break;
                }
                case scope: {
                    this.handleScopeMod(event, gunItem);
                    break;
                }
                case barrel: {
                    this.handleBarrelMod(event, gunItem);
                    break;
                }
                case oldScope: {
                    this.handleOldScopeMod(event, gunItem);
                    break;
                }
                case pistolScope: {
                    this.handlePistolScopeMod(event, gunItem);
                    break;
                }
                case pistolBarrel: {
                    this.handlePistolBarrelMod(event, gunItem);
                    break;
                }
            }
        }
    }

    public double getRateMod() {
        return this.rateMod;
    }

    public double getBurstRateMod() {
        return this.burstRateMod;
    }

    public float getRecoilAngleMod() {
        return this.recoilAngleMod;
    }

    public float getRecoilKickMod() {
        return this.recoilKickMod;
    }

    public float getHorizontalRecoilAngleMod() {
        return this.horizontalRecoilAngleMod;
    }

    public float getCameraRecoilModifierMod() {
        return this.cameraRecoilModifierMod;
    }

    public float getWeaponRecoilDurationMod() {
        return this.weaponRecoilDurationMod;
    }

    public float getcameraRecoilDurationMod() {
        return this.cameraRecoilDurationMod;
    }

    public float getRecoilDurationMod() {
        return this.recoilDurationMod;
    }

    public float getRecoilAdsReductionMod() {
        return this.recoilAdsReductionMod;
    }

    public double getProjectileAmountMod() {
        return this.projectileAmountMod;
    }

    public float getSpreadMod() {
        return this.spreadMod;
    }

    public float getWeightKiloMod() {
        return this.weightKiloMod;
    }

    private void handleGeneralMod(InputEvent.KeyInputEvent event, TimelessGunItem gunItem) {
        double stepModifier = 1.0;
        boolean isLeft = event.getKey() == 263;
        boolean isRight = event.getKey() == 262;
        boolean isUp = event.getKey() == 265;
        boolean isDown = event.getKey() == 264;
        boolean isControlDown = Keys.CONTROLLY.m_90857_() || Keys.CONTROLLYR.m_90857_();
        boolean isShiftDown = Keys.SHIFTY.m_90857_() || Keys.SHIFTYR.m_90857_();
        boolean isAltDown = Keys.ALTY.m_90857_() || Keys.ALTYR.m_90857_();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Gun gunTmp = gunItem.getGun();
        if (Keys.P.m_90857_()) {
            if (isShiftDown) {
                stepModifier *= 10.0;
            }
            if (isControlDown) {
                stepModifier /= 10.0;
            }
            player.m_5661_((Component)new TranslatableComponent("VerticalRecoilAngle: " + gunTmp.getGeneral().getRecoilAngle() + " | HorizontalRecoilAngle: " + gunTmp.getGeneral().getHorizontalRecoilAngle() + " | RecoilKick: " + gunTmp.getGeneral().getRecoilKick()), true);
            if (isLeft) {
                this.horizontalRecoilAngleMod = (float)((double)this.horizontalRecoilAngleMod + 0.025 * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("HorizontalRecoilAngle: " + gunTmp.getGeneral().getHorizontalRecoilAngle()).m_130940_(ChatFormatting.GREEN), true);
            } else if (isRight) {
                this.horizontalRecoilAngleMod = (float)((double)this.horizontalRecoilAngleMod - 0.025 * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("HorizontalRecoilAngle: " + gunTmp.getGeneral().getHorizontalRecoilAngle()).m_130940_(ChatFormatting.DARK_RED), true);
            } else if (isUp && isAltDown) {
                this.recoilKickMod = (float)((double)this.recoilKickMod + 0.025 * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("RecoilKick: " + gunTmp.getGeneral().getRecoilKick()).m_130940_(ChatFormatting.GREEN), true);
            } else if (isDown && isAltDown) {
                this.recoilKickMod = (float)((double)this.recoilKickMod - 0.025 * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("RecoilKick: " + gunTmp.getGeneral().getRecoilKick()).m_130940_(ChatFormatting.DARK_RED), true);
            } else if (isUp) {
                this.recoilAngleMod = (float)((double)this.recoilAngleMod + 0.025 * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("VerticalRecoilAngle: " + gunTmp.getGeneral().getRecoilAngle()).m_130940_(ChatFormatting.GREEN), true);
            } else if (isDown) {
                this.recoilAngleMod = (float)((double)this.recoilAngleMod - 0.025 * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("VerticalRecoilAngle: " + gunTmp.getGeneral().getRecoilAngle()).m_130940_(ChatFormatting.DARK_RED), true);
            }
        } else if (Keys.L.m_90857_()) {
            if (isShiftDown) {
                stepModifier *= 5.0;
            }
            player.m_5661_((Component)new TranslatableComponent("weaponRecoilOffset: " + gunTmp.getGeneral().getWeaponRecoilOffset() + " | RecoilDuration: " + gunTmp.getGeneral().getRecoilDuration()), true);
            if (isLeft) {
                this.weaponRecoilDurationMod = (float)((double)this.weaponRecoilDurationMod + 0.0025 * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("weaponRecoilOffset: " + gunTmp.getGeneral().getWeaponRecoilOffset()).m_130940_(ChatFormatting.GREEN), true);
            } else if (isRight) {
                this.weaponRecoilDurationMod = (float)((double)this.weaponRecoilDurationMod - 0.0025 * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("weaponRecoilOffset: " + gunTmp.getGeneral().getWeaponRecoilOffset()).m_130940_(ChatFormatting.DARK_RED), true);
            } else if (isUp) {
                this.recoilDurationMod = (float)((double)this.recoilDurationMod + 0.0025 * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("RecoilDuration: " + gunTmp.getGeneral().getRecoilDuration()).m_130940_(ChatFormatting.GREEN), true);
            } else if (isDown) {
                this.recoilDurationMod = (float)((double)this.recoilDurationMod - 0.0025 * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("RecoilDuration: " + gunTmp.getGeneral().getRecoilDuration()).m_130940_(ChatFormatting.DARK_RED), true);
            }
        } else if (Keys.O.m_90857_()) {
            if (isShiftDown) {
                stepModifier *= 5.0;
            }
            player.m_5661_((Component)new TranslatableComponent("CameraRecoilModifier: " + gunTmp.getGeneral().getCameraRecoilModifier()), true);
            if (isUp) {
                this.cameraRecoilModifierMod = (float)((double)this.cameraRecoilModifierMod + 0.0025 * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("CameraRecoilModifier: " + gunTmp.getGeneral().getCameraRecoilModifier()).m_130940_(ChatFormatting.GREEN), true);
            } else if (isDown) {
                this.cameraRecoilModifierMod = (float)((double)this.cameraRecoilModifierMod - 0.0025 * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("CameraRecoilModifier: " + gunTmp.getGeneral().getCameraRecoilModifier()).m_130940_(ChatFormatting.DARK_RED), true);
            }
        } else if (Keys.K.m_90857_()) {
            if (isShiftDown) {
                stepModifier *= 5.0;
            }
            player.m_5661_((Component)new TranslatableComponent("RecoilAdsReduction: " + gunTmp.getGeneral().getRecoilAdsReduction()), true);
            if (isUp) {
                this.recoilAdsReductionMod = (float)((double)this.recoilAdsReductionMod + 0.001 * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("RecoilAdsReduction: " + gunTmp.getGeneral().getRecoilAdsReduction()).m_130940_(ChatFormatting.GREEN), true);
            } else if (isDown) {
                this.recoilAdsReductionMod = (float)((double)this.recoilAdsReductionMod - 0.001 * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("RecoilAdsReduction: " + gunTmp.getGeneral().getRecoilAdsReduction()).m_130940_(ChatFormatting.DARK_RED), true);
            }
        } else if (Keys.M.m_90857_()) {
            if (isShiftDown) {
                stepModifier *= 10.0;
            }
            if (isControlDown) {
                stepModifier /= 10.0;
            }
            player.m_5661_((Component)new TranslatableComponent("Inaccuracy in Degrees: " + gunTmp.getGeneral().getSpread()), true);
            if (isUp) {
                this.spreadMod = (float)((double)this.spreadMod + 0.025 * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("Inaccuracy in Degrees: " + gunTmp.getGeneral().getSpread()).m_130940_(ChatFormatting.GREEN), true);
            } else if (isDown) {
                this.spreadMod = (float)((double)this.spreadMod - 0.025 * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("Inaccuracy in Degrees: " + gunTmp.getGeneral().getSpread()).m_130940_(ChatFormatting.DARK_RED), true);
            }
        } else if (Keys.I.m_90857_()) {
            if (isShiftDown) {
                stepModifier *= 10.0;
            }
            if (isControlDown) {
                stepModifier /= 10.0;
            }
            player.m_5661_((Component)new TranslatableComponent("Weight in Kilograms: " + gunTmp.getGeneral().getWeightKilo()), true);
            if (isUp) {
                this.weightKiloMod = (float)((double)this.weightKiloMod + 0.025 * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("Weight in Kilograms: " + gunTmp.getGeneral().getWeightKilo()).m_130940_(ChatFormatting.GREEN), true);
            } else if (isDown) {
                this.weightKiloMod = (float)((double)this.weightKiloMod - 0.025 * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("Weight in Kilograms: " + gunTmp.getGeneral().getWeightKilo()).m_130940_(ChatFormatting.DARK_RED), true);
            }
        } else if (Keys.J.m_90857_()) {
            player.m_5661_((Component)new TranslatableComponent("Rate in Ticks: " + gunTmp.getGeneral().getRate() + " | Burst Rate in Ticks:: " + gunTmp.getGeneral().getBurstRate()), true);
            if (isLeft) {
                this.burstRateMod += 0.5 * stepModifier;
                player.m_5661_((Component)new TranslatableComponent("Burst Rate in Ticks: " + gunTmp.getGeneral().getBurstRate()).m_130940_(ChatFormatting.GREEN), true);
            } else if (isRight) {
                this.burstRateMod -= 0.5 * stepModifier;
                player.m_5661_((Component)new TranslatableComponent("Burst Rate in Ticks: " + gunTmp.getGeneral().getBurstRate()).m_130940_(ChatFormatting.DARK_RED), true);
            } else if (isUp) {
                this.rateMod += 0.5;
                player.m_5661_((Component)new TranslatableComponent("Rate in Ticks: " + gunTmp.getGeneral().getRate()).m_130940_(ChatFormatting.GREEN), true);
            } else if (isDown) {
                this.rateMod -= 0.5;
                player.m_5661_((Component)new TranslatableComponent("Rate in Ticks: " + gunTmp.getGeneral().getRate()).m_130940_(ChatFormatting.DARK_RED), true);
            }
        } else if (Keys.N.m_90857_()) {
            player.m_5661_((Component)new TranslatableComponent("Projectile Amount: " + gunTmp.getGeneral().getProjectileAmount()), true);
            if (isUp) {
                this.projectileAmountMod += 0.5;
                player.m_5661_((Component)new TranslatableComponent("Projectile Amount: " + gunTmp.getGeneral().getProjectileAmount()).m_130940_(ChatFormatting.GREEN), true);
            } else if (isDown) {
                this.projectileAmountMod -= 0.5;
                player.m_5661_((Component)new TranslatableComponent("Projectile Amount: " + gunTmp.getGeneral().getProjectileAmount()).m_130940_(ChatFormatting.DARK_RED), true);
            }
        }
        CompoundTag gun = this.getMapItem(gunItem.m_5524_(), gunItem.getGun()).serializeNBT();
        gun.m_128469_("General").m_128473_("Rate");
        gun.m_128469_("General").m_128473_("RecoilAngle");
        gun.m_128469_("General").m_128473_("RecoilKick");
        gun.m_128469_("General").m_128473_("HorizontalRecoilAngle");
        gun.m_128469_("General").m_128473_("CameraRecoilModifier");
        gun.m_128469_("General").m_128473_("RecoilDurationOffset");
        gun.m_128469_("General").m_128473_("weaponRecoilOffset");
        gun.m_128469_("General").m_128473_("RecoilAdsReduction");
        gun.m_128469_("General").m_128473_("ProjectileAmount");
        gun.m_128469_("General").m_128473_("Spread");
        gun.m_128469_("General").m_128473_("WeightKilo");
        gun.m_128469_("General").m_128347_("Rate", (double)gunItem.getGun().getGeneral().getRate());
        gun.m_128469_("General").m_128347_("RecoilAngle", (double)gunItem.getGun().getGeneral().getRecoilAngle());
        gun.m_128469_("General").m_128347_("RecoilKick", (double)gunItem.getGun().getGeneral().getRecoilKick());
        gun.m_128469_("General").m_128347_("HorizontalRecoilAngle", (double)gunItem.getGun().getGeneral().getHorizontalRecoilAngle());
        gun.m_128469_("General").m_128347_("CameraRecoilModifier", (double)gunItem.getGun().getGeneral().getCameraRecoilModifier());
        gun.m_128469_("General").m_128347_("RecoilDurationOffset", (double)gunItem.getGun().getGeneral().getRecoilDuration());
        gun.m_128469_("General").m_128347_("weaponRecoilOffset", (double)gunItem.getGun().getGeneral().getWeaponRecoilOffset());
        gun.m_128469_("General").m_128347_("RecoilAdsReduction", (double)gunItem.getGun().getGeneral().getRecoilAdsReduction());
        gun.m_128469_("General").m_128347_("ProjectileAmount", (double)gunItem.getGun().getGeneral().getProjectileAmount());
        gun.m_128469_("General").m_128347_("Spread", (double)gunItem.getGun().getGeneral().getSpread());
        gun.m_128469_("General").m_128347_("WeightKilo", (double)gunItem.getGun().getGeneral().getWeightKilo());
        this.getMapItem(gunItem.m_5524_(), gunItem.getGun()).deserializeNBT(gun);
    }

    public float getDamageMod() {
        return this.damageMod;
    }

    public float getArmorIgnoreMod() {
        return this.armorIgnoreMod;
    }

    public float getCriticalMod() {
        return this.criticalMod;
    }

    public float getCriticalDamageMod() {
        return this.criticalDamageMod;
    }

    public float getHeadDamageMod() {
        return this.headDamageMod;
    }

    public float getCloseDamageMod() {
        return this.closeDamageMod;
    }

    public float getDecayStartMod() {
        return this.decayStartMod;
    }

    public float getMinDecayMultiplierMod() {
        return this.minDecayMultiplierMod;
    }

    public float getDecayEndMod() {
        return this.decayEndMod;
    }

    public float getSizePrjMod() {
        return this.sizePrjMod;
    }

    public double getSpeedMod() {
        return this.speedMod;
    }

    public double getLifeMod() {
        return this.lifeMod;
    }

    private void handleProjectileMod(InputEvent.KeyInputEvent event, TimelessGunItem gunItem) {
        double stepModifier = 1.0;
        boolean isUp = event.getKey() == 265;
        boolean isDown = event.getKey() == 264;
        boolean isControlDown = Keys.CONTROLLY.m_90857_() || Keys.CONTROLLYR.m_90857_();
        boolean isShiftDown = Keys.SHIFTY.m_90857_() || Keys.SHIFTYR.m_90857_();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Gun gunTmp = gunItem.getGun();
        if (Keys.P.m_90857_()) {
            if (isShiftDown) {
                stepModifier *= 10.0;
            }
            if (isControlDown) {
                stepModifier /= 10.0;
            }
            player.m_5661_((Component)new TranslatableComponent("Damage: " + gunTmp.getProjectile().getDamage()), true);
            if (isUp) {
                this.damageMod = (float)((double)this.damageMod + (double)0.025f * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("Damage: " + gunTmp.getProjectile().getDamage()).m_130940_(ChatFormatting.GREEN), true);
                this.criticalMod = (float)((double)this.criticalMod + (double)0.025f * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("Damage: " + gunTmp.getProjectile().getGunCritical()).m_130940_(ChatFormatting.GREEN), true);
                this.armorIgnoreMod = (float)((double)this.armorIgnoreMod + (double)0.025f * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("Damage: " + gunTmp.getProjectile().getGunArmorIgnore()).m_130940_(ChatFormatting.GREEN), true);
                this.criticalDamageMod = (float)((double)this.criticalDamageMod + (double)0.025f * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("Damage: " + gunTmp.getProjectile().getGunCriticalDamage()).m_130940_(ChatFormatting.GREEN), true);
                this.headDamageMod = (float)((double)this.headDamageMod + (double)0.025f * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("Damage: " + gunTmp.getProjectile().getGunHeadDamage()).m_130940_(ChatFormatting.GREEN), true);
                this.closeDamageMod = (float)((double)this.closeDamageMod + (double)0.025f * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("Damage: " + gunTmp.getProjectile().getGunCloseDamage()).m_130940_(ChatFormatting.GREEN), true);
                this.decayStartMod = (float)((double)this.decayStartMod + (double)0.025f * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("Damage: " + gunTmp.getProjectile().getGunDecayStart()).m_130940_(ChatFormatting.GREEN), true);
                this.minDecayMultiplierMod = (float)((double)this.minDecayMultiplierMod + (double)0.025f * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("Damage: " + gunTmp.getProjectile().getGunMinDecayMultiplier()).m_130940_(ChatFormatting.GREEN), true);
                this.decayEndMod = (float)((double)this.decayEndMod + (double)0.025f * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("Damage: " + gunTmp.getProjectile().getGunDecayEnd()).m_130940_(ChatFormatting.GREEN), true);
            } else if (isDown) {
                this.damageMod = (float)((double)this.damageMod - (double)0.025f * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("Damage: " + gunTmp.getProjectile().getDamage()).m_130940_(ChatFormatting.DARK_RED), true);
                this.criticalMod = (float)((double)this.criticalMod - (double)0.025f * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("Damage: " + gunTmp.getProjectile().getGunCritical()).m_130940_(ChatFormatting.DARK_RED), true);
                this.armorIgnoreMod = (float)((double)this.armorIgnoreMod - (double)0.025f * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("Damage: " + gunTmp.getProjectile().getGunArmorIgnore()).m_130940_(ChatFormatting.DARK_RED), true);
                this.criticalDamageMod = (float)((double)this.criticalDamageMod - (double)0.025f * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("Damage: " + gunTmp.getProjectile().getGunCriticalDamage()).m_130940_(ChatFormatting.DARK_RED), true);
                this.headDamageMod = (float)((double)this.headDamageMod - (double)0.025f * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("Damage: " + gunTmp.getProjectile().getGunHeadDamage()).m_130940_(ChatFormatting.DARK_RED), true);
                this.closeDamageMod = (float)((double)this.closeDamageMod - (double)0.025f * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("Damage: " + gunTmp.getProjectile().getGunCloseDamage()).m_130940_(ChatFormatting.DARK_RED), true);
                this.decayStartMod = (float)((double)this.decayStartMod - (double)0.025f * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("Damage: " + gunTmp.getProjectile().getGunDecayStart()).m_130940_(ChatFormatting.DARK_RED), true);
                this.minDecayMultiplierMod = (float)((double)this.minDecayMultiplierMod - (double)0.025f * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("Damage: " + gunTmp.getProjectile().getGunMinDecayMultiplier()).m_130940_(ChatFormatting.DARK_RED), true);
                this.decayEndMod = (float)((double)this.decayEndMod - (double)0.025f * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("Damage: " + gunTmp.getProjectile().getGunDecayEnd()).m_130940_(ChatFormatting.DARK_RED), true);
            }
        } else if (Keys.L.m_90857_()) {
            if (isShiftDown) {
                stepModifier *= 10.0;
            }
            if (isControlDown) {
                stepModifier /= 10.0;
            }
            player.m_5661_((Component)new TranslatableComponent("Projectile size: " + gunTmp.getProjectile().getSize()), true);
            if (isUp) {
                this.sizePrjMod = (float)((double)this.sizePrjMod + (double)0.025f * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("Projectile size: " + gunTmp.getProjectile().getSize()).m_130940_(ChatFormatting.GREEN), true);
            } else if (isDown) {
                this.sizePrjMod = (float)((double)this.sizePrjMod - (double)0.025f * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("Projectile size: " + gunTmp.getProjectile().getSize()).m_130940_(ChatFormatting.DARK_RED), true);
            }
        } else if (Keys.O.m_90857_()) {
            if (isShiftDown) {
                stepModifier *= 10.0;
            }
            player.m_5661_((Component)new TranslatableComponent("Speed: " + gunTmp.getProjectile().getSpeed()), true);
            if (isUp) {
                this.speedMod += 0.025 * stepModifier;
                player.m_5661_((Component)new TranslatableComponent("Speed: " + gunTmp.getProjectile().getSpeed()).m_130940_(ChatFormatting.GREEN), true);
            } else if (isDown) {
                this.speedMod -= 0.025 * stepModifier;
                player.m_5661_((Component)new TranslatableComponent("Speed: " + gunTmp.getProjectile().getSpeed()).m_130940_(ChatFormatting.DARK_RED), true);
            }
        } else if (Keys.K.m_90857_()) {
            player.m_5661_((Component)new TranslatableComponent("Ticks bullet Exists for: " + gunTmp.getProjectile().getLife()), true);
            if (isUp) {
                this.lifeMod += 0.5;
                player.m_5661_((Component)new TranslatableComponent("Ticks bullet Exists for: " + gunTmp.getProjectile().getLife()).m_130940_(ChatFormatting.GREEN), true);
            } else if (isDown) {
                this.lifeMod -= 0.5;
                player.m_5661_((Component)new TranslatableComponent("Ticks bullet Exists for: " + gunTmp.getProjectile().getLife()).m_130940_(ChatFormatting.DARK_RED), true);
            }
        }
        CompoundTag gun = this.getMapItem(gunItem.m_5524_(), gunItem.getGun()).serializeNBT();
        gun.m_128469_("Projectile").m_128473_("Damage");
        gun.m_128469_("Projectile").m_128473_("ArmorIgnore");
        gun.m_128469_("Projectile").m_128473_("Critical");
        gun.m_128469_("Projectile").m_128473_("CriticalDamage");
        gun.m_128469_("Projectile").m_128473_("HeadDamage");
        gun.m_128469_("Projectile").m_128473_("Size");
        gun.m_128469_("Projectile").m_128473_("Speed");
        gun.m_128469_("Projectile").m_128473_("Life");
        gun.m_128469_("Projectile").m_128347_("Damage", (double)gunItem.getGun().getProjectile().getDamage());
        gun.m_128469_("Projectile").m_128347_("ArmorIgnore", (double)gunItem.getGun().getProjectile().getGunArmorIgnore());
        gun.m_128469_("Projectile").m_128347_("Critical", (double)gunItem.getGun().getProjectile().getGunCritical());
        gun.m_128469_("Projectile").m_128347_("CriticalDamage", (double)gunItem.getGun().getProjectile().getGunCriticalDamage());
        gun.m_128469_("Projectile").m_128347_("HeadDamage", (double)gunItem.getGun().getProjectile().getGunHeadDamage());
        gun.m_128469_("Projectile").m_128347_("Size", (double)gunItem.getGun().getProjectile().getSize());
        gun.m_128469_("Projectile").m_128347_("Speed", gunItem.getGun().getProjectile().getSpeed());
        gun.m_128469_("Projectile").m_128347_("Life", (double)gunItem.getGun().getProjectile().getLife());
        this.getMapItem(gunItem.m_5524_(), gunItem.getGun()).deserializeNBT(gun);
    }

    public double getReloadMagTimerMod() {
        return this.reloadMagTimerMod;
    }

    public double getAdditionalReloadEmptyMagTimerMod() {
        return this.additionalReloadEmptyMagTimerMod;
    }

    public double getReloadAmountMod() {
        return this.reloadAmountMod;
    }

    public double getPreReloadPauseTicksMod() {
        return this.preReloadPauseTicksMod;
    }

    public double getInterReloadPauseTicksMod() {
        return this.interReloadPauseTicksMod;
    }

    private void handleReloadsMod(InputEvent.KeyInputEvent event, TimelessGunItem gunItem) {
        double stepModifier = 1.0;
        boolean isUp = event.getKey() == 265;
        boolean isDown = event.getKey() == 264;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Gun gunTmp = gunItem.getGun();
        if (Keys.P.m_90857_()) {
            player.m_5661_((Component)new TranslatableComponent("ReloadMagTimer: " + gunTmp.getReloads().getReloadMagTimer()), true);
            if (isUp) {
                this.reloadMagTimerMod += 0.5;
                player.m_5661_((Component)new TranslatableComponent("ReloadMagTimer: " + gunTmp.getReloads().getReloadMagTimer()).m_130940_(ChatFormatting.GREEN), true);
            } else if (isDown) {
                this.reloadMagTimerMod -= 0.5;
                player.m_5661_((Component)new TranslatableComponent("ReloadMagTimer: " + gunTmp.getReloads().getReloadMagTimer()).m_130940_(ChatFormatting.DARK_RED), true);
            }
        } else if (Keys.L.m_90857_()) {
            player.m_5661_((Component)new TranslatableComponent("AdditionalReloadEmptyMagTimer: " + gunTmp.getReloads().getAdditionalReloadEmptyMagTimer()), true);
            if (isUp) {
                this.additionalReloadEmptyMagTimerMod += 0.5;
                player.m_5661_((Component)new TranslatableComponent("AdditionalReloadEmptyMagTimer: " + gunTmp.getReloads().getAdditionalReloadEmptyMagTimer()).m_130940_(ChatFormatting.GREEN), true);
            } else if (isDown) {
                this.additionalReloadEmptyMagTimerMod -= 0.5;
                player.m_5661_((Component)new TranslatableComponent("AdditionalReloadEmptyMagTimer: " + gunTmp.getReloads().getAdditionalReloadEmptyMagTimer()).m_130940_(ChatFormatting.DARK_RED), true);
            }
        } else if (Keys.O.m_90857_()) {
            player.m_5661_((Component)new TranslatableComponent("ReloadAmount: " + gunTmp.getReloads().getReloadAmount()), true);
            if (isUp) {
                this.reloadAmountMod += 0.5;
                player.m_5661_((Component)new TranslatableComponent("ReloadAmount: " + gunTmp.getReloads().getReloadAmount()).m_130940_(ChatFormatting.GREEN), true);
            } else if (isDown) {
                this.reloadAmountMod -= 0.5;
                player.m_5661_((Component)new TranslatableComponent("ReloadAmount: " + gunTmp.getReloads().getReloadAmount()).m_130940_(ChatFormatting.DARK_RED), true);
            }
        } else if (Keys.K.m_90857_()) {
            player.m_5661_((Component)new TranslatableComponent("PreReloadPauseTicks: " + gunTmp.getReloads().getPreReloadPauseTicks()), true);
            if (isUp) {
                this.preReloadPauseTicksMod += 0.5;
                player.m_5661_((Component)new TranslatableComponent("PreReloadPauseTicks: " + gunTmp.getReloads().getPreReloadPauseTicks()).m_130940_(ChatFormatting.GREEN), true);
            } else if (isDown) {
                this.preReloadPauseTicksMod -= 0.5;
                player.m_5661_((Component)new TranslatableComponent("PreReloadPauseTicks: " + gunTmp.getReloads().getPreReloadPauseTicks()).m_130940_(ChatFormatting.DARK_RED), true);
            }
        } else if (Keys.M.m_90857_()) {
            player.m_5661_((Component)new TranslatableComponent("InterReloadPauseTicks: " + gunTmp.getReloads().getinterReloadPauseTicks()), true);
            if (isUp) {
                this.interReloadPauseTicksMod += 0.5;
                player.m_5661_((Component)new TranslatableComponent("InterReloadPauseTicks: " + gunTmp.getReloads().getinterReloadPauseTicks()).m_130940_(ChatFormatting.GREEN), true);
            } else if (isDown) {
                this.interReloadPauseTicksMod -= 0.5;
                player.m_5661_((Component)new TranslatableComponent("InterReloadPauseTicks: " + gunTmp.getReloads().getinterReloadPauseTicks()).m_130940_(ChatFormatting.DARK_RED), true);
            }
        }
        CompoundTag gun = this.getMapItem(gunItem.m_5524_(), gunItem.getGun()).serializeNBT();
        gun.m_128469_("Reloads").m_128473_("ReloadSpeed");
        gun.m_128469_("Reloads").m_128473_("ReloadMagTimer");
        gun.m_128469_("Reloads").m_128473_("AdditionalReloadEmptyMagTimer");
        gun.m_128469_("Reloads").m_128473_("ReloadPauseTicks");
        gun.m_128469_("Reloads").m_128473_("InterReloadPauseTicks");
        gun.m_128469_("Reloads").m_128347_("ReloadSpeed", (double)gunItem.getGun().getReloads().getReloadAmount());
        gun.m_128469_("Reloads").m_128347_("ReloadMagTimer", (double)gunItem.getGun().getReloads().getReloadMagTimer());
        gun.m_128469_("Reloads").m_128347_("AdditionalReloadEmptyMagTimer", (double)gunItem.getGun().getReloads().getAdditionalReloadEmptyMagTimer());
        gun.m_128469_("Reloads").m_128347_("ReloadPauseTicks", (double)gunItem.getGun().getReloads().getPreReloadPauseTicks());
        gun.m_128469_("Reloads").m_128347_("InterReloadPauseTicks", (double)gunItem.getGun().getReloads().getinterReloadPauseTicks());
        this.getMapItem(gunItem.m_5524_(), gunItem.getGun()).deserializeNBT(gun);
    }

    private void handleZoomMod(InputEvent.KeyInputEvent event, TimelessGunItem gunItem) {
        this.handlePositionedMod(event, gunItem);
    }

    private void handleFlashMod(InputEvent.KeyInputEvent event, TimelessGunItem gunItem) {
        this.handleScaledPositionedMod(event, gunItem);
    }

    private void handleScopeMod(InputEvent.KeyInputEvent event, TimelessGunItem gunItem) {
        this.handleScaledPositionedMod(event, gunItem);
    }

    private void handleBarrelMod(InputEvent.KeyInputEvent event, TimelessGunItem gunItem) {
        this.handleScaledPositionedMod(event, gunItem);
    }

    private void handleOldScopeMod(InputEvent.KeyInputEvent event, TimelessGunItem gunItem) {
        this.handleScaledPositionedMod(event, gunItem);
    }

    private void handlePistolScopeMod(InputEvent.KeyInputEvent event, TimelessGunItem gunItem) {
        this.handleScaledPositionedMod(event, gunItem);
    }

    private void handlePistolBarrelMod(InputEvent.KeyInputEvent event, TimelessGunItem gunItem) {
        this.handleScaledPositionedMod(event, gunItem);
    }

    public double getxMod() {
        return this.xMod;
    }

    public double getyMod() {
        return this.yMod;
    }

    public double getzMod() {
        return this.zMod;
    }

    private void handlePositionedMod(InputEvent.KeyInputEvent event, TimelessGunItem gunItem) {
        double stepModifier = 1.0;
        boolean isLeft = Keys.LEFT.m_90857_();
        boolean isRight = Keys.RIGHT.m_90857_();
        boolean isUp = Keys.UP.m_90857_();
        boolean isDown = Keys.DOWN.m_90857_();
        this.controlToggle = Keys.CONTROLLY.m_90857_() || Keys.CONTROLLYR.m_90857_();
        boolean bl = this.altToggle = Keys.ALTY.m_90857_() || Keys.ALTYR.m_90857_();
        if (this.controlToggle) {
            stepModifier /= 10.0;
        }
        if (isLeft) {
            this.xMod -= 0.1 * stepModifier;
        } else if (isRight) {
            this.xMod += 0.1 * stepModifier;
        } else if (isUp && this.altToggle) {
            this.zMod -= 0.1 * stepModifier;
        } else if (isDown && this.altToggle) {
            this.zMod += 0.1 * stepModifier;
        } else if (isUp) {
            this.yMod += 0.1 * stepModifier;
        } else if (isDown) {
            this.yMod -= 0.1 * stepModifier;
        }
        CompoundTag gun = this.getMapItem(gunItem.m_5524_(), gunItem.getGun()).serializeNBT();
        if (this.mode == TaCWeaponDevModes.flash) {
            gun.m_128469_("Display").m_128469_(this.mode.tagName).m_128473_("XOffset");
            gun.m_128469_("Display").m_128469_(this.mode.tagName).m_128473_("YOffset");
            gun.m_128469_("Display").m_128469_(this.mode.tagName).m_128473_("ZOffset");
            gun.m_128469_("Display").m_128469_(this.mode.tagName).m_128347_("XOffset", this.casedGetX());
            gun.m_128469_("Display").m_128469_(this.mode.tagName).m_128347_("YOffset", this.casedGetY());
            gun.m_128469_("Display").m_128469_(this.mode.tagName).m_128347_("ZOffset", this.casedGetZ());
        }
        if (this.mode == TaCWeaponDevModes.zoom) {
            gun.m_128469_("Modules").m_128469_("Zoom").m_128473_("XOffset");
            gun.m_128469_("Modules").m_128469_("Zoom").m_128473_("YOffset");
            gun.m_128469_("Modules").m_128469_("Zoom").m_128473_("ZOffset");
            gun.m_128469_("Modules").m_128469_("Zoom").m_128347_("XOffset", this.casedGetX());
            gun.m_128469_("Modules").m_128469_("Zoom").m_128347_("YOffset", this.casedGetY());
            gun.m_128469_("Modules").m_128469_("Zoom").m_128347_("ZOffset", this.casedGetZ());
        }
        if (this.mode == TaCWeaponDevModes.scope) {
            gun.m_128469_("Modules").m_128469_("Attachments").m_128469_("Scope").m_128473_("XOffset");
            gun.m_128469_("Modules").m_128469_("Attachments").m_128469_("Scope").m_128473_("YOffset");
            gun.m_128469_("Modules").m_128469_("Attachments").m_128469_("Scope").m_128473_("ZOffset");
            gun.m_128469_("Modules").m_128469_("Attachments").m_128469_("Scope").m_128347_("XOffset", this.casedGetX());
            gun.m_128469_("Modules").m_128469_("Attachments").m_128469_("Scope").m_128347_("YOffset", this.casedGetY());
            gun.m_128469_("Modules").m_128469_("Attachments").m_128469_("Scope").m_128347_("ZOffset", this.casedGetZ());
        } else {
            gun.m_128469_("Modules").m_128469_("Attachments").m_128469_(this.mode.tagName).m_128473_("XOffset");
            gun.m_128469_("Modules").m_128469_("Attachments").m_128469_(this.mode.tagName).m_128473_("YOffset");
            gun.m_128469_("Modules").m_128469_("Attachments").m_128469_(this.mode.tagName).m_128473_("ZOffset");
            gun.m_128469_("Modules").m_128469_("Attachments").m_128469_(this.mode.tagName).m_128347_("XOffset", this.casedGetX());
            gun.m_128469_("Modules").m_128469_("Attachments").m_128469_(this.mode.tagName).m_128347_("YOffset", this.casedGetY());
            gun.m_128469_("Modules").m_128469_("Attachments").m_128469_(this.mode.tagName).m_128347_("ZOffset", this.casedGetZ());
        }
        this.getMapItem(gunItem.m_5524_(), gunItem.getGun()).deserializeNBT(gun);
    }

    public double getSizeMod() {
        return this.sizeMod;
    }

    private void handleScaledPositionedMod(InputEvent.KeyInputEvent event, TimelessGunItem gunItem) {
        this.handlePositionedMod(event, gunItem);
        boolean isPeriodDown = Keys.SIZE_OPT.m_90857_();
        if (isPeriodDown) {
            boolean isShiftDown;
            double stepModifier = 1.0;
            boolean isUp = Keys.UP.m_90857_();
            boolean isDown = Keys.DOWN.m_90857_();
            boolean bl = isShiftDown = Keys.SHIFTY.m_90857_() || Keys.SHIFTYR.m_90857_();
            if (isShiftDown) {
                stepModifier *= 10.0;
            } else if (isUp) {
                this.sizeMod += 0.0075 * stepModifier;
            } else if (isDown) {
                this.sizeMod -= 0.0075 * stepModifier;
            }
        }
        CompoundTag gun = this.getMapItem(gunItem.m_5524_(), gunItem.getGun()).serializeNBT();
        if (this.mode == TaCWeaponDevModes.flash) {
            gun.m_128469_("Display").m_128469_(this.mode.tagName).m_128473_("Scale");
            gun.m_128469_("Display").m_128469_(this.mode.tagName).m_128347_("Scale", this.casedGetScale());
        } else {
            gun.m_128469_("Modules").m_128469_(this.mode.tagName).m_128473_("Scale");
            gun.m_128469_("Modules").m_128469_(this.mode.tagName).m_128347_("Scale", this.casedGetScale());
        }
        this.getMapItem(gunItem.m_5524_(), gunItem.getGun()).deserializeNBT(gun);
    }

    private Gun getMapItem(String gunTagName, Gun gun) {
        if (this.map.containsKey(gunTagName)) {
            return this.map.get(gunTagName);
        }
        this.map.put(gunTagName, gun.copy());
        return this.map.get(gunTagName);
    }

    private double casedGetScale() {
        TimelessGunItem gunItem = (TimelessGunItem)Minecraft.m_91087_().f_91074_.m_21205_().m_41720_();
        switch (this.mode) {
            case flash: {
                return gunItem.getGun().getDisplay().getFlash().getSize();
            }
            case scope: {
                return gunItem.getGun().canAttachType(IAttachment.Type.SCOPE) ? gunItem.getGun().getModules().getAttachments().getScope().getScale() : 0.0;
            }
            case barrel: {
                return gunItem.getGun().canAttachType(IAttachment.Type.BARREL) ? gunItem.getGun().getModules().getAttachments().getBarrel().getScale() : 0.0;
            }
            case oldScope: {
                return gunItem.getGun().canAttachType(IAttachment.Type.OLD_SCOPE) ? gunItem.getGun().getModules().getAttachments().getOldScope().getScale() : 0.0;
            }
            case pistolScope: {
                return gunItem.getGun().canAttachType(IAttachment.Type.PISTOL_SCOPE) ? gunItem.getGun().getModules().getAttachments().getPistolScope().getScale() : 0.0;
            }
            case pistolBarrel: {
                return gunItem.getGun().canAttachType(IAttachment.Type.PISTOL_BARREL) ? gunItem.getGun().getModules().getAttachments().getPistolBarrel().getScale() : 0.0;
            }
        }
        return 0.0;
    }

    private double casedGetX() {
        TimelessGunItem gunItem = (TimelessGunItem)Minecraft.m_91087_().f_91074_.m_21205_().m_41720_();
        switch (this.mode) {
            case flash: {
                return gunItem.getGun().getDisplay().getFlash().getXOffset();
            }
            case zoom: {
                return gunItem.getGun().getModules().getZoom().getXOffset();
            }
            case scope: {
                return gunItem.getGun().getModules().getAttachments().getScope() != null ? gunItem.getGun().getModules().getAttachments().getScope().getXOffset() : 0.0;
            }
            case barrel: {
                return gunItem.getGun().getModules().getAttachments().getBarrel() != null ? gunItem.getGun().getModules().getAttachments().getBarrel().getXOffset() : 0.0;
            }
            case oldScope: {
                return gunItem.getGun().getModules().getAttachments().getOldScope() != null ? gunItem.getGun().getModules().getAttachments().getOldScope().getXOffset() : 0.0;
            }
            case pistolScope: {
                return gunItem.getGun().getModules().getAttachments().getPistolScope() != null ? gunItem.getGun().getModules().getAttachments().getPistolScope().getXOffset() : 0.0;
            }
            case pistolBarrel: {
                return gunItem.getGun().getModules().getAttachments().getPistolBarrel() != null ? gunItem.getGun().getModules().getAttachments().getPistolBarrel().getXOffset() : 0.0;
            }
        }
        return 0.0;
    }

    private double casedGetY() {
        TimelessGunItem gunItem = (TimelessGunItem)Minecraft.m_91087_().f_91074_.m_21205_().m_41720_();
        switch (this.mode) {
            case flash: {
                return gunItem.getGun().getDisplay().getFlash().getYOffset();
            }
            case zoom: {
                return gunItem.getGun().getModules().getZoom().getYOffset();
            }
            case scope: {
                return gunItem.getGun().getModules().getAttachments().getScope() != null ? gunItem.getGun().getModules().getAttachments().getScope().getYOffset() : 0.0;
            }
            case barrel: {
                return gunItem.getGun().getModules().getAttachments().getBarrel() != null ? gunItem.getGun().getModules().getAttachments().getBarrel().getYOffset() : 0.0;
            }
            case oldScope: {
                return gunItem.getGun().getModules().getAttachments().getOldScope() != null ? gunItem.getGun().getModules().getAttachments().getOldScope().getYOffset() : 0.0;
            }
            case pistolScope: {
                return gunItem.getGun().getModules().getAttachments().getPistolScope() != null ? gunItem.getGun().getModules().getAttachments().getPistolScope().getYOffset() : 0.0;
            }
            case pistolBarrel: {
                return gunItem.getGun().getModules().getAttachments().getPistolBarrel() != null ? gunItem.getGun().getModules().getAttachments().getPistolBarrel().getYOffset() : 0.0;
            }
        }
        return 0.0;
    }

    private double casedGetZ() {
        TimelessGunItem gunItem = (TimelessGunItem)Minecraft.m_91087_().f_91074_.m_21205_().m_41720_();
        switch (this.mode) {
            case flash: {
                return gunItem.getGun().getDisplay().getFlash().getZOffset();
            }
            case zoom: {
                return gunItem.getGun().getModules().getZoom().getZOffset();
            }
            case scope: {
                return gunItem.getGun().getModules().getAttachments().getScope() != null ? gunItem.getGun().getModules().getAttachments().getScope().getZOffset() : 0.0;
            }
            case barrel: {
                return gunItem.getGun().getModules().getAttachments().getBarrel() != null ? gunItem.getGun().getModules().getAttachments().getBarrel().getZOffset() : 0.0;
            }
            case oldScope: {
                return gunItem.getGun().getModules().getAttachments().getOldScope() != null ? gunItem.getGun().getModules().getAttachments().getOldScope().getZOffset() : 0.0;
            }
            case pistolScope: {
                return gunItem.getGun().getModules().getAttachments().getPistolScope() != null ? gunItem.getGun().getModules().getAttachments().getPistolScope().getZOffset() : 0.0;
            }
            case pistolBarrel: {
                return gunItem.getGun().getModules().getAttachments().getPistolBarrel() != null ? gunItem.getGun().getModules().getAttachments().getPistolBarrel().getZOffset() : 0.0;
            }
        }
        return 0.0;
    }

    public void resetData() {
        switch (this.mode) {
            case general: {
                this.rateMod = 0.0;
                this.recoilAngleMod = 0.0f;
                this.recoilKickMod = 0.0f;
                this.horizontalRecoilAngleMod = 0.0f;
                this.cameraRecoilModifierMod = 0.0f;
                this.weaponRecoilDurationMod = 0.0f;
                this.recoilAdsReductionMod = 0.0f;
                this.projectileAmountMod = 0.0;
                this.spreadMod = 0.0f;
                this.weightKiloMod = 0.0f;
                break;
            }
            case reloads: {
                this.reloadMagTimerMod = 0.0;
                this.additionalReloadEmptyMagTimerMod = 0.0;
                this.reloadAmountMod = 0.0;
                this.preReloadPauseTicksMod = 0.0;
                this.interReloadPauseTicksMod = 0.0;
                break;
            }
            case projectile: {
                this.damageMod = 0.0f;
                this.armorIgnoreMod = 0.0f;
                this.criticalMod = 0.0f;
                this.criticalDamageMod = 0.0f;
                this.headDamageMod = 0.0f;
                this.closeDamageMod = 0.0f;
                this.decayStartMod = 0.0f;
                this.minDecayMultiplierMod = 0.0f;
                this.decayEndMod = 0.0f;
                this.sizePrjMod = 0.0f;
                this.speedMod = 0.0;
                this.lifeMod = 0.0;
                break;
            }
            case display: {
                break;
            }
            case flash: {
                this.xMod = 0.0;
                this.yMod = 0.0;
                this.zMod = 0.0;
                this.sizeMod = 0.0;
                break;
            }
            case zoom: {
                this.xMod = 0.0;
                this.yMod = 0.0;
                this.zMod = 0.0;
                break;
            }
            case scope: {
                this.xMod = 0.0;
                this.yMod = 0.0;
                this.zMod = 0.0;
                this.sizeMod = 0.0;
                break;
            }
            case barrel: {
                this.xMod = 0.0;
                this.yMod = 0.0;
                this.zMod = 0.0;
                break;
            }
            case oldScope: {
                this.xMod = 0.0;
                this.yMod = 0.0;
                this.zMod = 0.0;
                this.sizeMod = 0.0;
                break;
            }
            case pistolScope: {
                this.xMod = 0.0;
                this.yMod = 0.0;
                this.zMod = 0.0;
                break;
            }
            case pistolBarrel: {
                this.xMod = 0.0;
                this.yMod = 0.0;
                this.zMod = 0.0;
                break;
            }
        }
    }

    private void ensureData(Gun gun, Gun toUpdate) {
        switch (this.mode) {
            case general: {
                if (gun.getGeneral() == null) break;
                this.rateMod = gun.getGeneral().getRate() - toUpdate.getGeneral().getRate();
                this.recoilAngleMod = gun.getGeneral().getRecoilAngle() - toUpdate.getGeneral().getRecoilAngle();
                this.recoilKickMod = gun.getGeneral().getRecoilKick() - toUpdate.getGeneral().getRecoilKick();
                this.horizontalRecoilAngleMod = gun.getGeneral().getHorizontalRecoilAngle() - toUpdate.getGeneral().getHorizontalRecoilAngle();
                this.cameraRecoilModifierMod = gun.getGeneral().getCameraRecoilModifier() - toUpdate.getGeneral().getCameraRecoilModifier();
                this.weaponRecoilDurationMod = gun.getGeneral().getWeaponRecoilOffset() - toUpdate.getGeneral().getWeaponRecoilOffset();
                this.recoilDurationMod = gun.getGeneral().getRecoilDuration() - toUpdate.getGeneral().getRecoilDuration();
                this.recoilAdsReductionMod = gun.getGeneral().getRecoilAdsReduction() - toUpdate.getGeneral().getRecoilAdsReduction();
                this.projectileAmountMod = gun.getGeneral().getProjectileAmount() - toUpdate.getGeneral().getProjectileAmount();
                this.spreadMod = gun.getGeneral().getSpread() - toUpdate.getGeneral().getSpread();
                this.weightKiloMod = gun.getGeneral().getWeightKilo() - toUpdate.getGeneral().getWeightKilo();
                break;
            }
            case reloads: {
                break;
            }
            case projectile: {
                break;
            }
            case display: {
                break;
            }
            case flash: {
                if (toUpdate.getDisplay().getFlash() == null || gun.getDisplay().getFlash() == null) break;
                this.xMod = gun.getDisplay().getFlash().getXOffset() - toUpdate.getDisplay().getFlash().getXOffset();
                this.yMod = gun.getDisplay().getFlash().getYOffset() - toUpdate.getDisplay().getFlash().getYOffset();
                this.zMod = gun.getDisplay().getFlash().getZOffset() - toUpdate.getDisplay().getFlash().getZOffset();
                this.sizeMod = gun.getDisplay().getFlash().getSize() - toUpdate.getDisplay().getFlash().getSize();
                break;
            }
            case zoom: {
                if (toUpdate.getModules().getZoom() == null || gun.getModules().getZoom() == null) break;
                this.xMod = gun.getModules().getZoom().getXOffset() - toUpdate.getModules().getZoom().getXOffset();
                this.yMod = gun.getModules().getZoom().getYOffset() - toUpdate.getModules().getZoom().getYOffset();
                this.zMod = gun.getModules().getZoom().getZOffset() - toUpdate.getModules().getZoom().getZOffset();
                break;
            }
            case scope: {
                if (toUpdate.getModules().getAttachments().getScope() == null || gun.getModules().getAttachments().getScope() == null) break;
                this.xMod = gun.getModules().getAttachments().getScope().getXOffset() - toUpdate.getModules().getAttachments().getScope().getXOffset();
                this.yMod = gun.getModules().getAttachments().getScope().getYOffset() - toUpdate.getModules().getAttachments().getScope().getYOffset();
                this.zMod = gun.getModules().getAttachments().getScope().getZOffset() - toUpdate.getModules().getAttachments().getScope().getZOffset();
                this.sizeMod = gun.getModules().getAttachments().getScope().getScale() - toUpdate.getModules().getAttachments().getScope().getScale();
                break;
            }
            case barrel: {
                if (toUpdate.getModules().getAttachments().getBarrel() == null || gun.getModules().getAttachments().getBarrel() == null) break;
                this.xMod = gun.getModules().getAttachments().getBarrel().getXOffset() - toUpdate.getModules().getAttachments().getBarrel().getXOffset();
                this.yMod = gun.getModules().getAttachments().getBarrel().getYOffset() - toUpdate.getModules().getAttachments().getBarrel().getYOffset();
                this.zMod = gun.getModules().getAttachments().getBarrel().getZOffset() - toUpdate.getModules().getAttachments().getBarrel().getZOffset();
                break;
            }
            case oldScope: {
                if (toUpdate.getModules().getAttachments().getOldScope() == null || gun.getModules().getAttachments().getOldScope() == null) break;
                this.xMod = gun.getModules().getAttachments().getOldScope().getXOffset() - toUpdate.getModules().getAttachments().getOldScope().getXOffset();
                this.yMod = gun.getModules().getAttachments().getOldScope().getYOffset() - toUpdate.getModules().getAttachments().getOldScope().getYOffset();
                this.zMod = gun.getModules().getAttachments().getOldScope().getZOffset() - toUpdate.getModules().getAttachments().getOldScope().getZOffset();
                this.sizeMod = gun.getModules().getAttachments().getOldScope().getScale() - toUpdate.getModules().getAttachments().getOldScope().getScale();
                break;
            }
            case pistolScope: {
                if (toUpdate.getModules().getAttachments().getPistolScope() == null || gun.getModules().getAttachments().getPistolScope() == null) break;
                this.xMod = gun.getModules().getAttachments().getPistolScope().getXOffset() - toUpdate.getModules().getAttachments().getPistolScope().getXOffset();
                this.yMod = gun.getModules().getAttachments().getPistolScope().getYOffset() - toUpdate.getModules().getAttachments().getPistolScope().getYOffset();
                this.zMod = gun.getModules().getAttachments().getPistolScope().getZOffset() - toUpdate.getModules().getAttachments().getPistolScope().getZOffset();
                this.sizeMod = gun.getModules().getAttachments().getPistolScope().getScale() - toUpdate.getModules().getAttachments().getPistolScope().getScale();
                break;
            }
            case pistolBarrel: {
                if (toUpdate.getModules().getAttachments().getPistolBarrel() == null || gun.getModules().getAttachments().getPistolBarrel() == null) break;
                this.xMod = gun.getModules().getAttachments().getPistolBarrel().getXOffset() - toUpdate.getModules().getAttachments().getPistolBarrel().getXOffset();
                this.yMod = gun.getModules().getAttachments().getPistolBarrel().getYOffset() - toUpdate.getModules().getAttachments().getPistolBarrel().getYOffset();
                this.zMod = gun.getModules().getAttachments().getPistolBarrel().getZOffset() - toUpdate.getModules().getAttachments().getPistolBarrel().getZOffset();
                break;
            }
        }
    }

    public void exportData() {
        this.map.forEach((name, gun) -> {
            if (this.map.get(name) == null) {
                GunMod.LOGGER.log(Level.ERROR, "WEAPON EDITOR FAILED TO EXPORT THIS BROKEN DATA. CONTACT CLUMSYALIEN.");
                return;
            }
            GunMod.LOGGER.log(Level.FATAL, gun.serializeNBT().m_128469_("Modules").m_128469_("Attachments").toString());
            GsonBuilder gsonB = new GsonBuilder().setLenient().addSerializationExclusionStrategy(Gun.strategy).setPrettyPrinting();
            Object jsonString = gsonB.create().toJson(gun);
            jsonString = (String)jsonString + "\nTRAIL_ADJUST___" + gsonB.create().toJson((Object)this.sizeMod);
            jsonString = (String)jsonString + "\nSCOPE" + gsonB.create().toJson((Object)gun.serializeNBT().m_128469_("Modules").m_128469_("Attachments").m_128469_("Scope").toString());
            jsonString = (String)jsonString + "\nBARREL" + gsonB.create().toJson((Object)gun.serializeNBT().m_128469_("Modules").m_128469_("Attachments").m_128469_("Barrel").toString());
            jsonString = (String)jsonString + "\nOLD_SCOPE" + gsonB.create().toJson((Object)gun.serializeNBT().m_128469_("Modules").m_128469_("Attachments").m_128469_("OldScope").toString());
            jsonString = (String)jsonString + "\nPISTOL_SCOPE" + gsonB.create().toJson((Object)gun.serializeNBT().m_128469_("Modules").m_128469_("Attachments").m_128469_("PistolScope").toString());
            jsonString = (String)jsonString + "\nPISTOL_BARREL" + gsonB.create().toJson((Object)gun.serializeNBT().m_128469_("Modules").m_128469_("Attachments").m_128469_("PistolBarrel").toString());
            this.writeExport((String)jsonString, (String)name);
        });
    }

    private void writeExport(String jsonString, String name) {
        try {
            File dir = new File((String)Config.COMMON.development.TDevPath.get() + "\\tac_export\\");
            dir.mkdir();
            FileWriter dataWriter = new FileWriter(dir.getAbsolutePath() + "\\" + name + "_export.json");
            dataWriter.write(jsonString);
            dataWriter.close();
            GunMod.LOGGER.log(Level.INFO, "WEAPON EDITOR EXPORTED FILE ( " + name + "_export.txt ). BE PROUD!");
        }
        catch (IOException e) {
            GunMod.LOGGER.log(Level.ERROR, "WEAPON EDITOR FAILED TO EXPORT, NO FILE CREATED!!! NO ACCESS IN PATH?. CONTACT CLUMSYALIEN.");
        }
    }

    public static String formattedModeContext() {
        Object result = "\n";
        for (TaCWeaponDevModes mode : TaCWeaponDevModes.values()) {
            result = (String)result + mode.tagName + "\n";
        }
        return result;
    }

    public static enum TaCWeaponDevModes {
        general("General"),
        reloads("Reloads"),
        projectile("Projectile"),
        display("Display"),
        flash("Flash"),
        zoom("Zoom"),
        scope("Scope"),
        barrel("Barrel"),
        oldScope("OldScope"),
        pistolScope("PistolScope"),
        pistolBarrel("PistolBarrel");

        private String tagName;

        public String getTagName() {
            return this.tagName;
        }

        private TaCWeaponDevModes(String name) {
            this.tagName = name;
        }
    }
}

