/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.render.gunskin;

import com.tac.guns.client.render.gunskin.DefaultSkin;
import com.tac.guns.client.render.model.CachedModel;
import com.tac.guns.client.render.model.GunComponent;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public class GunSkin {
    protected final Map<GunComponent, CachedModel> models = new HashMap<GunComponent, CachedModel>();
    public final ResourceLocation skinName;
    public final ResourceLocation gunItemRegistryName;
    protected ResourceLocation icon;
    protected ResourceLocation miniIcon;
    private DefaultSkin defaultSkin;

    public GunSkin(ResourceLocation skinName, ResourceLocation gunItemRegistryName, DefaultSkin skin) {
        this.skinName = skinName;
        this.gunItemRegistryName = gunItemRegistryName;
        this.defaultSkin = skin;
    }

    protected GunSkin(ResourceLocation skinName, ResourceLocation gunItemRegistryName) {
        this.skinName = skinName;
        this.gunItemRegistryName = gunItemRegistryName;
    }

    public void setDefaultSkin(DefaultSkin defaultSkin) {
        this.defaultSkin = defaultSkin;
    }

    @Nullable
    public CachedModel getModel(GunComponent component) {
        return this.models.getOrDefault(component, this.defaultSkin.getModel(component));
    }

    protected void addComponent(GunComponent component, CachedModel model) {
        this.models.put(component, model);
    }

    public Map<GunComponent, CachedModel> getModels() {
        return this.models;
    }

    @Nullable
    public ResourceLocation getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        return this.defaultSkin.getIcon();
    }

    public void setIcon(ResourceLocation icon) {
        this.icon = icon;
    }

    @Nullable
    public ResourceLocation getMiniIcon() {
        if (this.miniIcon != null) {
            return this.miniIcon;
        }
        return this.defaultSkin.getMiniIcon();
    }

    public void setMiniIcon(ResourceLocation miniIcon) {
        this.miniIcon = miniIcon;
    }

    public void cleanCache() {
        for (CachedModel model : this.models.values()) {
            model.cleanCache();
        }
    }
}

