/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.render.gunskin;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.tac.guns.client.render.gunskin.DefaultSkin;
import com.tac.guns.client.render.gunskin.GunSkin;
import com.tac.guns.client.render.model.CachedModel;
import com.tac.guns.client.render.model.GunComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.registries.RegistryObject;

public class SkinLoader {
    public static final Map<ResourceLocation, SkinLoader> skinLoaders = new HashMap<ResourceLocation, SkinLoader>();
    private DefaultSkin defaultSkin;
    public static UnbakedModel missingModel;
    public static Map<ResourceLocation, UnbakedModel> unbakedModels;
    public static Map<ResourceLocation, UnbakedModel> topUnbakedModels;
    private final List<GunComponent> components;
    private final ResourceLocation gunItemRegistryName;

    public SkinLoader(ResourceLocation gunItemRegistryName, GunComponent ... components) {
        this.components = Arrays.asList(components);
        this.gunItemRegistryName = gunItemRegistryName;
    }

    public SkinLoader(RegistryObject<?> gunItemRegistry, GunComponent ... components) {
        this(gunItemRegistry.getId(), components);
    }

    public List<GunComponent> getComponents() {
        return this.components;
    }

    public static void register(ResourceLocation gunItemRegistryName, SkinLoader loader) {
        skinLoaders.put(gunItemRegistryName, loader);
    }

    public static SkinLoader getSkinLoader(String gunItemRegistryName) {
        ResourceLocation rl = ResourceLocation.m_135820_((String)gunItemRegistryName);
        return skinLoaders.get(rl);
    }

    public static SkinLoader getSkinLoader(ResourceLocation gunItemRegistryName) {
        return skinLoaders.get(gunItemRegistryName);
    }

    public ResourceLocation getGun() {
        return this.gunItemRegistryName;
    }

    public DefaultSkin loadDefaultSkin() {
        DefaultSkin skin = new DefaultSkin(this.gunItemRegistryName);
        String mainLoc = this.gunItemRegistryName.m_135827_() + ":special/" + this.getGun().m_135815_();
        for (GunComponent key : this.components) {
            SkinLoader.tryLoadComponent((GunSkin)skin, mainLoc, key);
        }
        this.defaultSkin = skin;
        ResourceLocation iconLoc = ResourceLocation.m_135820_((String)(this.gunItemRegistryName.m_135827_() + ":textures/gui/icon/" + this.gunItemRegistryName.m_135815_() + ".png"));
        if (iconLoc != null && Minecraft.m_91087_().m_91098_().m_7165_(iconLoc)) {
            skin.setIcon(iconLoc);
        }
        ResourceLocation miniIconLoc = ResourceLocation.m_135820_((String)(this.gunItemRegistryName.m_135827_() + ":textures/gui/icon/mini/" + this.gunItemRegistryName.m_135815_() + ".png"));
        if (iconLoc != null && Minecraft.m_91087_().m_91098_().m_7165_(iconLoc)) {
            skin.setMiniIcon(miniIconLoc);
        }
        return skin;
    }

    public GunSkin loadCustomSkin(ResourceLocation skinName, Map<String, String> models) {
        if (this.defaultSkin == null) {
            return null;
        }
        GunSkin skin = new GunSkin(skinName, this.getGun());
        skin.setDefaultSkin(this.defaultSkin);
        if (models.containsKey("auto")) {
            String main = models.get("auto");
            for (GunComponent key : this.components) {
                SkinLoader.tryLoadComponent(skin, main, key);
            }
        } else {
            for (GunComponent key : this.components) {
                SkinLoader.tryLoadComponent(skin, models, key);
            }
        }
        return skin;
    }

    public boolean loadSkinIcon(@Nonnull GunSkin skin, @Nonnull ResourceLocation iconLocation) {
        if (Minecraft.m_91087_().m_91098_().m_7165_(iconLocation)) {
            skin.setIcon(iconLocation);
            return true;
        }
        ResourceLocation tl = ResourceLocation.m_135820_((String)(iconLocation.m_135827_() + ":textures/" + iconLocation.m_135815_() + ".png"));
        if (tl != null && Minecraft.m_91087_().m_91098_().m_7165_(tl)) {
            skin.setIcon(tl);
            return true;
        }
        return false;
    }

    public boolean loadSkinMiniIcon(@Nonnull GunSkin skin, @Nonnull ResourceLocation iconLocation) {
        if (Minecraft.m_91087_().m_91098_().m_7165_(iconLocation)) {
            skin.setIcon(iconLocation);
            return true;
        }
        ResourceLocation tl = ResourceLocation.m_135820_((String)(iconLocation.m_135827_() + ":textures/" + iconLocation.m_135815_() + ".png"));
        if (tl != null && Minecraft.m_91087_().m_91098_().m_7165_(tl)) {
            skin.setMiniIcon(tl);
            return true;
        }
        return false;
    }

    private static void tryLoadComponent(GunSkin skin, Map<String, String> models, GunComponent component) {
        ResourceLocation loc;
        if (models.containsKey(component.key) && (loc = ResourceLocation.m_135820_((String)models.get(component.key))) != null) {
            CachedModel mainModel = new CachedModel(loc);
            ForgeModelBakery.addSpecialModel((ResourceLocation)loc);
            skin.addComponent(component, mainModel);
        }
    }

    private static void tryLoadComponent(GunSkin skin, String mainLocation, GunComponent component) {
        ResourceLocation loc = component.getModelLocation(mainLocation);
        if (loc != null) {
            ResourceLocation test = new ResourceLocation(loc.m_135827_(), "models/" + loc.m_135815_() + ".json");
            if (Minecraft.m_91087_().m_91098_().m_7165_(test)) {
                CachedModel mainModel = new CachedModel(loc);
                ForgeModelBakery.addSpecialModel((ResourceLocation)loc);
                skin.addComponent(component, mainModel);
            }
        }
    }

    public GunSkin loadTextureOnlySkin(ResourceLocation skinName, List<Pair<String, ResourceLocation>> textures) {
        if (this.defaultSkin == null) {
            return null;
        }
        GunSkin skin = new GunSkin(skinName, this.getGun());
        skin.setDefaultSkin(this.defaultSkin);
        for (GunComponent component : this.components) {
            ResourceLocation parent = component.getModelLocation(this.gunItemRegistryName.m_135827_() + ":special/" + this.gunItemRegistryName.m_135815_());
            TextureModel model = TextureModel.tryCreateCopy(parent);
            if (model == null) continue;
            model.applyTextures(textures);
            ResourceLocation componentLoc = component.getModelLocation(skinName.m_135827_() + ":gunskin/generated/" + this.gunItemRegistryName.m_135827_() + this.gunItemRegistryName.m_135815_() + "_" + skinName.m_135815_());
            skin.addComponent(component, new CachedModel(componentLoc));
            unbakedModels.put(componentLoc, (UnbakedModel)model.getModel());
            topUnbakedModels.put(componentLoc, (UnbakedModel)model.getModel());
        }
        return skin;
    }

    public static class TextureModel {
        public static final ResourceLocation atlasLocation = new ResourceLocation("minecraft:textures/atlas/blocks.png");
        private final BlockModel unbaked;

        private TextureModel(BlockModel model) {
            this.unbaked = model;
        }

        public static TextureModel tryCreateCopy(ResourceLocation parentLocation) {
            TextureModel textureModel = null;
            if (ForgeModelBakery.instance() != null) {
                BlockModel parent = (BlockModel)ForgeModelBakery.instance().m_119341_(parentLocation);
                if (parent == missingModel) {
                    return null;
                }
                ArrayList list = Lists.newArrayList();
                HashMap map = Maps.newHashMap();
                BlockModel model = new BlockModel(parentLocation, (List)list, (Map)map, true, null, parent.m_111491_(), parent.m_111484_());
                textureModel = new TextureModel(model);
            }
            return textureModel;
        }

        public void applyTextures(List<Pair<String, ResourceLocation>> textures) {
            textures.forEach(p -> this.applyTexture((String)p.getFirst(), (ResourceLocation)p.getSecond()));
        }

        public void applyTexture(String key, ResourceLocation textureLocation) {
            this.unbaked.f_111417_.put(key, Either.left((Object)new Material(atlasLocation, textureLocation)));
        }

        public BlockModel getModel() {
            return this.unbaked;
        }
    }
}

