/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.render.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public class GunComponent
implements Comparable<GunComponent> {
    public final String key;
    public final String namespace;
    public String group;
    private static final HashMap<String, HashMap<String, GunComponent>> componentMap = new HashMap();

    public GunComponent(@Nullable String key) {
        this(key, key);
    }

    public GunComponent(@Nullable String key, @Nullable String group) {
        this(null, key, group);
    }

    public GunComponent(@Nullable String namespace, @Nullable String key, @Nullable String group) {
        this.key = key;
        this.namespace = namespace;
        this.group = group;
        componentMap.compute(namespace, (k, map) -> {
            if (map == null) {
                map = new HashMap<String, GunComponent>();
            }
            map.put(key, this);
            return map;
        });
    }

    public static GunComponent getComponent(@Nullable String namespace, @Nullable String key) {
        Map map = componentMap.get(namespace);
        if (map != null) {
            return (GunComponent)map.get(key);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o instanceof GunComponent) {
            GunComponent component = (GunComponent)o;
            return Objects.equals(this.key, component.key) && Objects.equals(this.namespace, component.namespace);
        }
        return false;
    }

    public int hashCode() {
        return (this.namespace == null ? 0 : this.namespace.hashCode()) * 31 + (this.key == null ? 0 : this.key.hashCode());
    }

    @Override
    public int compareTo(@Nonnull GunComponent o) {
        int r = this.namespace.compareTo(o.namespace);
        if (r != 0) {
            return r;
        }
        return this.key.compareTo(o.key);
    }

    @Nullable
    public ResourceLocation getModelLocation(String mainLocation) {
        return ResourceLocation.m_135820_((String)(mainLocation + (String)(this.key == null ? "" : "_" + this.key)));
    }

    @Nullable
    public ResourceLocation getModelLocation(ResourceLocation mainLocation) {
        return ResourceLocation.m_135820_((String)(mainLocation + (String)(this.key == null ? "" : "_" + this.key)));
    }
}

