/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.render.model.scope.scopeUtil;

import java.nio.ByteBuffer;
import org.lwjgl.opengl.GL30;

public class FrameBuffer {
    private int buffer;
    private int renderBuffer;
    private int width;
    private int height;
    private int[] textures;
    private int textureDepth;
    private final boolean hasRenderBuffer;
    private final boolean hasDepthTexture;
    boolean multipleTextures;

    public FrameBuffer(int width, int height, int textureCount, boolean hasRenderBuffer, boolean hasDepthTexture) {
        this.width = width;
        this.height = height;
        this.hasRenderBuffer = hasRenderBuffer;
        this.hasDepthTexture = hasDepthTexture;
        this.textures = new int[textureCount];
        this.delete();
        this.create();
    }

    public FrameBuffer(int width, int height) {
        this.width = width;
        this.height = height;
        this.hasRenderBuffer = false;
        this.hasDepthTexture = false;
        this.delete();
        this.create();
        this.init();
    }

    public void init() {
        this.bind(true);
        this.createTexture();
        GL30.glDrawBuffer((int)36064);
        this.checkComplete();
        if (this.hasRenderBuffer) {
            this.generateRenderBuffer();
        }
        if (this.hasDepthTexture) {
            this.createDepthTexture();
        }
    }

    public void resize(int width, int height) {
        this.width = width;
        this.height = height;
        this.deleteTextures();
    }

    public void create() {
        this.buffer = GL30.glGenFramebuffers();
    }

    public void bind(boolean viewport) {
        GL30.glBindFramebuffer((int)36160, (int)this.buffer);
        if (viewport) {
            GL30.glViewport((int)0, (int)0, (int)this.width, (int)this.height);
        }
    }

    public void unbind() {
        GL30.glBindFramebuffer((int)36160, (int)0);
    }

    private void createTexture() {
        int texture = GL30.glGenTextures();
        this.textures = new int[1];
        this.textures[0] = texture;
        GL30.glBindTexture((int)3553, (int)texture);
        GL30.glTexImage2D((int)3553, (int)0, (int)34842, (int)this.width, (int)this.height, (int)0, (int)6408, (int)5126, (ByteBuffer)null);
        GL30.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL30.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL30.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL30.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL30.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)texture, (int)0);
    }

    public void createTexture(int index, int textureFormat, int format, int type, int colorAttachment, int wrap, int filter) {
        int texture;
        this.textures[index] = texture = GL30.glGenTextures();
        GL30.glBindTexture((int)3553, (int)texture);
        GL30.glTexImage2D((int)3553, (int)0, (int)textureFormat, (int)this.width, (int)this.height, (int)0, (int)format, (int)type, (ByteBuffer)null);
        GL30.glTexParameteri((int)3553, (int)10240, (int)filter);
        GL30.glTexParameteri((int)3553, (int)10241, (int)filter);
        GL30.glTexParameteri((int)3553, (int)10242, (int)wrap);
        GL30.glTexParameteri((int)3553, (int)10243, (int)wrap);
        GL30.glFramebufferTexture2D((int)36160, (int)colorAttachment, (int)3553, (int)texture, (int)0);
    }

    public void setTexture(int texture, int colorAttachment) {
        GL30.glFramebufferTexture2D((int)36160, (int)colorAttachment, (int)3553, (int)texture, (int)0);
    }

    private void createDepthTexture() {
        this.textureDepth = GL30.glGenTextures();
        GL30.glBindTexture((int)3553, (int)this.textureDepth);
        GL30.glTexImage2D((int)3553, (int)0, (int)6402, (int)this.width, (int)this.height, (int)0, (int)6402, (int)5126, (ByteBuffer)null);
        GL30.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL30.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL30.glFramebufferTexture2D((int)36160, (int)36096, (int)3553, (int)this.textureDepth, (int)0);
    }

    private void generateRenderBuffer() {
        this.renderBuffer = GL30.glGenRenderbuffers();
        GL30.glBindRenderbuffer((int)36161, (int)this.renderBuffer);
        GL30.glRenderbufferStorage((int)36161, (int)6402, (int)this.width, (int)this.height);
        GL30.glFramebufferRenderbuffer((int)36160, (int)36096, (int)36161, (int)this.renderBuffer);
    }

    public void bindTexture(int index) {
        GL30.glBindTexture((int)3553, (int)this.textures[index]);
    }

    public void bindTexture() {
        GL30.glBindTexture((int)3553, (int)this.textures[0]);
    }

    public int getTexture(int index) {
        return this.textures[index];
    }

    public int getTexture() {
        return this.textures[0];
    }

    private void checkComplete() {
    }

    public void clear() {
        GL30.glClear((int)16640);
    }

    public void viewPort(int width, int height) {
        GL30.glViewport((int)0, (int)0, (int)width, (int)height);
    }

    public void delete() {
        this.deleteTextures();
        if (this.hasDepthTexture) {
            GL30.glDeleteTextures((int)this.textureDepth);
        }
        if (this.hasRenderBuffer) {
            GL30.glDeleteRenderbuffers((int)this.renderBuffer);
        }
        GL30.glDeleteFramebuffers((int)this.buffer);
    }

    private void deleteTextures() {
        if (this.textures != null) {
            for (int texture : this.textures) {
                GL30.glDeleteTextures((int)texture);
            }
        }
    }

    public void drawBuffer(int i) {
        GL30.glDrawBuffer((int)(36064 + i));
    }

    public int getBuffer() {
        return this.buffer;
    }

    public int getRenderBuffer() {
        return this.renderBuffer;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getTextureDepth() {
        return this.textureDepth;
    }
}

