/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.render.pose;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.tac.guns.Config;
import com.tac.guns.client.render.pose.AimPose;
import com.tac.guns.client.render.pose.LimbPose;
import com.tac.guns.client.render.pose.WeaponPose;
import com.tac.guns.common.GripType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MiniGunPose
extends WeaponPose {
    @Override
    protected AimPose getUpPose() {
        AimPose pose = new AimPose();
        pose.getIdle().setRenderYawOffset(45.0f).setItemRotation(new Vector3f(10.0f, 0.0f, 0.0f)).setRightArm(new LimbPose().setRotationAngleX(-100.0f).setRotationAngleY(-45.0f).setRotationAngleZ(0.0f).setRotationPointY(2.0f)).setLeftArm(new LimbPose().setRotationAngleX(-150.0f).setRotationAngleY(40.0f).setRotationAngleZ(-10.0f).setRotationPointY(1.0f));
        return pose;
    }

    @Override
    protected AimPose getForwardPose() {
        AimPose pose = new AimPose();
        pose.getIdle().setRenderYawOffset(45.0f).setRightArm(new LimbPose().setRotationAngleX(-15.0f).setRotationAngleY(-45.0f).setRotationAngleZ(0.0f).setRotationPointY(2.0f)).setLeftArm(new LimbPose().setRotationAngleX(-45.0f).setRotationAngleY(30.0f).setRotationAngleZ(0.0f).setRotationPointY(2.0f));
        return pose;
    }

    @Override
    protected AimPose getDownPose() {
        AimPose pose = new AimPose();
        pose.getIdle().setRenderYawOffset(45.0f).setItemRotation(new Vector3f(-50.0f, 0.0f, 0.0f)).setItemTranslate(new Vector3f(0.0f, 0.0f, 1.0f)).setRightArm(new LimbPose().setRotationAngleX(0.0f).setRotationAngleY(-45.0f).setRotationAngleZ(0.0f).setRotationPointY(1.0f)).setLeftArm(new LimbPose().setRotationAngleX(-25.0f).setRotationAngleY(30.0f).setRotationAngleZ(15.0f).setRotationPointY(4.0f));
        return pose;
    }

    @Override
    protected boolean hasAimPose() {
        return false;
    }

    @Override
    public void applyPlayerModelRotation(Player player, PlayerModel model, InteractionHand hand, float aimProgress) {
        if (((Boolean)Config.CLIENT.display.oldAnimations.get()).booleanValue()) {
            boolean right = Minecraft.m_91087_().f_91066_.f_92127_ == HumanoidArm.RIGHT ? hand == InteractionHand.MAIN_HAND : hand == InteractionHand.OFF_HAND;
            ModelPart mainArm = right ? model.f_102811_ : model.f_102812_;
            ModelPart secondaryArm = right ? model.f_102812_ : model.f_102811_;
            mainArm.f_104203_ = (float)Math.toRadians(-15.0);
            mainArm.f_104204_ = (float)Math.toRadians(-45.0) * (right ? 1.0f : -1.0f);
            mainArm.f_104205_ = (float)Math.toRadians(0.0);
            secondaryArm.f_104203_ = (float)Math.toRadians(-45.0);
            secondaryArm.f_104204_ = (float)Math.toRadians(30.0) * (right ? 1.0f : -1.0f);
            secondaryArm.f_104205_ = (float)Math.toRadians(0.0);
        } else {
            super.applyPlayerModelRotation(player, model, hand, aimProgress);
        }
    }

    @Override
    public void applyPlayerPreRender(Player player, InteractionHand hand, float aimProgress, PoseStack matrixStack, MultiBufferSource buffer) {
        if (((Boolean)Config.CLIENT.display.oldAnimations.get()).booleanValue()) {
            boolean right = Minecraft.m_91087_().f_91066_.f_92127_ == HumanoidArm.RIGHT ? hand == InteractionHand.MAIN_HAND : hand == InteractionHand.OFF_HAND;
            player.f_20884_ = player.f_19859_ + 45.0f * (right ? 1.0f : -1.0f);
            player.f_20883_ = player.m_146908_() + 45.0f * (right ? 1.0f : -1.0f);
        } else {
            super.applyPlayerPreRender(player, hand, aimProgress, matrixStack, buffer);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void applyHeldItemTransforms(Player player, InteractionHand hand, float aimProgress, PoseStack matrixStack, MultiBufferSource buffer) {
        if (((Boolean)Config.CLIENT.display.oldAnimations.get()).booleanValue()) {
            if (hand == InteractionHand.OFF_HAND) {
                matrixStack.m_85837_(0.0, -0.625, 0.0);
                matrixStack.m_85837_(0.0, 0.0, -0.125);
            }
        } else {
            super.applyHeldItemTransforms(player, hand, aimProgress, matrixStack, buffer);
        }
    }

    @Override
    public boolean applyOffhandTransforms(Player player, PlayerModel model, ItemStack stack, PoseStack matrixStack, float partialTicks) {
        return GripType.applyBackTransforms(player, matrixStack);
    }

    @Override
    public boolean canApplySprintingAnimation() {
        return false;
    }
}

