/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.render.pose;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.tac.guns.Config;
import com.tac.guns.client.handler.ReloadHandler;
import com.tac.guns.client.render.pose.AimPose;
import com.tac.guns.client.render.pose.LimbPose;
import com.tac.guns.client.render.pose.WeaponPose;
import com.tac.guns.client.util.RenderUtil;
import com.tac.guns.common.GripType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TwoHandedPose
extends WeaponPose {
    @Override
    protected AimPose getUpPose() {
        AimPose upPose = new AimPose();
        upPose.getIdle().setRenderYawOffset(45.0f).setItemRotation(new Vector3f(60.0f, 0.0f, 10.0f)).setRightArm(new LimbPose().setRotationAngleX(-120.0f).setRotationAngleY(-55.0f).setRotationPointX(-5.0f).setRotationPointY(3.0f).setRotationPointZ(0.0f)).setLeftArm(new LimbPose().setRotationAngleX(-160.0f).setRotationAngleY(-20.0f).setRotationAngleZ(-30.0f).setRotationPointY(2.0f).setRotationPointZ(-1.0f));
        upPose.getAiming().setRenderYawOffset(45.0f).setItemRotation(new Vector3f(40.0f, 0.0f, 30.0f)).setItemTranslate(new Vector3f(-1.0f, 0.0f, 0.0f)).setRightArm(new LimbPose().setRotationAngleX(-140.0f).setRotationAngleY(-55.0f).setRotationPointX(-5.0f).setRotationPointY(3.0f).setRotationPointZ(0.0f)).setLeftArm(new LimbPose().setRotationAngleX(-170.0f).setRotationAngleY(-20.0f).setRotationAngleZ(-35.0f).setRotationPointY(1.0f).setRotationPointZ(0.0f));
        return upPose;
    }

    @Override
    protected AimPose getForwardPose() {
        AimPose forwardPose = new AimPose();
        forwardPose.getIdle().setRenderYawOffset(45.0f).setItemRotation(new Vector3f(30.0f, -11.0f, 0.0f)).setRightArm(new LimbPose().setRotationAngleX(-60.0f).setRotationAngleY(-55.0f).setRotationAngleZ(0.0f).setRotationPointX(-5.0f).setRotationPointY(2.0f).setRotationPointZ(1.0f)).setLeftArm(new LimbPose().setRotationAngleX(-65.0f).setRotationAngleY(-10.0f).setRotationAngleZ(5.0f).setRotationPointY(2.0f).setRotationPointZ(-1.0f));
        forwardPose.getAiming().setRenderYawOffset(45.0f).setItemRotation(new Vector3f(5.0f, -21.0f, 0.0f)).setRightArm(new LimbPose().setRotationAngleX(-85.0f).setRotationAngleY(-65.0f).setRotationAngleZ(0.0f).setRotationPointX(-5.0f).setRotationPointY(2.0f)).setLeftArm(new LimbPose().setRotationAngleX(-90.0f).setRotationAngleY(-15.0f).setRotationAngleZ(0.0f).setRotationPointY(2.0f).setRotationPointZ(0.0f));
        return forwardPose;
    }

    @Override
    protected AimPose getDownPose() {
        AimPose downPose = new AimPose();
        downPose.getIdle().setRenderYawOffset(45.0f).setItemRotation(new Vector3f(-15.0f, -5.0f, 0.0f)).setItemTranslate(new Vector3f(0.0f, -0.5f, 0.5f)).setRightArm(new LimbPose().setRotationAngleX(-30.0f).setRotationAngleY(-65.0f).setRotationAngleZ(0.0f).setRotationPointX(-5.0f).setRotationPointY(2.0f)).setLeftArm(new LimbPose().setRotationAngleX(-5.0f).setRotationAngleY(-20.0f).setRotationAngleZ(20.0f).setRotationPointY(5.0f).setRotationPointZ(0.0f));
        downPose.getAiming().setRenderYawOffset(45.0f).setItemRotation(new Vector3f(-20.0f, -5.0f, -10.0f)).setItemTranslate(new Vector3f(0.0f, -0.5f, 1.0f)).setRightArm(new LimbPose().setRotationAngleX(-30.0f).setRotationAngleY(-65.0f).setRotationAngleZ(0.0f).setRotationPointX(-5.0f).setRotationPointY(1.0f)).setLeftArm(new LimbPose().setRotationAngleX(-10.0f).setRotationAngleY(-20.0f).setRotationAngleZ(30.0f).setRotationPointY(5.0f).setRotationPointZ(0.0f));
        return downPose;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void applyPlayerModelRotation(Player player, PlayerModel model, InteractionHand hand, float aimProgress) {
        if (((Boolean)Config.CLIENT.display.oldAnimations.get()).booleanValue()) {
            Minecraft mc = Minecraft.m_91087_();
            boolean right = mc.f_91066_.f_92127_ == HumanoidArm.RIGHT ? hand == InteractionHand.MAIN_HAND : hand == InteractionHand.OFF_HAND;
            ModelPart mainArm = right ? model.f_102811_ : model.f_102812_;
            ModelPart secondaryArm = right ? model.f_102812_ : model.f_102811_;
            mainArm.f_104203_ = model.f_102808_.f_104203_;
            mainArm.f_104204_ = model.f_102808_.f_104204_;
            mainArm.f_104205_ = model.f_102808_.f_104205_;
            secondaryArm.f_104203_ = model.f_102808_.f_104203_;
            secondaryArm.f_104204_ = model.f_102808_.f_104204_;
            secondaryArm.f_104205_ = model.f_102808_.f_104205_;
            mainArm.f_104203_ = (float)Math.toRadians(-55.0f + aimProgress * -30.0f);
            mainArm.f_104204_ = (float)Math.toRadians((-45.0f + aimProgress * -20.0f) * (right ? 1.0f : -1.0f));
            secondaryArm.f_104203_ = (float)Math.toRadians(-42.0f + aimProgress * -48.0f);
            secondaryArm.f_104204_ = (float)Math.toRadians((-15.0f + aimProgress * 5.0f) * (right ? 1.0f : -1.0f));
        } else {
            super.applyPlayerModelRotation(player, model, hand, aimProgress);
            float angle = this.getPlayerPitch(player);
            model.f_102808_.f_104203_ = (float)Math.toRadians((double)angle > 0.0 ? (double)(angle * 70.0f) : (double)(angle * 90.0f));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void applyPlayerPreRender(Player player, InteractionHand hand, float aimProgress, PoseStack matrixStack, MultiBufferSource buffer) {
        if (((Boolean)Config.CLIENT.display.oldAnimations.get()).booleanValue()) {
            boolean right = Minecraft.m_91087_().f_91066_.f_92127_ == HumanoidArm.RIGHT ? hand == InteractionHand.MAIN_HAND : hand == InteractionHand.OFF_HAND;
            player.f_20884_ = player.f_19859_ + (right ? 25.0f : -25.0f) + aimProgress * (right ? 20.0f : -20.0f);
            player.f_20883_ = player.m_146908_() + (right ? 25.0f : -25.0f) + aimProgress * (right ? 20.0f : -20.0f);
        } else {
            super.applyPlayerPreRender(player, hand, aimProgress, matrixStack, buffer);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void applyHeldItemTransforms(Player player, InteractionHand hand, float aimProgress, PoseStack matrixStack, MultiBufferSource buffer) {
        if (((Boolean)Config.CLIENT.display.oldAnimations.get()).booleanValue()) {
            if (hand == InteractionHand.MAIN_HAND) {
                boolean right = Minecraft.m_91087_().f_91066_.f_92127_ == HumanoidArm.RIGHT ? hand == InteractionHand.MAIN_HAND : hand == InteractionHand.OFF_HAND;
                matrixStack.m_85837_(0.0, 0.0, 0.05);
                float invertRealProgress = 1.0f - aimProgress;
                matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(25.0f * invertRealProgress * (right ? 1.0f : -1.0f)));
                matrixStack.m_85845_(Vector3f.f_122225_.m_122240_((30.0f * invertRealProgress + aimProgress * -20.0f) * (right ? 1.0f : -1.0f)));
                matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(25.0f * invertRealProgress + aimProgress * 5.0f));
            }
        } else {
            super.applyHeldItemTransforms(player, hand, aimProgress, matrixStack, buffer);
        }
    }

    @Override
    public void renderFirstPersonArms(LocalPlayer player, HumanoidArm hand, ItemStack stack, PoseStack matrixStack, MultiBufferSource buffer, int light, float partialTicks) {
        matrixStack.m_85837_(0.0, 0.0, -1.0);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        matrixStack.m_85836_();
        float reloadProgress = ReloadHandler.get().getReloadProgress(partialTicks, stack);
        matrixStack.m_85837_((double)reloadProgress * 0.5, (double)(-reloadProgress), (double)(-reloadProgress) * 0.5);
        int side = hand.m_20828_() == HumanoidArm.RIGHT ? 1 : -1;
        matrixStack.m_85837_((double)(6 * side) * 0.0625, -0.585, -0.5);
        if (Minecraft.m_91087_().f_91074_.m_108564_().equals("slim") && hand.m_20828_() == HumanoidArm.LEFT) {
            matrixStack.m_85837_((double)(0.03125f * (float)(-side)), 0.0, 0.0);
        }
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(80.0f));
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(15.0f * (float)(-side)));
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(15.0f * (float)(-side)));
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(-35.0f));
        matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        RenderUtil.renderFirstPersonArm(player, hand.m_20828_(), matrixStack, buffer, light);
        matrixStack.m_85849_();
        double centerOffset = 2.5;
        if (Minecraft.m_91087_().f_91074_.m_108564_().equals("slim")) {
            centerOffset += hand == HumanoidArm.RIGHT ? 0.2 : 0.8;
        }
        centerOffset = hand == HumanoidArm.RIGHT ? -centerOffset : centerOffset;
        matrixStack.m_85837_(centerOffset * 0.0625, -0.4, -0.975);
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(80.0f));
        matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        RenderUtil.renderFirstPersonArm(player, hand, matrixStack, buffer, light);
    }

    @Override
    public boolean applyOffhandTransforms(Player player, PlayerModel model, ItemStack stack, PoseStack matrixStack, float partialTicks) {
        return GripType.applyBackTransforms(player, matrixStack);
    }
}

