/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.common;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.tac.guns.client.render.IHeldAnimation;
import com.tac.guns.client.render.pose.BazookaPose;
import com.tac.guns.client.render.pose.MiniGunPose;
import com.tac.guns.client.render.pose.OneHandedPose;
import com.tac.guns.client.render.pose.TwoHandedPose;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;

public class GripType {
    public static final GripType ONE_HANDED = new GripType(new ResourceLocation("tac", "one_handed"), new OneHandedPose());
    public static final GripType TWO_HANDED = new GripType(new ResourceLocation("tac", "two_handed"), new TwoHandedPose());
    public static final GripType MINI_GUN = new GripType(new ResourceLocation("tac", "mini_gun"), new MiniGunPose());
    public static final GripType BAZOOKA = new GripType(new ResourceLocation("tac", "bazooka"), new BazookaPose());
    private static Map<ResourceLocation, GripType> gripTypeMap = new HashMap<ResourceLocation, GripType>();
    private final ResourceLocation id;
    private final IHeldAnimation heldAnimation;

    public static boolean applyBackTransforms(Player player, PoseStack matrixStack) {
        if (player.m_6844_(EquipmentSlot.CHEST).m_41720_() == Items.f_42741_) {
            return false;
        }
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        if (player.m_6047_()) {
            matrixStack.m_85837_(0.0, -0.4375, -0.25);
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(30.0f));
        } else {
            matrixStack.m_85837_(0.0, -0.3125, -0.125);
        }
        if (!player.m_6844_(EquipmentSlot.CHEST).m_41619_()) {
            matrixStack.m_85837_(0.0, 0.0, -0.0625);
        }
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(-45.0f));
        matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        return true;
    }

    public static void registerType(GripType type) {
        gripTypeMap.putIfAbsent(type.getId(), type);
    }

    public static GripType getType(ResourceLocation id) {
        return gripTypeMap.getOrDefault(id, ONE_HANDED);
    }

    public GripType(ResourceLocation id, IHeldAnimation heldAnimation) {
        this.id = id;
        this.heldAnimation = heldAnimation;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public IHeldAnimation getHeldAnimation() {
        return this.heldAnimation;
    }

    static {
        GripType.registerType(ONE_HANDED);
        GripType.registerType(TWO_HANDED);
        GripType.registerType(MINI_GUN);
        GripType.registerType(BAZOOKA);
    }
}

