/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.common;

import com.mrcrayfish.framework.common.data.SyncedEntityData;
import com.tac.guns.common.Gun;
import com.tac.guns.duck.PlayerWithSynData;
import com.tac.guns.init.ModSyncedDataKeys;
import com.tac.guns.inventory.gear.armor.ArmorRigCapabilityProvider;
import com.tac.guns.inventory.gear.armor.RigSlotsHandler;
import com.tac.guns.item.GunItem;
import com.tac.guns.item.transition.wearables.ArmorRigItem;
import com.tac.guns.network.PacketHandler;
import com.tac.guns.network.message.MessageGunSound;
import com.tac.guns.util.GunEnchantmentHelper;
import com.tac.guns.util.GunModifierHelper;
import com.tac.guns.util.WearableHelper;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="tac")
public class ReloadTracker {
    private static final Map<Player, ReloadTracker> RELOAD_TRACKER_MAP = new WeakHashMap<Player, ReloadTracker>();
    private final int startTick;
    private final int slot;
    private final ItemStack stack;
    private final Gun gun;

    private ReloadTracker(Player player) {
        this.startTick = player.f_19797_;
        this.slot = player.m_150109_().f_35977_;
        this.stack = player.m_150109_().m_36056_();
        this.gun = ((GunItem)this.stack.m_41720_()).getModifiedGun(this.stack);
    }

    private boolean isSameWeapon(Player player) {
        return !this.stack.m_41619_() && player.m_150109_().f_35977_ == this.slot && player.m_150109_().m_36056_() == this.stack;
    }

    private boolean isWeaponFull() {
        CompoundTag tag = this.stack.m_41784_();
        return tag.m_128451_("AmmoCount") >= GunModifierHelper.getAmmoCapacity(this.stack, this.gun);
    }

    private boolean isWeaponEmpty() {
        CompoundTag tag = this.stack.m_41784_();
        return tag.m_128451_("AmmoCount") == 0;
    }

    private boolean hasNoAmmo(Player player) {
        return Gun.findAmmo(player, this.gun.getProjectile().getItem()).length == 0 ? true : Gun.findAmmo(player, this.gun.getProjectile().getItem())[0].m_41619_();
    }

    private boolean canReload(Player player) {
        boolean reload;
        Gun gun = ((GunItem)this.stack.m_41720_()).getGun();
        ItemStack rig = WearableHelper.PlayerWornRig(player);
        if (gun.getReloads().isMagFed()) {
            int interval;
            int deltaTicks;
            reload = this.isWeaponEmpty() ? (deltaTicks = player.f_19797_ - this.startTick) > (interval = gun.getReloads().getReloadMagTimer() + gun.getReloads().getAdditionalReloadEmptyMagTimer() + this.gun.getReloads().getPreReloadPauseTicks()) : (deltaTicks = player.f_19797_ - this.startTick) > (interval = gun.getReloads().getReloadMagTimer() + this.gun.getReloads().getPreReloadPauseTicks());
        } else {
            int deltaTicks = player.f_19797_ - this.startTick;
            int interval = GunEnchantmentHelper.getReloadInterval(this.stack);
            reload = deltaTicks > 0 && deltaTicks % interval == 0;
        }
        return reload;
    }

    private void increaseAmmo(Player player) {
        ResourceLocation reloadSound;
        ItemStack ammo = Gun.findAmmo(player, this.gun.getProjectile().getItem())[0];
        if (!ammo.m_41619_()) {
            CompoundTag tag = this.stack.m_41783_();
            int amount = Math.min(ammo.m_41613_(), this.gun.getReloads().getReloadAmount());
            if (tag != null) {
                int maxAmmo = GunModifierHelper.getAmmoCapacity(this.stack, this.gun);
                amount = Math.min(amount, maxAmmo - tag.m_128451_("AmmoCount"));
                tag.m_128405_("AmmoCount", tag.m_128451_("AmmoCount") + amount);
            }
            this.shrinkFromAmmoPool(new ItemStack[]{ammo}, player, amount);
        }
        if ((reloadSound = this.gun.getSounds().getReload()) != null) {
            MessageGunSound message = new MessageGunSound(reloadSound, SoundSource.PLAYERS, (float)player.m_20185_(), (float)player.m_20186_() + 1.0f, (float)player.m_20189_(), 1.0f, 1.0f, player.m_142049_(), false, true);
            PacketHandler.getPlayChannel().send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), 16.0, player.f_19853_.m_46472_())), (Object)message);
        }
    }

    public static int calcMaxReserveAmmo(ItemStack[] ammoStacks) {
        int result = 0;
        for (ItemStack x : ammoStacks) {
            result += x.m_41613_();
        }
        return result;
    }

    private void shrinkFromAmmoPool(ItemStack[] ammoStacks, Player player, int shrinkAmount) {
        int max;
        int shrinkAmt = shrinkAmount;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ItemStack rig = WearableHelper.PlayerWornRig(player);
        if (!rig.m_41619_() && !player.m_7500_() && rig.m_41720_() instanceof ArmorRigItem) {
            RigSlotsHandler itemHandler = (RigSlotsHandler)rig.getCapability(ArmorRigCapabilityProvider.capability).resolve().get();
            for (ItemStack x : itemHandler.getStacks()) {
                if (!Gun.isAmmo(x, this.gun.getProjectile().getItem())) continue;
                stacks.add(x);
            }
            boolean flag = false;
            for (ItemStack x : stacks) {
                if (!x.m_41619_()) {
                    max = Math.min(shrinkAmt, x.m_41613_());
                    x.m_41774_(max);
                    shrinkAmt -= max;
                }
                if (shrinkAmt != 0) continue;
                flag = true;
                break;
            }
            ((PlayerWithSynData)player).updateRig();
            if (flag) {
                return;
            }
        }
        for (ItemStack x : ammoStacks) {
            if (!x.m_41619_()) {
                max = Math.min(shrinkAmt, x.m_41613_());
                x.m_41774_(max);
                shrinkAmt -= max;
            }
            if (shrinkAmt != 0) continue;
            return;
        }
    }

    private void increaseMagAmmo(Player player) {
        ResourceLocation reloadSound;
        ItemStack[] ammoStacks = Gun.findAmmo(player, this.gun.getProjectile().getItem());
        boolean stackItor = false;
        if (ammoStacks.length > 0) {
            CompoundTag tag = this.stack.m_41783_();
            int ammoAmount = Math.min(ReloadTracker.calcMaxReserveAmmo(ammoStacks), GunModifierHelper.getAmmoCapacity(this.stack, this.gun));
            if (tag != null) {
                int currentAmmo = tag.m_128451_("AmmoCount");
                int maxAmmo = GunModifierHelper.getAmmoCapacity(this.stack, this.gun);
                int amount = maxAmmo - currentAmmo;
                if (currentAmmo == 0 && !this.gun.getReloads().isOpenBolt()) {
                    if (ammoAmount < amount) {
                        tag.m_128405_("AmmoCount", currentAmmo + ammoAmount);
                        this.shrinkFromAmmoPool(ammoStacks, player, ammoAmount);
                    } else {
                        tag.m_128405_("AmmoCount", maxAmmo - 1);
                        this.shrinkFromAmmoPool(ammoStacks, player, amount - 1);
                    }
                } else if (ammoAmount < amount) {
                    tag.m_128405_("AmmoCount", currentAmmo + ammoAmount);
                    this.shrinkFromAmmoPool(ammoStacks, player, ammoAmount);
                } else {
                    tag.m_128405_("AmmoCount", maxAmmo);
                    this.shrinkFromAmmoPool(ammoStacks, player, amount);
                }
            }
        }
        if ((reloadSound = this.gun.getSounds().getReload()) != null) {
            MessageGunSound message = new MessageGunSound(reloadSound, SoundSource.PLAYERS, (float)player.m_20185_(), (float)player.m_20186_() + 1.0f, (float)player.m_20189_(), 1.0f, 1.0f, player.m_142049_(), false, true);
            PacketHandler.getPlayChannel().send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), 16.0, player.f_19853_.m_46472_())), (Object)message);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !event.player.f_19853_.f_46443_) {
            Player player = event.player;
            if (((Boolean)SyncedEntityData.instance().get((Entity)player, ModSyncedDataKeys.RELOADING)).booleanValue()) {
                ReloadTracker tracker;
                if (!RELOAD_TRACKER_MAP.containsKey(player)) {
                    if (!(player.m_150109_().m_36056_().m_41720_() instanceof GunItem)) {
                        SyncedEntityData.instance().set((Entity)player, ModSyncedDataKeys.RELOADING, (Object)false);
                        SyncedEntityData.instance().set((Entity)player, ModSyncedDataKeys.STOP_ANIMA, (Object)false);
                        return;
                    }
                    RELOAD_TRACKER_MAP.put(player, new ReloadTracker(player));
                }
                if (!(tracker = RELOAD_TRACKER_MAP.get(player)).isSameWeapon(player) || tracker.isWeaponFull() || tracker.hasNoAmmo(player)) {
                    RELOAD_TRACKER_MAP.remove(player);
                    SyncedEntityData.instance().set((Entity)player, ModSyncedDataKeys.RELOADING, (Object)false);
                    SyncedEntityData.instance().set((Entity)player, ModSyncedDataKeys.STOP_ANIMA, (Object)true);
                    return;
                }
                if (tracker.canReload(player)) {
                    Player finalPlayer = player;
                    Gun gun = tracker.gun;
                    if (gun.getReloads().isMagFed()) {
                        tracker.increaseMagAmmo(player);
                        RELOAD_TRACKER_MAP.remove(player);
                        SyncedEntityData.instance().set((Entity)player, ModSyncedDataKeys.RELOADING, (Object)false);
                        SyncedEntityData.instance().set((Entity)player, ModSyncedDataKeys.STOP_ANIMA, (Object)false);
                    } else {
                        tracker.increaseAmmo(player);
                        if (tracker.isWeaponFull() || tracker.hasNoAmmo(player)) {
                            RELOAD_TRACKER_MAP.remove(player);
                            SyncedEntityData.instance().set((Entity)player, ModSyncedDataKeys.RELOADING, (Object)false);
                            SyncedEntityData.instance().set((Entity)player, ModSyncedDataKeys.STOP_ANIMA, (Object)false);
                        }
                    }
                }
            } else if (RELOAD_TRACKER_MAP.containsKey(player)) {
                RELOAD_TRACKER_MAP.remove(player);
            }
        }
    }

    public static boolean isPlayerReload(Player player) {
        return RELOAD_TRACKER_MAP.containsKey(player);
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerEvent.PlayerLoggedOutEvent event) {
        MinecraftServer server = event.getPlayer().m_20194_();
        if (server != null) {
            server.execute(() -> RELOAD_TRACKER_MAP.remove(event.getPlayer()));
        }
    }
}

