/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.entity;

import com.mrcrayfish.framework.common.data.SyncedEntityData;
import com.tac.guns.Config;
import com.tac.guns.common.AimingManager;
import com.tac.guns.common.BoundingBoxManager;
import com.tac.guns.common.Gun;
import com.tac.guns.common.SpreadTracker;
import com.tac.guns.entity.DamageSourceProjectile;
import com.tac.guns.event.LevelUpEvent;
import com.tac.guns.init.ModEnchantments;
import com.tac.guns.init.ModSyncedDataKeys;
import com.tac.guns.interfaces.IDamageable;
import com.tac.guns.interfaces.IExplosionDamageable;
import com.tac.guns.interfaces.IHeadshotBox;
import com.tac.guns.item.GunItem;
import com.tac.guns.item.transition.TimelessGunItem;
import com.tac.guns.network.PacketHandler;
import com.tac.guns.network.message.MessageBlood;
import com.tac.guns.network.message.MessagePlayerShake;
import com.tac.guns.network.message.MessageProjectileHitBlock;
import com.tac.guns.network.message.MessageProjectileHitEntity;
import com.tac.guns.network.message.MessageRemoveProjectile;
import com.tac.guns.util.BufferUtil;
import com.tac.guns.util.GunEnchantmentHelper;
import com.tac.guns.util.GunModifierHelper;
import com.tac.guns.util.WearableHelper;
import com.tac.guns.util.math.ExtendedEntityRayTraceResult;
import com.tac.guns.world.ProjectileExplosion;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class ProjectileEntity
extends Entity
implements IEntityAdditionalSpawnData {
    private static final Predicate<Entity> PROJECTILE_TARGETS = input -> input != null && input.m_6087_() && !input.m_5833_();
    private static final Predicate<BlockState> IGNORE_LEAVES = input -> input != null && (Boolean)Config.COMMON.gameplay.ignoreLeaves.get() != false && input.m_60734_() instanceof LeavesBlock;
    protected int shooterId;
    protected LivingEntity shooter;
    protected Gun modifiedGun;
    protected Gun.General general;
    protected Gun.Projectile projectile;
    private ItemStack weapon = ItemStack.f_41583_;
    private ItemStack item = ItemStack.f_41583_;
    protected float additionalDamage = 0.0f;
    protected EntityDimensions entitySize;
    public double modifiedGravity;
    public int life;
    protected Vec3 startPos;

    public ProjectileEntity(EntityType<? extends Entity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public ProjectileEntity(EntityType<? extends Entity> entityType, Level worldIn, LivingEntity shooter, ItemStack weapon, GunItem item, Gun modifiedGun, float randP, float randY) {
        this(entityType, worldIn);
        this.shooterId = shooter.m_142049_();
        this.shooter = shooter;
        this.modifiedGun = modifiedGun;
        this.general = modifiedGun.getGeneral();
        this.projectile = modifiedGun.getProjectile();
        this.entitySize = new EntityDimensions(this.projectile.getSize(), this.projectile.getSize(), false);
        this.modifiedGravity = modifiedGun.getProjectile().isGravity() ? GunModifierHelper.getModifiedProjectileGravity(weapon, -0.0285) : 0.0;
        this.life = GunModifierHelper.getModifiedProjectileLife(weapon, this.projectile.getLife());
        Vec3 dir = this.getDirection(shooter, weapon, item, modifiedGun);
        double speedModifier = GunEnchantmentHelper.getProjectileSpeedModifier(weapon);
        double speed = GunModifierHelper.getModifiedProjectileSpeed(weapon, this.projectile.getSpeed() * speedModifier);
        this.m_20334_(dir.f_82479_ * speed, dir.f_82480_ * speed, dir.f_82481_ * speed);
        this.updateHeading();
        double posX = shooter.f_19790_ + (shooter.m_20185_() - shooter.f_19790_) / 2.0;
        double posY = shooter.f_19791_ + (shooter.m_20186_() - shooter.f_19791_) / 2.0 + (double)shooter.m_20192_();
        double posZ = shooter.f_19792_ + (shooter.m_20189_() - shooter.f_19792_) / 2.0;
        this.m_6034_(posX, posY, posZ);
        Item ammo = (Item)ForgeRegistries.ITEMS.getValue(this.projectile.getItem());
        if (ammo != null) {
            ItemStack model;
            int customModelData = -1;
            if (weapon.m_41783_() != null && weapon.m_41783_().m_128425_("Model", 10) && (model = ItemStack.m_41712_((CompoundTag)weapon.m_41783_().m_128469_("Model"))).m_41783_() != null && model.m_41783_().m_128441_("CustomModelData")) {
                customModelData = model.m_41783_().m_128451_("CustomModelData");
            }
            ItemStack ammoStack = new ItemStack((ItemLike)ammo);
            if (customModelData != -1) {
                ammoStack.m_41784_().m_128405_("CustomModelData", customModelData);
            }
            this.item = ammoStack;
        }
    }

    protected void m_8097_() {
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.entitySize;
    }

    private Vec3 getDirection(LivingEntity shooter, ItemStack weapon, GunItem item, Gun modifiedGun) {
        float gunSpread = GunModifierHelper.getModifiedSpread(weapon, modifiedGun.getGeneral().getSpread()) * GunEnchantmentHelper.getSpreadModifier(weapon);
        if (gunSpread == 0.0f) {
            return this.getVectorFromRotation(shooter.m_146909_(), shooter.m_146908_());
        }
        if (shooter instanceof Player) {
            AimingManager.AimTracker tracker;
            if (!modifiedGun.getGeneral().isAlwaysSpread()) {
                float modSpread = SpreadTracker.get((Player)shooter).getSpread(item);
                if (modSpread != 0.0f) {
                    gunSpread *= SpreadTracker.get((Player)shooter).getSpread(item);
                } else {
                    gunSpread = modifiedGun.getGeneral().getFirstShotSpread();
                    gunSpread = GunModifierHelper.getModifiedFirstShotSpread(weapon, gunSpread);
                }
            }
            if ((tracker = AimingManager.get().getAimTracker((Player)shooter)) == null || tracker.getLerpProgress() < (double)0.95f) {
                if ((double)gunSpread < 0.5) {
                    gunSpread += 0.5f;
                }
                gunSpread *= modifiedGun.getGeneral().getHipFireInaccuracy();
                gunSpread = GunModifierHelper.getModifiedHipFireSpread(weapon, gunSpread);
                if (((Float)SyncedEntityData.instance().get((Entity)((Player)shooter), ModSyncedDataKeys.MOVING)).floatValue() != 0.0f) {
                    gunSpread *= Math.max(1.0f, 2.0f * (1.0f + ((Float)SyncedEntityData.instance().get((Entity)((Player)shooter), ModSyncedDataKeys.MOVING)).floatValue()) * modifiedGun.getGeneral().getMovementInaccuracy());
                }
            }
            if (((Player)shooter).m_6047_() && modifiedGun.getGeneral().getProjectileAmount() == 1) {
                gunSpread *= 0.75f;
            }
        }
        return this.getVectorFromRotation(shooter.m_146909_() - gunSpread / 2.0f + this.f_19796_.nextFloat() * gunSpread, shooter.m_146908_() - gunSpread / 2.0f + this.f_19796_.nextFloat() * gunSpread);
    }

    public void setWeapon(ItemStack weapon) {
        this.weapon = weapon.m_41777_();
    }

    public ItemStack getWeapon() {
        return this.weapon;
    }

    public void setItem(ItemStack item) {
        this.item = item;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void setAdditionalDamage(float additionalDamage) {
        this.additionalDamage = additionalDamage;
    }

    public double getModifiedGravity() {
        return this.modifiedGravity;
    }

    public void m_8119_() {
        super.m_8119_();
        this.updateHeading();
        this.onProjectileTick();
        if (!this.f_19853_.m_5776_()) {
            Object result;
            Vec3 startVec = this.m_20182_();
            if (this.f_19797_ < 1) {
                this.startPos = startVec;
            }
            Vec3 endVec = startVec.m_82549_(this.m_20184_());
            BlockHitResult resultB = result = ProjectileEntity.rayTraceBlocks(this.f_19853_, new ClipContext(startVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this), IGNORE_LEAVES);
            BlockState blockState = this.f_19853_.m_8055_(resultB.m_82425_());
            if (resultB.m_6662_() != HitResult.Type.MISS) {
                endVec = resultB.m_82450_();
            }
            List<EntityResult> hitEntities = null;
            int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.COLLATERAL.get()), (ItemStack)this.weapon);
            if (level == 0) {
                EntityResult entityResult = this.findEntityOnPath(startVec, endVec);
                if (entityResult != null) {
                    hitEntities = Collections.singletonList(entityResult);
                }
            } else {
                hitEntities = this.findEntitiesOnPath(startVec, endVec);
            }
            if (hitEntities != null && hitEntities.size() > 0) {
                for (EntityResult entityResult : hitEntities) {
                    result = new ExtendedEntityRayTraceResult(entityResult);
                    if (((EntityHitResult)result).m_82443_() instanceof Player) {
                        Player player = (Player)((EntityHitResult)result).m_82443_();
                        if (this.shooter instanceof Player && !((Player)this.shooter).m_7099_(player) && !((Boolean)Config.COMMON.development.bulletSelfHarm.get()).booleanValue()) {
                            result = null;
                        }
                    }
                    if (result == null) continue;
                    this.onHit((HitResult)result, startVec, endVec);
                }
            } else {
                this.onHit((HitResult)result, startVec, endVec);
            }
        }
        double nextPosX = this.m_20185_() + this.m_20184_().m_7096_();
        double nextPosY = this.m_20186_() + this.m_20184_().m_7098_();
        double nextPosZ = this.m_20189_() + this.m_20184_().m_7094_();
        this.m_6034_(nextPosX, nextPosY, nextPosZ);
        if (this.projectile.isGravity()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, this.modifiedGravity, 0.0));
        }
        if (this.f_19797_ >= this.life) {
            if (this.m_6084_()) {
                this.onExpired();
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void onProjectileTick() {
    }

    protected void onExpired() {
    }

    @Nullable
    protected EntityResult findEntityOnPath(Vec3 startVec, Vec3 endVec) {
        Vec3 hitVec = null;
        Entity hitEntity = null;
        boolean headshot = false;
        List entities = this.f_19853_.m_6249_((Entity)this, this.m_142469_().m_82369_(this.m_20184_()).m_82400_(1.0), PROJECTILE_TARGETS);
        double closestDistance = Double.MAX_VALUE;
        for (Entity entity : entities) {
            Vec3 hitPos;
            double distanceToHit;
            EntityResult result;
            if (entity.equals((Object)this.shooter) && !((Boolean)Config.COMMON.development.bulletSelfHarm.get()).booleanValue() || (result = this.getHitResult(entity, startVec, endVec)) == null || !((distanceToHit = startVec.m_82554_(hitPos = result.getHitPos())) < closestDistance)) continue;
            hitVec = hitPos;
            hitEntity = entity;
            closestDistance = distanceToHit;
            headshot = result.isHeadshot();
        }
        return hitEntity != null ? new EntityResult(hitEntity, hitVec, headshot) : null;
    }

    @Nullable
    protected List<EntityResult> findEntitiesOnPath(Vec3 startVec, Vec3 endVec) {
        ArrayList<EntityResult> hitEntities = new ArrayList<EntityResult>();
        List entities = this.f_19853_.m_6249_((Entity)this, this.m_142469_().m_82369_(this.m_20184_()).m_82400_(1.0), PROJECTILE_TARGETS);
        for (Entity entity : entities) {
            EntityResult result;
            if (entity.equals((Object)this.shooter) && !((Boolean)Config.COMMON.development.bulletSelfHarm.get()).booleanValue() || (result = this.getHitResult(entity, startVec, endVec)) == null) continue;
            hitEntities.add(result);
        }
        return hitEntities;
    }

    @Nullable
    private EntityResult getHitResult(Entity entity, Vec3 startVec, Vec3 endVec) {
        AABB box;
        IHeadshotBox<LivingEntity> headshotBox;
        double expandHeight = entity instanceof Player && !entity.m_6047_() ? 0.0625 : 0.0;
        AABB boundingBox = entity.m_142469_();
        if (((Boolean)Config.COMMON.gameplay.improvedHitboxes.get()).booleanValue() && entity instanceof ServerPlayer && this.shooter != null) {
            int ping = (int)Math.floor((double)((ServerPlayer)this.shooter).f_8943_ / 1000.0 * 20.0 + 0.5);
            boundingBox = BoundingBoxManager.getBoundingBox((Player)entity, ping);
        }
        boundingBox = boundingBox.m_82363_(0.0, expandHeight, 0.0);
        Vec3 hitPos = boundingBox.m_82371_(startVec, endVec).orElse(null);
        Vec3 grownHitPos = boundingBox.m_82377_(((Double)Config.COMMON.gameplay.growBoundingBoxAmountV2.get()).doubleValue(), 0.0, ((Double)Config.COMMON.gameplay.growBoundingBoxAmountV2.get()).doubleValue()).m_82371_(startVec, endVec).orElse(null);
        if (hitPos == null && grownHitPos != null) {
            BlockHitResult raytraceresult = ProjectileEntity.rayTraceBlocks(this.f_19853_, new ClipContext(startVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this), IGNORE_LEAVES);
            BlockHitResult resultB = raytraceresult;
            BlockState blockState = this.f_19853_.m_8055_(resultB.m_82425_());
            if (blockState.m_60767_() == Material.f_76272_) {
                Predicate<BlockState> IGNORE_BLOCK = input -> input != null && input.m_60734_().equals(blockState.m_60734_());
                BlockHitResult result2 = ProjectileEntity.rayTraceBlocks(this.f_19853_, new ClipContext(startVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this), IGNORE_BLOCK);
                if (result2.m_6662_() != HitResult.Type.MISS) {
                    endVec = result2.m_82450_();
                }
                if (raytraceresult.m_6662_() == HitResult.Type.BLOCK) {
                    return null;
                }
            } else if (raytraceresult.m_6662_() == HitResult.Type.BLOCK) {
                return null;
            }
            hitPos = grownHitPos;
        }
        boolean headshot = false;
        if (((Boolean)Config.COMMON.gameplay.enableHeadShots.get()).booleanValue() && entity instanceof LivingEntity && (headshotBox = BoundingBoxManager.getHeadshotBoxes(entity.m_6095_())) != null && (box = headshotBox.getHeadshotBox((LivingEntity)entity)) != null) {
            Optional headshotHitPos = (box = box.m_82386_(boundingBox.m_82399_().f_82479_, boundingBox.f_82289_, boundingBox.m_82399_().f_82481_)).m_82371_(startVec, endVec);
            if (!headshotHitPos.isPresent()) {
                box = box.m_82377_(((Double)Config.COMMON.gameplay.growBoundingBoxAmountV2.get()).doubleValue(), 0.0, ((Double)Config.COMMON.gameplay.growBoundingBoxAmountV2.get()).doubleValue());
                headshotHitPos = box.m_82371_(startVec, endVec);
            }
            if (headshotHitPos.isPresent() && (hitPos == null || ((Vec3)headshotHitPos.get()).m_82554_(hitPos) < 0.5)) {
                hitPos = (Vec3)headshotHitPos.get();
                headshot = true;
            }
        }
        if (hitPos == null) {
            return null;
        }
        return new EntityResult(entity, hitPos, headshot);
    }

    private void onHit(HitResult result, Vec3 startVec, Vec3 endVec) {
        if (this.modifiedGun == null) {
            return;
        }
        if (result instanceof BlockHitResult) {
            BlockPos offsetPos;
            int fireStarterLevel;
            BlockHitResult blockRayTraceResult = (BlockHitResult)result;
            if (blockRayTraceResult.m_6662_() == HitResult.Type.MISS) {
                return;
            }
            Vec3 hitVec = result.m_82450_();
            BlockPos pos = blockRayTraceResult.m_82425_();
            BlockState state = this.f_19853_.m_8055_(pos);
            Block block = state.m_60734_();
            if (Objects.requireNonNull(block.getRegistryName()).m_135815_().contains("_button")) {
                return;
            }
            if (((Boolean)Config.COMMON.gameplay.enableGunGriefing.get()).booleanValue() && (block instanceof HalfTransparentBlock || block instanceof IronBarsBlock) && state.m_60767_() == Material.f_76275_) {
                this.f_19853_.m_46953_(blockRayTraceResult.m_82425_(), ((Boolean)Config.COMMON.gameplay.glassDrop.get()).booleanValue(), (Entity)this.shooter);
            }
            if (block instanceof IDamageable) {
                ((IDamageable)block).onBlockDamaged(this.f_19853_, state, pos, this, this.getDamage(), (int)Math.ceil((double)this.getDamage() / 2.0) + 1);
            }
            this.onHitBlock(state, pos, blockRayTraceResult.m_82434_(), hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_);
            if (block instanceof BellBlock) {
                BellBlock bell = (BellBlock)block;
                bell.m_49712_(this.f_19853_, pos, blockRayTraceResult.m_82434_());
            }
            if ((fireStarterLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.FIRE_STARTER.get()), (ItemStack)this.weapon)) > 0 && ((Boolean)Config.COMMON.gameplay.enableGunGriefing.get()).booleanValue() && BaseFireBlock.m_49255_((Level)this.f_19853_, (BlockPos)(offsetPos = pos.m_142300_(blockRayTraceResult.m_82434_())), (Direction)blockRayTraceResult.m_82434_())) {
                BlockState fireState = BaseFireBlock.m_49245_((BlockGetter)this.f_19853_, (BlockPos)offsetPos);
                this.f_19853_.m_7731_(offsetPos, fireState, 11);
                ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123756_, hitVec.f_82479_ - 1.0 + this.f_19796_.nextDouble() * 2.0, hitVec.f_82480_, hitVec.f_82481_ - 1.0 + this.f_19796_.nextDouble() * 2.0, 4, 0.0, 0.0, 0.0, 0.0);
            }
            return;
        }
        if (result instanceof ExtendedEntityRayTraceResult) {
            ExtendedEntityRayTraceResult entityRayTraceResult = (ExtendedEntityRayTraceResult)result;
            Entity entity = entityRayTraceResult.m_82443_();
            if (entity.m_142049_() == this.shooterId && !((Boolean)Config.COMMON.development.bulletSelfHarm.get()).booleanValue()) {
                return;
            }
            int fireStarterLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.FIRE_STARTER.get()), (ItemStack)this.weapon);
            if (fireStarterLevel > 0) {
                entity.m_20254_(2);
            }
            if (!entity.m_6084_()) {
                entity.f_19802_ = 0;
            } else if (entity.m_6084_()) {
                this.onHitEntity(entity, result.m_82450_(), startVec, endVec, entityRayTraceResult.isHeadshot());
                int collateralLevel = EnchantmentHelper.m_44836_((Enchantment)((Enchantment)ModEnchantments.COLLATERAL.get()), (LivingEntity)this.shooter);
                if (collateralLevel == 0) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                }
                entity.f_19802_ = 0;
            }
        }
    }

    protected void onHitEntity(Entity entity, Vec3 hitVec, Vec3 startVec, Vec3 endVec, boolean headshot) {
        float newDamage;
        float damage = this.getDamage(hitVec);
        boolean critical = damage != (newDamage = this.getCriticalDamage(this.weapon, this.f_19796_, damage));
        damage = newDamage;
        if (headshot) {
            if ((Double)Config.COMMON.gameplay.headShotDamageMultiplier.get() * (double)this.projectile.getGunHeadDamage() >= 0.0) {
                damage *= (float)((Double)Config.COMMON.gameplay.headShotDamageMultiplier.get() * (double)this.projectile.getGunHeadDamage());
            }
            damage += GunModifierHelper.getAdditionalHeadshotDamage(this.weapon) == 0.0f ? 1.0f : GunModifierHelper.getAdditionalHeadshotDamage(this.weapon);
        }
        DamageSource source = new DamageSourceProjectile("bullet", this, (Entity)this.shooter, this.weapon).m_19366_();
        if (entity instanceof Player && !WearableHelper.PlayerWornRig((Player)entity).m_41619_()) {
            if (!WearableHelper.tickFromCurrentDurability((Player)entity, this)) {
                PacketHandler.getPlayChannel().sendTo((Object)new MessagePlayerShake((LivingEntity)((Player)entity)), ((ServerPlayer)entity).f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
            } else {
                this.tac_attackEntity(source, entity, damage);
            }
        } else {
            this.tac_attackEntity(source, entity, damage);
        }
        if (this.shooter instanceof Player) {
            int hitType = critical ? 2 : (headshot ? 1 : 0);
            this.updateWeaponLevels(damage);
            PacketHandler.getPlayChannel().send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.shooter), (Object)new MessageProjectileHitEntity(hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_, hitType, entity instanceof Player));
        }
        PacketHandler.getPlayChannel().send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new MessageBlood(hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_));
    }

    private void tac_attackWithBluntDamage(DamageSource source, Entity entity, float damage) {
        entity.m_6469_(source, damage * this.modifiedGun.getProjectile().getBluntDamagePercentage());
    }

    private void tac_attackEntity(DamageSource source, Entity entity, float damage) {
        if (((Boolean)Config.COMMON.gameplay.bulletsIgnoreStandardArmor.get()).booleanValue()) {
            float damageToMcArmor = 0.0f;
            if ((Double)Config.COMMON.gameplay.percentDamageIgnoresStandardArmor.get() * (double)this.projectile.getGunArmorIgnore() <= 1.0) {
                damageToMcArmor = (float)((double)damage * (1.0 - (Double)Config.COMMON.gameplay.percentDamageIgnoresStandardArmor.get() * (double)this.projectile.getGunArmorIgnore()));
                entity.m_6469_(source, damageToMcArmor);
            }
            entity.f_19802_ = 0;
            source.m_19380_();
            source.m_19382_();
            if ((Double)Config.COMMON.gameplay.percentDamageIgnoresStandardArmor.get() * (double)this.projectile.getGunArmorIgnore() > 0.0) {
                entity.m_6469_(source, damage - damageToMcArmor);
            }
        } else {
            entity.m_6469_(source, damage);
        }
    }

    protected void updateWeaponLevels(float damage) {
        ItemStack gunStack = this.shooter.m_21205_();
        if (!(gunStack.m_41720_() instanceof GunItem) || gunStack.m_41783_() == null) {
            return;
        }
        if (gunStack.m_41783_().m_128423_("levelDmg") != null) {
            gunStack.m_41783_().m_128350_("levelDmg", gunStack.m_41783_().m_128457_("levelDmg") + damage);
        }
        if (gunStack.m_41783_().m_128423_("level") != null) {
            TimelessGunItem gunItem = (TimelessGunItem)gunStack.m_41720_();
            if ((double)gunStack.m_41783_().m_128457_("levelDmg") > (double)gunItem.getGun().getGeneral().getLevelReq() * ((double)gunStack.m_41783_().m_128451_("level") * 3.0)) {
                gunStack.m_41783_().m_128350_("levelDmg", 0.0f);
                gunStack.m_41783_().m_128405_("level", gunStack.m_41783_().m_128451_("level") + 1);
                MinecraftForge.EVENT_BUS.post((Event)new LevelUpEvent.Post((Player)this.shooter, gunStack));
            }
        }
    }

    protected void onHitBlock(BlockState state, BlockPos pos, Direction face, double x, double y, double z) {
        PacketHandler.getPlayChannel().send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_19853_.m_46745_(pos)), (Object)new MessageProjectileHitBlock(x, y, z, pos, face));
        if (EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.FIRE_STARTER.get()), (ItemStack)this.weapon) > 0) {
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123756_, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    protected void teleportToHitPoint(HitResult rayTraceResult) {
        Vec3 hitResult = rayTraceResult.m_82450_();
        this.m_6034_(hitResult.f_82479_, hitResult.f_82480_, hitResult.f_82481_);
    }

    public void m_7378_(CompoundTag compound) {
        this.projectile = new Gun.Projectile();
        this.projectile.deserializeNBT(compound.m_128469_("Projectile"));
        this.general = new Gun.General();
        this.general.deserializeNBT(compound.m_128469_("General"));
        this.modifiedGravity = compound.m_128459_("ModifiedGravity");
        this.life = compound.m_128451_("MaxLife");
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128365_("Projectile", (Tag)this.projectile.serializeNBT());
        compound.m_128365_("General", (Tag)this.general.serializeNBT());
        compound.m_128347_("ModifiedGravity", this.modifiedGravity);
        compound.m_128405_("MaxLife", this.life);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130079_(this.projectile.serializeNBT());
        buffer.m_130079_(this.general.serializeNBT());
        buffer.writeInt(this.shooterId);
        BufferUtil.writeItemStackToBufIgnoreTag((ByteBuf)buffer, this.item);
        buffer.writeDouble(this.modifiedGravity);
        buffer.m_130130_(this.life);
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        this.projectile = new Gun.Projectile();
        this.projectile.deserializeNBT(buffer.m_130260_());
        this.general = new Gun.General();
        this.general.deserializeNBT(buffer.m_130260_());
        this.shooterId = buffer.readInt();
        this.item = BufferUtil.readItemStackFromBufIgnoreTag((ByteBuf)buffer);
        this.modifiedGravity = buffer.readDouble();
        this.life = buffer.m_130242_();
        this.entitySize = new EntityDimensions(this.projectile.getSize(), this.projectile.getSize(), false);
    }

    public void updateHeading() {
        float f = Mth.m_14116_((float)((float)(this.m_20184_().m_7096_() * this.m_20184_().m_7096_() + this.m_20184_().m_7094_() * this.m_20184_().m_7094_())));
        this.m_146922_((float)(Mth.m_14136_((double)this.m_20184_().m_7096_(), (double)this.m_20184_().m_7094_()) * 57.29577951308232));
        this.m_146926_((float)(Mth.m_14136_((double)this.m_20184_().m_7098_(), (double)f) * 57.29577951308232));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    public Gun.Projectile getProjectile() {
        return this.projectile;
    }

    private Vec3 getVectorFromRotation(float pitch, float yaw) {
        float f = Mth.m_14089_((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = Mth.m_14031_((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -Mth.m_14089_((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = Mth.m_14031_((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    public LivingEntity getShooter() {
        return this.shooter;
    }

    public int getShooterId() {
        return this.shooterId;
    }

    public float getDamage(Vec3 hitVec) {
        float initialDamage = this.projectile.getDamage() + this.additionalDamage;
        double maxDistance = (double)this.projectile.getLife() * this.projectile.getSpeed();
        double projDistance = hitVec.m_82554_(this.startPos);
        if (this.projectile.isDamageReduceOverLife()) {
            float modifier;
            if (projDistance <= Math.min(Math.min(this.projectile.getSpeed() / 10.0, maxDistance / 100.0), 2.0)) {
                modifier = this.projectile.getGunCloseDamage() > 1.0f ? this.projectile.getGunCloseDamage() : 1.0f;
            } else {
                float minDecayMultiplier;
                float decayEndDistance;
                float decayStartDistance;
                if (this.projectile.getGunDecayStart() > this.projectile.getGunDecayEnd() && this.projectile.getGunMinDecayMultiplier() > 1.0f) {
                    decayStartDistance = (float)((double)Mth.m_14036_((float)this.projectile.getGunDecayEnd(), (float)0.0f, (float)1.0f) * maxDistance);
                    decayEndDistance = (float)((double)Mth.m_14036_((float)this.projectile.getGunDecayStart(), (float)0.0f, (float)1.0f) * maxDistance);
                    minDecayMultiplier = this.projectile.getGunMinDecayMultiplier();
                } else {
                    decayStartDistance = (float)((double)Mth.m_14036_((float)this.projectile.getGunDecayStart(), (float)0.0f, (float)1.0f) * maxDistance);
                    decayEndDistance = (float)((double)Mth.m_14036_((float)this.projectile.getGunDecayEnd(), (float)0.0f, (float)1.0f) * maxDistance);
                    minDecayMultiplier = Mth.m_14036_((float)this.projectile.getGunMinDecayMultiplier(), (float)0.0f, (float)1.0f);
                }
                modifier = decayStartDistance == decayEndDistance ? (projDistance > (double)decayEndDistance ? minDecayMultiplier : 1.0f) : (float)Mth.m_14008_((double)((projDistance - (double)decayEndDistance) * (double)(1.0f - minDecayMultiplier) / (double)(decayStartDistance - decayEndDistance) + (double)minDecayMultiplier), (double)Math.min(minDecayMultiplier, 1.0f), (double)Math.max(minDecayMultiplier, 1.0f));
            }
            initialDamage *= modifier;
        }
        float damage = initialDamage / (float)this.general.getProjectileAmount();
        damage = GunModifierHelper.getModifiedDamage(this.weapon, this.modifiedGun, damage);
        damage = GunEnchantmentHelper.getAcceleratorDamage(this.weapon, damage);
        return Math.max(0.0f, damage);
    }

    public float getDamage() {
        float initialDamage = this.projectile.getDamage() + this.additionalDamage;
        if (this.projectile.isDamageReduceOverLife()) {
            float modifier = ((float)this.projectile.getLife() - (float)(this.f_19797_ - 1)) / (float)this.projectile.getLife();
            initialDamage *= modifier;
        }
        float damage = initialDamage / (float)this.general.getProjectileAmount();
        damage = GunModifierHelper.getModifiedDamage(this.weapon, this.modifiedGun, damage);
        damage = GunEnchantmentHelper.getAcceleratorDamage(this.weapon, damage);
        return Math.max(0.0f, damage);
    }

    private float getCriticalDamage(ItemStack weapon, Random rand, float damage) {
        float chance = GunModifierHelper.getCriticalChance(weapon) + this.projectile.getGunCritical();
        if (rand.nextFloat() < chance) {
            return (float)((double)damage * (Double)Config.COMMON.gameplay.criticalDamageMultiplier.get() * (double)this.projectile.getGunCriticalDamage());
        }
        return damage;
    }

    public boolean m_6783_(double distance) {
        return true;
    }

    public void onRemovedFromWorld() {
        if (!this.f_19853_.f_46443_) {
            PacketHandler.getPlayChannel().send(PacketDistributor.NEAR.with(this::getDeathTargetPoint), (Object)new MessageRemoveProjectile(this.m_142049_()));
        }
    }

    private PacketDistributor.TargetPoint getDeathTargetPoint() {
        return new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 256.0, this.f_19853_.m_46472_());
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private static BlockHitResult rayTraceBlocks(Level world, ClipContext context, Predicate<BlockState> ignorePredicate) {
        return ProjectileEntity.performRayTrace(context, (rayTraceContext, blockPos) -> {
            BlockState blockState = world.m_8055_(blockPos);
            if (ignorePredicate.test(blockState)) {
                return null;
            }
            FluidState fluidState = world.m_6425_(blockPos);
            Vec3 startVec = rayTraceContext.m_45702_();
            Vec3 endVec = rayTraceContext.m_45693_();
            VoxelShape blockShape = rayTraceContext.m_45694_(blockState, (BlockGetter)world, blockPos);
            BlockHitResult blockResult = world.m_45558_(startVec, endVec, blockPos, blockShape, blockState);
            VoxelShape fluidShape = rayTraceContext.m_45698_(fluidState, (BlockGetter)world, blockPos);
            BlockHitResult fluidResult = fluidShape.m_83220_(startVec, endVec, blockPos);
            double blockDistance = blockResult == null ? Double.MAX_VALUE : rayTraceContext.m_45702_().m_82557_(blockResult.m_82450_());
            double fluidDistance = fluidResult == null ? Double.MAX_VALUE : rayTraceContext.m_45702_().m_82557_(fluidResult.m_82450_());
            return blockDistance <= fluidDistance ? blockResult : fluidResult;
        }, rayTraceContext -> {
            Vec3 Vector3d2 = rayTraceContext.m_45702_().m_82546_(rayTraceContext.m_45693_());
            return BlockHitResult.m_82426_((Vec3)rayTraceContext.m_45693_(), (Direction)Direction.m_122366_((double)Vector3d2.f_82479_, (double)Vector3d2.f_82480_, (double)Vector3d2.f_82481_), (BlockPos)new BlockPos(rayTraceContext.m_45693_()));
        });
    }

    private static <T> T performRayTrace(ClipContext context, BiFunction<ClipContext, BlockPos, T> hitFunction, Function<ClipContext, T> missFactory) {
        int blockZ;
        int blockY;
        Vec3 endVec;
        Vec3 startVec = context.m_45702_();
        if (startVec.equals((Object)(endVec = context.m_45693_()))) {
            return missFactory.apply(context);
        }
        double startX = Mth.m_14139_((double)-1.0E-7, (double)endVec.f_82479_, (double)startVec.f_82479_);
        double startY = Mth.m_14139_((double)-1.0E-7, (double)endVec.f_82480_, (double)startVec.f_82480_);
        double startZ = Mth.m_14139_((double)-1.0E-7, (double)endVec.f_82481_, (double)startVec.f_82481_);
        double endX = Mth.m_14139_((double)-1.0E-7, (double)startVec.f_82479_, (double)endVec.f_82479_);
        double endY = Mth.m_14139_((double)-1.0E-7, (double)startVec.f_82480_, (double)endVec.f_82480_);
        double endZ = Mth.m_14139_((double)-1.0E-7, (double)startVec.f_82481_, (double)endVec.f_82481_);
        int blockX = Mth.m_14107_((double)endX);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(blockX, blockY = Mth.m_14107_((double)endY), blockZ = Mth.m_14107_((double)endZ));
        T t = hitFunction.apply(context, (BlockPos)mutablePos);
        if (t != null) {
            return t;
        }
        double deltaX = startX - endX;
        double deltaY = startY - endY;
        double deltaZ = startZ - endZ;
        int signX = Mth.m_14205_((double)deltaX);
        int signY = Mth.m_14205_((double)deltaY);
        int signZ = Mth.m_14205_((double)deltaZ);
        double d9 = signX == 0 ? Double.MAX_VALUE : (double)signX / deltaX;
        double d10 = signY == 0 ? Double.MAX_VALUE : (double)signY / deltaY;
        double d11 = signZ == 0 ? Double.MAX_VALUE : (double)signZ / deltaZ;
        double d12 = d9 * (signX > 0 ? 1.0 - Mth.m_14185_((double)endX) : Mth.m_14185_((double)endX));
        double d13 = d10 * (signY > 0 ? 1.0 - Mth.m_14185_((double)endY) : Mth.m_14185_((double)endY));
        double d14 = d11 * (signZ > 0 ? 1.0 - Mth.m_14185_((double)endZ) : Mth.m_14185_((double)endZ));
        while (d12 <= 1.0 || d13 <= 1.0 || d14 <= 1.0) {
            T t1;
            if (d12 < d13) {
                if (d12 < d14) {
                    blockX += signX;
                    d12 += d9;
                } else {
                    blockZ += signZ;
                    d14 += d11;
                }
            } else if (d13 < d14) {
                blockY += signY;
                d13 += d10;
            } else {
                blockZ += signZ;
                d14 += d11;
            }
            if ((t1 = hitFunction.apply(context, (BlockPos)mutablePos.m_122178_(blockX, blockY, blockZ))) == null) continue;
            return t1;
        }
        return missFactory.apply(context);
    }

    public static void createExplosion(Entity entity, float radius, boolean forceNone) {
        Level world = entity.f_19853_;
        if (world.m_5776_()) {
            return;
        }
        Explosion.BlockInteraction mode = (Boolean)Config.COMMON.gameplay.enableGunGriefing.get() != false && !forceNone ? Explosion.BlockInteraction.BREAK : Explosion.BlockInteraction.NONE;
        ProjectileExplosion explosion = new ProjectileExplosion(world, entity, null, null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), radius, false, mode);
        if (ForgeEventFactory.onExplosionStart((Level)world, (Explosion)explosion)) {
            return;
        }
        explosion.m_46061_();
        explosion.m_46075_(true);
        if (mode == Explosion.BlockInteraction.NONE) {
            explosion.m_46080_();
        }
        explosion.m_46081_().forEach(pos -> {
            if (world.m_8055_(pos).m_60734_() instanceof IExplosionDamageable) {
                ((IExplosionDamageable)world.m_8055_(pos).m_60734_()).onProjectileExploded(world, world.m_8055_(pos), (BlockPos)pos, entity);
            }
        });
        for (ServerPlayer player : ((ServerLevel)world).m_6907_()) {
            if (!(player.m_20275_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_()) < 4096.0)) continue;
            player.f_8906_.m_141995_((Packet)new ClientboundExplodePacket(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), radius, explosion.m_46081_(), (Vec3)explosion.m_46078_().get(player)));
        }
    }

    public static class EntityResult {
        private Entity entity;
        private Vec3 hitVec;
        private boolean headshot;

        public EntityResult(Entity entity, Vec3 hitVec, boolean headshot) {
            this.entity = entity;
            this.hitVec = hitVec;
            this.headshot = headshot;
        }

        public Entity getEntity() {
            return this.entity;
        }

        public Vec3 getHitPos() {
            return this.hitVec;
        }

        public boolean isHeadshot() {
            return this.headshot;
        }
    }

    private static class BlockRayTraceMeta {
        public BlockHitResult blockRayTraceResult;
        public int wallBangCount = 0;

        public BlockRayTraceMeta(BlockHitResult blockRayTraceResult, int wallBangCount) {
            this.wallBangCount = wallBangCount;
            this.blockRayTraceResult = blockRayTraceResult;
        }

        public BlockRayTraceMeta(BlockHitResult blockRayTraceResult) {
            this.blockRayTraceResult = blockRayTraceResult;
        }
    }
}

