/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.extra_events;

import com.tac.guns.Config;
import com.tac.guns.common.Gun;
import com.tac.guns.event.GunFireEvent;
import com.tac.guns.item.GunItem;
import com.tac.guns.item.transition.TimelessGunItem;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.KeybindComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.ArrayUtils;

@Mod.EventBusSubscriber(modid="tac", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TacShootingEvent {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void preShoot(GunFireEvent.Pre event) {
        if (!(event.getStack().m_41720_() instanceof TimelessGunItem)) {
            return;
        }
        TacShootingEvent.HandleFireMode(event);
    }

    private static void HandleFireMode(GunFireEvent.Pre event) {
        int currentFireMode;
        ItemStack gunItem = event.getStack();
        int[] gunItemFireModes = gunItem.m_41783_().m_128465_("supportedFireModes");
        Gun gun = ((GunItem)gunItem.m_41720_()).getModifiedGun(gunItem);
        if (gunItem.m_41783_().m_128423_("CurrentFireMode") == null) {
            if (ArrayUtils.isEmpty((int[])gunItemFireModes) || gunItemFireModes == null) {
                gunItemFireModes = gun.getGeneral().getRateSelector();
                gunItem.m_41783_().m_128385_("supportedFireModes", gunItemFireModes);
            }
            gunItem.m_41783_().m_128405_("CurrentFireMode", gunItemFireModes[0]);
        }
        if ((currentFireMode = gunItem.m_41783_().m_128451_("CurrentFireMode")) == 0) {
            if (!((Boolean)Config.COMMON.gameplay.safetyExistence.get()).booleanValue()) {
                gunItem.m_41783_().m_128473_("CurrentFireMode");
                gunItem.m_41783_().m_128405_("CurrentFireMode", gunItemFireModes[currentFireMode + 1]);
            } else {
                event.getPlayer().m_5661_((Component)new TranslatableComponent("info.tac.gun_safety_lock", new Object[]{new KeybindComponent("key.tac.fireSelect").getString().toUpperCase(Locale.ENGLISH)}).m_130940_(ChatFormatting.GREEN), true);
                event.setCanceled(true);
            }
            ResourceLocation fireModeSound = gun.getSounds().getCock();
            if (fireModeSound != null && event.getPlayer().m_6084_()) {
                event.getPlayer().m_5496_(new SoundEvent(fireModeSound), 1.0f, 1.0f);
            }
        }
    }
}

