/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.item;

import com.tac.guns.common.Gun;
import com.tac.guns.common.NetworkGunManager;
import com.tac.guns.init.ModItems;
import com.tac.guns.item.IColored;
import com.tac.guns.util.GunEnchantmentHelper;
import com.tac.guns.util.GunModifierHelper;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.KeybindComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class GunItem
extends Item
implements IColored {
    private WeakHashMap<CompoundTag, Gun> modifiedGunCache = new WeakHashMap();
    private Gun gun = new Gun();

    public GunItem(Item.Properties properties) {
        super(properties);
    }

    public void setGun(NetworkGunManager.Supplier supplier) {
        this.gun = supplier.getGun();
    }

    public Gun getGun() {
        return this.gun;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flag) {
        Gun modifiedGun = this.getModifiedGun(stack);
        Item ammo = (Item)ForgeRegistries.ITEMS.getValue(modifiedGun.getProjectile().getItem());
        if (ammo != null) {
            tooltip.add((Component)new TranslatableComponent("info.tac.ammo_type", new Object[]{new TranslatableComponent(ammo.m_5524_()).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.GRAY));
        }
        Object additionalDamageText = "";
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound != null && tagCompound.m_128425_("AdditionalDamage", 99)) {
            float additionalDamage = tagCompound.m_128457_("AdditionalDamage");
            if ((additionalDamage += GunModifierHelper.getAdditionalDamage(stack)) > 0.0f) {
                additionalDamageText = ChatFormatting.GREEN + " +" + ItemStack.f_41584_.format(additionalDamage);
            } else if (additionalDamage < 0.0f) {
                additionalDamageText = ChatFormatting.RED + " " + ItemStack.f_41584_.format(additionalDamage);
            }
        }
        float damage = modifiedGun.getProjectile().getDamage();
        damage = GunModifierHelper.getModifiedProjectileDamage(stack, damage);
        damage = GunEnchantmentHelper.getAcceleratorDamage(stack, damage);
        tooltip.add((Component)new TranslatableComponent("info.tac.damage", new Object[]{ChatFormatting.WHITE + ItemStack.f_41584_.format(damage) + (String)additionalDamageText}).m_130940_(ChatFormatting.GRAY));
        if (tagCompound != null) {
            if (tagCompound.m_128471_("IgnoreAmmo")) {
                tooltip.add((Component)new TranslatableComponent("info.tac.ignore_ammo").m_130940_(ChatFormatting.AQUA));
            } else {
                int ammoCount = tagCompound.m_128451_("AmmoCount");
                tooltip.add((Component)new TranslatableComponent("info.tac.ammo", new Object[]{ChatFormatting.WHITE.toString() + ammoCount + "/" + GunModifierHelper.getAmmoCapacity(stack, modifiedGun)}).m_130940_(ChatFormatting.GRAY));
            }
        }
        tooltip.add((Component)new TranslatableComponent("info.tac.attachment_help", new Object[]{new KeybindComponent("key.tac.attachments").getString().toUpperCase(Locale.ENGLISH)}).m_130940_(ChatFormatting.YELLOW));
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> stacks) {
        if (this.m_41389_(group)) {
            ItemStack stack = new ItemStack((ItemLike)this);
            stack.m_41784_().m_128405_("AmmoCount", this.gun.getReloads().getMaxAmmo());
            stacks.add((Object)stack);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public boolean m_142522_(ItemStack stack) {
        CompoundTag tagCompound = stack.m_41784_();
        Gun modifiedGun = this.getModifiedGun(stack);
        return !tagCompound.m_128471_("IgnoreAmmo") && tagCompound.m_128451_("AmmoCount") != GunModifierHelper.getAmmoCapacity(stack, modifiedGun);
    }

    public int m_142158_(ItemStack stack) {
        CompoundTag tagCompound = stack.m_41784_();
        Gun modifiedGun = this.getModifiedGun(stack);
        return (int)(13.0 * ((double)tagCompound.m_128451_("AmmoCount") / (double)GunModifierHelper.getAmmoCapacity(stack, modifiedGun)));
    }

    public int m_142159_(ItemStack p_150901_) {
        return Objects.requireNonNull(ChatFormatting.AQUA.m_126665_());
    }

    public Gun getModifiedGun(ItemStack stack) {
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound != null && tagCompound.m_128425_("Gun", 10)) {
            return this.modifiedGunCache.computeIfAbsent(tagCompound, item -> {
                if (tagCompound.m_128471_("Custom")) {
                    return Gun.create(tagCompound.m_128469_("Gun"));
                }
                Gun gunCopy = this.gun.copy();
                gunCopy.deserializeNBT(tagCompound.m_128469_("Gun"));
                return gunCopy;
            });
        }
        return this.gun;
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public static boolean isSingleHanded(ItemStack stack) {
        Item item = stack.m_41720_();
        return item == ModItems.M1911.get() || item == ModItems.MICRO_UZI.get() || item == ModItems.CZ75.get() || item == ModItems.MK23.get();
    }
}

