/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.item.transition;

import com.tac.guns.GunMod;
import com.tac.guns.common.Gun;
import com.tac.guns.interfaces.IGunModifier;
import com.tac.guns.item.GunItem;
import com.tac.guns.item.transition.TimelessGunItem;
import com.tac.guns.util.GunEnchantmentHelper;
import com.tac.guns.util.GunModifierHelper;
import com.tac.guns.util.Process;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.KeybindComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class MBPGunItem
extends TimelessGunItem {
    public MBPGunItem(Process<Item.Properties> properties) {
        super((Item.Properties properties1) -> properties.process(new Item.Properties().m_41487_(1).m_41491_(GunMod.GROUP)), new IGunModifier[0]);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flag) {
        float additionalDamage;
        Gun modifiedGun = this.getModifiedGun(stack);
        Item ammo = (Item)ForgeRegistries.ITEMS.getValue(modifiedGun.getProjectile().getItem());
        if (ammo != null) {
            tooltip.add((Component)new TranslatableComponent("info.tac.ammo_type", new Object[]{new TranslatableComponent(ammo.m_5524_()).m_130940_(ChatFormatting.GOLD)}).m_130940_(ChatFormatting.DARK_GRAY));
        }
        Object additionalDamageText = "";
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound != null && tagCompound.m_128425_("AdditionalDamage", 99)) {
            additionalDamage = tagCompound.m_128457_("AdditionalDamage");
            if ((additionalDamage += GunModifierHelper.getAdditionalDamage(stack)) > 0.0f) {
                additionalDamageText = ChatFormatting.GREEN + " +" + ItemStack.f_41584_.format(additionalDamage);
            } else if (additionalDamage < 0.0f) {
                additionalDamageText = ChatFormatting.RED + " " + ItemStack.f_41584_.format(additionalDamage);
            }
        }
        additionalDamage = modifiedGun.getProjectile().getDamage();
        additionalDamage = GunModifierHelper.getModifiedProjectileDamage(stack, additionalDamage);
        additionalDamage = GunEnchantmentHelper.getAcceleratorDamage(stack, additionalDamage);
        tooltip.add((Component)new TranslatableComponent("info.tac.damage", new Object[]{ChatFormatting.GOLD + ItemStack.f_41584_.format(additionalDamage) + (String)additionalDamageText}).m_130940_(ChatFormatting.DARK_GRAY));
        if (tagCompound != null) {
            if (tagCompound.m_128471_("IgnoreAmmo")) {
                tooltip.add((Component)new TranslatableComponent("info.tac.ignore_ammo").m_130940_(ChatFormatting.AQUA));
            } else {
                int ammoCount = tagCompound.m_128451_("AmmoCount");
                tooltip.add((Component)new TranslatableComponent("info.tac.ammo", new Object[]{ChatFormatting.GOLD.toString() + ammoCount + "/" + GunModifierHelper.getAmmoCapacity(stack, modifiedGun)}).m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
        if (tagCompound != null && tagCompound.m_128423_("CurrentFireMode") != null) {
            if (tagCompound.m_128451_("CurrentFireMode") == 0) {
                tooltip.add((Component)new TranslatableComponent("info.tac.firemode_safe", new Object[]{new KeybindComponent("key.tac.fireSelect").getString().toUpperCase(Locale.ENGLISH)}).m_130940_(ChatFormatting.GREEN));
            } else if (tagCompound.m_128451_("CurrentFireMode") == 1) {
                tooltip.add((Component)new TranslatableComponent("info.tac.firemode_semi", new Object[]{new KeybindComponent("key.tac.fireSelect").getString().toUpperCase(Locale.ENGLISH)}).m_130940_(ChatFormatting.RED));
            } else if (tagCompound.m_128451_("CurrentFireMode") == 2) {
                tooltip.add((Component)new TranslatableComponent("info.tac.firemode_auto", new Object[]{new KeybindComponent("key.tac.fireSelect").getString().toUpperCase(Locale.ENGLISH)}).m_130940_(ChatFormatting.RED));
            }
        }
        if (tagCompound != null) {
            GunItem gun = (GunItem)stack.m_41720_();
            float speed = 0.1f / (1.0f + (gun.getGun().getGeneral().getWeightKilo() * (1.0f + GunModifierHelper.getModifierOfWeaponWeight(stack)) + GunModifierHelper.getAdditionalWeaponWeight(stack)) * 0.0275f);
            if ((speed = Math.max(Math.min(speed, 0.095f), 0.075f)) > 0.094f) {
                tooltip.add((Component)new TranslatableComponent("info.tac.lightWeightGun", new Object[]{new TranslatableComponent(-((int)((0.1 - (double)speed) * 1000.0)) + "%").m_130940_(ChatFormatting.RED)}).m_130940_(ChatFormatting.DARK_AQUA));
            } else if ((double)speed < 0.09 && (double)speed > 0.0825) {
                tooltip.add((Component)new TranslatableComponent("info.tac.standardWeightGun", new Object[]{new TranslatableComponent(-((int)((0.1 - (double)speed) * 1000.0)) + "%").m_130940_(ChatFormatting.RED)}).m_130940_(ChatFormatting.DARK_GREEN));
            } else {
                tooltip.add((Component)new TranslatableComponent("info.tac.heavyWeightGun", new Object[]{new TranslatableComponent(-((int)((0.1 - (double)speed) * 1000.0)) + "%").m_130940_(ChatFormatting.RED)}).m_130940_(ChatFormatting.DARK_RED));
            }
        }
        if (tagCompound != null) {
            tooltip.add((Component)new TranslatableComponent("info.moonshine.oldRifleScope", new Object[]{new TranslatableComponent("Rain").m_130940_(ChatFormatting.BOLD)}).m_130940_(ChatFormatting.BLUE));
        }
        tooltip.add((Component)new TranslatableComponent("info.tac.attachment_help", new Object[]{new KeybindComponent("key.tac.attachments").getString().toUpperCase(Locale.ENGLISH)}).m_130940_(ChatFormatting.YELLOW));
    }

    public MBPGunItem() {
        this((Item.Properties properties) -> properties);
    }
}

