/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.item.transition;

import com.tac.guns.Config;
import com.tac.guns.GunMod;
import com.tac.guns.client.Keys;
import com.tac.guns.common.Gun;
import com.tac.guns.common.network.ServerPlayHandler;
import com.tac.guns.interfaces.IGunModifier;
import com.tac.guns.item.GunItem;
import com.tac.guns.item.attachment.IAttachment;
import com.tac.guns.util.GunEnchantmentHelper;
import com.tac.guns.util.GunModifierHelper;
import com.tac.guns.util.Process;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.KeybindComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class TimelessGunItem
extends GunItem {
    private final IGunModifier[] modifiers;
    private Boolean integratedOptic = false;

    public TimelessGunItem(Process<Item.Properties> properties, IGunModifier ... modifiers) {
        super(properties.process(new Item.Properties().m_41487_(1).m_41491_(GunMod.GROUP)));
        this.modifiers = modifiers;
    }

    public TimelessGunItem(Process<Item.Properties> properties, Boolean integratedOptic, IGunModifier ... modifiers) {
        super(properties.process(new Item.Properties().m_41487_(1).m_41491_(GunMod.GROUP)));
        this.modifiers = modifiers;
        this.integratedOptic = integratedOptic;
    }

    public TimelessGunItem() {
        this((Item.Properties properties) -> properties, new IGunModifier[0]);
    }

    public Boolean isIntegratedOptic() {
        return this.integratedOptic;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flag) {
        boolean isShift;
        float additionalDamage;
        Gun modifiedGun = this.getModifiedGun(stack);
        Item ammo = (Item)ForgeRegistries.ITEMS.getValue(modifiedGun.getProjectile().getItem());
        if (ammo != null) {
            tooltip.add((Component)new TranslatableComponent("info.tac.ammo_type", new Object[]{new TranslatableComponent(ammo.m_5524_()).m_130940_(ChatFormatting.GOLD)}).m_130940_(ChatFormatting.DARK_GRAY));
        }
        Object additionalDamageText = "";
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound != null && tagCompound.m_128425_("AdditionalDamage", 99)) {
            additionalDamage = tagCompound.m_128457_("AdditionalDamage");
            if ((additionalDamage += GunModifierHelper.getAdditionalDamage(stack)) > 0.0f) {
                additionalDamageText = ChatFormatting.GREEN + " +" + ItemStack.f_41584_.format(additionalDamage);
            } else if (additionalDamage < 0.0f) {
                additionalDamageText = ChatFormatting.RED + " " + ItemStack.f_41584_.format(additionalDamage);
            }
        }
        additionalDamage = modifiedGun.getProjectile().getDamage();
        additionalDamage = GunModifierHelper.getModifiedProjectileDamage(stack, additionalDamage);
        additionalDamage = GunEnchantmentHelper.getAcceleratorDamage(stack, additionalDamage);
        tooltip.add((Component)new TranslatableComponent("info.tac.damage", new Object[]{ChatFormatting.GOLD + ItemStack.f_41584_.format(additionalDamage) + (String)additionalDamageText}).m_130940_(ChatFormatting.DARK_GRAY));
        if (tagCompound != null) {
            if (tagCompound.m_128471_("IgnoreAmmo")) {
                tooltip.add((Component)new TranslatableComponent("info.tac.ignore_ammo").m_130940_(ChatFormatting.AQUA));
            } else {
                int ammoCount = tagCompound.m_128451_("AmmoCount");
                tooltip.add((Component)new TranslatableComponent("info.tac.ammo", new Object[]{ChatFormatting.GOLD.toString() + ammoCount + "/" + GunModifierHelper.getAmmoCapacity(stack, modifiedGun)}).m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
        if (!(isShift = Keys.MORE_INFO_HOLD.m_90857_())) {
            String text = new KeybindComponent("key.tac.more_info_hold").getString().toUpperCase(Locale.ENGLISH);
            tooltip.add((Component)new TranslatableComponent("info.tac.more_info_gunitem", new Object[]{text}).m_130940_(ChatFormatting.YELLOW));
        }
        if (isShift) {
            GunItem gun = (GunItem)stack.m_41720_();
            if (tagCompound != null) {
                double armorPen = gun.getGun().getProjectile().getGunArmorIgnore() >= 0.0f ? Math.min((Double)Config.COMMON.gameplay.percentDamageIgnoresStandardArmor.get() * (double)gun.getGun().getProjectile().getGunArmorIgnore() * 100.0, 100.0) : 0.0;
                tooltip.add((Component)new TranslatableComponent("info.tac.armorPen", new Object[]{new TranslatableComponent(String.format("%.1f", armorPen) + "%").m_130940_(ChatFormatting.RED)}).m_130940_(ChatFormatting.DARK_AQUA));
                int headDamgeModifier = (Double)Config.COMMON.gameplay.headShotDamageMultiplier.get() * (double)gun.getGun().getProjectile().getGunHeadDamage() >= 0.0 ? (int)((Double)Config.COMMON.gameplay.headShotDamageMultiplier.get() * (double)gun.getGun().getProjectile().getGunHeadDamage() * 100.0) : 0;
                tooltip.add((Component)new TranslatableComponent("info.tac.headDamageModifier", new Object[]{new TranslatableComponent(String.format("%d", headDamgeModifier) + "%").m_130940_(ChatFormatting.RED)}).m_130940_(ChatFormatting.DARK_AQUA));
                float speed = ServerPlayHandler.calceldGunWeightSpeed(gun.getGun(), stack);
                speed = Math.max(Math.min(speed, 0.1f), 0.075f);
                if (speed > 0.094f) {
                    tooltip.add((Component)new TranslatableComponent("info.tac.lightWeightGun", new Object[]{new TranslatableComponent(-((int)((0.1 - (double)speed) * 1000.0)) + "%").m_130940_(ChatFormatting.RED)}).m_130940_(ChatFormatting.DARK_AQUA));
                } else if ((double)speed < 0.095 && (double)speed > 0.0875) {
                    tooltip.add((Component)new TranslatableComponent("info.tac.standardWeightGun", new Object[]{new TranslatableComponent(-((int)((0.1 - (double)speed) * 1000.0)) + "%").m_130940_(ChatFormatting.RED)}).m_130940_(ChatFormatting.DARK_GREEN));
                } else {
                    tooltip.add((Component)new TranslatableComponent("info.tac.heavyWeightGun", new Object[]{new TranslatableComponent(-((int)((0.1 - (double)speed) * 1000.0)) + "%").m_130940_(ChatFormatting.RED)}).m_130940_(ChatFormatting.DARK_RED));
                }
                float percentageToNextLevel = tagCompound.m_128457_("levelDmg") * 100.0f / (modifiedGun.getGeneral().getLevelReq() * ((float)tagCompound.m_128451_("level") * 3.0f));
                tooltip.add((Component)new TranslatableComponent("info.tac.current_level").m_7220_((Component)new TranslatableComponent(" " + tagCompound.m_128451_("level") + " : " + String.format("%.2f", Float.valueOf(percentageToNextLevel)) + "%")).m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.BOLD));
            }
            tooltip.add((Component)new TranslatableComponent("info.tac.attachment_help", new Object[]{Keys.ATTACHMENTS.getKey().m_84875_().m_6111_().toUpperCase(Locale.ENGLISH)}).m_130940_(ChatFormatting.YELLOW));
            if (gun.getGun().canAttachType(IAttachment.Type.PISTOL_SCOPE)) {
                tooltip.add((Component)new TranslatableComponent("info.tac.pistolScope", new Object[]{new TranslatableComponent("MiniScope").m_130940_(ChatFormatting.BOLD)}).m_130940_(ChatFormatting.LIGHT_PURPLE));
            }
            if (gun.getGun().canAttachType(IAttachment.Type.IR_DEVICE)) {
                tooltip.add((Component)new TranslatableComponent("info.tac.irLaserEquip", new Object[]{new TranslatableComponent("IrLaser").m_130940_(ChatFormatting.BOLD)}).m_130940_(ChatFormatting.AQUA));
            }
        }
    }

    public IGunModifier[] getModifiers() {
        return this.modifiers;
    }

    @Override
    public int m_142159_(ItemStack p_150901_) {
        return Objects.requireNonNull(ChatFormatting.GOLD.m_126665_());
    }

    @Override
    public boolean m_142522_(ItemStack stack) {
        if (((Boolean)Config.CLIENT.display.weaponAmmoBar.get()).booleanValue()) {
            CompoundTag tagCompound = stack.m_41784_();
            Gun modifiedGun = this.getModifiedGun(stack);
            return !tagCompound.m_128471_("IgnoreAmmo") && tagCompound.m_128451_("AmmoCount") != GunModifierHelper.getAmmoCapacity(stack, modifiedGun);
        }
        return false;
    }

    public boolean m_5812_(ItemStack gunItem) {
        return false;
    }
}

