/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.item.transition.wearables;

import com.tac.guns.common.NetworkRigManager;
import com.tac.guns.common.Rig;
import com.tac.guns.inventory.gear.armor.ArmorRigCapabilityProvider;
import com.tac.guns.inventory.gear.armor.ArmorRigContainerProvider;
import com.tac.guns.inventory.gear.armor.RigSlotsHandler;
import com.tac.guns.item.transition.wearables.IArmoredRigItem;
import com.tac.guns.util.RigEnchantmentHelper;
import com.tac.guns.util.WearableHelper;
import java.util.Objects;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;

@Mod.EventBusSubscriber(modid="tac")
public class ArmorRigItem
extends Item
implements IArmoredRigItem {
    private final int numOfRows;
    private ArmorRigContainerProvider containerProvider;
    private WeakHashMap<CompoundTag, Rig> modifiedRigCache = new WeakHashMap();
    private Rig rig = new Rig();

    public ArmorRigItem(Item.Properties properties) {
        super(properties);
        this.numOfRows = 1;
    }

    public int getNumOfRows() {
        return this.numOfRows;
    }

    public ArmorRigItem(int rows, Item.Properties properties) {
        super(properties);
        this.numOfRows = rows;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (world.f_46443_) {
            return super.m_7203_(world, player, hand);
        }
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
        }
        this.containerProvider = new ArmorRigContainerProvider(player.m_21120_(hand));
        NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)this.containerProvider);
        super.m_7203_(world, player, hand);
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new ArmorRigCapabilityProvider();
    }

    public void setRig(NetworkRigManager.Supplier supplier) {
        this.rig = supplier.getRig();
    }

    public Rig getRig() {
        return this.rig;
    }

    public boolean m_41468_() {
        return true;
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        stack.m_41784_();
        CompoundTag nbt = super.getShareTag(stack);
        if (stack.m_41720_() instanceof ArmorRigItem) {
            RigSlotsHandler itemHandler = (RigSlotsHandler)stack.getCapability(ArmorRigCapabilityProvider.capability).resolve().get();
            nbt.m_128365_("storage", (Tag)itemHandler.serializeNBT());
        }
        return nbt;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> stacks) {
        if (this.m_41389_(group)) {
            ItemStack stack = new ItemStack((ItemLike)this);
            stack.m_41784_();
            WearableHelper.FillDefaults(stack, this.rig);
            stacks.add((Object)stack);
        }
    }

    public boolean m_142522_(ItemStack p_150899_) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        stack.m_41784_();
        Rig modifiedRig = this.getModifiedRig(stack);
        return (int)(13.0 * ((double)WearableHelper.GetCurrentDurability(stack) / (double)RigEnchantmentHelper.getModifiedDurability(stack, modifiedRig)));
    }

    public int m_142159_(ItemStack p_150901_) {
        return Objects.requireNonNull(ChatFormatting.AQUA.m_126665_());
    }

    public Rig getModifiedRig(ItemStack stack) {
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound != null && tagCompound.m_128425_("Rig", 10)) {
            return this.modifiedRigCache.computeIfAbsent(tagCompound, item -> {
                if (tagCompound.m_128471_("Custom")) {
                    return Rig.create(tagCompound.m_128469_("Rig"));
                }
                Rig gunCopy = this.rig.copy();
                gunCopy.deserializeNBT(tagCompound.m_128469_("Rig"));
                return gunCopy;
            });
        }
        return this.rig;
    }
}

