/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.network.message;

import com.mrcrayfish.framework.api.network.PlayMessage;
import com.tac.guns.event.GunReloadEvent;
import com.tac.guns.init.ModSyncedDataKeys;
import com.tac.guns.item.GunItem;
import com.tac.guns.network.PacketHandler;
import com.tac.guns.network.message.MessageGunSound;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class MessageReload
extends PlayMessage<MessageReload> {
    private boolean reload;

    public MessageReload() {
    }

    public MessageReload(boolean reload) {
        this.reload = reload;
    }

    public void encode(MessageReload messageReload, FriendlyByteBuf buffer) {
        buffer.writeBoolean(messageReload.reload);
    }

    public MessageReload decode(FriendlyByteBuf buffer) {
        return new MessageReload(buffer.readBoolean());
    }

    public void handle(MessageReload messageReload, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null && !player.m_5833_()) {
                ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)messageReload.reload);
                if (!messageReload.reload) {
                    return;
                }
                ItemStack gun = player.m_21205_();
                if (MinecraftForge.EVENT_BUS.post((Event)new GunReloadEvent.Pre((Player)player, gun))) {
                    ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)false);
                    return;
                }
                MinecraftForge.EVENT_BUS.post((Event)new GunReloadEvent.Post((Player)player, gun));
                ResourceLocation reloadSound = ((GunItem)gun.m_41720_()).getGun().getSounds().getCock();
                if (reloadSound != null) {
                    MessageGunSound message = new MessageGunSound(reloadSound, SoundSource.PLAYERS, (float)player.m_20185_(), (float)player.m_20186_() + 1.0f, (float)player.m_20189_(), 1.0f, 1.0f, player.m_142049_(), false, true);
                    PacketHandler.getPlayChannel().send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(player, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), 16.0, player.f_19853_.m_46472_())), (Object)message);
                }
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

