/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.network.message;

import com.mrcrayfish.framework.api.network.PlayMessage;
import com.tac.guns.common.network.ServerPlayHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class MessageShoot
extends PlayMessage<MessageShoot> {
    private float rotationYaw;
    private float rotationPitch;
    private float randP;
    private float randY;

    public MessageShoot() {
    }

    public MessageShoot(float yaw, float pitch, float randP, float randY) {
        this.rotationPitch = pitch;
        this.rotationYaw = yaw;
        this.randP = randP;
        this.randY = randY;
    }

    public void encode(MessageShoot messageShoot, FriendlyByteBuf buffer) {
        buffer.writeFloat(messageShoot.rotationYaw);
        buffer.writeFloat(messageShoot.rotationPitch);
        buffer.writeFloat(messageShoot.randP);
        buffer.writeFloat(messageShoot.randY);
    }

    public MessageShoot decode(FriendlyByteBuf buffer) {
        return new MessageShoot(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
    }

    public void handle(MessageShoot messageShoot, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null) {
                ServerPlayHandler.handleShoot(messageShoot, player, messageShoot.randP, messageShoot.randY);
            }
        });
        supplier.get().setPacketHandled(true);
    }

    public float getRotationYaw() {
        return this.rotationYaw;
    }

    public float getRotationPitch() {
        return this.rotationPitch;
    }
}

