/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.util;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class IDLNBTUtil {
    public static final String MOD_SECTION_NAME = "tac_nbt";

    public static CompoundTag getNBT(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null) {
            nbt = new CompoundTag();
            stack.m_41751_(nbt);
        }
        return nbt;
    }

    public static CompoundTag getNBTReadOnly(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null) {
            nbt = new CompoundTag();
        }
        return nbt;
    }

    public static CompoundTag getNBT(Entity entity) {
        CompoundTag nbt = entity.getPersistentData();
        return nbt;
    }

    public static CompoundTag getNBT(CompoundTag tag) {
        if (tag == null) {
            return new CompoundTag();
        }
        return tag;
    }

    @Nullable
    public static boolean stackHasKey(ItemStack stack, String key) {
        return !stack.m_41619_() && IDLNBTUtil.getNBTReadOnly(stack).m_128441_(key);
    }

    public static boolean setBoolean(ItemStack stack, String key, boolean value) {
        CompoundTag nbt = IDLNBTUtil.getNBT(stack);
        nbt.m_128379_(key, value);
        return true;
    }

    public static boolean getBoolean(ItemStack stack, String key, boolean defaultVal) {
        if (IDLNBTUtil.stackHasKey(stack, key)) {
            CompoundTag nbt = IDLNBTUtil.getNBTReadOnly(stack);
            return nbt.m_128471_(key);
        }
        return defaultVal;
    }

    public static boolean getBoolean(ItemStack stack, String key) {
        if (IDLNBTUtil.stackHasKey(stack, key)) {
            CompoundTag nbt = IDLNBTUtil.getNBTReadOnly(stack);
            return nbt.m_128471_(key);
        }
        return false;
    }

    public static boolean getBooleanDF(ItemStack stack, String key, boolean defaultVal) {
        if (IDLNBTUtil.stackHasKey(stack, key)) {
            CompoundTag nbt = IDLNBTUtil.getNBTReadOnly(stack);
            return nbt.m_128471_(key);
        }
        return defaultVal;
    }

    public static boolean setDouble(ItemStack stack, String key, double value) {
        CompoundTag nbt = IDLNBTUtil.getNBT(stack);
        nbt.m_128347_(key, value);
        return true;
    }

    public static double getDouble(ItemStack stack, String key, double defaultVal) {
        if (IDLNBTUtil.stackHasKey(stack, key)) {
            CompoundTag nbt = IDLNBTUtil.getNBTReadOnly(stack);
            return nbt.m_128459_(key);
        }
        return defaultVal;
    }

    public static boolean setLong(ItemStack stack, String key, long value) {
        CompoundTag nbt = IDLNBTUtil.getNBT(stack);
        nbt.m_128356_(key, value);
        return true;
    }

    public static boolean setInt(ItemStack stack, String key, int value) {
        CompoundTag nbt = IDLNBTUtil.getNBT(stack);
        nbt.m_128405_(key, value);
        return true;
    }

    public static boolean setIntOptimized(ItemStack stack, String key, int value) {
        CompoundTag nbt = IDLNBTUtil.getNBT(stack);
        if (nbt.m_128451_(key) != value) {
            nbt.m_128405_(key, value);
        }
        return true;
    }

    public static boolean setInt(Entity entity, String key, int value) {
        CompoundTag nbt = IDLNBTUtil.getNBT(entity);
        nbt.m_128405_(key, value);
        return true;
    }

    public static boolean setIntAuto(Entity entity, String key, int value) {
        if (entity instanceof Player) {
            IDLNBTUtil.setPlayerIdeallandTagSafe((Player)entity, key, value);
            return true;
        }
        CompoundTag nbt = IDLNBTUtil.getNBT(entity);
        nbt.m_128405_(key, value);
        return true;
    }

    public static boolean addIntAuto(Entity entity, String key, int value) {
        int oldVal = IDLNBTUtil.getIntAuto(entity, key, 0);
        IDLNBTUtil.setIntAuto(entity, key, value + oldVal);
        return true;
    }

    public static int getInt(Entity entity, String key, int defaultVal) {
        if (IDLNBTUtil.entityHasKey(entity, key)) {
            CompoundTag nbt = IDLNBTUtil.getNBT(entity);
            return nbt.m_128451_(key);
        }
        return defaultVal;
    }

    public static int getIntAuto(Entity entity, String key, int defaultVal) {
        if (entity instanceof Player) {
            return IDLNBTUtil.getPlayerIdeallandIntSafe((Player)entity, key);
        }
        if (IDLNBTUtil.entityHasKey(entity, key)) {
            CompoundTag nbt = IDLNBTUtil.getNBT(entity);
            return nbt.m_128451_(key);
        }
        return defaultVal;
    }

    public static int getInt(ItemStack stack, String key, int defaultVal) {
        if (IDLNBTUtil.stackHasKey(stack, key)) {
            CompoundTag nbt = IDLNBTUtil.getNBTReadOnly(stack);
            return nbt.m_128451_(key);
        }
        return defaultVal;
    }

    public static long getLong(ItemStack stack, String key, int defaultVal) {
        if (IDLNBTUtil.stackHasKey(stack, key)) {
            CompoundTag nbt = IDLNBTUtil.getNBTReadOnly(stack);
            return nbt.m_128454_(key);
        }
        return defaultVal;
    }

    public static int getInt(ItemStack stack, String key) {
        return IDLNBTUtil.getInt(stack, key, 0);
    }

    public static String getString(ItemStack stack, String key, String defaultVal) {
        if (IDLNBTUtil.stackHasKey(stack, key)) {
            CompoundTag nbt = IDLNBTUtil.getNBTReadOnly(stack);
            return nbt.m_128461_(key);
        }
        return defaultVal;
    }

    public static boolean setString(ItemStack stack, String key, String value) {
        CompoundTag nbt = IDLNBTUtil.getNBT(stack);
        nbt.m_128359_(key, value);
        return true;
    }

    @Nullable
    public static boolean entityHasKey(Entity entity, String key) {
        return IDLNBTUtil.getNBT(entity).m_128441_(key);
    }

    public static boolean getBoolean(Entity entity, String key, boolean defaultVal) {
        if (IDLNBTUtil.entityHasKey(entity, key)) {
            CompoundTag nbt = IDLNBTUtil.getNBT(entity);
            return nbt.m_128471_(key);
        }
        return defaultVal;
    }

    public static boolean setBoolean(Entity stack, String key, boolean value) {
        CompoundTag nbt = IDLNBTUtil.getNBT(stack);
        nbt.m_128379_(key, value);
        return true;
    }

    public static boolean setString(Entity stack, String key, String value) {
        CompoundTag nbt = IDLNBTUtil.getNBT(stack);
        nbt.m_128359_(key, value);
        return true;
    }

    public static int[] getIntArray(ItemStack stack, String key) {
        if (IDLNBTUtil.stackHasKey(stack, key)) {
            CompoundTag nbt = IDLNBTUtil.getNBTReadOnly(stack);
            return nbt.m_128465_(key);
        }
        return new int[0];
    }

    public static int[] getIntArray(LivingEntity entity, String key) {
        if (IDLNBTUtil.entityHasKey((Entity)entity, key)) {
            CompoundTag nbt = IDLNBTUtil.getNBT((Entity)entity);
            return nbt.m_128465_(key);
        }
        return new int[0];
    }

    public static void setIntArray(ItemStack stack, String key, int[] array) {
        CompoundTag nbt = IDLNBTUtil.getNBT(stack);
        nbt.m_128385_(key, array);
    }

    public static CompoundTag getTagSafe(CompoundTag tag, String key) {
        if (tag == null) {
            return new CompoundTag();
        }
        return tag.m_128469_(key);
    }

    public static CompoundTag getPlyrIdlTagSafe(Player player) {
        if (player == null) {
            return new CompoundTag();
        }
        CompoundTag playerData = player.getPersistentData();
        CompoundTag data = IDLNBTUtil.getTagSafe(playerData, "PlayerPersisted");
        return IDLNBTUtil.getTagSafe(data, MOD_SECTION_NAME);
    }

    public static CompoundTag getPlayerIdeallandTagGroupSafe(Player player, String key) {
        return IDLNBTUtil.getPlyrIdlTagSafe(player).m_128469_(key);
    }

    public static int[] getPlayerIdeallandIntArraySafe(Player player, String key) {
        return IDLNBTUtil.getPlyrIdlTagSafe(player).m_128465_(key);
    }

    public static int getPlayerIdeallandIntSafe(Player player, String key) {
        return IDLNBTUtil.getPlyrIdlTagSafe(player).m_128451_(key);
    }

    public static float getPlayerIdeallandFloatSafe(Player player, String key) {
        return IDLNBTUtil.getPlyrIdlTagSafe(player).m_128457_(key);
    }

    public static double getPlayerIdeallandDoubleSafe(Player player, String key) {
        return IDLNBTUtil.getPlyrIdlTagSafe(player).m_128459_(key);
    }

    public static boolean getPlayerIdeallandBoolSafe(Player player, String key) {
        return IDLNBTUtil.getPlyrIdlTagSafe(player).m_128471_(key);
    }

    public static String getPlayerIdeallandStrSafe(Player player, String key) {
        return IDLNBTUtil.getPlyrIdlTagSafe(player).m_128461_(key);
    }

    public static BlockPos getPlayerIdeallandBlockPosSafe(Player player, String key) {
        if (player == null) {
            return BlockPos.f_121853_;
        }
        Tag inbt = IDLNBTUtil.getPlyrIdlTagSafe(player).m_128423_(key);
        if (inbt instanceof CompoundTag) {
            return NbtUtils.m_129239_((CompoundTag)((CompoundTag)inbt));
        }
        return BlockPos.f_121853_;
    }

    public static void setPlayerIdeallandTagSafe(Player player, String key, int value) {
        if (player == null) {
            return;
        }
        CompoundTag playerData = player.getPersistentData();
        CompoundTag data = IDLNBTUtil.getTagSafe(playerData, "PlayerPersisted");
        CompoundTag idl_data = IDLNBTUtil.getPlyrIdlTagSafe(player);
        idl_data.m_128405_(key, value);
        data.m_128365_(MOD_SECTION_NAME, (Tag)idl_data);
        playerData.m_128365_("PlayerPersisted", (Tag)data);
    }

    public static void setPlayerIdeallandTagSafe(Player player, String key, int[] value) {
        if (player == null) {
            return;
        }
        CompoundTag playerData = player.getPersistentData();
        CompoundTag data = IDLNBTUtil.getTagSafe(playerData, "PlayerPersisted");
        CompoundTag idl_data = IDLNBTUtil.getPlyrIdlTagSafe(player);
        idl_data.m_128385_(key, value);
        data.m_128365_(MOD_SECTION_NAME, (Tag)idl_data);
        playerData.m_128365_("PlayerPersisted", (Tag)data);
    }

    public static void setPlayerIdeallandTagSafe(Player player, String key, double value) {
        if (player == null) {
            return;
        }
        CompoundTag playerData = player.getPersistentData();
        CompoundTag data = IDLNBTUtil.getTagSafe(playerData, "PlayerPersisted");
        CompoundTag idl_data = IDLNBTUtil.getPlyrIdlTagSafe(player);
        idl_data.m_128347_(key, value);
        data.m_128365_(MOD_SECTION_NAME, (Tag)idl_data);
        playerData.m_128365_("PlayerPersisted", (Tag)data);
    }

    public static void setPlayerIdeallandTagSafe(Player player, String key, boolean value) {
        if (player == null) {
            return;
        }
        CompoundTag playerData = player.getPersistentData();
        CompoundTag data = IDLNBTUtil.getTagSafe(playerData, "PlayerPersisted");
        CompoundTag idl_data = IDLNBTUtil.getPlyrIdlTagSafe(player);
        idl_data.m_128379_(key, value);
        data.m_128365_(MOD_SECTION_NAME, (Tag)idl_data);
        playerData.m_128365_("PlayerPersisted", (Tag)data);
    }

    public static void setPlayerIdeallandTagSafe(Player player, String key, String value) {
        if (player == null) {
            return;
        }
        CompoundTag playerData = player.getPersistentData();
        CompoundTag data = IDLNBTUtil.getTagSafe(playerData, "PlayerPersisted");
        CompoundTag idl_data = IDLNBTUtil.getPlyrIdlTagSafe(player);
        idl_data.m_128359_(key, value);
        data.m_128365_(MOD_SECTION_NAME, (Tag)idl_data);
        playerData.m_128365_("PlayerPersisted", (Tag)data);
    }

    public static void setPlayerIdeallandTagSafe(Player player, String key, BlockPos value) {
        CompoundTag playerData = player.getPersistentData();
        CompoundTag data = IDLNBTUtil.getTagSafe(playerData, "PlayerPersisted");
        CompoundTag idl_data = IDLNBTUtil.getPlyrIdlTagSafe(player);
        idl_data.m_128365_(key, (Tag)NbtUtils.m_129224_((BlockPos)value));
        data.m_128365_(MOD_SECTION_NAME, (Tag)idl_data);
        playerData.m_128365_("PlayerPersisted", (Tag)data);
    }
}

