/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.util;

import com.tac.guns.common.Rig;
import com.tac.guns.duck.PlayerWithSynData;
import com.tac.guns.entity.ProjectileEntity;
import com.tac.guns.item.transition.wearables.ArmorRigItem;
import com.tac.guns.network.PacketHandler;
import com.tac.guns.network.message.MessageGunSound;
import com.tac.guns.util.RigEnchantmentHelper;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.PacketDistributor;

public class WearableHelper {
    @Nonnull
    public static ItemStack PlayerWornRig(Player player) {
        return ((PlayerWithSynData)player).getRig();
    }

    public static void FillDefaults(ItemStack item, Rig rig) {
        item.m_41783_().m_128350_("RigDurability", RigEnchantmentHelper.getModifiedDurability(item, rig));
    }

    public static boolean isFullDurability(ItemStack rig) {
        Rig modifiedRig = ((ArmorRigItem)rig.m_41720_()).getModifiedRig(rig);
        float max = RigEnchantmentHelper.getModifiedDurability(rig, modifiedRig);
        return rig.m_41783_().m_128457_("RigDurability") >= max;
    }

    public static boolean tickFromCurrentDurability(Player player, ProjectileEntity proj) {
        ItemStack rig = WearableHelper.PlayerWornRig(player);
        float og = rig.m_41783_().m_128457_("RigDurability");
        rig.m_41783_().m_128473_("RigDurability");
        if (og == 0.0f) {
            return true;
        }
        if (og - proj.getDamage() > 0.0f) {
            rig.m_41783_().m_128350_("RigDurability", og - proj.getDamage());
        } else if (og - proj.getDamage() < 0.0f) {
            ResourceLocation brokenSound = ((ArmorRigItem)rig.m_41720_()).getRig().getSounds().getBroken();
            if (brokenSound != null) {
                MessageGunSound messageSound = new MessageGunSound(brokenSound, SoundSource.PLAYERS, (float)player.m_20185_(), (float)(player.m_20186_() + 1.0), (float)player.m_20189_(), 1.5f, 1.0f, player.m_142049_(), false, false);
                PacketHandler.getPlayChannel().send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)messageSound);
            }
            rig.m_41783_().m_128350_("RigDurability", 0.0f);
            return false;
        }
        return false;
    }

    public static float currentDurabilityPercentage(ItemStack rig) {
        return rig.m_41783_().m_128457_("RigDurability") / ((ArmorRigItem)rig.m_41720_()).getRig().getRepair().getDurability();
    }

    public static boolean tickRepairCurrentDurability(ItemStack rig) {
        Rig modifiedRig = ((ArmorRigItem)rig.m_41720_()).getModifiedRig(rig);
        float og = rig.m_41783_().m_128457_("RigDurability");
        float max = RigEnchantmentHelper.getModifiedDurability(rig, modifiedRig);
        float ofDurability = modifiedRig.getRepair().getQuickRepairability();
        rig.m_41783_().m_128473_("RigDurability");
        float totalAfterRepair = og + max * ofDurability;
        if (!(totalAfterRepair >= max)) {
            rig.m_41783_().m_128350_("RigDurability", totalAfterRepair);
            return true;
        }
        rig.m_41783_().m_128350_("RigDurability", max);
        return false;
    }

    public static boolean tickRepairCurrentDurability(ItemStack rig, float repair) {
        Rig modifiedRig = ((ArmorRigItem)rig.m_41720_()).getModifiedRig(rig);
        float og = rig.m_41783_().m_128457_("RigDurability");
        float max = RigEnchantmentHelper.getModifiedDurability(rig, modifiedRig);
        float ofDurability = repair;
        rig.m_41783_().m_128473_("RigDurability");
        float totalAfterRepair = og + max * ofDurability;
        if (!(og >= max)) {
            rig.m_41783_().m_128350_("RigDurability", totalAfterRepair);
            return true;
        }
        rig.m_41783_().m_128350_("RigDurability", max);
        return false;
    }

    public static float GetCurrentDurability(ItemStack item) {
        return item.m_41783_().m_128457_("RigDurability");
    }
}

