/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.world;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class ProjectileExplosion
extends Explosion {
    private static final ExplosionDamageCalculator DEFAULT_CONTEXT = new ExplosionDamageCalculator();
    private final Level world;
    private final double x;
    private final double y;
    private final double z;
    private final float size;
    private final Entity exploder;
    private final ExplosionDamageCalculator context;

    public ProjectileExplosion(Level world, Entity exploder, @Nullable DamageSource source, @Nullable ExplosionDamageCalculator context, double x, double y, double z, float size, boolean causesFire, Explosion.BlockInteraction mode) {
        super(world, exploder, source, context, x, y, z, size, causesFire, mode);
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.size = size;
        this.exploder = exploder;
        this.context = context == null ? DEFAULT_CONTEXT : context;
    }

    public void m_46061_() {
        HashSet set = Sets.newHashSet();
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    if (x != 0 && x != 15 && y != 0 && y != 15 && z != 0 && z != 15) continue;
                    double d0 = (float)x / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)y / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)z / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double blockX = this.x;
                    double blockY = this.y;
                    double blockZ = this.z;
                    for (float f = this.size * (0.7f + this.world.f_46441_.nextFloat() * 0.6f); f > 0.0f; f -= 0.225f) {
                        FluidState fluidState;
                        BlockPos pos = new BlockPos(blockX, blockY, blockZ);
                        BlockState blockState = this.world.m_8055_(pos);
                        Optional optional = this.context.m_6617_((Explosion)this, (BlockGetter)this.world, pos, blockState, fluidState = this.world.m_6425_(pos));
                        if (optional.isPresent()) {
                            f -= (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && this.context.m_6714_((Explosion)this, (BlockGetter)this.world, pos, blockState, f)) {
                            set.add(pos);
                        }
                        blockX += d0 * (double)0.3f;
                        blockY += d1 * (double)0.3f;
                        blockZ += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.m_46081_().addAll(set);
        float radius = this.size * 2.0f;
        int minX = Mth.m_14107_((double)(this.x - (double)radius - 1.0));
        int maxX = Mth.m_14107_((double)(this.x + (double)radius + 1.0));
        int minY = Mth.m_14107_((double)(this.y - (double)radius - 1.0));
        int maxY = Mth.m_14107_((double)(this.y + (double)radius + 1.0));
        int minZ = Mth.m_14107_((double)(this.z - (double)radius - 1.0));
        int maxZ = Mth.m_14107_((double)(this.z + (double)radius + 1.0));
        List entities = this.world.m_45933_(this.exploder, new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
        ForgeEventFactory.onExplosionDetonate((Level)this.world, (Explosion)this, (List)entities, (double)radius);
        Vec3 explosionPos = new Vec3(this.x, this.y, this.z);
        for (Entity entity : entities) {
            Player player;
            double deltaZ;
            double deltaY;
            double strength;
            if (entity.m_6128_() || (strength = (double)(Mth.m_14116_((float)((float)entity.m_20238_(explosionPos))) / radius)) > 1.0) continue;
            double deltaX = entity.m_20185_() - this.x;
            double distanceToExplosion = Mth.m_14116_((float)((float)(deltaX * deltaX + (deltaY = (entity instanceof PrimedTnt ? entity.m_20186_() : entity.m_20188_()) - this.y) * deltaY + (deltaZ = entity.m_20189_() - this.z) * deltaZ)));
            if (distanceToExplosion != 0.0) {
                deltaX /= distanceToExplosion;
                deltaY /= distanceToExplosion;
                deltaZ /= distanceToExplosion;
            } else {
                deltaX = 0.0;
                deltaY = 1.0;
                deltaZ = 0.0;
            }
            double blockDensity = ProjectileExplosion.m_46064_((Vec3)explosionPos, (Entity)entity);
            double damage = (1.0 - strength) * blockDensity;
            entity.m_6469_(this.m_46077_(), (float)((int)((damage * damage + damage) / 2.0 * 7.0 * (double)radius + 1.0)));
            double blastDamage = damage;
            if (entity instanceof LivingEntity) {
                blastDamage = ProtectionEnchantment.m_45135_((LivingEntity)((LivingEntity)entity), (double)damage);
            }
            entity.m_20256_(entity.m_20184_().m_82520_(deltaX * blastDamage, deltaY * blastDamage, deltaZ * blastDamage));
            if (!(entity instanceof Player) || (player = (Player)entity).m_5833_() || player.m_7500_() && player.m_150110_().f_35935_) continue;
            this.m_46078_().put(player, new Vec3(deltaX * damage, deltaY * damage, deltaZ * damage));
        }
    }
}

