/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model;

import de.javagl.jgltf.model.AccessorData;
import de.javagl.jgltf.model.AccessorFloatData;
import de.javagl.jgltf.model.AccessorModel;
import de.javagl.jgltf.model.BoundingBox;
import de.javagl.jgltf.model.ElementType;
import de.javagl.jgltf.model.GltfConstants;
import de.javagl.jgltf.model.GltfModel;
import de.javagl.jgltf.model.MathUtils;
import de.javagl.jgltf.model.MeshModel;
import de.javagl.jgltf.model.MeshPrimitiveModel;
import de.javagl.jgltf.model.NodeModel;
import de.javagl.jgltf.model.SceneModel;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

class BoundingBoxComputer {
    private static final Logger logger = Logger.getLogger(BoundingBoxComputer.class.getName());
    private final GltfModel gltfModel;

    BoundingBoxComputer(GltfModel gltfModel) {
        this.gltfModel = gltfModel;
    }

    BoundingBox compute() {
        BoundingBox boundingBox = new BoundingBox();
        List<SceneModel> sceneModels = this.gltfModel.getSceneModels();
        for (SceneModel sceneModel : sceneModels) {
            float[] rootTransform = MathUtils.createIdentity4x4();
            this.computeSceneBoundingBox(sceneModel, rootTransform, boundingBox);
        }
        return boundingBox;
    }

    private BoundingBox computeSceneBoundingBox(SceneModel sceneModel, float[] transform, BoundingBox boundingBox) {
        BoundingBox localResult = boundingBox;
        if (localResult == null) {
            localResult = new BoundingBox();
        }
        List<NodeModel> nodeModels = sceneModel.getNodeModels();
        for (NodeModel nodeModel : nodeModels) {
            this.computeNodeBoundingBox(nodeModel, transform, localResult);
        }
        return localResult;
    }

    private BoundingBox computeNodeBoundingBox(NodeModel nodeModel, float[] parentTransform, BoundingBox boundingBox) {
        BoundingBox result = boundingBox;
        if (result == null) {
            result = new BoundingBox();
        }
        float[] localTransform = nodeModel.computeLocalTransform(null);
        float[] transform = new float[16];
        MathUtils.mul4x4(parentTransform, localTransform, transform);
        List<MeshModel> meshModels = nodeModel.getMeshModels();
        for (MeshModel meshModel : meshModels) {
            BoundingBox meshBoundingBox = this.computeMeshBoundingBox(meshModel, transform, result);
            result.combine(meshBoundingBox);
        }
        List<NodeModel> children = nodeModel.getChildren();
        for (NodeModel child : children) {
            this.computeNodeBoundingBox(child, transform, result);
        }
        return result;
    }

    private BoundingBox computeMeshBoundingBox(MeshModel meshModel, float[] transform, BoundingBox boundingBox) {
        BoundingBox result = boundingBox;
        if (result == null) {
            result = new BoundingBox();
        }
        List<MeshPrimitiveModel> primitives = meshModel.getMeshPrimitiveModels();
        for (MeshPrimitiveModel meshPrimitiveModel : primitives) {
            BoundingBox meshPrimitiveBoundingBox = this.computeBoundingBox(meshPrimitiveModel, transform);
            if (meshPrimitiveBoundingBox == null) continue;
            result.combine(meshPrimitiveBoundingBox);
        }
        return result;
    }

    private BoundingBox computeBoundingBox(MeshPrimitiveModel meshPrimitiveModel, float[] transform) {
        String positionsAttributeName;
        Map<String, AccessorModel> attributes = meshPrimitiveModel.getAttributes();
        AccessorModel accessorModel = attributes.get(positionsAttributeName = "POSITION");
        if (accessorModel == null) {
            return null;
        }
        ElementType accessorType = accessorModel.getElementType();
        int numComponents = accessorType.getNumComponents();
        if (numComponents < 3) {
            logger.warning("Mesh primitive " + positionsAttributeName + " attribute refers to an accessor with type " + accessorType + " - expected \"VEC3\" or \"VEC4\"");
            return null;
        }
        Class<?> componentDataType = accessorModel.getComponentDataType();
        if (!componentDataType.equals(Float.TYPE)) {
            logger.warning("Mesh primitive " + positionsAttributeName + " attribute refers to an accessor with component type " + GltfConstants.stringFor(accessorModel.getComponentType()) + " - expected GL_FLOAT");
        }
        AccessorData accessorData = accessorModel.getAccessorData();
        AccessorFloatData accessorFloatData = (AccessorFloatData)accessorData;
        float[] point = new float[3];
        float[] transformedPoint = transform != null ? new float[3] : point;
        BoundingBox boundingBox = new BoundingBox();
        for (int e = 0; e < accessorData.getNumElements(); ++e) {
            for (int c = 0; c < 3; ++c) {
                point[c] = accessorFloatData.get(e, c);
            }
            if (transform != null) {
                MathUtils.transformPoint3D(transform, point, transformedPoint);
            }
            boundingBox.combine(transformedPoint[0], transformedPoint[1], transformedPoint[2]);
        }
        return boundingBox;
    }
}

