/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model.io;

import de.javagl.jgltf.model.GltfModel;
import de.javagl.jgltf.model.io.GltfAsset;
import de.javagl.jgltf.model.io.GltfAssetReader;
import de.javagl.jgltf.model.io.JsonError;
import de.javagl.jgltf.model.io.JsonErrorConsumers;
import de.javagl.jgltf.model.io.v1.GltfAssetV1;
import de.javagl.jgltf.model.io.v2.GltfAssetV2;
import de.javagl.jgltf.model.v1.GltfModelV1;
import de.javagl.jgltf.model.v2.GltfModelV2;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.function.Consumer;

public final class GltfModelReader {
    private Consumer<? super JsonError> jsonErrorConsumer = JsonErrorConsumers.createLogging();

    public void setJsonErrorConsumer(Consumer<? super JsonError> jsonErrorConsumer) {
        this.jsonErrorConsumer = jsonErrorConsumer;
    }

    public GltfModel read(URI uri) throws IOException {
        GltfAssetReader gltfAssetReader = new GltfAssetReader();
        gltfAssetReader.setJsonErrorConsumer(this.jsonErrorConsumer);
        GltfAsset gltfAsset = gltfAssetReader.read(uri);
        return GltfModelReader.createModel(gltfAsset);
    }

    public GltfModel readWithoutReferences(URI uri) throws IOException {
        try (InputStream inputStream = uri.toURL().openStream();){
            GltfModel gltfModel;
            GltfModel gltfModel2 = gltfModel = this.readWithoutReferences(inputStream);
            return gltfModel2;
        }
    }

    public GltfModel readWithoutReferences(InputStream inputStream) throws IOException {
        GltfAssetReader gltfAssetReader = new GltfAssetReader();
        gltfAssetReader.setJsonErrorConsumer(this.jsonErrorConsumer);
        GltfAsset gltfAsset = gltfAssetReader.readWithoutReferences(inputStream);
        return GltfModelReader.createModel(gltfAsset);
    }

    private static GltfModel createModel(GltfAsset gltfAsset) throws IOException {
        if (gltfAsset instanceof GltfAssetV1) {
            GltfAssetV1 gltfAssetV1 = (GltfAssetV1)gltfAsset;
            return new GltfModelV1(gltfAssetV1);
        }
        if (gltfAsset instanceof GltfAssetV2) {
            GltfAssetV2 gltfAssetV2 = (GltfAssetV2)gltfAsset;
            return new GltfModelV2(gltfAssetV2);
        }
        throw new IOException("The glTF asset has an unknown version: " + gltfAsset);
    }
}

